/*
 * Decompiled with CFR 0.152.
 */
package net.corda.packaging.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.IndexedValue;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.corda.packaging.CordappManifest;
import net.corda.packaging.CordappManifestException;
import net.corda.packaging.Cpk;
import net.corda.packaging.DependencyMetadataException;
import net.corda.packaging.InvalidSignatureException;
import net.corda.packaging.PackagingException;
import net.corda.packaging.internal.CpkLoader;
import net.corda.packaging.internal.JarExtractorInputStream;
import net.corda.packaging.internal.SignatureCollector;
import net.corda.packaging.internal.TeeInputStream;
import net.corda.packaging.internal.UncloseableInputStream;
import net.corda.v5.crypto.DigestAlgorithmName;
import net.corda.v5.crypto.SecureHash;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00029:B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J*\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020%H\u0002J \u0010)\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,H\u0002J(\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00182\u0006\u0010*\u001a\u00020%2\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0002J2\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00182\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000405H\u0002J\u0014\u00106\u001a\u00020\u0016*\u00020\u00112\u0006\u00107\u001a\u00020\u0004H\u0002J\u0014\u00106\u001a\u00020\u0016*\u0002082\u0006\u00107\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lnet/corda/packaging/internal/CpkLoader;", "", "()V", "CORDA_CPK_V1", "", "DEPENDENCIES_FILE_ENTRY", "DEPENDENCIES_FILE_NAME", "DEPENDENCY_NAME_TAG", "DEPENDENCY_SIGNERS_TAG", "DEPENDENCY_SIGNER_TAG", "DEPENDENCY_TAG", "DEPENDENCY_TYPE_TAG", "DEPENDENCY_VERSION_TAG", "JAR_EXTENSION", "LIB_FOLDER", "META_INF_FOLDER", "cpkV1DocumentBuilderFactory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "consumeStream", "", "inputStream", "Ljava/io/InputStream;", "buffer", "", "from", "Lnet/corda/packaging/Cpk;", "source", "expansionLocation", "Ljava/nio/file/Path;", "cpkLocation", "verifySignature", "", "isLibJar", "jarEntry", "Ljava/util/zip/ZipEntry;", "isMainJar", "isManifest", "zipEntry", "processLibJar", "cpkEntry", "ctx", "Lnet/corda/packaging/internal/CpkLoader$CpkContext;", "processMainJar", "mainJarStream", "readDependencies", "Ljava/util/NavigableSet;", "Lnet/corda/packaging/Cpk$Identifier;", "jarName", "dependenciesFileContent", "fileLocationAppender", "Lkotlin/Function1;", "disableProperty", "propertyName", "Ljavax/xml/validation/SchemaFactory;", "CpkContext", "XmlErrorHandler", "packaging"})
public final class CpkLoader {
    private static final Logger logger;
    private static final String JAR_EXTENSION = ".jar";
    private static final String LIB_FOLDER = "lib";
    private static final String META_INF_FOLDER = "META-INF";
    private static final String DEPENDENCIES_FILE_NAME = "CPKDependencies";
    @NotNull
    public static final String DEPENDENCIES_FILE_ENTRY = "META-INF/CPKDependencies";
    private static final String DEPENDENCY_TAG = "cpkDependency";
    private static final String DEPENDENCY_NAME_TAG = "name";
    private static final String DEPENDENCY_VERSION_TAG = "version";
    private static final String DEPENDENCY_SIGNERS_TAG = "signers";
    private static final String DEPENDENCY_TYPE_TAG = "type";
    private static final String DEPENDENCY_SIGNER_TAG = "signer";
    private static final String CORDA_CPK_V1 = "corda-cpk-1.0.xsd";
    private static final DocumentBuilderFactory cpkV1DocumentBuilderFactory;
    @NotNull
    public static final CpkLoader INSTANCE;

    private final void disableProperty(DocumentBuilderFactory $this$disableProperty, String propertyName) {
        try {
            $this$disableProperty.setAttribute(propertyName, "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private final void disableProperty(SchemaFactory $this$disableProperty, String propertyName) {
        try {
            $this$disableProperty.setProperty(propertyName, "");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMainJar(ZipEntry jarEntry) {
        if (jarEntry.isDirectory()) return false;
        String string = jarEntry.getName();
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        String string2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
        if (StringsKt.indexOf$default((CharSequence)string2, (char)'/', (int)0, (boolean)false, (int)6, null) != -1) return false;
        if (!StringsKt.endsWith$default((String)it, (String)JAR_EXTENSION, (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLibJar(ZipEntry jarEntry) {
        if (jarEntry.isDirectory()) return false;
        String string = jarEntry.getName();
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        String string2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
        if (!StringsKt.startsWith$default((String)string2, (String)LIB_FOLDER, (boolean)false, (int)2, null)) return false;
        if (StringsKt.indexOf$default((CharSequence)it, (char)'/', (int)0, (boolean)false, (int)6, null) != LIB_FOLDER.length()) return false;
        if (StringsKt.indexOf$default((CharSequence)it, (char)'/', (int)4, (boolean)false, (int)4, null) != -1) return false;
        if (!StringsKt.endsWith$default((String)it, (String)JAR_EXTENSION, (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean isManifest(ZipEntry zipEntry) {
        return Intrinsics.areEqual((Object)zipEntry.getName(), (Object)"META-INF/MANIFEST.MF");
    }

    private final void consumeStream(InputStream inputStream, byte[] buffer) {
        while (inputStream.read(buffer) != -1) {
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processMainJar(InputStream mainJarStream, ZipEntry cpkEntry, boolean verifySignature, CpkContext ctx2) {
        void manifest;
        ctx2.setCordappFileName(cpkEntry.getName());
        DigestInputStream cordappDigestInputStream = new DigestInputStream(mainJarStream, ctx2.getCordappDigest());
        JarInputStream jarInputStream = new JarInputStream((InputStream)cordappDigestInputStream, verifySignature);
        boolean bl = false;
        boolean bl2 = false;
        JarInputStream jar = jarInputStream;
        boolean bl3 = false;
        SignatureCollector signatureCollector = new SignatureCollector();
        try {
            while (jar.getNextJarEntry() != null) {
                JarEntry jarEntry;
                if (Intrinsics.areEqual((Object)jarEntry.getName(), (Object)DEPENDENCIES_FILE_ENTRY)) {
                    UncloseableInputStream uncloseableInputStream = new UncloseableInputStream(jar);
                    String string = cpkEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cpkEntry.name");
                    ctx2.setCpkDependencies(INSTANCE.readDependencies(string, uncloseableInputStream, ctx2.getFileLocationAppender()));
                } else {
                    INSTANCE.consumeStream(jar, ctx2.getBuffer());
                }
                try {
                    signatureCollector.addEntry(jarEntry);
                }
                catch (IOException e) {
                    throw (Throwable)new PackagingException((String)ctx2.getFileLocationAppender().invoke((Object)"Could not retrieve certificates of CorDapp JAR"), e);
                }
                jar.closeEntry();
            }
        }
        catch (SecurityException se) {
            throw (Throwable)new InvalidSignatureException((String)ctx2.getFileLocationAppender().invoke((Object)("Detected invalid signature on '" + ctx2.getCordappFileName() + '\'')), se);
        }
        Manifest manifest2 = jar.getManifest();
        if (manifest2 == null) {
            throw (Throwable)new CordappManifestException((String)ctx2.getFileLocationAppender().invoke((Object)("Missing manifest from cordapp jar '" + ctx2.getCordappFileName() + '\'')), null, 2, null);
        }
        Manifest manifest3 = manifest2;
        Object object = manifest3.getMainAttributes().getValue("Corda-CPK-Type");
        if (object != null) {
            Object object2 = object;
            Cpk.Type.Companion companion = Cpk.Type.Companion;
            boolean bl4 = false;
            boolean bl5 = false;
            String p1 = object2;
            boolean bl6 = false;
            object = companion.parse(p1);
            if (object != null) {
                object2 = object;
                boolean bl7 = false;
                bl4 = false;
                Object it = object2;
                boolean bl8 = false;
                ctx2.setCpkType((Cpk.Type)it);
            }
        }
        Pair pair = TuplesKt.to((Object)CordappManifest.Companion.fromManifest(manifest3), signatureCollector.getCertificates());
        CordappManifest cordappManifest = (CordappManifest)pair.component1();
        Set certificates = (Set)pair.component2();
        this.consumeStream(cordappDigestInputStream, ctx2.getBuffer());
        ctx2.setCordappManifest((CordappManifest)manifest);
        ctx2.setCordappCertificates(certificates);
        CpkContext cpkContext = ctx2;
        int n = cpkContext.getTopLevelJars();
        cpkContext.setTopLevelJars(n + 1);
    }

    private final void processLibJar(InputStream inputStream, ZipEntry cpkEntry, CpkContext ctx2) {
        Object object;
        try {
            MessageDigest libraryMessageDigest = MessageDigest.getInstance(DigestAlgorithmName.SHA2_256.getName());
            this.consumeStream(new DigestInputStream(inputStream, libraryMessageDigest), ctx2.getBuffer());
            object = libraryMessageDigest.digest();
        }
        catch (IOException e) {
            throw (Throwable)new PackagingException((String)ctx2.getFileLocationAppender().invoke((Object)("Could not calculate hash of library jar '" + cpkEntry.getName())), e);
        }
        byte[] digestBytes = object;
        Map map = ctx2.getLibraryMap();
        String string = cpkEntry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cpkEntry.name");
        object = string;
        String string2 = cpkEntry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cpkEntry.name");
        int n = StringsKt.lastIndexOf$default((CharSequence)string2, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)object2).substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String string4 = DigestAlgorithmName.SHA2_256.getName();
        Intrinsics.checkNotNullExpressionValue((Object)digestBytes, (String)"digestBytes");
        map.put(string3, new SecureHash(string4, digestBytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Cpk from(@NotNull InputStream source, @Nullable Path expansionLocation, @Nullable String cpkLocation, boolean verifySignature) {
        Cpk cpk;
        JarInputStream jarInputStream;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        byte[] byArray = new byte[8192];
        Path path = expansionLocation;
        Path path2 = path != null ? path.resolve("source.cpk") : null;
        MessageDigest messageDigest = MessageDigest.getInstance(DigestAlgorithmName.SHA2_256.getName());
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"MessageDigest.getInstanc\u2026orithmName.SHA2_256.name)");
        MessageDigest messageDigest2 = MessageDigest.getInstance(DigestAlgorithmName.SHA2_256.getName());
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest2, (String)"MessageDigest.getInstanc\u2026orithmName.SHA2_256.name)");
        Function1 function1 = cpkLocation == null ? (Function1)from.ctx.1.INSTANCE : (Function1)new Function1<String, String>(cpkLocation){
            final /* synthetic */ String $cpkLocation;

            @NotNull
            public final String invoke(@NotNull String msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                return msg + " in CPK at " + this.$cpkLocation;
            }
            {
                this.$cpkLocation = string;
                super(1);
            }
        };
        NavigableSet navigableSet = new TreeSet();
        Object object = new TreeMap();
        Cpk.Manifest manifest = null;
        CordappManifest cordappManifest = null;
        Set<? extends Certificate> set = null;
        MessageDigest messageDigest3 = messageDigest2;
        String string = null;
        MessageDigest messageDigest4 = messageDigest;
        Cpk.Type type = Cpk.Type.UNKNOWN;
        Path path3 = path2;
        CpkContext ctx2 = new CpkContext(byArray, 0, (Function1<? super String, String>)function1, path3, type, messageDigest4, string, messageDigest3, set, cordappManifest, manifest, (NavigableMap<String, SecureHash>)object, navigableSet);
        Path path4 = expansionLocation;
        Path contentFolder = path4 != null ? path4.resolve("content") : null;
        InputStream stream2BeFullyConsumed = new DigestInputStream(source, ctx2.getCpkDigest());
        if (contentFolder == null) {
            jarInputStream = new JarInputStream(stream2BeFullyConsumed, verifySignature);
        } else {
            Path path5 = ctx2.getCpkFile();
            Intrinsics.checkNotNull((Object)path5);
            Files.createDirectories(path5.getParent(), new FileAttribute[0]);
            Path path6 = ctx2.getCpkFile();
            Intrinsics.checkNotNull((Object)path6);
            OutputStream outputStream = Files.newOutputStream(path6, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"Files.newOutputStream(ctx.cpkFile!!)");
            stream2BeFullyConsumed = new TeeInputStream(stream2BeFullyConsumed, outputStream);
            jarInputStream = new JarExtractorInputStream(stream2BeFullyConsumed, contentFolder, verifySignature, cpkLocation, null, null, 48, null);
        }
        object = jarInputStream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            JarInputStream jarInputStream2 = (JarInputStream)object;
            boolean bl3 = false;
            Manifest manifest2 = jarInputStream2.getManifest();
            if (manifest2 == null) throw (Throwable)new PackagingException((String)ctx2.getFileLocationAppender().invoke((Object)"Invalid file format"), null, 2, null);
            Manifest jarManifest = manifest2;
            ctx2.setCpkManifest(Cpk.Manifest.Companion.fromManifest(new Manifest(jarManifest)));
            while (true) {
                block17: {
                    ZipEntry cpkEntry;
                    block15: {
                        block16: {
                            block14: {
                                if (jarInputStream2.getNextEntry() == null) break block14;
                                if (!INSTANCE.isMainJar(cpkEntry)) break block15;
                                break block16;
                            }
                            INSTANCE.consumeStream(stream2BeFullyConsumed, ctx2.getBuffer());
                            jarInputStream2 = Unit.INSTANCE;
                            break;
                        }
                        INSTANCE.processMainJar(jarInputStream2, cpkEntry, verifySignature, ctx2);
                        break block17;
                    }
                    if (INSTANCE.isLibJar(cpkEntry)) {
                        INSTANCE.processLibJar(jarInputStream2, cpkEntry, ctx2);
                    } else if (INSTANCE.isManifest(cpkEntry)) {
                        ctx2.setCpkManifest(Cpk.Manifest.Companion.fromManifest(new Manifest(jarInputStream2)));
                    }
                }
                jarInputStream2.closeEntry();
            }
        }
        catch (Throwable jarInputStream2) {
            throwable = jarInputStream2;
            throw jarInputStream2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        ctx2.validate();
        Object object2 = contentFolder;
        if (object2 != null) {
            object = object2;
            bl = false;
            boolean bl4 = false;
            Object p1 = object;
            boolean bl5 = false;
            object2 = ctx2.buildExpanded((Path)p1);
            if (object2 != null) {
                cpk = (Cpk)object2;
                return cpk;
            }
        }
        cpk = ctx2.buildArchived();
        return cpk;
    }

    private final NavigableSet<Cpk.Identifier> readDependencies(String jarName, InputStream dependenciesFileContent, Function1<? super String, String> fileLocationAppender) {
        NodeList cpkDependencyNodes;
        Object documentBuilder;
        try {
            documentBuilder = cpkV1DocumentBuilderFactory.newDocumentBuilder();
            ((DocumentBuilder)documentBuilder).setErrorHandler(new XmlErrorHandler(jarName));
            Document document = ((DocumentBuilder)documentBuilder).parse(dependenciesFileContent);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"documentBuilder.parse(dependenciesFileContent)");
            documentBuilder = document;
        }
        catch (DependencyMetadataException e) {
            throw (Throwable)e;
        }
        catch (SecurityException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new DependencyMetadataException((String)fileLocationAppender.invoke((Object)"Error parsing CPK dependencies file"), e);
        }
        Object cpkDependencyDocument = documentBuilder;
        NodeList nodeList = cpkDependencyNodes = cpkDependencyDocument.getElementsByTagName(DEPENDENCY_TAG);
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"cpkDependencyNodes");
        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000%\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\tH\u0096\u0002J\t\u0010\n\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"net/corda/packaging/internal/CpkLoader$readDependencies$ElementIterator", "", "Lorg/w3c/dom/Element;", "nodes", "Lorg/w3c/dom/NodeList;", "(Lorg/w3c/dom/NodeList;)V", "index", "", "hasNext", "", "next", "packaging"})
        public final class ElementIterator
        implements Iterator<Element>,
        KMappedMarker {
            private int index;
            private final NodeList nodes;

            public boolean hasNext() {
                return this.index < this.nodes.getLength();
            }

            @NotNull
            public Element next() {
                Node node;
                if (this.hasNext()) {
                    int n = this.index;
                    this.index = n + 1;
                    node = this.nodes.item(n);
                    if (node == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
                    }
                } else {
                    throw (Throwable)new NoSuchElementException();
                }
                return (Element)node;
            }

            public ElementIterator(@NotNull NodeList nodes) {
                Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
                this.nodes = nodes;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        }
        return (NavigableSet)SequencesKt.toCollection((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.withIndex((Sequence)SequencesKt.asSequence((Iterator)new ElementIterator(nodeList))), (Function1)((Function1)new Function1<IndexedValue<? extends Element>, Cpk.Identifier>(fileLocationAppender){
            final /* synthetic */ Function1 $fileLocationAppender;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Cpk.Identifier invoke(@NotNull IndexedValue<? extends Element> el) {
                boolean bl;
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter(el, (String)"el");
                NodeList dependencyNameElements = ((Element)el.getValue()).getElementsByTagName("name");
                NodeList dependencyVersionElements = ((Element)el.getValue()).getElementsByTagName("version");
                NodeList dependencyTypeElements = ((Element)el.getValue()).getElementsByTagName("type");
                NodeList dependencySignersElements = ((Element)el.getValue()).getElementsByTagName("signers");
                NodeList nodeList = dependencyNameElements;
                Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"dependencyNameElements");
                if (nodeList.getLength() != 1) {
                    String msg = (String)this.$fileLocationAppender.invoke((Object)("The entry at index " + el.getIndex() + " of the CPK dependencies did not specify its name correctly."));
                    throw (Throwable)new DependencyMetadataException(msg, null, 2, null);
                }
                NodeList nodeList2 = dependencyVersionElements;
                Intrinsics.checkNotNullExpressionValue((Object)nodeList2, (String)"dependencyVersionElements");
                if (nodeList2.getLength() != 1) {
                    String msg = (String)this.$fileLocationAppender.invoke((Object)("The entry at index " + el.getIndex() + " of the CPK dependencies file did not specify its version correctly."));
                    throw (Throwable)new DependencyMetadataException(msg, null, 2, null);
                }
                NodeList nodeList3 = dependencySignersElements;
                Intrinsics.checkNotNullExpressionValue((Object)nodeList3, (String)"dependencySignersElements");
                if (nodeList3.getLength() != 1) {
                    String msg = (String)this.$fileLocationAppender.invoke((Object)("The entry at index " + el.getIndex() + " of the CPK dependencies file did not specify its signers correctly."));
                    throw (Throwable)new DependencyMetadataException(msg, null, 2, null);
                }
                Node node = dependencySignersElements.item(0);
                if (node == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                Element signers = (Element)node;
                NodeList nodeList4 = signers.getElementsByTagName("signer");
                Intrinsics.checkNotNullExpressionValue((Object)nodeList4, (String)"signers.getElementsByTag\u2026me(DEPENDENCY_SIGNER_TAG)");
                Object object = SequencesKt.asSequence((Iterator)new ElementIterator(nodeList4));
                Collection destination$iv = new TreeSet<SecureHash>(Cpk.Identifier.Companion.getSecureHashComparator());
                boolean $i$f$mapTo = false;
                for (E item$iv : $this$mapTo$iv) {
                    SecureHash secureHash;
                    String string;
                    boolean bl2;
                    CharSequence charSequence;
                    void signer;
                    Element element = (Element)item$iv;
                    Collection collection = destination$iv;
                    boolean bl3 = false;
                    String string2 = signer.getAttribute("algorithm");
                    if (string2 != null) {
                        charSequence = string2;
                        bl2 = false;
                        String string3 = charSequence;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                    } else {
                        string = null;
                    }
                    String algorithm = string;
                    charSequence = algorithm;
                    bl2 = false;
                    boolean bl4 = false;
                    if (charSequence == null || charSequence.length() == 0) {
                        String msg = (String)this.$fileLocationAppender.invoke((Object)("The entry at index " + el.getIndex() + " of the CPK dependencies file" + " did not specify an algorithm for its signer's public key hash."));
                        throw (Throwable)new DependencyMetadataException(msg, null, 2, null);
                    }
                    byte[] hashData = Base64.getDecoder().decode(signer.getTextContent());
                    String string4 = algorithm;
                    if (Intrinsics.areEqual((Object)string4, (Object)DigestAlgorithmName.SHA2_256.getName())) {
                        String string5 = DigestAlgorithmName.SHA2_256.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)hashData, (String)"hashData");
                        secureHash = new SecureHash(string5, hashData);
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)hashData, (String)"hashData");
                        secureHash = new SecureHash(algorithm, hashData);
                    }
                    SecureHash secureHash2 = secureHash;
                    collection.add(secureHash2);
                }
                TreeSet publicKeyHashes = (TreeSet)destination$iv;
                Node node2 = dependencyNameElements.item(0);
                Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"dependencyNameElements.item(0)");
                String string = node2.getTextContent();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyNameElements.item(0).textContent");
                Node node3 = dependencyVersionElements.item(0);
                Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"dependencyVersionElements.item(0)");
                String string6 = node3.getTextContent();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"dependencyVersionElements.item(0).textContent");
                object = new Cpk.Identifier(string, string6, publicKeyHashes);
                boolean bl5 = false;
                boolean bl6 = false;
                Object it = object;
                boolean bl7 = false;
                NodeList nodeList5 = dependencyTypeElements;
                Intrinsics.checkNotNullExpressionValue((Object)nodeList5, (String)"dependencyTypeElements");
                switch (nodeList5.getLength()) {
                    case 0: {
                        bl = true;
                        break;
                    }
                    case 1: {
                        Node node4 = dependencyTypeElements.item(0);
                        Intrinsics.checkNotNullExpressionValue((Object)node4, (String)"dependencyTypeElements.item(0)");
                        String string7 = node4.getTextContent();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"dependencyTypeElements.item(0).textContent");
                        if (Cpk.Type.Companion.parse(string7) != Cpk.Type.CORDA_API) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        String msg = (String)this.$fileLocationAppender.invoke((Object)("The entry at index " + el.getIndex() + " of the CPK dependencies file has multiple types"));
                        throw (Throwable)new DependencyMetadataException(msg, null, 2, null);
                    }
                }
                return bl ? object : null;
            }
            {
                this.$fileLocationAppender = function1;
                super(1);
            }
        })), (Collection)new TreeSet());
    }

    private CpkLoader() {
    }

    static {
        CpkLoader cpkLoader;
        INSTANCE = cpkLoader = new CpkLoader();
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(CpkLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(T::class.java)");
        CpkLoader.logger = logger;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        boolean bl = false;
        boolean bl2 = false;
        DocumentBuilderFactory dbf = documentBuilderFactory;
        boolean bl3 = false;
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilderFactory documentBuilderFactory2 = dbf;
        Intrinsics.checkNotNullExpressionValue((Object)documentBuilderFactory2, (String)"dbf");
        INSTANCE.disableProperty(documentBuilderFactory2, "http://javax.xml.XMLConstants/property/accessExternalSchema");
        INSTANCE.disableProperty(dbf, "http://javax.xml.XMLConstants/property/accessExternalDTD");
        dbf.setExpandEntityReferences(false);
        dbf.setIgnoringComments(true);
        dbf.setNamespaceAware(true);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        boolean bl4 = false;
        boolean bl5 = false;
        SchemaFactory sf = schemaFactory;
        boolean bl6 = false;
        sf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        SchemaFactory schemaFactory2 = sf;
        Intrinsics.checkNotNullExpressionValue((Object)schemaFactory2, (String)"sf");
        INSTANCE.disableProperty(schemaFactory2, "http://javax.xml.XMLConstants/property/accessExternalSchema");
        INSTANCE.disableProperty(sf, "http://javax.xml.XMLConstants/property/accessExternalDTD");
        URL uRL = INSTANCE.getClass().getClassLoader().getResource(CORDA_CPK_V1);
        if (uRL == null) {
            throw (Throwable)new IllegalStateException("Corda CPK v1 schema missing");
        }
        Schema cpkSchema = schemaFactory.newSchema(uRL);
        dbf.setSchema(cpkSchema);
        cpkV1DocumentBuilderFactory = documentBuilderFactory;
    }

    public static final /* synthetic */ Logger access$getLogger$p(CpkLoader $this) {
        CpkLoader cpkLoader = $this;
        return logger;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b+\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u009b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u0012\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010H\u001a\u00020IJ\u000e\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\nJ\u0006\u0010M\u001a\u00020NR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010&R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010G\u00a8\u0006O"}, d2={"Lnet/corda/packaging/internal/CpkLoader$CpkContext;", "", "buffer", "", "topLevelJars", "", "fileLocationAppender", "Lkotlin/Function1;", "", "cpkFile", "Ljava/nio/file/Path;", "cpkType", "Lnet/corda/packaging/Cpk$Type;", "cpkDigest", "Ljava/security/MessageDigest;", "cordappFileName", "cordappDigest", "cordappCertificates", "", "Ljava/security/cert/Certificate;", "cordappManifest", "Lnet/corda/packaging/CordappManifest;", "cpkManifest", "Lnet/corda/packaging/Cpk$Manifest;", "libraryMap", "Ljava/util/NavigableMap;", "Lnet/corda/v5/crypto/SecureHash;", "cpkDependencies", "Ljava/util/NavigableSet;", "Lnet/corda/packaging/Cpk$Identifier;", "([BILkotlin/jvm/functions/Function1;Ljava/nio/file/Path;Lnet/corda/packaging/Cpk$Type;Ljava/security/MessageDigest;Ljava/lang/String;Ljava/security/MessageDigest;Ljava/util/Set;Lnet/corda/packaging/CordappManifest;Lnet/corda/packaging/Cpk$Manifest;Ljava/util/NavigableMap;Ljava/util/NavigableSet;)V", "getBuffer", "()[B", "getCordappCertificates", "()Ljava/util/Set;", "setCordappCertificates", "(Ljava/util/Set;)V", "getCordappDigest", "()Ljava/security/MessageDigest;", "getCordappFileName", "()Ljava/lang/String;", "setCordappFileName", "(Ljava/lang/String;)V", "getCordappManifest", "()Lnet/corda/packaging/CordappManifest;", "setCordappManifest", "(Lnet/corda/packaging/CordappManifest;)V", "getCpkDependencies", "()Ljava/util/NavigableSet;", "setCpkDependencies", "(Ljava/util/NavigableSet;)V", "getCpkDigest", "getCpkFile", "()Ljava/nio/file/Path;", "setCpkFile", "(Ljava/nio/file/Path;)V", "getCpkManifest", "()Lnet/corda/packaging/Cpk$Manifest;", "setCpkManifest", "(Lnet/corda/packaging/Cpk$Manifest;)V", "getCpkType", "()Lnet/corda/packaging/Cpk$Type;", "setCpkType", "(Lnet/corda/packaging/Cpk$Type;)V", "getFileLocationAppender", "()Lkotlin/jvm/functions/Function1;", "getLibraryMap", "()Ljava/util/NavigableMap;", "getTopLevelJars", "()I", "setTopLevelJars", "(I)V", "buildArchived", "Lnet/corda/packaging/Cpk$Archived;", "buildExpanded", "Lnet/corda/packaging/Cpk$Expanded;", "expansionLocation", "validate", "", "packaging"})
    private static final class CpkContext {
        @NotNull
        private final byte[] buffer;
        private int topLevelJars;
        @NotNull
        private final Function1<String, String> fileLocationAppender;
        @Nullable
        private Path cpkFile;
        @NotNull
        private Cpk.Type cpkType;
        @NotNull
        private final MessageDigest cpkDigest;
        @Nullable
        private String cordappFileName;
        @NotNull
        private final MessageDigest cordappDigest;
        @Nullable
        private Set<? extends Certificate> cordappCertificates;
        @Nullable
        private CordappManifest cordappManifest;
        @Nullable
        private Cpk.Manifest cpkManifest;
        @NotNull
        private final NavigableMap<String, SecureHash> libraryMap;
        @NotNull
        private NavigableSet<Cpk.Identifier> cpkDependencies;

        public final void validate() {
            if (this.topLevelJars == 0) {
                throw (Throwable)new PackagingException((String)this.fileLocationAppender.invoke((Object)"No CorDapp JAR found"), null, 2, null);
            }
            if (this.topLevelJars > 1) {
                throw (Throwable)new PackagingException((String)this.fileLocationAppender.invoke((Object)(this.topLevelJars + " CorDapp JARs found")), null, 2, null);
            }
        }

        @NotNull
        public final Cpk.Expanded buildExpanded(@NotNull Path expansionLocation) {
            Intrinsics.checkNotNullParameter((Object)expansionLocation, (String)"expansionLocation");
            Path libFolder = expansionLocation.resolve(CpkLoader.LIB_FOLDER);
            Set libraries2 = (Files.exists(libFolder, new LinkOption[0]) ? Files.list(libFolder) : Stream.empty()).filter(buildExpanded.libraries.1.INSTANCE).collect(Collectors.toUnmodifiableSet());
            Path path = this.cpkFile;
            Intrinsics.checkNotNull((Object)path);
            Path path2 = expansionLocation.resolve(this.cordappFileName);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"expansionLocation.resolve(cordappFileName)");
            Set set = libraries2;
            Intrinsics.checkNotNullExpressionValue(set, (String)"libraries");
            Cpk.Manifest manifest = this.cpkManifest;
            Intrinsics.checkNotNull((Object)manifest);
            String string = this.cordappFileName;
            Intrinsics.checkNotNull((Object)string);
            String string2 = DigestAlgorithmName.SHA2_256.getName();
            byte[] byArray = this.cpkDigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cpkDigest.digest()");
            SecureHash secureHash = new SecureHash(string2, byArray);
            String string3 = DigestAlgorithmName.SHA2_256.getName();
            byte[] byArray2 = this.cordappDigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cordappDigest.digest()");
            SecureHash secureHash2 = new SecureHash(string3, byArray2);
            Set<? extends Certificate> set2 = this.cordappCertificates;
            Intrinsics.checkNotNull(set2);
            CordappManifest cordappManifest = this.cordappManifest;
            Intrinsics.checkNotNull((Object)cordappManifest);
            NavigableMap<String, SecureHash> navigableMap = Collections.unmodifiableNavigableMap(this.libraryMap);
            Intrinsics.checkNotNullExpressionValue(navigableMap, (String)"Collections.unmodifiableNavigableMap(libraryMap)");
            NavigableSet<Cpk.Identifier> navigableSet = Collections.unmodifiableNavigableSet(this.cpkDependencies);
            Intrinsics.checkNotNullExpressionValue(navigableSet, (String)"Collections.unmodifiable\u2026gableSet(cpkDependencies)");
            NavigableSet<Cpk.Identifier> navigableSet2 = navigableSet;
            NavigableMap<String, SecureHash> navigableMap2 = navigableMap;
            CordappManifest cordappManifest2 = cordappManifest;
            Set<? extends Certificate> set3 = set2;
            SecureHash secureHash3 = secureHash2;
            SecureHash secureHash4 = secureHash;
            String string4 = string;
            Cpk.Manifest manifest2 = manifest;
            Set set4 = set;
            Path path3 = path2;
            Cpk.Type type = this.cpkType;
            Path path4 = path;
            return new Cpk.Expanded(path3, set4, path4, type, secureHash4, manifest2, string4, secureHash3, set3, cordappManifest2, navigableMap2, navigableSet2);
        }

        @NotNull
        public final Cpk.Archived buildArchived() {
            Cpk.Manifest manifest = this.cpkManifest;
            Intrinsics.checkNotNull((Object)manifest);
            String string = this.cordappFileName;
            Intrinsics.checkNotNull((Object)string);
            String string2 = DigestAlgorithmName.SHA2_256.getName();
            byte[] byArray = this.cpkDigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cpkDigest.digest()");
            SecureHash secureHash = new SecureHash(string2, byArray);
            String string3 = DigestAlgorithmName.SHA2_256.getName();
            byte[] byArray2 = this.cordappDigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cordappDigest.digest()");
            SecureHash secureHash2 = new SecureHash(string3, byArray2);
            Set<? extends Certificate> set = this.cordappCertificates;
            Intrinsics.checkNotNull(set);
            CordappManifest cordappManifest = this.cordappManifest;
            Intrinsics.checkNotNull((Object)cordappManifest);
            NavigableMap<String, SecureHash> navigableMap = Collections.unmodifiableNavigableMap(this.libraryMap);
            Intrinsics.checkNotNullExpressionValue(navigableMap, (String)"Collections.unmodifiableNavigableMap(libraryMap)");
            NavigableSet<Cpk.Identifier> navigableSet = Collections.unmodifiableNavigableSet(this.cpkDependencies);
            Intrinsics.checkNotNullExpressionValue(navigableSet, (String)"Collections.unmodifiable\u2026gableSet(cpkDependencies)");
            NavigableSet<Cpk.Identifier> navigableSet2 = navigableSet;
            NavigableMap<String, SecureHash> navigableMap2 = navigableMap;
            CordappManifest cordappManifest2 = cordappManifest;
            Set<? extends Certificate> set2 = set;
            SecureHash secureHash3 = secureHash2;
            SecureHash secureHash4 = secureHash;
            String string4 = string;
            Cpk.Manifest manifest2 = manifest;
            return new Cpk.Archived(this.cpkType, secureHash4, manifest2, string4, secureHash3, set2, cordappManifest2, navigableMap2, navigableSet2);
        }

        @NotNull
        public final byte[] getBuffer() {
            return this.buffer;
        }

        public final int getTopLevelJars() {
            return this.topLevelJars;
        }

        public final void setTopLevelJars(int n) {
            this.topLevelJars = n;
        }

        @NotNull
        public final Function1<String, String> getFileLocationAppender() {
            return this.fileLocationAppender;
        }

        @Nullable
        public final Path getCpkFile() {
            return this.cpkFile;
        }

        public final void setCpkFile(@Nullable Path path) {
            this.cpkFile = path;
        }

        @NotNull
        public final Cpk.Type getCpkType() {
            return this.cpkType;
        }

        public final void setCpkType(@NotNull Cpk.Type type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"<set-?>");
            this.cpkType = type;
        }

        @NotNull
        public final MessageDigest getCpkDigest() {
            return this.cpkDigest;
        }

        @Nullable
        public final String getCordappFileName() {
            return this.cordappFileName;
        }

        public final void setCordappFileName(@Nullable String string) {
            this.cordappFileName = string;
        }

        @NotNull
        public final MessageDigest getCordappDigest() {
            return this.cordappDigest;
        }

        @Nullable
        public final Set<Certificate> getCordappCertificates() {
            return this.cordappCertificates;
        }

        public final void setCordappCertificates(@Nullable Set<? extends Certificate> set) {
            this.cordappCertificates = set;
        }

        @Nullable
        public final CordappManifest getCordappManifest() {
            return this.cordappManifest;
        }

        public final void setCordappManifest(@Nullable CordappManifest cordappManifest) {
            this.cordappManifest = cordappManifest;
        }

        @Nullable
        public final Cpk.Manifest getCpkManifest() {
            return this.cpkManifest;
        }

        public final void setCpkManifest(@Nullable Cpk.Manifest manifest) {
            this.cpkManifest = manifest;
        }

        @NotNull
        public final NavigableMap<String, SecureHash> getLibraryMap() {
            return this.libraryMap;
        }

        @NotNull
        public final NavigableSet<Cpk.Identifier> getCpkDependencies() {
            return this.cpkDependencies;
        }

        public final void setCpkDependencies(@NotNull NavigableSet<Cpk.Identifier> navigableSet) {
            Intrinsics.checkNotNullParameter(navigableSet, (String)"<set-?>");
            this.cpkDependencies = navigableSet;
        }

        public CpkContext(@NotNull byte[] buffer, int topLevelJars, @NotNull Function1<? super String, String> fileLocationAppender, @Nullable Path cpkFile, @NotNull Cpk.Type cpkType, @NotNull MessageDigest cpkDigest, @Nullable String cordappFileName, @NotNull MessageDigest cordappDigest, @Nullable Set<? extends Certificate> cordappCertificates, @Nullable CordappManifest cordappManifest, @Nullable Cpk.Manifest cpkManifest, @NotNull NavigableMap<String, SecureHash> libraryMap, @NotNull NavigableSet<Cpk.Identifier> cpkDependencies) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter(fileLocationAppender, (String)"fileLocationAppender");
            Intrinsics.checkNotNullParameter((Object)cpkType, (String)"cpkType");
            Intrinsics.checkNotNullParameter((Object)cpkDigest, (String)"cpkDigest");
            Intrinsics.checkNotNullParameter((Object)cordappDigest, (String)"cordappDigest");
            Intrinsics.checkNotNullParameter(libraryMap, (String)"libraryMap");
            Intrinsics.checkNotNullParameter(cpkDependencies, (String)"cpkDependencies");
            this.buffer = buffer;
            this.topLevelJars = topLevelJars;
            this.fileLocationAppender = fileLocationAppender;
            this.cpkFile = cpkFile;
            this.cpkType = cpkType;
            this.cpkDigest = cpkDigest;
            this.cordappFileName = cordappFileName;
            this.cordappDigest = cordappDigest;
            this.cordappCertificates = cordappCertificates;
            this.cordappManifest = cordappManifest;
            this.cpkManifest = cpkManifest;
            this.libraryMap = libraryMap;
            this.cpkDependencies = cpkDependencies;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/corda/packaging/internal/CpkLoader$XmlErrorHandler;", "Lorg/xml/sax/ErrorHandler;", "jarName", "", "(Ljava/lang/String;)V", "error", "", "ex", "Lorg/xml/sax/SAXParseException;", "fatalError", "warning", "packaging"})
    private static final class XmlErrorHandler
    implements ErrorHandler {
        private final String jarName;

        @Override
        public void warning(@NotNull SAXParseException ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            CpkLoader.access$getLogger$p(INSTANCE).warn("Problem at (line {}, column {}) parsing CPK dependencies for {}: {}", new Object[]{ex.getLineNumber(), ex.getColumnNumber(), this.jarName, ex.getMessage()});
        }

        @Override
        public void error(@NotNull SAXParseException ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            CpkLoader.access$getLogger$p(INSTANCE).error("Error at (line {}, column {}) parsing CPK dependencies for {}: {}", new Object[]{ex.getLineNumber(), ex.getColumnNumber(), this.jarName, ex.getMessage()});
            String string = ex.getMessage();
            if (string == null) {
                string = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ex.message ?: \"\"");
            throw (Throwable)new DependencyMetadataException(string, ex);
        }

        @Override
        public void fatalError(@NotNull SAXParseException ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            CpkLoader.access$getLogger$p(INSTANCE).error("Fatal error at (line {}, column {}) parsing CPK dependencies for {}: {}", new Object[]{ex.getLineNumber(), ex.getColumnNumber(), this.jarName, ex.getMessage()});
            throw (Throwable)ex;
        }

        public XmlErrorHandler(@NotNull String jarName) {
            Intrinsics.checkNotNullParameter((Object)jarName, (String)"jarName");
            this.jarName = jarName;
        }
    }
}

