/*
 * Decompiled with CFR 0.152.
 */
package net.corda.packaging.internal;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.packaging.Cpb;
import net.corda.packaging.Cpk;
import net.corda.packaging.internal.UncloseableInputStream;
import net.corda.v5.crypto.DigestAlgorithmName;
import net.corda.v5.crypto.SecureHash;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lnet/corda/packaging/internal/CpbLoader;", "", "()V", "from", "Lnet/corda/packaging/Cpb;", "inputStream", "Ljava/io/InputStream;", "expansionLocation", "Ljava/nio/file/Path;", "cpbLocation", "", "verifySignature", "", "isCpk", "entry", "Ljava/util/zip/ZipEntry;", "packaging"})
public final class CpbLoader {
    @NotNull
    public static final CpbLoader INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCpk(ZipEntry entry) {
        if (entry.isDirectory()) return false;
        String string = entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
        if (!StringsKt.endsWith$default((String)string, (String)".cpk", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Cpb from(@NotNull InputStream inputStream, @Nullable Path expansionLocation, @Nullable String cpbLocation, boolean verifySignature) {
        Cpb cpb;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        boolean bl = false;
        List archivedCpks = new ArrayList();
        boolean bl2 = false;
        List expandedCpks = new ArrayList();
        MessageDigest md = MessageDigest.getInstance(DigestAlgorithmName.SHA2_256.getName());
        Closeable closeable = new JarInputStream((InputStream)new DigestInputStream(inputStream, md), verifySignature);
        boolean bl3 = false;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            JarInputStream zipInputStream = (JarInputStream)closeable;
            boolean bl5 = false;
            while (zipInputStream.getNextEntry() != null) {
                ZipEntry entry;
                if (INSTANCE.isCpk(entry)) {
                    boolean bl6;
                    Cpk cpk;
                    Collection collection;
                    UncloseableInputStream uncloseableInputStream = new UncloseableInputStream(zipInputStream);
                    if (expansionLocation != null) {
                        collection = expandedCpks;
                        InputStream inputStream2 = uncloseableInputStream;
                        Path path = expansionLocation.resolve(entry.getName());
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"expansionLocation.resolve(entry.name)");
                        cpk = Cpk.Expanded.Companion.from(inputStream2, path, Intrinsics.stringPlus((String)cpbLocation, (Object)('/' + entry.getName())), verifySignature);
                        bl6 = false;
                        collection.add(cpk);
                    } else {
                        collection = archivedCpks;
                        String string = cpbLocation;
                        cpk = Cpk.Archived.Companion.from(uncloseableInputStream, string != null ? string + '/' + entry.getName() : null, verifySignature);
                        bl6 = false;
                        collection.add(cpk);
                    }
                }
                zipInputStream.closeEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (expansionLocation != null) {
            String string = DigestAlgorithmName.SHA2_256.getName();
            byte[] byArray = md.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"md.digest()");
            boolean bl7 = false;
            cpb = new Cpb.Expanded(new Cpb.Identifier(new SecureHash(string, byArray)), new Cpb.MetaData(MapsKt.emptyMap()), expandedCpks);
        } else {
            String string = DigestAlgorithmName.SHA2_256.getName();
            byte[] byArray = md.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"md.digest()");
            boolean bl8 = false;
            cpb = new Cpb.Archived(new Cpb.Identifier(new SecureHash(string, byArray)), new Cpb.MetaData(MapsKt.emptyMap()), archivedCpks);
        }
        return cpb;
    }

    private CpbLoader() {
    }

    static {
        CpbLoader cpbLoader;
        INSTANCE = cpbLoader = new CpbLoader();
    }
}

