/*
 * Decompiled with CFR 0.152.
 */
package net.corda.packaging.internal;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import net.corda.packaging.Cpk;
import net.corda.packaging.DependencyResolutionException;
import net.corda.packaging.SigningParameters;
import net.corda.packaging.internal.CpbBuilder;
import net.corda.packaging.internal.CpkDependencyResolver;
import net.corda.packaging.internal.ZipTweaker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001cB?\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J8\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002J*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/corda/packaging/internal/CpbBuilder;", "", "cpkFiles", "", "Ljava/nio/file/Path;", "cpkArchives", "metadataReader", "Ljava/io/Reader;", "signingParams", "Lnet/corda/packaging/SigningParameters;", "useSignatures", "", "(Ljava/lang/Iterable;Ljava/lang/Iterable;Ljava/io/Reader;Lnet/corda/packaging/SigningParameters;Z)V", "metadata", "Lcom/typesafe/config/Config;", "build", "", "output", "Ljava/io/OutputStream;", "index", "Ljava/util/NavigableMap;", "Lnet/corda/packaging/Cpk$Identifier;", "Lnet/corda/packaging/internal/CpbBuilder$CpkData;", "roots", "existingIndex", "resolveDependencies", "archivePaths", "writeArchive", "CpkData", "packaging"})
public final class CpbBuilder {
    private final Config metadata;
    private final Iterable<Path> cpkFiles;
    private final Iterable<Path> cpkArchives;
    private final SigningParameters signingParams;
    private final boolean useSignatures;

    /*
     * WARNING - void declaration
     */
    private final Iterable<Path> resolveDependencies(Iterable<? extends Path> roots, Iterable<? extends Path> archivePaths) {
        void $this$mapTo$iv$iv;
        Comparable<Cpk.Identifier> comparable;
        Object object;
        void $this$associateByTo$iv;
        Set rootSet2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence(roots), (Function1)resolveDependencies.rootSet.1.INSTANCE));
        TreeMap index = new TreeMap();
        this.index(roots, index);
        Set set = index.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"index.keys");
        List rootIdentifiers = CollectionsKt.toList((Iterable)set);
        for (Path path : archivePaths) {
            Stream<Path> stream = Files.list(path);
            Intrinsics.checkNotNullExpressionValue(stream, (String)"Files.list(archivePath)");
            List cpkFiles2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence(stream), (Function1)((Function1)new Function1<Path, Boolean>(rootSet2){
                final /* synthetic */ Set $rootSet;

                public final boolean invoke(Path it) {
                    return !this.$rootSet.contains(it.toRealPath(new LinkOption[0]));
                }
                {
                    this.$rootSet = set;
                    super(1);
                }
            })), (Function1)resolveDependencies.cpkFiles.2.INSTANCE));
            this.index(cpkFiles2, index);
        }
        Set set2 = index.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"index.entries");
        Iterable iterable = set2;
        Map destination$iv = new TreeMap();
        boolean $i$f$associateByTo232 = false;
        for (Object element$iv : $this$associateByTo$iv) {
            Map.Entry it;
            Map.Entry entry = (Map.Entry)element$iv;
            object = destination$iv;
            boolean bl = false;
            comparable = (Cpk.Identifier)it.getKey();
            it = (Map.Entry)element$iv;
            boolean bl2 = false;
            NavigableSet<Cpk.Identifier> navigableSet = ((CpkData)it.getValue()).getCpk().getDependencies();
            object.put(comparable, navigableSet);
        }
        TreeMap treeMap = (TreeMap)destination$iv;
        Iterable $this$map$iv = CpkDependencyResolver.INSTANCE.resolveDependencies(rootIdentifiers, treeMap, this.useSignatures);
        boolean $i$f$map = false;
        Iterable $i$f$associateByTo232 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Cpk.Identifier identifier = (Cpk.Identifier)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Object v = index.get(it);
            Intrinsics.checkNotNull(v);
            comparable = ((CpkData)v).getPath();
            object.add(comparable);
        }
        return (List)destination$iv$iv;
    }

    private final NavigableMap<Cpk.Identifier, CpkData> index(Iterable<? extends Path> roots, NavigableMap<Cpk.Identifier, CpkData> existingIndex) {
        for (Path path : roots) {
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"Files.newInputStream(root)");
            Cpk.Archived cpk = Cpk.Archived.Companion.from(inputStream, ((Object)path).toString(), this.useSignatures);
            CpkData previous = existingIndex.put(cpk.getId(), new CpkData(cpk, path));
            if (previous == null) continue;
            throw (Throwable)new DependencyResolutionException("Detected two CPKs with the same identifier " + cpk.getId() + ": '" + path + "' and '" + previous.getPath() + '\'', null, 2, null);
        }
        return existingIndex;
    }

    static /* synthetic */ NavigableMap index$default(CpbBuilder cpbBuilder, Iterable iterable, NavigableMap navigableMap, int n, Object object) {
        if ((n & 2) != 0) {
            navigableMap = new TreeMap();
        }
        return cpbBuilder.index(iterable, navigableMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeArchive(OutputStream output) {
        byte[] buffer = new byte[8192];
        Iterable<Path> resolvedCpkSet = this.resolveDependencies(this.cpkFiles, this.cpkArchives);
        Closeable closeable = new ZipOutputStream(output);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream;
            ZipOutputStream os = (ZipOutputStream)closeable;
            boolean bl3 = false;
            ZipTweaker.Companion.writeZipEntry(os, (Function0<? extends InputStream>)((Function0)new Function0<InputStream>(this, buffer, resolvedCpkSet){
                final /* synthetic */ CpbBuilder this$0;
                final /* synthetic */ byte[] $buffer$inlined;
                final /* synthetic */ Iterable $resolvedCpkSet$inlined;
                {
                    this.this$0 = cpbBuilder;
                    this.$buffer$inlined = byArray;
                    this.$resolvedCpkSet$inlined = iterable;
                    super(0);
                }

                @NotNull
                public final InputStream invoke() {
                    String string = CpbBuilder.access$getMetadata$p(this.this$0).root().render(ConfigRenderOptions.concise());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"metadata.root().render(C\u2026gRenderOptions.concise())");
                    String string2 = string;
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    String string3 = string2;
                    boolean bl2 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = string4.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    return new ByteArrayInputStream(byArray);
                }
            }), "install.json", buffer, 8);
            for (Path cpkFile : resolvedCpkSet) {
                ZipTweaker.Companion.writeZipEntry(os, (Function0<? extends InputStream>)((Function0)new Function0<InputStream>(cpkFile){
                    final /* synthetic */ Path $cpkFile;

                    @NotNull
                    public final InputStream invoke() {
                        InputStream inputStream = Files.newInputStream(this.$cpkFile, new OpenOption[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"Files.newInputStream(cpkFile)");
                        return inputStream;
                    }
                    {
                        this.$cpkFile = path;
                        super(0);
                    }
                }), ((Object)cpkFile.getFileName()).toString(), buffer, 0);
            }
            Manifest manifest = new Manifest();
            Closeable closeable2 = new ByteArrayOutputStream();
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                ByteArrayOutputStream it = (ByteArrayOutputStream)closeable2;
                boolean bl6 = false;
                manifest.write(it);
                byteArrayOutputStream = it;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byte[] manifestBytes = byteArrayOutputStream.toByteArray();
            ZipTweaker.Companion.writeZipEntry(os, (Function0<? extends InputStream>)((Function0)new Function0<InputStream>(manifestBytes){
                final /* synthetic */ byte[] $manifestBytes;

                @NotNull
                public final InputStream invoke() {
                    return new ByteArrayInputStream(this.$manifestBytes);
                }
                {
                    this.$manifestBytes = byArray;
                    super(0);
                }
            }), "META-INF/MANIFEST.MF", buffer, 8);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void build(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (this.signingParams == null) {
            this.writeArchive(output);
        } else {
            Path path = Files.createTempFile(null, null, new FileAttribute[0]);
            boolean bl = false;
            boolean bl2 = false;
            Path tempFile = path;
            boolean bl3 = false;
            try {
                this.writeArchive(new BufferedOutputStream(Files.newOutputStream(tempFile, new OpenOption[0])));
                File file = tempFile.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tempFile.toFile()");
                SigningParameters.Companion.sign(file, output, this.signingParams);
            }
            finally {
                Files.delete(tempFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CpbBuilder(@NotNull Iterable<? extends Path> cpkFiles2, @NotNull Iterable<? extends Path> cpkArchives, @Nullable Reader metadataReader, @Nullable SigningParameters signingParams, boolean useSignatures) {
        Reader reader;
        block9: {
            block8: {
                Config config;
                Intrinsics.checkNotNullParameter(cpkFiles2, (String)"cpkFiles");
                Intrinsics.checkNotNullParameter(cpkArchives, (String)"cpkArchives");
                this.cpkFiles = cpkFiles2;
                this.cpkArchives = cpkArchives;
                this.signingParams = signingParams;
                this.useSignatures = useSignatures;
                CpbBuilder cpbBuilder = this;
                reader = metadataReader;
                if (reader == null) break block8;
                Closeable closeable = reader;
                CpbBuilder cpbBuilder2 = cpbBuilder;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    Reader it = (Reader)closeable;
                    boolean bl3 = false;
                    config = ConfigFactory.parseReader((Reader)it, (ConfigParseOptions)ConfigParseOptions.defaults());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Config config2 = config;
                cpbBuilder = cpbBuilder2;
                reader = config2;
                if (reader != null) break block9;
            }
            Config config = ConfigFactory.empty();
            reader = config;
            Intrinsics.checkNotNullExpressionValue((Object)config, (String)"ConfigFactory.empty()");
        }
        cpbBuilder.metadata = reader;
    }

    public /* synthetic */ CpbBuilder(Iterable iterable, Iterable iterable2, Reader reader, SigningParameters signingParameters, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            reader = null;
        }
        this(iterable, iterable2, reader, signingParameters, bl);
    }

    public static final /* synthetic */ Config access$getMetadata$p(CpbBuilder $this) {
        return $this.metadata;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lnet/corda/packaging/internal/CpbBuilder$CpkData;", "", "cpk", "Lnet/corda/packaging/Cpk;", "path", "Ljava/nio/file/Path;", "(Lnet/corda/packaging/Cpk;Ljava/nio/file/Path;)V", "getCpk", "()Lnet/corda/packaging/Cpk;", "getPath", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "packaging"})
    private static final class CpkData {
        @NotNull
        private final Cpk cpk;
        @NotNull
        private final Path path;

        @NotNull
        public final Cpk getCpk() {
            return this.cpk;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public CpkData(@NotNull Cpk cpk, @NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)cpk, (String)"cpk");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.cpk = cpk;
            this.path = path;
        }

        @NotNull
        public final Cpk component1() {
            return this.cpk;
        }

        @NotNull
        public final Path component2() {
            return this.path;
        }

        @NotNull
        public final CpkData copy(@NotNull Cpk cpk, @NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)cpk, (String)"cpk");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new CpkData(cpk, path);
        }

        public static /* synthetic */ CpkData copy$default(CpkData cpkData, Cpk cpk, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                cpk = cpkData.cpk;
            }
            if ((n & 2) != 0) {
                path = cpkData.path;
            }
            return cpkData.copy(cpk, path);
        }

        @NotNull
        public String toString() {
            return "CpkData(cpk=" + this.cpk + ", path=" + this.path + ")";
        }

        public int hashCode() {
            Cpk cpk = this.cpk;
            Path path = this.path;
            return (cpk != null ? cpk.hashCode() : 0) * 31 + (path != null ? ((Object)path).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CpkData)) break block3;
                    CpkData cpkData = (CpkData)object;
                    if (!Intrinsics.areEqual((Object)this.cpk, (Object)cpkData.cpk) || !Intrinsics.areEqual((Object)this.path, (Object)cpkData.path)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

