/*
 * Decompiled with CFR 0.152.
 */
package net.corda.packaging;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;

public class VersionComparator
implements Comparator<String> {
    private static char[] defaultEpoch = new char[]{'0'};

    private static int indexOf(char[] haystack, char needle, int start) {
        int result = -1;
        for (int i2 = start; i2 < haystack.length; ++i2) {
            if (haystack[i2] != needle) continue;
            result = i2;
            break;
        }
        return result;
    }

    private static int indexOf(char[] haystack, char needle) {
        return VersionComparator.indexOf(haystack, needle, 0);
    }

    private static char[] cstring(String s) {
        char[] result = new char[s.length() + 1];
        for (int i2 = 0; i2 < s.length(); ++i2) {
            result[i2] = s.charAt(i2);
        }
        result[s.length()] = '\u0000';
        return result;
    }

    private static boolean cstringEquals(char[] cstring1, int begin1, char[] cstring2, int begin2) {
        for (int i2 = 0; i2 < cstring1.length + begin1 || i2 < cstring2.length + begin2; ++i2) {
            char c1 = cstring1[begin1 + i2];
            char c2 = cstring2[begin2 + i2];
            if (c1 != c2) {
                return false;
            }
            if (c1 == '\u0000') break;
        }
        return true;
    }

    private static int strlen(char[] cstring, int begin) {
        int i2;
        for (i2 = begin; i2 < cstring.length && cstring[i2] != '\u0000'; ++i2) {
        }
        return i2 - begin;
    }

    private static int strlen(char[] cstring) {
        return VersionComparator.strlen(cstring, 0);
    }

    private static int strcmp(char[] cstring1, int begin1, char[] cstring2, int begin2) {
        int lim = Math.min(VersionComparator.strlen(cstring1, begin1), VersionComparator.strlen(cstring2, begin2));
        for (int i2 = 0; i2 < lim; ++i2) {
            char c1 = cstring1[begin1 + i2];
            char c2 = cstring2[begin2 + i2];
            if (c1 < c2) {
                return -1;
            }
            if (c1 <= c2) continue;
            return 1;
        }
        return Integer.compare(cstring1.length, cstring2.length);
    }

    private static void parseEVR(char[] text, int[] evr) {
        int release;
        int version;
        int epoch;
        int s;
        for (s = 0; s < text.length && Character.isDigit(text[s]); ++s) {
        }
        int se = VersionComparator.indexOf(text, '-', s);
        if (text[s] == ':') {
            epoch = 0;
            text[s++] = '\u0000';
            version = s;
            if (text[epoch] == '\u0000') {
                epoch = -1;
            }
        } else {
            epoch = -1;
            version = 0;
        }
        if (se != -1) {
            text[se++] = '\u0000';
            release = se;
        } else {
            release = -1;
        }
        evr[0] = epoch;
        evr[1] = version;
        evr[2] = release;
    }

    private static int rpmvercmp(char[] chars1, int start1, char[] chars2, int start2) {
        if (VersionComparator.strcmp(chars1, start1, chars2, start2) == 0) {
            return 0;
        }
        char[] str1 = Arrays.copyOfRange(chars1, start1, start1 + VersionComparator.strlen(chars1, start1) + 1);
        char[] str2 = Arrays.copyOfRange(chars2, start2, start2 + VersionComparator.strlen(chars2, start2) + 1);
        int one = 0;
        int two = 0;
        int ptr1 = 0;
        int ptr2 = 0;
        while (str1[one] != '\u0000' && str2[two] != '\u0000') {
            int rc;
            boolean isNum;
            char c2;
            char c1;
            while ((c1 = str1[one]) != '\u0000' && !Character.isAlphabetic(c1) && !Character.isDigit(c1)) {
                ++one;
            }
            while ((c2 = str2[two]) != '\u0000' && !Character.isAlphabetic(c2) && !Character.isDigit(c2)) {
                ++two;
            }
            if (c1 == '\u0000' || c2 == '\u0000') break;
            if (one - ptr1 != two - ptr2) {
                return one - ptr1 < two - ptr2 ? -1 : 1;
            }
            ptr1 = one;
            ptr2 = two;
            if (Character.isDigit(str1[ptr1])) {
                while ((c1 = str1[ptr1]) != '\u0000' && Character.isDigit(c1)) {
                    ++ptr1;
                }
                while ((c2 = str2[ptr2]) != '\u0000' && Character.isDigit(c2)) {
                    ++ptr2;
                }
                isNum = true;
            } else {
                while ((c1 = str1[ptr1]) != '\u0000' && Character.isAlphabetic(c1)) {
                    ++ptr1;
                }
                while ((c2 = str2[ptr2]) != '\u0000' && Character.isAlphabetic(c2)) {
                    ++ptr2;
                }
                isNum = false;
            }
            char oldch1 = str1[ptr1];
            str1[ptr1] = '\u0000';
            char oldch2 = str2[ptr2];
            str2[ptr2] = '\u0000';
            if (one == ptr1) {
                return -1;
            }
            if (two == ptr2) {
                return isNum ? 1 : -1;
            }
            if (isNum) {
                int len2;
                while (str1[one] == '0') {
                    ++one;
                }
                while (str2[two] == '0') {
                    ++two;
                }
                int len1 = VersionComparator.strlen(str1, one);
                if (len1 > (len2 = VersionComparator.strlen(str2, two))) {
                    return 1;
                }
                if (len2 > len1) {
                    return -1;
                }
            }
            if ((rc = VersionComparator.strcmp(str1, one, str2, two)) != 0) {
                return rc;
            }
            str1[ptr1] = oldch1;
            one = ptr1;
            str2[ptr2] = oldch2;
            two = ptr2;
        }
        if (str1[one] == '\u0000' && str2[two] == '\u0000') {
            return 0;
        }
        if (str1[one] == '\u0000' && !Character.isAlphabetic(str2[two]) || Character.isAlphabetic(str1[one])) {
            return -1;
        }
        return 1;
    }

    public static int cmp(String v1, String v2) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (Objects.equals(v1, v2)) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (v1.length() == 0) {
            return -1;
        }
        if (v2.length() == 0) {
            return 1;
        }
        char[] chars1 = VersionComparator.cstring(v1);
        char[] chars2 = VersionComparator.cstring(v2);
        int[] evr = new int[3];
        VersionComparator.parseEVR(chars1, evr);
        int epoch1 = evr[0];
        int version1 = evr[1];
        int release1 = evr[2];
        VersionComparator.parseEVR(chars2, evr);
        int epoch2 = evr[0];
        int version2 = evr[1];
        int release2 = evr[2];
        char[] seq1 = epoch1 == -1 ? defaultEpoch : chars1;
        char[] seq2 = epoch2 == -1 ? defaultEpoch : chars2;
        int ret = VersionComparator.rpmvercmp(seq1, epoch1 == -1 ? 0 : epoch1, seq2, epoch2 == -1 ? 0 : epoch2);
        if (ret == 0 && (ret = VersionComparator.rpmvercmp(chars1, version1, chars2, version2)) == 0 && release1 != -1 && release2 != -1) {
            ret = VersionComparator.rpmvercmp(chars1, release1, chars2, release2);
        }
        return ret;
    }

    @Override
    public int compare(String v1, String v2) {
        return VersionComparator.cmp(v1, v2);
    }
}

