/*
 * Decompiled with CFR 0.152.
 */
package net.corda.packaging;

import java.io.File;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.zip.ZipFile;
import jdk.security.jarsigner.JarSigner;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.crypto.DigestAlgorithmName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 \r2\u00020\u0001:\u0001\rB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lnet/corda/packaging/SigningParameters;", "", "keyStore", "Ljava/security/KeyStore;", "keyAlias", "", "keyPassword", "(Ljava/security/KeyStore;Ljava/lang/String;Ljava/lang/String;)V", "getKeyAlias", "()Ljava/lang/String;", "getKeyPassword", "getKeyStore", "()Ljava/security/KeyStore;", "Companion", "packaging"})
public final class SigningParameters {
    @NotNull
    private final KeyStore keyStore;
    @NotNull
    private final String keyAlias;
    @Nullable
    private final String keyPassword;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final KeyStore getKeyStore() {
        return this.keyStore;
    }

    @NotNull
    public final String getKeyAlias() {
        return this.keyAlias;
    }

    @Nullable
    public final String getKeyPassword() {
        return this.keyPassword;
    }

    public SigningParameters(@NotNull KeyStore keyStore, @NotNull String keyAlias, @Nullable String keyPassword) {
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        this.keyStore = keyStore;
        this.keyAlias = keyAlias;
        this.keyPassword = keyPassword;
    }

    public /* synthetic */ SigningParameters(KeyStore keyStore, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(keyStore, string, string2);
    }

    @JvmStatic
    public static final void sign(@NotNull File originalFile, @NotNull OutputStream outputStream, @NotNull SigningParameters params) {
        Companion.sign(originalFile, outputStream, params);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lnet/corda/packaging/SigningParameters$Companion;", "", "()V", "sign", "", "originalFile", "Ljava/io/File;", "outputStream", "Ljava/io/OutputStream;", "params", "Lnet/corda/packaging/SigningParameters;", "packaging"})
    public static final class Companion {
        @JvmStatic
        public final void sign(@NotNull File originalFile, @NotNull OutputStream outputStream, @NotNull SigningParameters params) {
            char[] cArray;
            Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Certificate certificate = params.getKeyStore().getCertificate(params.getKeyAlias());
            if (certificate == null) {
                throw (Throwable)new IllegalArgumentException("The specified keystore does not contain a key with alias '" + params.getKeyAlias() + '\'');
            }
            Certificate signingCertificate = certificate;
            CertPath certPath = CertificateFactory.getInstance("X.509").generateCertPath(CollectionsKt.listOf((Object)signingCertificate));
            KeyStore keyStore = params.getKeyStore();
            String string = params.getKeyAlias();
            String string2 = params.getKeyPassword();
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                char[] cArray2 = string4.toCharArray();
                cArray = cArray2;
                Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
            } else {
                cArray = null;
            }
            Key key = keyStore.getKey(string, cArray);
            if (key == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.PrivateKey");
            }
            PrivateKey key2 = (PrivateKey)key;
            new JarSigner.Builder(key2, certPath).digestAlgorithm(DigestAlgorithmName.SHA2_256.getName()).build().sign(new ZipFile(originalFile), outputStream);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

