/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.protonwrapper.netty;

import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/netty/ConnectionChange;", "", "remoteAddress", "Ljava/net/InetSocketAddress;", "remoteCert", "Ljava/security/cert/X509Certificate;", "connected", "", "badCert", "(Ljava/net/InetSocketAddress;Ljava/security/cert/X509Certificate;ZZ)V", "getBadCert", "()Z", "getConnected", "getRemoteAddress", "()Ljava/net/InetSocketAddress;", "getRemoteCert", "()Ljava/security/cert/X509Certificate;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "node-api"})
public final class ConnectionChange {
    @NotNull
    private final InetSocketAddress remoteAddress;
    @Nullable
    private final X509Certificate remoteCert;
    private final boolean connected;
    private final boolean badCert;

    @NotNull
    public String toString() {
        X509Certificate x509Certificate = this.remoteCert;
        return "ConnectionChange remoteAddress: " + this.remoteAddress + " connected state: " + this.connected + " cert subject: " + (x509Certificate != null ? x509Certificate.getSubjectDN() : null) + " cert ok: " + !this.badCert;
    }

    @NotNull
    public final InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Nullable
    public final X509Certificate getRemoteCert() {
        return this.remoteCert;
    }

    public final boolean getConnected() {
        return this.connected;
    }

    public final boolean getBadCert() {
        return this.badCert;
    }

    public ConnectionChange(@NotNull InetSocketAddress remoteAddress, @Nullable X509Certificate remoteCert, boolean connected, boolean badCert) {
        Intrinsics.checkParameterIsNotNull((Object)remoteAddress, (String)"remoteAddress");
        this.remoteAddress = remoteAddress;
        this.remoteCert = remoteCert;
        this.connected = connected;
        this.badCert = badCert;
    }

    @NotNull
    public final InetSocketAddress component1() {
        return this.remoteAddress;
    }

    @Nullable
    public final X509Certificate component2() {
        return this.remoteCert;
    }

    public final boolean component3() {
        return this.connected;
    }

    public final boolean component4() {
        return this.badCert;
    }

    @NotNull
    public final ConnectionChange copy(@NotNull InetSocketAddress remoteAddress, @Nullable X509Certificate remoteCert, boolean connected, boolean badCert) {
        Intrinsics.checkParameterIsNotNull((Object)remoteAddress, (String)"remoteAddress");
        return new ConnectionChange(remoteAddress, remoteCert, connected, badCert);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ConnectionChange copy$default(ConnectionChange connectionChange, InetSocketAddress inetSocketAddress, X509Certificate x509Certificate, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            inetSocketAddress = connectionChange.remoteAddress;
        }
        if ((n & 2) != 0) {
            x509Certificate = connectionChange.remoteCert;
        }
        if ((n & 4) != 0) {
            bl = connectionChange.connected;
        }
        if ((n & 8) != 0) {
            bl2 = connectionChange.badCert;
        }
        return connectionChange.copy(inetSocketAddress, x509Certificate, bl, bl2);
    }

    public int hashCode() {
        InetSocketAddress inetSocketAddress = this.remoteAddress;
        X509Certificate x509Certificate = this.remoteCert;
        int n = ((inetSocketAddress != null ? ((Object)inetSocketAddress).hashCode() : 0) * 31 + (x509Certificate != null ? ((Object)x509Certificate).hashCode() : 0)) * 31;
        int n2 = this.connected ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        int n3 = (n + n2) * 31;
        int n4 = this.badCert ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        return n3 + n4;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ConnectionChange)) break block3;
                ConnectionChange connectionChange = (ConnectionChange)object;
                if (!Intrinsics.areEqual((Object)this.remoteAddress, (Object)connectionChange.remoteAddress) || !Intrinsics.areEqual((Object)this.remoteCert, (Object)connectionChange.remoteCert) || !(this.connected == connectionChange.connected) || !(this.badCert == connectionChange.badCert)) break block3;
            }
            return true;
        }
        return false;
    }
}

