/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.protonwrapper.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.nodeapi.internal.crypto.X509UtilitiesKt;
import net.corda.nodeapi.internal.protonwrapper.engine.EventProcessor;
import net.corda.nodeapi.internal.protonwrapper.messages.ReceivedMessage;
import net.corda.nodeapi.internal.protonwrapper.messages.impl.ReceivedMessageImpl;
import net.corda.nodeapi.internal.protonwrapper.messages.impl.SendableMessageImpl;
import net.corda.nodeapi.internal.protonwrapper.netty.AMQPChannelHandler;
import net.corda.nodeapi.internal.protonwrapper.netty.ConnectionChange;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.ProtonJTransport;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.framing.TransportFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.MDC;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 52\u00020\u0001:\u00015B\u008d\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u001e\u0010\u000b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u0012\u0004\u0012\u00020\u00100\f\u0012\u001e\u0010\u0011\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u0012\u0004\u0012\u00020\u00100\f\u0012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\f\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010%\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0016J\u0016\u0010(\u001a\u00020\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0)H\u0002J\u001c\u0010*\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\b2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010'H\u0002J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\bH\u0002J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\bH\u0002J\u0018\u0010.\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020#H\u0016J\u0016\u00100\u001a\u00020\u00102\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00100)H\u0002J \u00102\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPChannelHandler;", "Lio/netty/channel/ChannelDuplexHandler;", "serverMode", "", "allowedRemoteLegalNames", "", "Lnet/corda/core/identity/CordaX500Name;", "userName", "", "password", "trace", "onOpen", "Lkotlin/Function1;", "Lkotlin/Pair;", "Lio/netty/channel/socket/SocketChannel;", "Lnet/corda/nodeapi/internal/protonwrapper/netty/ConnectionChange;", "", "onClose", "onReceive", "Lnet/corda/nodeapi/internal/protonwrapper/messages/ReceivedMessage;", "(ZLjava/util/Set;Ljava/lang/String;Ljava/lang/String;ZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "badCert", "eventProcessor", "Lnet/corda/nodeapi/internal/protonwrapper/engine/EventProcessor;", "localCert", "Ljava/security/cert/X509Certificate;", "remoteAddress", "Ljava/net/InetSocketAddress;", "remoteCert", "channelActive", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead", "msg", "", "createAMQPEngine", "exceptionCaught", "cause", "", "logDebugWithMDC", "Lkotlin/Function0;", "logErrorWithMDC", "ex", "logInfoWithMDC", "logWarnWithMDC", "userEventTriggered", "evt", "withMDC", "block", "write", "promise", "Lio/netty/channel/ChannelPromise;", "Companion", "node-api"})
public final class AMQPChannelHandler
extends ChannelDuplexHandler {
    private InetSocketAddress remoteAddress;
    private X509Certificate localCert;
    private X509Certificate remoteCert;
    private EventProcessor eventProcessor;
    private boolean badCert;
    private final boolean serverMode;
    private final Set<CordaX500Name> allowedRemoteLegalNames;
    private final String userName;
    private final String password;
    private final boolean trace;
    private final Function1<Pair<? extends SocketChannel, ConnectionChange>, Unit> onOpen;
    private final Function1<Pair<? extends SocketChannel, ConnectionChange>, Unit> onClose;
    private final Function1<ReceivedMessage, Unit> onReceive;
    private static final Logger log;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withMDC(Function0<Unit> block) {
        Map map = MDC.getCopyOfContextMap();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map oldMDC = map;
        try {
            MDC.put((String)"serverMode", (String)String.valueOf(this.serverMode));
            InetSocketAddress inetSocketAddress = this.remoteAddress;
            if (inetSocketAddress == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remoteAddress");
            }
            MDC.put((String)"remoteAddress", (String)inetSocketAddress.toString());
            Object object = this.localCert;
            MDC.put((String)"localCert", object != null && (object = ((X509Certificate)object).getSubjectDN()) != null ? object.toString() : null);
            Object object2 = this.remoteCert;
            MDC.put((String)"remoteCert", object2 != null && (object2 = ((X509Certificate)object2).getSubjectDN()) != null ? object2.toString() : null);
            Set<CordaX500Name> set2 = this.allowedRemoteLegalNames;
            MDC.put((String)"allowedRemoteLegalNames", set2 != null ? CollectionsKt.joinToString$default((Iterable)set2, (CharSequence)";", null, null, (int)0, null, (Function1)withMDC.1.INSTANCE, (int)30, null) : null);
            block.invoke();
        }
        finally {
            MDC.setContextMap((Map)oldMDC);
        }
    }

    private final void logDebugWithMDC(Function0<String> msg) {
        if (log.isDebugEnabled()) {
            this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(msg){
                final /* synthetic */ Function0 $msg;

                public final void invoke() {
                    AMQPChannelHandler.access$getLog$cp().debug((String)this.$msg.invoke());
                }
                {
                    this.$msg = function0;
                    super(0);
                }
            }));
        }
    }

    private final void logInfoWithMDC(String msg) {
        this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(msg){
            final /* synthetic */ String $msg;

            public final void invoke() {
                AMQPChannelHandler.access$getLog$cp().info(this.$msg);
            }
            {
                this.$msg = string;
                super(0);
            }
        }));
    }

    private final void logWarnWithMDC(String msg) {
        this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(msg){
            final /* synthetic */ String $msg;

            public final void invoke() {
                AMQPChannelHandler.access$getLog$cp().warn(this.$msg);
            }
            {
                this.$msg = string;
                super(0);
            }
        }));
    }

    private final void logErrorWithMDC(String msg, Throwable ex) {
        this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(msg, ex){
            final /* synthetic */ String $msg;
            final /* synthetic */ Throwable $ex;

            public final void invoke() {
                AMQPChannelHandler.access$getLog$cp().error(this.$msg, this.$ex);
            }
            {
                this.$msg = string;
                this.$ex = throwable;
                super(0);
            }
        }));
    }

    static /* bridge */ /* synthetic */ void logErrorWithMDC$default(AMQPChannelHandler aMQPChannelHandler, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        aMQPChannelHandler.logErrorWithMDC(string, throwable);
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Channel ch = ctx.channel();
        SocketAddress socketAddress = ch.remoteAddress();
        if (socketAddress == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        this.remoteAddress = (InetSocketAddress)socketAddress;
        SocketAddress socketAddress2 = ch.localAddress();
        if (socketAddress2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        InetSocketAddress localAddress = (InetSocketAddress)socketAddress2;
        StringBuilder stringBuilder = new StringBuilder().append("New client connection ").append(ch.id()).append(" from ");
        InetSocketAddress inetSocketAddress = this.remoteAddress;
        if (inetSocketAddress == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteAddress");
        }
        this.logInfoWithMDC(stringBuilder.append(inetSocketAddress).append(" to ").append(localAddress).toString());
    }

    private final void createAMQPEngine(ChannelHandlerContext ctx) {
        Channel ch;
        Channel channel = ch = ctx.channel();
        Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"ch");
        X509Certificate x509Certificate = this.localCert;
        if (x509Certificate == null) {
            Intrinsics.throwNpe();
        }
        String string = x509Certificate.getSubjectX500Principal().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localCert!!.subjectX500Principal.toString()");
        X509Certificate x509Certificate2 = this.remoteCert;
        if (x509Certificate2 == null) {
            Intrinsics.throwNpe();
        }
        String string2 = x509Certificate2.getSubjectX500Principal().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"remoteCert!!.subjectX500Principal.toString()");
        EventProcessor eventProcessor = this.eventProcessor = new EventProcessor(channel, this.serverMode, string, string2, this.userName, this.password);
        if (eventProcessor == null) {
            Intrinsics.throwNpe();
        }
        Connection connection2 = eventProcessor.getConnection();
        Transport transport = connection2.getTransport();
        if (transport == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.qpid.proton.engine.ProtonJTransport");
        }
        ProtonJTransport transport2 = (ProtonJTransport)transport;
        if (this.trace) {
            transport2.setProtocolTracer(new ProtocolTracer(this){
                final /* synthetic */ AMQPChannelHandler this$0;

                public void sentFrame(@NotNull TransportFrame transportFrame) {
                    Intrinsics.checkParameterIsNotNull((Object)transportFrame, (String)"transportFrame");
                    AMQPChannelHandler.access$logInfoWithMDC(this.this$0, String.valueOf(transportFrame.getBody()));
                }

                public void receivedFrame(@NotNull TransportFrame transportFrame) {
                    Intrinsics.checkParameterIsNotNull((Object)transportFrame, (String)"transportFrame");
                    AMQPChannelHandler.access$logInfoWithMDC(this.this$0, String.valueOf(transportFrame.getBody()));
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
        ctx.fireChannelActive();
        EventProcessor eventProcessor2 = this.eventProcessor;
        if (eventProcessor2 == null) {
            Intrinsics.throwNpe();
        }
        eventProcessor2.processEventsAsync();
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Channel ch = ctx.channel();
        StringBuilder stringBuilder = new StringBuilder().append("Closed client connection ").append(ch.id()).append(" from ");
        InetSocketAddress inetSocketAddress = this.remoteAddress;
        if (inetSocketAddress == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteAddress");
        }
        this.logInfoWithMDC(stringBuilder.append(inetSocketAddress).append(" to ").append(ch.localAddress()).toString());
        Channel channel = ch;
        if (channel == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.netty.channel.socket.SocketChannel");
        }
        SocketChannel socketChannel = (SocketChannel)channel;
        InetSocketAddress inetSocketAddress2 = this.remoteAddress;
        if (inetSocketAddress2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteAddress");
        }
        this.onClose.invoke((Object)new Pair((Object)socketChannel, (Object)new ConnectionChange(inetSocketAddress2, this.remoteCert, false, this.badCert)));
        EventProcessor eventProcessor = this.eventProcessor;
        if (eventProcessor != null) {
            eventProcessor.close();
        }
        ctx.fireChannelInactive();
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)evt, (String)"evt");
        if (evt instanceof SslHandshakeCompletionEvent) {
            if (((SslHandshakeCompletionEvent)evt).isSuccess()) {
                CordaX500Name cordaX500Name;
                SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                SSLEngine sSLEngine = sslHandler.engine();
                Intrinsics.checkExpressionValueIsNotNull((Object)sSLEngine, (String)"sslHandler.engine()");
                SSLSession sSLSession = sSLEngine.getSession();
                Intrinsics.checkExpressionValueIsNotNull((Object)sSLSession, (String)"sslHandler.engine().session");
                Certificate certificate = sSLSession.getLocalCertificates()[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)certificate, (String)"sslHandler.engine().session.localCertificates[0]");
                this.localCert = X509UtilitiesKt.getX509(certificate);
                SSLEngine sSLEngine2 = sslHandler.engine();
                Intrinsics.checkExpressionValueIsNotNull((Object)sSLEngine2, (String)"sslHandler.engine()");
                SSLSession sSLSession2 = sSLEngine2.getSession();
                Intrinsics.checkExpressionValueIsNotNull((Object)sSLSession2, (String)"sslHandler.engine().session");
                Certificate certificate2 = sSLSession2.getPeerCertificates()[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)certificate2, (String)"sslHandler.engine().session.peerCertificates[0]");
                this.remoteCert = X509UtilitiesKt.getX509(certificate2);
                try {
                    X509Certificate x509Certificate = this.remoteCert;
                    if (x509Certificate == null) {
                        Intrinsics.throwNpe();
                    }
                    X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                    Intrinsics.checkExpressionValueIsNotNull((Object)x500Principal, (String)"remoteCert!!.subjectX500Principal");
                    cordaX500Name = CordaX500Name.Companion.build(x500Principal);
                }
                catch (IllegalArgumentException ex) {
                    this.badCert = true;
                    this.logErrorWithMDC("Certificate subject not a valid CordaX500Name", ex);
                    ctx.close();
                    return;
                }
                CordaX500Name remoteX500Name = cordaX500Name;
                if (this.allowedRemoteLegalNames != null && !this.allowedRemoteLegalNames.contains(remoteX500Name)) {
                    this.badCert = true;
                    AMQPChannelHandler.logErrorWithMDC$default(this, "Provided certificate subject " + remoteX500Name + " not in expected set " + this.allowedRemoteLegalNames, null, 2, null);
                    ctx.close();
                    return;
                }
                this.logInfoWithMDC("Handshake completed with subject: " + remoteX500Name);
                this.createAMQPEngine(ctx);
                Channel channel = ctx.channel();
                if (channel == null) {
                    throw new TypeCastException("null cannot be cast to non-null type io.netty.channel.socket.SocketChannel");
                }
                SocketChannel socketChannel = (SocketChannel)channel;
                InetSocketAddress inetSocketAddress = this.remoteAddress;
                if (inetSocketAddress == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"remoteAddress");
                }
                this.onOpen.invoke((Object)new Pair((Object)socketChannel, (Object)new ConnectionChange(inetSocketAddress, this.remoteCert, true, false)));
            } else {
                Throwable cause = ((SslHandshakeCompletionEvent)evt).cause();
                if (cause instanceof ClosedChannelException) {
                    this.logWarnWithMDC("SSL Handshake closed early.");
                } else if (cause instanceof SSLException && Intrinsics.areEqual((Object)cause.getMessage(), (Object)"handshake timed out")) {
                    this.logWarnWithMDC("SSL Handshake timed out");
                } else {
                    this.badCert = true;
                }
                AMQPChannelHandler.logErrorWithMDC$default(this, "Handshake failure " + ((SslHandshakeCompletionEvent)evt).cause().getMessage(), null, 2, null);
                if (log.isTraceEnabled()) {
                    this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(evt){
                        final /* synthetic */ Object $evt;

                        public final void invoke() {
                            AMQPChannelHandler.access$getLog$cp().trace("Handshake failure", ((SslHandshakeCompletionEvent)this.$evt).cause());
                        }
                        {
                            this.$evt = object;
                            super(0);
                        }
                    }));
                }
                ctx.close();
            }
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        this.logWarnWithMDC("Closing channel due to nonrecoverable exception " + cause.getMessage());
        if (log.isTraceEnabled()) {
            this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(cause){
                final /* synthetic */ Throwable $cause;

                public final void invoke() {
                    AMQPChannelHandler.access$getLog$cp().trace("Pipeline uncaught exception", this.$cause);
                }
                {
                    this.$cause = throwable;
                    super(0);
                }
            }));
        }
        ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        try {
            if (msg instanceof ByteBuf) {
                EventProcessor eventProcessor = this.eventProcessor;
                if (eventProcessor == null) {
                    Intrinsics.throwNpe();
                }
                eventProcessor.transportProcessInput((ByteBuf)msg);
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
        EventProcessor eventProcessor = this.eventProcessor;
        if (eventProcessor == null) {
            Intrinsics.throwNpe();
        }
        eventProcessor.processEventsAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull((Object)promise, (String)"promise");
        try {
            try {
                Object object = msg;
                if (object instanceof SendableMessageImpl) {
                    InetSocketAddress inetAddress = new InetSocketAddress(((SendableMessageImpl)msg).getDestinationLink().getHost(), ((SendableMessageImpl)msg).getDestinationLink().getPort());
                    this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(this, inetAddress){
                        final /* synthetic */ AMQPChannelHandler this$0;
                        final /* synthetic */ InetSocketAddress $inetAddress;

                        @NotNull
                        public final String invoke() {
                            return "Message for endpoint " + this.$inetAddress + " , expected " + AMQPChannelHandler.access$getRemoteAddress$p(this.this$0) + ' ';
                        }
                        {
                            this.this$0 = aMQPChannelHandler;
                            this.$inetAddress = inetSocketAddress;
                            super(0);
                        }
                    }));
                    CordaX500Name cordaX500Name = CordaX500Name.Companion.parse(((SendableMessageImpl)msg).getDestinationLegalName());
                    X509Certificate x509Certificate = this.remoteCert;
                    if (x509Certificate == null) {
                        Intrinsics.throwNpe();
                    }
                    X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                    Intrinsics.checkExpressionValueIsNotNull((Object)x500Principal, (String)"remoteCert!!.subjectX500Principal");
                    boolean bl = Intrinsics.areEqual((Object)cordaX500Name, (Object)CordaX500Name.Companion.build(x500Principal));
                    if (!bl) {
                        StringBuilder stringBuilder = new StringBuilder().append("Message for incorrect legal identity ").append(((SendableMessageImpl)msg).getDestinationLegalName()).append(" expected ");
                        X509Certificate x509Certificate2 = this.remoteCert;
                        if (x509Certificate2 == null) {
                            Intrinsics.throwNpe();
                        }
                        String string = stringBuilder.append(x509Certificate2.getSubjectX500Principal()).toString();
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(msg){
                        final /* synthetic */ Object $msg;

                        @NotNull
                        public final String invoke() {
                            return "channel write " + ((SendableMessageImpl)this.$msg).getApplicationProperties().get("_AMQ_DUPL_ID");
                        }
                        {
                            this.$msg = object;
                            super(0);
                        }
                    }));
                    EventProcessor eventProcessor = this.eventProcessor;
                    if (eventProcessor == null) {
                        Intrinsics.throwNpe();
                    }
                    eventProcessor.transportWriteMessage((SendableMessageImpl)msg);
                } else if (object instanceof ReceivedMessage) {
                    this.onReceive.invoke(msg);
                } else if (object instanceof Transport) {
                    EventProcessor eventProcessor = this.eventProcessor;
                    if (eventProcessor == null) {
                        Intrinsics.throwNpe();
                    }
                    eventProcessor.transportProcessOutput(ctx);
                } else if (object instanceof ReceivedMessageImpl.MessageCompleter) {
                    EventProcessor eventProcessor = this.eventProcessor;
                    if (eventProcessor == null) {
                        Intrinsics.throwNpe();
                    }
                    eventProcessor.complete((ReceivedMessageImpl.MessageCompleter)msg);
                }
            }
            catch (Exception ex) {
                this.logErrorWithMDC("Error in AMQP write processing", ex);
                throw (Throwable)ex;
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
        EventProcessor eventProcessor = this.eventProcessor;
        if (eventProcessor == null) {
            Intrinsics.throwNpe();
        }
        eventProcessor.processEventsAsync();
    }

    public AMQPChannelHandler(boolean serverMode, @Nullable Set<CordaX500Name> allowedRemoteLegalNames, @Nullable String userName, @Nullable String password, boolean trace, @NotNull Function1<? super Pair<? extends SocketChannel, ConnectionChange>, Unit> onOpen, @NotNull Function1<? super Pair<? extends SocketChannel, ConnectionChange>, Unit> onClose2, @NotNull Function1<? super ReceivedMessage, Unit> onReceive) {
        Intrinsics.checkParameterIsNotNull(onOpen, (String)"onOpen");
        Intrinsics.checkParameterIsNotNull(onClose2, (String)"onClose");
        Intrinsics.checkParameterIsNotNull(onReceive, (String)"onReceive");
        this.serverMode = serverMode;
        this.allowedRemoteLegalNames = allowedRemoteLegalNames;
        this.userName = userName;
        this.password = password;
        this.trace = trace;
        this.onOpen = onOpen;
        this.onClose = onClose2;
        this.onReceive = onReceive;
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ void access$logInfoWithMDC(AMQPChannelHandler $this, @NotNull String msg) {
        $this.logInfoWithMDC(msg);
    }

    @NotNull
    public static final /* synthetic */ InetSocketAddress access$getRemoteAddress$p(AMQPChannelHandler $this) {
        InetSocketAddress inetSocketAddress = $this.remoteAddress;
        if (inetSocketAddress == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteAddress");
        }
        return inetSocketAddress;
    }

    public static final /* synthetic */ void access$setRemoteAddress$p(AMQPChannelHandler $this, @NotNull InetSocketAddress inetSocketAddress) {
        $this.remoteAddress = inetSocketAddress;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPChannelHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "node-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

