/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.protonwrapper.engine;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\r\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\nH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006&"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/engine/NettyWritable;", "Lorg/apache/qpid/proton/codec/WritableBuffer;", "nettyBuffer", "Lio/netty/buffer/ByteBuf;", "(Lio/netty/buffer/ByteBuf;)V", "getNettyBuffer", "()Lio/netty/buffer/ByteBuf;", "hasRemaining", "", "limit", "", "position", "", "put", "payload", "Ljava/nio/ByteBuffer;", "b", "", "src", "", "offset", "length", "Lorg/apache/qpid/proton/codec/ReadableBuffer;", "putDouble", "d", "", "putFloat", "f", "", "putInt", "i", "putLong", "l", "", "putShort", "s", "", "remaining", "node-api"})
public final class NettyWritable
implements WritableBuffer {
    @NotNull
    private final ByteBuf nettyBuffer;

    public void put(byte b) {
        this.nettyBuffer.writeByte((int)b);
    }

    public void putFloat(float f) {
        this.nettyBuffer.writeFloat(f);
    }

    public void putDouble(double d) {
        this.nettyBuffer.writeDouble(d);
    }

    public void put(@NotNull byte[] src, int offset, int length) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        this.nettyBuffer.writeBytes(src, offset, length);
    }

    public void putShort(short s) {
        this.nettyBuffer.writeShort((int)s);
    }

    public void putInt(int i2) {
        this.nettyBuffer.writeInt(i2);
    }

    public void putLong(long l) {
        this.nettyBuffer.writeLong(l);
    }

    public boolean hasRemaining() {
        return this.nettyBuffer.writerIndex() < this.nettyBuffer.capacity();
    }

    public int remaining() {
        return this.nettyBuffer.capacity() - this.nettyBuffer.writerIndex();
    }

    public int position() {
        return this.nettyBuffer.writerIndex();
    }

    public void position(int position) {
        this.nettyBuffer.writerIndex(position);
    }

    public void put(@NotNull ByteBuffer payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        this.nettyBuffer.writeBytes(payload);
    }

    public void put(@NotNull ReadableBuffer payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        this.nettyBuffer.writeBytes(payload.byteBuffer());
    }

    public int limit() {
        return this.nettyBuffer.capacity();
    }

    @NotNull
    public final ByteBuf getNettyBuffer() {
        return this.nettyBuffer;
    }

    public NettyWritable(@NotNull ByteBuf nettyBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)nettyBuffer, (String)"nettyBuffer");
        this.nettyBuffer = nettyBuffer;
    }
}

