/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.protonwrapper.engine;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.nodeapi.internal.protonwrapper.engine.ConnectionStateMachine;
import net.corda.nodeapi.internal.protonwrapper.engine.NettyWritable;
import net.corda.nodeapi.internal.protonwrapper.messages.MessageStatus;
import net.corda.nodeapi.internal.protonwrapper.messages.impl.ReceivedMessageImpl;
import net.corda.nodeapi.internal.protonwrapper.messages.impl.SendableMessageImpl;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Engine;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.message.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.MDC;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 T2\u00020\u0001:\u0001TB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0016H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020!H\u0002J\u0010\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u0007H\u0002J\u0016\u0010*\u001a\u00020+2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070,H\u0002J\u001c\u0010-\u001a\u00020+2\u0006\u0010'\u001a\u00020\u00072\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0010\u00100\u001a\u00020+2\u0006\u0010'\u001a\u00020\u0007H\u0002J\u001c\u00101\u001a\u00020+2\u0006\u0010'\u001a\u00020\u00072\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0010\u00102\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00106\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00107\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00108\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00109\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010:\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010;\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010<\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010=\u001a\u00020+2\u0006\u0010>\u001a\u000204H\u0016J\u0010\u0010?\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010@\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010A\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010B\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010C\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010D\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010E\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010F\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010G\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010H\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010I\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0006\u0010J\u001a\u00020+J\u0010\u0010K\u001a\u00020+2\u0006\u0010L\u001a\u00020\u0018H\u0002J\u000e\u0010M\u001a\u00020+2\u0006\u0010'\u001a\u00020$J\u000e\u0010N\u001a\u00020+2\u0006\u0010O\u001a\u00020PJ\u000e\u0010Q\u001a\u00020+2\u0006\u0010'\u001a\u00020\u0014J\u0016\u0010R\u001a\u00020+2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020+0,H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00160\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/engine/ConnectionStateMachine;", "Lorg/apache/qpid/proton/engine/BaseHandler;", "serverMode", "", "collector", "Lorg/apache/qpid/proton/engine/Collector;", "localLegalName", "", "remoteLegalName", "userName", "password", "(ZLorg/apache/qpid/proton/engine/Collector;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "connection", "Lorg/apache/qpid/proton/engine/Connection;", "getConnection", "()Lorg/apache/qpid/proton/engine/Connection;", "id", "messageQueues", "", "Ljava/util/LinkedList;", "Lnet/corda/nodeapi/internal/protonwrapper/messages/impl/SendableMessageImpl;", "receivers", "Lorg/apache/qpid/proton/engine/Receiver;", "senders", "Lorg/apache/qpid/proton/engine/Sender;", "session", "Lorg/apache/qpid/proton/engine/Session;", "tagId", "", "transport", "Lorg/apache/qpid/proton/engine/Transport;", "unackedQueue", "decodeAMQPMessage", "Lorg/apache/qpid/proton/message/Message;", "link", "encodeAMQPMessage", "Lio/netty/buffer/ByteBuf;", "message", "encodePayloadBytes", "msg", "getSender", "target", "logDebugWithMDC", "", "Lkotlin/Function0;", "logErrorWithMDC", "ex", "", "logInfoWithMDC", "logWarnWithMDC", "onConnectionFinal", "event", "Lorg/apache/qpid/proton/engine/Event;", "onConnectionInit", "onConnectionLocalClose", "onConnectionLocalOpen", "onConnectionUnbound", "onDelivery", "onLinkFinal", "onLinkFlow", "onLinkLocalOpen", "onLinkRemoteClose", "e", "onLinkRemoteOpen", "onSessionFinal", "onSessionInit", "onSessionLocalClose", "onSessionLocalOpen", "onTransport", "onTransportClosed", "onTransportError", "onTransportHeadClosed", "onTransportInternal", "onTransportTailClosed", "processTransport", "transmitMessages", "sender", "transportProcessInput", "transportProcessOutput", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "transportWriteMessage", "withMDC", "block", "Companion", "node-api"})
public final class ConnectionStateMachine
extends BaseHandler {
    @NotNull
    private final Connection connection;
    private final Transport transport;
    private final String id;
    private Session session;
    private final Map<String, LinkedList<SendableMessageImpl>> messageQueues;
    private final LinkedList<SendableMessageImpl> unackedQueue;
    private final Map<String, Receiver> receivers;
    private final Map<String, Sender> senders;
    private int tagId;
    private final boolean serverMode;
    private final String localLegalName;
    private final String remoteLegalName;
    private static final int IDLE_TIMEOUT = 10000;
    private static final Logger log;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withMDC(Function0<Unit> block) {
        Map map = MDC.getCopyOfContextMap();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map oldMDC = map;
        try {
            MDC.put((String)"serverMode", (String)String.valueOf(this.serverMode));
            MDC.put((String)"localLegalName", (String)this.localLegalName);
            MDC.put((String)"remoteLegalName", (String)this.remoteLegalName);
            block.invoke();
        }
        finally {
            MDC.setContextMap((Map)oldMDC);
        }
    }

    private final void logDebugWithMDC(Function0<String> msg) {
        if (log.isDebugEnabled()) {
            this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(msg){
                final /* synthetic */ Function0 $msg;

                public final void invoke() {
                    ConnectionStateMachine.access$getLog$cp().debug((String)this.$msg.invoke());
                }
                {
                    this.$msg = function0;
                    super(0);
                }
            }));
        }
    }

    private final void logInfoWithMDC(String msg) {
        this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(msg){
            final /* synthetic */ String $msg;

            public final void invoke() {
                ConnectionStateMachine.access$getLog$cp().info(this.$msg);
            }
            {
                this.$msg = string;
                super(0);
            }
        }));
    }

    private final void logWarnWithMDC(String msg, Throwable ex) {
        this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(msg, ex){
            final /* synthetic */ String $msg;
            final /* synthetic */ Throwable $ex;

            public final void invoke() {
                ConnectionStateMachine.access$getLog$cp().warn(this.$msg, this.$ex);
            }
            {
                this.$msg = string;
                this.$ex = throwable;
                super(0);
            }
        }));
    }

    static /* bridge */ /* synthetic */ void logWarnWithMDC$default(ConnectionStateMachine connectionStateMachine, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        connectionStateMachine.logWarnWithMDC(string, throwable);
    }

    private final void logErrorWithMDC(String msg, Throwable ex) {
        this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(msg, ex){
            final /* synthetic */ String $msg;
            final /* synthetic */ Throwable $ex;

            public final void invoke() {
                ConnectionStateMachine.access$getLog$cp().error(this.$msg, this.$ex);
            }
            {
                this.$msg = string;
                this.$ex = throwable;
                super(0);
            }
        }));
    }

    static /* bridge */ /* synthetic */ void logErrorWithMDC$default(ConnectionStateMachine connectionStateMachine, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        connectionStateMachine.logErrorWithMDC(string, throwable);
    }

    @NotNull
    public final Connection getConnection() {
        return this.connection;
    }

    public void onConnectionInit(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Connection connection2 = event.getConnection();
        this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(connection2){
            final /* synthetic */ Connection $connection;

            @NotNull
            public final String invoke() {
                return "Connection init " + this.$connection;
            }
            {
                this.$connection = connection2;
                super(0);
            }
        }));
    }

    public void onConnectionLocalOpen(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Connection connection2 = event.getConnection();
        this.logInfoWithMDC("Connection local open " + connection2);
        Session session = connection2.session();
        session.open();
        this.session = session;
        for (String target : this.messageQueues.keySet()) {
            this.getSender(target);
        }
    }

    public void onConnectionLocalClose(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Connection connection2 = event.getConnection();
        this.logInfoWithMDC("Connection local close " + connection2);
        connection2.close();
        connection2.free();
    }

    public void onConnectionUnbound(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getConnection(), (Object)this.connection)) {
            Channel channel;
            Object object = this.connection.getContext();
            if (!(object instanceof Channel)) {
                object = null;
            }
            if ((channel = (Channel)object) != null && channel.isActive()) {
                channel.close();
            }
        }
    }

    public void onConnectionFinal(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Connection connection2 = event.getConnection();
        this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(connection2){
            final /* synthetic */ Connection $connection;

            @NotNull
            public final String invoke() {
                return "Connection final " + this.$connection;
            }
            {
                this.$connection = connection2;
                super(0);
            }
        }));
        if (Intrinsics.areEqual((Object)connection2, (Object)this.connection)) {
            Channel channel;
            SendableMessageImpl msg;
            this.connection.setContext(null);
            for (LinkedList<SendableMessageImpl> queue : this.messageQueues.values()) {
                SendableMessageImpl msg2;
                while ((msg2 = queue.poll()) != null) {
                    msg2.doComplete(MessageStatus.Rejected);
                    msg2.release();
                }
            }
            this.messageQueues.clear();
            while ((msg = this.unackedQueue.poll()) != null) {
                msg.doComplete(MessageStatus.Rejected);
                msg.release();
            }
            Object object = connection2.getContext();
            if (!(object instanceof Channel)) {
                object = null;
            }
            if ((channel = (Channel)object) != null && channel.isActive()) {
                channel.close();
            }
            this.transport.setContext(null);
            this.session = null;
            this.receivers.clear();
            this.senders.clear();
        }
    }

    public void onTransportHeadClosed(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Transport transport = event.getTransport();
        this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(transport){
            final /* synthetic */ Transport $transport;

            @NotNull
            public final String invoke() {
                return "Transport Head Closed " + this.$transport;
            }
            {
                this.$transport = transport;
                super(0);
            }
        }));
        transport.close_tail();
        Transport transport2 = transport;
        Intrinsics.checkExpressionValueIsNotNull((Object)transport2, (String)"transport");
        this.onTransportInternal(transport2);
    }

    public void onTransportTailClosed(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Transport transport = event.getTransport();
        this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(transport){
            final /* synthetic */ Transport $transport;

            @NotNull
            public final String invoke() {
                return "Transport Tail Closed " + this.$transport;
            }
            {
                this.$transport = transport;
                super(0);
            }
        }));
        transport.close_head();
        Transport transport2 = transport;
        Intrinsics.checkExpressionValueIsNotNull((Object)transport2, (String)"transport");
        this.onTransportInternal(transport2);
    }

    public void onTransportClosed(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Transport transport = event.getTransport();
        this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(transport){
            final /* synthetic */ Transport $transport;

            @NotNull
            public final String invoke() {
                return "Transport Closed " + this.$transport;
            }
            {
                this.$transport = transport;
                super(0);
            }
        }));
        if (Intrinsics.areEqual((Object)transport, (Object)this.transport)) {
            transport.unbind();
            transport.free();
            transport.setContext(null);
        }
    }

    public void onTransportError(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Transport transport = event.getTransport();
        this.logInfoWithMDC("Transport Error " + transport);
        Transport transport2 = event.getTransport();
        Intrinsics.checkExpressionValueIsNotNull((Object)transport2, (String)"event.transport");
        ErrorCondition condition = transport2.getCondition();
        if (condition != null) {
            this.logInfoWithMDC("Error: " + condition.getDescription());
        } else {
            this.logInfoWithMDC("Error (no description returned).");
        }
        Transport transport3 = transport;
        Intrinsics.checkExpressionValueIsNotNull((Object)transport3, (String)"transport");
        this.onTransportInternal(transport3);
    }

    public void onTransport(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Transport transport = event.getTransport();
        this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(transport){
            final /* synthetic */ Transport $transport;

            @NotNull
            public final String invoke() {
                return "Transport " + this.$transport;
            }
            {
                this.$transport = transport;
                super(0);
            }
        }));
        Transport transport2 = transport;
        Intrinsics.checkExpressionValueIsNotNull((Object)transport2, (String)"transport");
        this.onTransportInternal(transport2);
    }

    private final void onTransportInternal(Transport transport) {
        block3: {
            Channel channel;
            Connection connection2;
            int pending;
            if (transport.isClosed() || (pending = transport.pending()) <= 0) break block3;
            Object object = transport.getContext();
            if (!(object instanceof Connection)) {
                object = null;
            }
            Connection connection3 = connection2 = (Connection)object;
            Object object2 = connection3 != null ? connection3.getContext() : null;
            if (!(object2 instanceof Channel)) {
                object2 = null;
            }
            Channel channel2 = channel = (Channel)object2;
            if (channel2 != null) {
                channel2.writeAndFlush((Object)transport);
            }
        }
    }

    public void onSessionInit(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Session session = event.getSession();
        this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(session){
            final /* synthetic */ Session $session;

            @NotNull
            public final String invoke() {
                return "Session init " + this.$session;
            }
            {
                this.$session = session;
                super(0);
            }
        }));
    }

    public void onSessionLocalOpen(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Session session = event.getSession();
        this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(session){
            final /* synthetic */ Session $session;

            @NotNull
            public final String invoke() {
                return "Session local open " + this.$session;
            }
            {
                this.$session = session;
                super(0);
            }
        }));
    }

    private final Sender getSender(String target) {
        if (!this.senders.containsKey(target)) {
            Sender sender;
            Session session = this.session;
            if (session == null) {
                Intrinsics.throwNpe();
            }
            Sender sender2 = sender = session.sender(UUID.randomUUID().toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)sender2, (String)"sender");
            Object object = new Source();
            Sender sender3 = sender2;
            Source $receiver = object;
            $receiver.setAddress(target);
            $receiver.setDynamic(false);
            $receiver.setDurable(TerminusDurability.NONE);
            Source source = object;
            sender3.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
            object = new Target();
            sender3 = sender;
            $receiver = object;
            $receiver.setAddress(target);
            $receiver.setDynamic(false);
            $receiver.setDurable(TerminusDurability.UNSETTLED_STATE);
            source = object;
            sender3.setTarget((org.apache.qpid.proton.amqp.transport.Target)source);
            sender.setSenderSettleMode(SenderSettleMode.UNSETTLED);
            sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            object = this.senders;
            Sender sender4 = sender;
            object.put(target, sender4);
            sender.open();
        }
        Sender sender = this.senders.get(target);
        if (sender == null) {
            Intrinsics.throwNpe();
        }
        return sender;
    }

    public void onSessionLocalClose(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Session session = event.getSession();
        this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(session){
            final /* synthetic */ Session $session;

            @NotNull
            public final String invoke() {
                return "Session local close " + this.$session;
            }
            {
                this.$session = session;
                super(0);
            }
        }));
        session.close();
        session.free();
    }

    public void onSessionFinal(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Session session = event.getSession();
        this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(session){
            final /* synthetic */ Session $session;

            @NotNull
            public final String invoke() {
                return "Session final " + this.$session;
            }
            {
                this.$session = session;
                super(0);
            }
        }));
        if (Intrinsics.areEqual((Object)session, (Object)this.session)) {
            this.session = null;
        }
    }

    public void onLinkLocalOpen(@NotNull Event event) {
        Link link;
        String string;
        Map<String, Sender> map;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Link link2 = event.getLink();
        if (link2 instanceof Sender) {
            this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(link2){
                final /* synthetic */ Link $link;

                @NotNull
                public final String invoke() {
                    return "Sender Link local open " + ((Sender)this.$link).getName() + ' ' + ((Sender)this.$link).getSource() + ' ' + ((Sender)this.$link).getTarget();
                }
                {
                    this.$link = link;
                    super(0);
                }
            }));
            map = this.senders;
            org.apache.qpid.proton.amqp.transport.Target target = ((Sender)link2).getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)target, (String)"link.target");
            String string2 = target.getAddress();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"link.target.address");
            string = string2;
            link = link2;
            map.put(string, (Sender)link);
            this.transmitMessages((Sender)link2);
        }
        if (link2 instanceof Receiver) {
            this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(link2){
                final /* synthetic */ Link $link;

                @NotNull
                public final String invoke() {
                    return "Receiver Link local open " + ((Receiver)this.$link).getName() + ' ' + ((Receiver)this.$link).getSource() + ' ' + ((Receiver)this.$link).getTarget();
                }
                {
                    this.$link = link;
                    super(0);
                }
            }));
            map = this.receivers;
            org.apache.qpid.proton.amqp.transport.Target target = ((Receiver)link2).getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)target, (String)"link.target");
            String string3 = target.getAddress();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"link.target.address");
            string = string3;
            link = link2;
            map.put(string, (Sender)link);
        }
    }

    public void onLinkRemoteOpen(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Link link = event.getLink();
        if (link instanceof Receiver && ((Receiver)link).getRemoteTarget() instanceof Coordinator) {
            this.logDebugWithMDC((Function0<String>)((Function0)onLinkRemoteOpen.1.INSTANCE));
        }
    }

    public void onLinkRemoteClose(@NotNull Event e) {
        Link link;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Link link2 = link = e.getLink();
        Intrinsics.checkExpressionValueIsNotNull((Object)link2, (String)"link");
        if (link2.getRemoteCondition() != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Connection closed due to error on remote side: `");
            ErrorCondition errorCondition = link.getRemoteCondition();
            Intrinsics.checkExpressionValueIsNotNull((Object)errorCondition, (String)"link.remoteCondition");
            ConnectionStateMachine.logWarnWithMDC$default(this, stringBuilder.append(errorCondition.getDescription()).append('`').toString(), null, 2, null);
            this.transport.setCondition(link.getCondition());
            this.transport.close_tail();
            this.transport.pop(Math.max(0, this.transport.pending()));
        }
    }

    public void onLinkFinal(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Link link = event.getLink();
        if (link instanceof Sender) {
            this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(link){
                final /* synthetic */ Link $link;

                @NotNull
                public final String invoke() {
                    return "Sender Link final " + ((Sender)this.$link).getName() + ' ' + ((Sender)this.$link).getSource() + ' ' + ((Sender)this.$link).getTarget();
                }
                {
                    this.$link = link;
                    super(0);
                }
            }));
            org.apache.qpid.proton.amqp.transport.Target target = ((Sender)link).getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)target, (String)"link.target");
            this.senders.remove(target.getAddress());
        }
        if (link instanceof Receiver) {
            this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(link){
                final /* synthetic */ Link $link;

                @NotNull
                public final String invoke() {
                    return "Receiver Link final " + ((Receiver)this.$link).getName() + ' ' + ((Receiver)this.$link).getSource() + ' ' + ((Receiver)this.$link).getTarget();
                }
                {
                    this.$link = link;
                    super(0);
                }
            }));
            org.apache.qpid.proton.amqp.transport.Target target = ((Receiver)link).getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)target, (String)"link.target");
            this.receivers.remove(target.getAddress());
        }
    }

    public void onLinkFlow(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Link link = event.getLink();
        if (link instanceof Sender) {
            this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(link){
                final /* synthetic */ Link $link;

                @NotNull
                public final String invoke() {
                    return "Sender Flow event: " + ((Sender)this.$link).getName() + ' ' + ((Sender)this.$link).getSource() + ' ' + ((Sender)this.$link).getTarget();
                }
                {
                    this.$link = link;
                    super(0);
                }
            }));
            org.apache.qpid.proton.amqp.transport.Target target = ((Sender)link).getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)target, (String)"link.target");
            if (this.senders.containsKey(target.getAddress())) {
                this.transmitMessages((Sender)link);
            }
        } else if (link instanceof Receiver) {
            this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(link){
                final /* synthetic */ Link $link;

                @NotNull
                public final String invoke() {
                    return "Receiver Flow event: " + ((Receiver)this.$link).getName() + ' ' + ((Receiver)this.$link).getSource() + ' ' + ((Receiver)this.$link).getTarget();
                }
                {
                    this.$link = link;
                    super(0);
                }
            }));
        }
    }

    public final void processTransport() {
        this.onTransportInternal(this.transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void transmitMessages(Sender sender) {
        Object object;
        void $receiver$iv;
        Map<String, LinkedList<SendableMessageImpl>> map = this.messageQueues;
        org.apache.qpid.proton.amqp.transport.Target target = sender.getTarget();
        Intrinsics.checkExpressionValueIsNotNull((Object)target, (String)"sender.target");
        String string = target.getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sender.target.address");
        String key$iv = string;
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            LinkedList answer$iv = new LinkedList();
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        LinkedList messageQueue = (LinkedList)object;
        while (sender.getCredit() > 0) {
            this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(sender){
                final /* synthetic */ Sender $sender;

                @NotNull
                public final String invoke() {
                    return "Sender credit: " + this.$sender.getCredit();
                }
                {
                    this.$sender = sender;
                    super(0);
                }
            }));
            SendableMessageImpl nextMessage = (SendableMessageImpl)messageQueue.poll();
            if (nextMessage == null) break;
            try {
                ByteBuf messageBuf;
                Delivery delivery;
                if (nextMessage.getBuf() == null) {
                    Intrinsics.throwNpe();
                }
                ByteBuffer buf = ByteBuffer.allocate(4);
                int answer$iv = this.tagId;
                this.tagId = answer$iv + 1;
                buf.putInt(answer$iv);
                Delivery delivery2 = delivery = sender.delivery(buf.array());
                Intrinsics.checkExpressionValueIsNotNull((Object)delivery2, (String)"delivery");
                delivery2.setContext((Object)nextMessage);
                sender.send(messageBuf.array(), messageBuf.arrayOffset() + messageBuf.readerIndex(), messageBuf.readableBytes());
                nextMessage.setStatus(MessageStatus.Sent);
                this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(delivery, nextMessage){
                    final /* synthetic */ Delivery $delivery;
                    final /* synthetic */ SendableMessageImpl $nextMessage;

                    @NotNull
                    public final String invoke() {
                        StringBuilder stringBuilder = new StringBuilder().append("Put tag ");
                        Delivery delivery = this.$delivery;
                        Intrinsics.checkExpressionValueIsNotNull((Object)delivery, (String)"delivery");
                        return stringBuilder.append(DatatypeConverter.printHexBinary((byte[])delivery.getTag())).append(" on wire uuid: ").append(this.$nextMessage.getApplicationProperties().get("_AMQ_DUPL_ID")).toString();
                    }
                    {
                        this.$delivery = delivery;
                        this.$nextMessage = sendableMessageImpl;
                        super(0);
                    }
                }));
                this.unackedQueue.offer(nextMessage);
                sender.advance();
            }
            finally {
                nextMessage.release();
            }
        }
    }

    public void onDelivery(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Delivery delivery = event.getDelivery();
        this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(delivery){
            final /* synthetic */ Delivery $delivery;

            @NotNull
            public final String invoke() {
                return "Delivery " + this.$delivery;
            }
            {
                this.$delivery = delivery;
                super(0);
            }
        }));
        Delivery delivery2 = delivery;
        Intrinsics.checkExpressionValueIsNotNull((Object)delivery2, (String)"delivery");
        Link link = delivery2.getLink();
        if (link instanceof Receiver) {
            if (delivery.isReadable() && !delivery.isPartial()) {
                Channel channel;
                Connection connection2;
                Message amqpMessage = this.decodeAMQPMessage((Receiver)link);
                Section section = amqpMessage.getBody();
                if (section == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.apache.qpid.proton.amqp.messaging.Data");
                }
                Binary binary = ((Data)section).getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)binary, (String)"(amqpMessage.body as Data).value");
                byte[] payload = binary.getArray();
                Connection connection3 = connection2 = event.getConnection();
                Object object = connection3 != null ? connection3.getContext() : null;
                if (!(object instanceof Channel)) {
                    object = null;
                }
                if ((channel = (Channel)object) != null) {
                    ApplicationProperties applicationProperties = amqpMessage.getApplicationProperties();
                    Intrinsics.checkExpressionValueIsNotNull((Object)applicationProperties, (String)"amqpMessage.applicationProperties");
                    HashMap appProperties = new HashMap(applicationProperties.getValue());
                    Map map = appProperties;
                    String string = "_AMQ_VALIDATED_USER";
                    String string2 = this.remoteLegalName;
                    map.put(string, string2);
                    SocketAddress socketAddress = channel.localAddress();
                    if (socketAddress == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
                    }
                    InetSocketAddress localAddress = (InetSocketAddress)socketAddress;
                    SocketAddress socketAddress2 = channel.remoteAddress();
                    if (socketAddress2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
                    }
                    InetSocketAddress remoteAddress = (InetSocketAddress)socketAddress2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)payload, (String)"payload");
                    org.apache.qpid.proton.amqp.transport.Source source = ((Receiver)link).getSource();
                    Intrinsics.checkExpressionValueIsNotNull((Object)source, (String)"link.source");
                    String string3 = source.getAddress();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"link.source.address");
                    String string4 = remoteAddress.getHostString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"remoteAddress.hostString");
                    NetworkHostAndPort networkHostAndPort = new NetworkHostAndPort(string4, remoteAddress.getPort());
                    String string5 = localAddress.getHostString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"localAddress.hostString");
                    ReceivedMessageImpl receivedMessage = new ReceivedMessageImpl(payload, string3, this.remoteLegalName, networkHostAndPort, this.localLegalName, new NetworkHostAndPort(string5, localAddress.getPort()), appProperties, channel, delivery);
                    this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(appProperties){
                        final /* synthetic */ HashMap $appProperties;

                        @NotNull
                        public final String invoke() {
                            return "Full message received uuid: " + this.$appProperties.get("_AMQ_DUPL_ID");
                        }
                        {
                            this.$appProperties = hashMap;
                            super(0);
                        }
                    }));
                    channel.writeAndFlush((Object)receivedMessage);
                    if (Intrinsics.areEqual((Object)link.current(), (Object)delivery)) {
                        link.advance();
                    }
                } else {
                    delivery.disposition((DeliveryState)new Rejected());
                    delivery.settle();
                }
            }
        } else if (link instanceof Sender) {
            Collection collection;
            this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(delivery){
                final /* synthetic */ Delivery $delivery;

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Sender delivery confirmed tag ");
                    Delivery delivery = this.$delivery;
                    Intrinsics.checkExpressionValueIsNotNull((Object)delivery, (String)"delivery");
                    return stringBuilder.append(DatatypeConverter.printHexBinary((byte[])delivery.getTag())).toString();
                }
                {
                    this.$delivery = delivery;
                    super(0);
                }
            }));
            boolean ok = delivery.remotelySettled() && Intrinsics.areEqual((Object)delivery.getRemoteState(), (Object)Accepted.getInstance());
            Object object = delivery.getContext();
            if (!(object instanceof SendableMessageImpl)) {
                object = null;
            }
            SendableMessageImpl sourceMessage = (SendableMessageImpl)object;
            Collection collection2 = collection = (Collection)this.unackedQueue;
            if (collection2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
            }
            TypeIntrinsics.asMutableCollection((Object)collection2).remove(sourceMessage);
            SendableMessageImpl sendableMessageImpl = sourceMessage;
            if (sendableMessageImpl != null) {
                sendableMessageImpl.doComplete(ok ? MessageStatus.Acknowledged : MessageStatus.Rejected);
            }
            delivery.settle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteBuf encodeAMQPMessage(Message message) {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1500);
        try {
            try {
                ByteBuf byteBuf = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
                message.encode((WritableBuffer)new NettyWritable(byteBuf));
                byte[] bytes = new byte[buffer.writerIndex()];
                buffer.readBytes(bytes);
                ByteBuf byteBuf2 = Unpooled.wrappedBuffer((byte[])bytes);
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf2, (String)"Unpooled.wrappedBuffer(bytes)");
                ByteBuf byteBuf3 = byteBuf2;
                return byteBuf3;
            }
            catch (Exception ex) {
                this.logErrorWithMDC("Unable to encode message as AMQP packet", ex);
                throw (Throwable)ex;
            }
        }
        finally {
            buffer.release();
        }
    }

    private final ByteBuf encodePayloadBytes(SendableMessageImpl msg) {
        Message message;
        Message message2 = message = Proton.message();
        Intrinsics.checkExpressionValueIsNotNull((Object)message2, (String)"message");
        message2.setBody((Section)new Data(new Binary(msg.getPayload())));
        message.setDurable(true);
        message.setProperties(new Properties());
        HashMap<String, Object> appProperties = new HashMap<String, Object>(msg.getApplicationProperties());
        Map map = appProperties;
        String string = "_AMQ_VALIDATED_USER";
        String string2 = this.localLegalName;
        map.put(string, string2);
        message.setApplicationProperties(new ApplicationProperties((Map)appProperties));
        return this.encodeAMQPMessage(message);
    }

    private final Message decodeAMQPMessage(Receiver link) {
        Message amqpMessage = Proton.message();
        ReadableBuffer buf = link.recv();
        amqpMessage.decode(buf);
        Message message = amqpMessage;
        Intrinsics.checkExpressionValueIsNotNull((Object)message, (String)"amqpMessage");
        return message;
    }

    /*
     * WARNING - void declaration
     */
    public final void transportWriteMessage(@NotNull SendableMessageImpl msg) {
        Object object;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        msg.setBuf(this.encodePayloadBytes(msg));
        Map<String, LinkedList<SendableMessageImpl>> map = this.messageQueues;
        String key$iv = msg.getTopic();
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            LinkedList answer$iv = new LinkedList();
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        LinkedList messageQueue = (LinkedList)object;
        messageQueue.offer(msg);
        if (this.session != null) {
            Sender sender = this.getSender(msg.getTopic());
            this.transmitMessages(sender);
        }
    }

    public final void transportProcessInput(@NotNull ByteBuf msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        ByteBuffer source = msg.nioBuffer();
        try {
            do {
                ByteBuffer buffer = this.transport.getInputBuffer();
                int limit = Math.min(buffer.remaining(), source.remaining());
                ByteBuffer duplicate = source.duplicate();
                duplicate.limit(source.position() + limit);
                buffer.put(duplicate);
                this.transport.processInput().checkIsOk();
                source.position(source.position() + limit);
            } while (source.hasRemaining());
        }
        catch (Exception ex) {
            ErrorCondition condition = new ErrorCondition();
            condition.setCondition(Symbol.getSymbol((String)"proton:io"));
            condition.setDescription(ex.getMessage());
            this.transport.setCondition(condition);
            this.transport.close_tail();
            this.transport.pop(Math.max(0, this.transport.pending()));
        }
    }

    public final void transportProcessOutput(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        try {
            boolean done = false;
            while (!done) {
                ByteBuffer toWrite = this.transport.getOutputBuffer();
                if (toWrite != null && toWrite.hasRemaining()) {
                    ByteBuf outbound = ctx.alloc().buffer(toWrite.remaining());
                    outbound.writeBytes(toWrite);
                    ctx.write((Object)outbound);
                    this.transport.outputConsumed();
                    continue;
                }
                done = true;
            }
            ctx.flush();
        }
        catch (Exception ex) {
            ErrorCondition condition = new ErrorCondition();
            condition.setCondition(Symbol.getSymbol((String)"proton:io"));
            condition.setDescription(ex.getMessage());
            this.transport.setCondition(condition);
            this.transport.close_head();
            this.transport.pop(Math.max(0, this.transport.pending()));
        }
    }

    public ConnectionStateMachine(boolean serverMode, @NotNull Collector collector, @NotNull String localLegalName, @NotNull String remoteLegalName, @Nullable String userName, @Nullable String password) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        Intrinsics.checkParameterIsNotNull((Object)localLegalName, (String)"localLegalName");
        Intrinsics.checkParameterIsNotNull((Object)remoteLegalName, (String)"remoteLegalName");
        this.serverMode = serverMode;
        this.localLegalName = localLegalName;
        this.remoteLegalName = remoteLegalName;
        this.id = UUID.randomUUID().toString();
        ConnectionStateMachine connectionStateMachine = this;
        connectionStateMachine.messageQueues = map = (Map)new LinkedHashMap();
        this.unackedQueue = new LinkedList();
        connectionStateMachine = this;
        connectionStateMachine.receivers = map = (Map)new LinkedHashMap();
        connectionStateMachine = this;
        connectionStateMachine.senders = map = (Map)new LinkedHashMap();
        Connection connection2 = Engine.connection();
        Intrinsics.checkExpressionValueIsNotNull((Object)connection2, (String)"Engine.connection()");
        this.connection = connection2;
        this.connection.setContainer("CORDA:" + this.id);
        Transport transport = Engine.transport();
        Intrinsics.checkExpressionValueIsNotNull((Object)transport, (String)"Engine.transport()");
        this.transport = transport;
        this.transport.setIdleTimeout(10000);
        this.transport.setContext((Object)this.connection);
        this.transport.setEmitFlowEventOnSend(true);
        this.connection.collect(collector);
        Sasl sasl = this.transport.sasl();
        if (userName != null) {
            sasl.setMechanisms(new String[]{"PLAIN"});
            if (this.serverMode) {
                sasl.server();
                sasl.done(Sasl.PN_SASL_OK);
            } else {
                sasl.plain(userName, password);
                sasl.client();
            }
        } else {
            sasl.setMechanisms(new String[]{"ANONYMOUS"});
            if (this.serverMode) {
                sasl.server();
                sasl.done(Sasl.PN_SASL_OK);
            } else {
                sasl.client();
            }
        }
        this.transport.bind(this.connection);
        if (!this.serverMode) {
            this.connection.open();
        }
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/engine/ConnectionStateMachine$Companion;", "", "()V", "IDLE_TIMEOUT", "", "log", "Lorg/slf4j/Logger;", "node-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

