/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.persistence;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.persistence.AttributeConverter;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.NamedCacheFactory;
import net.corda.core.schemas.MappedSchema;
import net.corda.core.utilities.ByteArrays;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.nodeapi.internal.persistence.CordaPersistence;
import net.corda.nodeapi.internal.persistence.CordaPersistenceKt;
import net.corda.nodeapi.internal.persistence.DatabaseConfig;
import net.corda.nodeapi.internal.persistence.DatabaseTransaction;
import net.corda.nodeapi.internal.persistence.DatabaseTransactionKt;
import net.corda.nodeapi.internal.persistence.DelegatingStatisticsService;
import net.corda.nodeapi.internal.persistence.HibernateConfiguration$sam$java_util_function_Function$0;
import net.corda.nodeapi.internal.persistence.SchemaInitializationType;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.stat.Statistics;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.MaterializedBlobType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayTypeDescriptor;
import org.hibernate.type.descriptor.sql.BlobTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.VarbinaryTypeDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 $2\u00020\u0001:\u0007$%&'()*BM\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\"\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0015J\u0016\u0010!\u001a\u00020\u00152\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0014\u0010\"\u001a\u00020\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lnet/corda/nodeapi/internal/persistence/HibernateConfiguration;", "", "schemas", "", "Lnet/corda/core/schemas/MappedSchema;", "databaseConfig", "Lnet/corda/nodeapi/internal/persistence/DatabaseConfig;", "attributeConverters", "", "Ljavax/persistence/AttributeConverter;", "jdbcUrl", "", "cacheFactory", "Lnet/corda/core/internal/NamedCacheFactory;", "customClassLoader", "Ljava/lang/ClassLoader;", "(Ljava/util/Set;Lnet/corda/nodeapi/internal/persistence/DatabaseConfig;Ljava/util/Collection;Ljava/lang/String;Lnet/corda/core/internal/NamedCacheFactory;Ljava/lang/ClassLoader;)V", "getCustomClassLoader", "()Ljava/lang/ClassLoader;", "sessionFactories", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lorg/hibernate/SessionFactory;", "sessionFactoryForRegisteredSchemas", "getSessionFactoryForRegisteredSchemas", "()Lorg/hibernate/SessionFactory;", "buildSessionFactory", "config", "Lorg/hibernate/cfg/Configuration;", "metadataSources", "Lorg/hibernate/boot/MetadataSources;", "initStatistics", "", "sessionFactory", "makeSessionFactoryForSchemas", "sessionFactoryForSchemas", "key", "Companion", "CordaMaterializedBlobType", "CordaPrimitiveByteArrayTypeDescriptor", "CordaWrapperBinaryType", "MapBlobToNormalBlob", "MapBlobToPostgresByteA", "NodeDatabaseConnectionProvider", "node-api"})
public final class HibernateConfiguration {
    private final Cache<Set<MappedSchema>, SessionFactory> sessionFactories;
    @NotNull
    private final SessionFactory sessionFactoryForRegisteredSchemas;
    private final DatabaseConfig databaseConfig;
    private final Collection<AttributeConverter<?, ?>> attributeConverters;
    private final String jdbcUrl;
    @Nullable
    private final ClassLoader customClassLoader;
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public final SessionFactory getSessionFactoryForRegisteredSchemas() {
        return this.sessionFactoryForRegisteredSchemas;
    }

    @NotNull
    public final SessionFactory sessionFactoryForSchemas(@NotNull Set<? extends MappedSchema> key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Function1 function1 = (Function1)new Function1<Set<? extends MappedSchema>, SessionFactory>(this){

            @NotNull
            public final SessionFactory invoke(@NotNull Set<? extends MappedSchema> p1) {
                Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                return HibernateConfiguration.access$makeSessionFactoryForSchemas((HibernateConfiguration)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(HibernateConfiguration.class);
            }

            public final String getName() {
                return "makeSessionFactoryForSchemas";
            }

            public final String getSignature() {
                return "makeSessionFactoryForSchemas(Ljava/util/Set;)Lorg/hibernate/SessionFactory;";
            }
        };
        Object object = this.sessionFactories.get(key, (Function)new HibernateConfiguration$sam$java_util_function_Function$0(function1));
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (SessionFactory)object;
    }

    private final SessionFactory makeSessionFactoryForSchemas(Set<? extends MappedSchema> schemas) {
        logger.info("Creating session factory for schemas: " + schemas);
        BootstrapServiceRegistry serviceRegistry = new BootstrapServiceRegistryBuilder().build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
        String hbm2dll = this.databaseConfig.getInitialiseSchema() && this.databaseConfig.getInitialiseAppSchema() == SchemaInitializationType.UPDATE ? "update" : (!this.databaseConfig.getInitialiseSchema() && this.databaseConfig.getInitialiseAppSchema() == SchemaInitializationType.UPDATE || this.databaseConfig.getInitialiseAppSchema() == SchemaInitializationType.VALIDATE ? "validate" : "none");
        Configuration config = new Configuration(metadataSources).setProperty("hibernate.connection.provider_class", NodeDatabaseConnectionProvider.class.getName()).setProperty("hibernate.format_sql", "true").setProperty("hibernate.hbm2ddl.auto", hbm2dll).setProperty("javax.persistence.validation.mode", "none").setProperty("hibernate.connection.isolation", String.valueOf(this.databaseConfig.getTransactionIsolationLevel().getJdbcValue()));
        Iterable $receiver$iv = schemas;
        for (Object element$iv : $receiver$iv) {
            MappedSchema schema = (MappedSchema)element$iv;
            Iterable $receiver$iv2 = schema.getMappedTypes();
            for (Object element$iv2 : $receiver$iv2) {
                Class it = (Class)element$iv2;
                config.addAnnotatedClass(it);
            }
        }
        Configuration configuration = config;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"config");
        SessionFactory sessionFactory = this.buildSessionFactory(configuration, metadataSources, this.customClassLoader);
        logger.info("Created session factory for schemas: " + schemas);
        if (this.databaseConfig.getExportHibernateJMXStatistics()) {
            this.initStatistics(sessionFactory);
        }
        return sessionFactory;
    }

    public final void initStatistics(@NotNull SessionFactory sessionFactory) {
        Intrinsics.checkParameterIsNotNull((Object)sessionFactory, (String)"sessionFactory");
        ObjectName statsName = new ObjectName("org.hibernate:type=statistics");
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        Statistics statistics = sessionFactory.getStatistics();
        Intrinsics.checkExpressionValueIsNotNull((Object)statistics, (String)"sessionFactory.statistics");
        DelegatingStatisticsService statisticsMBean = new DelegatingStatisticsService(statistics);
        statisticsMBean.setStatisticsEnabled(true);
        try {
            mbeanServer.registerMBean(statisticsMBean, statsName);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    private final SessionFactory buildSessionFactory(Configuration config, MetadataSources metadataSources, ClassLoader customClassLoader) {
        SessionFactoryBuilder sessionFactoryBuilder;
        MetadataBuilder metadataBuilder;
        config.getStandardServiceRegistryBuilder().applySettings((Map)config.getProperties());
        if (customClassLoader != null) {
            config.getStandardServiceRegistryBuilder().addService(ClassLoaderService.class, (Service)new ClassLoaderServiceImpl(customClassLoader));
        }
        MetadataBuilder metadataBuilder2 = metadataBuilder = metadataSources.getMetadataBuilder(config.getStandardServiceRegistryBuilder().build());
        Intrinsics.checkExpressionValueIsNotNull((Object)metadataBuilder2, (String)"metadataBuilder");
        Metadata metadata = Companion.buildHibernateMetadata(metadataBuilder2, this.jdbcUrl, this.attributeConverters);
        SessionFactoryBuilder $receiver = sessionFactoryBuilder = metadata.getSessionFactoryBuilder();
        $receiver.allowOutOfTransactionUpdateOperations(true);
        $receiver.applySecondLevelCacheSupport(false);
        $receiver.applyQueryCacheSupport(false);
        $receiver.enableReleaseResourcesOnCloseEnabled(true);
        SessionFactory sessionFactory = $receiver.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)sessionFactory, (String)"build()");
        Intrinsics.checkExpressionValueIsNotNull((Object)sessionFactory, (String)"metadata.sessionFactoryB\u2026        build()\n        }");
        return sessionFactory;
    }

    @Nullable
    public final ClassLoader getCustomClassLoader() {
        return this.customClassLoader;
    }

    public HibernateConfiguration(@NotNull Set<? extends MappedSchema> schemas, @NotNull DatabaseConfig databaseConfig, @NotNull Collection<? extends AttributeConverter<?, ?>> attributeConverters, @NotNull String jdbcUrl, @NotNull NamedCacheFactory cacheFactory, @Nullable ClassLoader customClassLoader) {
        SessionFactory sessionFactory;
        Intrinsics.checkParameterIsNotNull(schemas, (String)"schemas");
        Intrinsics.checkParameterIsNotNull((Object)databaseConfig, (String)"databaseConfig");
        Intrinsics.checkParameterIsNotNull(attributeConverters, (String)"attributeConverters");
        Intrinsics.checkParameterIsNotNull((Object)jdbcUrl, (String)"jdbcUrl");
        Intrinsics.checkParameterIsNotNull((Object)cacheFactory, (String)"cacheFactory");
        this.databaseConfig = databaseConfig;
        this.attributeConverters = attributeConverters;
        this.jdbcUrl = jdbcUrl;
        this.customClassLoader = customClassLoader;
        Caffeine caffeine = Caffeine.newBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)caffeine, (String)"Caffeine.newBuilder()");
        this.sessionFactories = cacheFactory.buildNamed(caffeine, "HibernateConfiguration_sessionFactories");
        Set<? extends MappedSchema> set2 = schemas;
        HibernateConfiguration hibernateConfiguration = this;
        Set<? extends MappedSchema> it = set2;
        logger.info("Init HibernateConfiguration for schemas: " + it);
        hibernateConfiguration.sessionFactoryForRegisteredSchemas = sessionFactory = this.sessionFactoryForSchemas(it);
    }

    public /* synthetic */ HibernateConfiguration(Set set2, DatabaseConfig databaseConfig, Collection collection, String string, NamedCacheFactory namedCacheFactory, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            classLoader = null;
        }
        this(set2, databaseConfig, collection, string, namedCacheFactory, classLoader);
    }

    static {
        Companion = new Companion(null);
        logger = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @NotNull
    public static final /* synthetic */ SessionFactory access$makeSessionFactoryForSchemas(HibernateConfiguration $this, @NotNull Set schemas) {
        return $this.makeSessionFactoryForSchemas(schemas);
    }

    @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J!\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000bH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/corda/nodeapi/internal/persistence/HibernateConfiguration$NodeDatabaseConnectionProvider;", "Lorg/hibernate/engine/jdbc/connections/spi/ConnectionProvider;", "()V", "closeConnection", "", "conn", "Ljava/sql/Connection;", "getConnection", "isUnwrappableAs", "", "unwrapType", "Ljava/lang/Class;", "supportsAggressiveRelease", "unwrap", "T", "(Ljava/lang/Class;)Ljava/lang/Object;", "node-api"})
    public static final class NodeDatabaseConnectionProvider
    implements ConnectionProvider {
        public void closeConnection(@NotNull Connection conn) {
            DatabaseTransaction databaseTransaction;
            Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
            conn.setAutoCommit(false);
            DatabaseTransaction $receiver = databaseTransaction = DatabaseTransactionKt.getContextTransaction();
            $receiver.commit();
            $receiver.close();
        }

        public boolean supportsAggressiveRelease() {
            return true;
        }

        @NotNull
        public Connection getConnection() {
            return CordaPersistence.newTransaction$default(CordaPersistenceKt.getContextDatabase(), null, 1, null).getConnection();
        }

        public <T> T unwrap(@NotNull Class<T> unwrapType) {
            Intrinsics.checkParameterIsNotNull(unwrapType, (String)"unwrapType");
            Object object = InternalUtils.castIfPossible(unwrapType, (Object)this);
            if (object == null) {
                throw (Throwable)new UnknownUnwrapTypeException(unwrapType);
            }
            return (T)object;
        }

        public boolean isUnwrappableAs(@Nullable Class<?> unwrapType) {
            return Intrinsics.areEqual(unwrapType, NodeDatabaseConnectionProvider.class);
        }
    }

    @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lnet/corda/nodeapi/internal/persistence/HibernateConfiguration$CordaMaterializedBlobType;", "Lorg/hibernate/type/AbstractSingleColumnStandardBasicType;", "", "()V", "getName", "", "node-api"})
    public static final class CordaMaterializedBlobType
    extends AbstractSingleColumnStandardBasicType<byte[]> {
        public static final CordaMaterializedBlobType INSTANCE;

        @NotNull
        public String getName() {
            return "materialized_blob";
        }

        private CordaMaterializedBlobType() {
            super((SqlTypeDescriptor)BlobTypeDescriptor.DEFAULT, (JavaTypeDescriptor)CordaPrimitiveByteArrayTypeDescriptor.INSTANCE);
        }

        static {
            CordaMaterializedBlobType cordaMaterializedBlobType;
            INSTANCE = cordaMaterializedBlobType = new CordaMaterializedBlobType();
        }
    }

    @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/corda/nodeapi/internal/persistence/HibernateConfiguration$CordaPrimitiveByteArrayTypeDescriptor;", "Lorg/hibernate/type/descriptor/java/PrimitiveByteArrayTypeDescriptor;", "()V", "LOG_SIZE_LIMIT", "", "extractLoggableRepresentation", "", "value", "", "node-api"})
    private static final class CordaPrimitiveByteArrayTypeDescriptor
    extends PrimitiveByteArrayTypeDescriptor {
        private static final int LOG_SIZE_LIMIT = 1024;
        public static final CordaPrimitiveByteArrayTypeDescriptor INSTANCE;

        @NotNull
        public String extractLoggableRepresentation(@Nullable byte[] value) {
            String string;
            if (value == null) {
                String string2 = super.extractLoggableRepresentation(value);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"super.extractLoggableRepresentation(value)");
            } else if (value.length <= 1024) {
                string = "[size=" + value.length + ", value=" + ByteArrays.toHexString((byte[])value) + ']';
            } else {
                byte[] byArray = value;
                int n = 0;
                int n2 = 1024;
                StringBuilder stringBuilder = new StringBuilder().append("[size=").append(value.length).append(", value=");
                byte[] byArray2 = Arrays.copyOfRange(byArray, n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOfR\u2026this, fromIndex, toIndex)");
                byte[] byArray3 = byArray2;
                string = stringBuilder.append(ByteArrays.toHexString((byte[])byArray3)).append("...truncated...]").toString();
            }
            return string;
        }

        private CordaPrimitiveByteArrayTypeDescriptor() {
        }

        static {
            CordaPrimitiveByteArrayTypeDescriptor cordaPrimitiveByteArrayTypeDescriptor;
            INSTANCE = cordaPrimitiveByteArrayTypeDescriptor = new CordaPrimitiveByteArrayTypeDescriptor();
        }
    }

    @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lnet/corda/nodeapi/internal/persistence/HibernateConfiguration$CordaWrapperBinaryType;", "Lorg/hibernate/type/AbstractSingleColumnStandardBasicType;", "", "()V", "getName", "", "getRegistrationKeys", "", "()[Ljava/lang/String;", "node-api"})
    public static final class CordaWrapperBinaryType
    extends AbstractSingleColumnStandardBasicType<byte[]> {
        public static final CordaWrapperBinaryType INSTANCE;

        @NotNull
        public String[] getRegistrationKeys() {
            String[] stringArray = new String[3];
            stringArray[0] = this.getName();
            stringArray[1] = "ByteArray";
            String string = byte[].class.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ByteArray::class.java.name");
            stringArray[2] = string;
            return stringArray;
        }

        @NotNull
        public String getName() {
            return "corda-wrapper-binary";
        }

        private CordaWrapperBinaryType() {
            super((SqlTypeDescriptor)VarbinaryTypeDescriptor.INSTANCE, (JavaTypeDescriptor)PrimitiveByteArrayTypeDescriptor.INSTANCE);
        }

        static {
            CordaWrapperBinaryType cordaWrapperBinaryType;
            INSTANCE = cordaWrapperBinaryType = new CordaWrapperBinaryType();
        }
    }

    @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lnet/corda/nodeapi/internal/persistence/HibernateConfiguration$MapBlobToPostgresByteA;", "Lorg/hibernate/type/AbstractSingleColumnStandardBasicType;", "", "()V", "getName", "", "getRegistrationKeys", "", "()[Ljava/lang/String;", "node-api"})
    public static final class MapBlobToPostgresByteA
    extends AbstractSingleColumnStandardBasicType<byte[]> {
        public static final MapBlobToPostgresByteA INSTANCE;

        @NotNull
        public String[] getRegistrationKeys() {
            String[] stringArray = new String[3];
            stringArray[0] = this.getName();
            stringArray[1] = "ByteArray";
            String string = byte[].class.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ByteArray::class.java.name");
            stringArray[2] = string;
            return stringArray;
        }

        @NotNull
        public String getName() {
            return "corda-blob";
        }

        private MapBlobToPostgresByteA() {
            super((SqlTypeDescriptor)VarbinaryTypeDescriptor.INSTANCE, (JavaTypeDescriptor)PrimitiveByteArrayTypeDescriptor.INSTANCE);
        }

        static {
            MapBlobToPostgresByteA mapBlobToPostgresByteA;
            INSTANCE = mapBlobToPostgresByteA = new MapBlobToPostgresByteA();
        }
    }

    @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lnet/corda/nodeapi/internal/persistence/HibernateConfiguration$MapBlobToNormalBlob;", "Lorg/hibernate/type/MaterializedBlobType;", "()V", "getName", "", "node-api"})
    public static final class MapBlobToNormalBlob
    extends MaterializedBlobType {
        public static final MapBlobToNormalBlob INSTANCE;

        @NotNull
        public String getName() {
            return "corda-blob";
        }

        private MapBlobToNormalBlob() {
        }

        static {
            MapBlobToNormalBlob mapBlobToNormalBlob;
            INSTANCE = mapBlobToNormalBlob = new MapBlobToNormalBlob();
        }
    }

    @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/corda/nodeapi/internal/persistence/HibernateConfiguration$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "buildHibernateMetadata", "Lorg/hibernate/boot/Metadata;", "metadataBuilder", "Lorg/hibernate/boot/MetadataBuilder;", "jdbcUrl", "", "attributeConverters", "", "Ljavax/persistence/AttributeConverter;", "node-api"})
    public static final class Companion {
        @NotNull
        public final Metadata buildHibernateMetadata(@NotNull MetadataBuilder metadataBuilder, @NotNull String jdbcUrl, @NotNull Collection<? extends AttributeConverter<?, ?>> attributeConverters) {
            MetadataBuilder metadataBuilder2;
            Intrinsics.checkParameterIsNotNull((Object)metadataBuilder, (String)"metadataBuilder");
            Intrinsics.checkParameterIsNotNull((Object)jdbcUrl, (String)"jdbcUrl");
            Intrinsics.checkParameterIsNotNull(attributeConverters, (String)"attributeConverters");
            MetadataBuilder $receiver = metadataBuilder2 = metadataBuilder;
            Iterable $receiver$iv = attributeConverters;
            for (Object element$iv : $receiver$iv) {
                AttributeConverter it = (AttributeConverter)element$iv;
                $receiver.applyAttributeConverter(it);
            }
            $receiver.applyBasicType((BasicType)CordaMaterializedBlobType.INSTANCE, new String[]{CordaMaterializedBlobType.INSTANCE.getName()});
            $receiver.applyBasicType((BasicType)CordaWrapperBinaryType.INSTANCE, new String[]{CordaWrapperBinaryType.INSTANCE.getName()});
            if (StringsKt.contains((CharSequence)jdbcUrl, (CharSequence)":postgresql:", (boolean)true)) {
                $receiver.applyBasicType((BasicType)MapBlobToPostgresByteA.INSTANCE, new String[]{MapBlobToPostgresByteA.INSTANCE.getName()});
            } else {
                $receiver.applyBasicType((BasicType)MapBlobToNormalBlob.INSTANCE, new String[]{MapBlobToNormalBlob.INSTANCE.getName()});
            }
            Metadata metadata = $receiver.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)metadata, (String)"build()");
            return metadata;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

