/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.persistence;

import co.paralleluniverse.strands.Strand;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.nodeapi.internal.persistence.CordaPersistenceKt;
import net.corda.nodeapi.internal.persistence.DatabaseTransaction;
import org.hibernate.Session;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u000b\u001a\u00020\f\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0003\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"(\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\u0005\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"_contextTransaction", "Ljava/lang/ThreadLocal;", "Lnet/corda/nodeapi/internal/persistence/DatabaseTransaction;", "contextTransaction", "getContextTransaction", "()Lnet/corda/nodeapi/internal/persistence/DatabaseTransaction;", "transaction", "contextTransactionOrNull", "getContextTransactionOrNull", "setContextTransactionOrNull", "(Lnet/corda/nodeapi/internal/persistence/DatabaseTransaction;)V", "currentDBSession", "Lorg/hibernate/Session;", "node-api"})
public final class DatabaseTransactionKt {
    private static final ThreadLocal<DatabaseTransaction> _contextTransaction = new ThreadLocal();

    @NotNull
    public static final Session currentDBSession() {
        return DatabaseTransactionKt.getContextTransaction().getSession();
    }

    @Nullable
    public static final DatabaseTransaction getContextTransactionOrNull() {
        if (Intrinsics.areEqual((Object)CordaPersistenceKt.get_prohibitDatabaseAccess().get(), (Object)true)) {
            throw (Throwable)new IllegalAccessException("Database access is disabled in this context.");
        }
        return _contextTransaction.get();
    }

    public static final void setContextTransactionOrNull(@Nullable DatabaseTransaction transaction) {
        _contextTransaction.set(transaction);
    }

    @NotNull
    public static final DatabaseTransaction getContextTransaction() {
        DatabaseTransaction databaseTransaction = DatabaseTransactionKt.getContextTransactionOrNull();
        if (databaseTransaction == null) {
            String string = "Was expecting to find transaction set on current strand: " + Strand.currentStrand();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return databaseTransaction;
    }
}

