/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.persistence;

import co.paralleluniverse.strands.Strand;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.corda.nodeapi.internal.persistence.CordaPersistence;
import net.corda.nodeapi.internal.persistence.CordaPersistenceKt;
import net.corda.nodeapi.internal.persistence.DatabaseTransaction;
import net.corda.nodeapi.internal.persistence.DatabaseTransactionKt;
import net.corda.nodeapi.internal.persistence.DatabaseTransactionRolledBackException;
import net.corda.nodeapi.internal.persistence.DatabaseTransactionWrappingSubscriber;
import net.corda.nodeapi.internal.persistence.NoOpSubscriber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.subjects.UnicastSubject;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001f\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016\u00a2\u0006\u0002\u0010\u0017\u001a*\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0019\"\b\b\u0000\u0010\u0014*\u00020\u001a*\b\u0012\u0004\u0012\u0002H\u00140\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u0007\u001a\f\u0010\u001c\u001a\u00020\u0007*\u00020\u001dH\u0002\u001a,\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00140\u001f\"\b\b\u0000\u0010\u0014*\u00020\u001a*\b\u0012\u0004\u0012\u0002H\u00140\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"8\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"$\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\"\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006!"}, d2={"NODE_DATABASE_PREFIX", "", "_contextDatabase", "Ljava/lang/InheritableThreadLocal;", "Lnet/corda/nodeapi/internal/persistence/CordaPersistence;", "_prohibitDatabaseAccess", "Ljava/lang/ThreadLocal;", "", "kotlin.jvm.PlatformType", "get_prohibitDatabaseAccess", "()Ljava/lang/ThreadLocal;", "database", "contextDatabase", "getContextDatabase", "()Lnet/corda/nodeapi/internal/persistence/CordaPersistence;", "setContextDatabase", "(Lnet/corda/nodeapi/internal/persistence/CordaPersistence;)V", "contextDatabaseOrNull", "getContextDatabaseOrNull", "withoutDatabaseAccess", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "bufferUntilDatabaseCommit", "Lrx/Observer;", "", "propagateRollbackAsError", "hasSQLExceptionCause", "", "wrapWithDatabaseTransaction", "Lrx/Observable;", "db", "node-api"})
public final class CordaPersistenceKt {
    @NotNull
    public static final String NODE_DATABASE_PREFIX = "node_";
    private static final ThreadLocal<Boolean> _prohibitDatabaseAccess = ThreadLocal.withInitial(_prohibitDatabaseAccess.1.INSTANCE);
    private static final InheritableThreadLocal<CordaPersistence> _contextDatabase = new InheritableThreadLocal();

    public static final ThreadLocal<Boolean> get_prohibitDatabaseAccess() {
        return _prohibitDatabaseAccess;
    }

    @NotNull
    public static final CordaPersistence getContextDatabase() {
        boolean bl = Intrinsics.areEqual((Object)_prohibitDatabaseAccess.get(), (Object)true) ^ true;
        if (!bl) {
            String string = "Database access is disabled in this context.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        CordaPersistence cordaPersistence = (CordaPersistence)_contextDatabase.get();
        if (cordaPersistence == null) {
            String string = "Was expecting to find CordaPersistence set on current thread: " + Strand.currentStrand();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return cordaPersistence;
    }

    public static final void setContextDatabase(@NotNull CordaPersistence database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        _contextDatabase.set(database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withoutDatabaseAccess(@NotNull Function0<? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        Boolean oldValue = _prohibitDatabaseAccess.get();
        _prohibitDatabaseAccess.set(true);
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            _prohibitDatabaseAccess.set(oldValue);
        }
    }

    @Nullable
    public static final CordaPersistence getContextDatabaseOrNull() {
        return (CordaPersistence)_contextDatabase.get();
    }

    @NotNull
    public static final <T> Observer<T> bufferUntilDatabaseCommit(@NotNull Observer<T> $receiver, boolean propagateRollbackAsError) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        DatabaseTransaction currentTx = DatabaseTransactionKt.getContextTransaction();
        UnicastSubject subject = UnicastSubject.create();
        Observable observable = currentTx.getBoundary$node_api().filter((Func1)bufferUntilDatabaseCommit.databaseTxBoundary.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"currentTx.boundary.filter { it.success }");
        Observable databaseTxBoundary2 = observable;
        if (propagateRollbackAsError) {
            currentTx.getBoundary$node_api().filter((Func1)bufferUntilDatabaseCommit.1.INSTANCE).subscribe((Action1)new Action1<CordaPersistence.Boundary>($receiver){
                final /* synthetic */ Observer receiver$0;

                public final void call(CordaPersistence.Boundary it) {
                    this.receiver$0.onError((Throwable)new DatabaseTransactionRolledBackException(it.getTxId()));
                }
                {
                    this.receiver$0 = observer;
                }
            });
        }
        subject.delaySubscription(databaseTxBoundary2).subscribe($receiver);
        UnicastSubject unicastSubject = subject;
        Intrinsics.checkExpressionValueIsNotNull((Object)unicastSubject, (String)"subject");
        return (Observer)unicastSubject;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Observer bufferUntilDatabaseCommit$default(Observer observer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return CordaPersistenceKt.bufferUntilDatabaseCommit(observer, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Observable<T> wrapWithDatabaseTransaction(@NotNull Observable<T> $receiver, @Nullable CordaPersistence db) {
        void wrappingSubscriber;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = new DatabaseTransactionWrappingSubscriber(db);
        Observable observable = $receiver.lift(new Observable.Operator<R, T>((Ref.ObjectRef)wrappingSubscriber){
            final /* synthetic */ Ref.ObjectRef $wrappingSubscriber;

            public final Subscriber<? super T> call(@NotNull Subscriber<? super T> toBeWrappedInDbTx) {
                Intrinsics.checkParameterIsNotNull(toBeWrappedInDbTx, (String)"toBeWrappedInDbTx");
                ((DatabaseTransactionWrappingSubscriber)((Object)this.$wrappingSubscriber.element)).getDelegates().add(toBeWrappedInDbTx);
                return ((DatabaseTransactionWrappingSubscriber)((Object)this.$wrappingSubscriber.element)).getDelegates().size() == 1 ? (Subscriber)((DatabaseTransactionWrappingSubscriber)((Object)this.$wrappingSubscriber.element)) : (Subscriber)new NoOpSubscriber<T>(toBeWrappedInDbTx);
            }
            {
                this.$wrappingSubscriber = objectRef;
            }
        }).doOnUnsubscribe(new Action0((Ref.ObjectRef)wrappingSubscriber, db){
            final /* synthetic */ Ref.ObjectRef $wrappingSubscriber;
            final /* synthetic */ CordaPersistence $db;

            public final void call() {
                ((DatabaseTransactionWrappingSubscriber)((Object)this.$wrappingSubscriber.element)).cleanUp();
                if (((DatabaseTransactionWrappingSubscriber)((Object)this.$wrappingSubscriber.element)).getDelegates().isEmpty()) {
                    this.$wrappingSubscriber.element = new DatabaseTransactionWrappingSubscriber<U>(this.$db);
                }
            }
            {
                this.$wrappingSubscriber = objectRef;
                this.$db = cordaPersistence;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"this.lift { toBeWrappedI\u2026riber(db)\n        }\n    }");
        return observable;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Observable wrapWithDatabaseTransaction$default(Observable observable, CordaPersistence cordaPersistence, int n, Object object) {
        if ((n & 1) != 0) {
            cordaPersistence = null;
        }
        return CordaPersistenceKt.wrapWithDatabaseTransaction(observable, cordaPersistence);
    }

    private static final boolean hasSQLExceptionCause(@NotNull Throwable $receiver) {
        boolean bl;
        Throwable throwable = $receiver.getCause();
        if (throwable == null) {
            bl = false;
        } else if (throwable instanceof SQLException) {
            bl = true;
        } else {
            Throwable throwable2 = $receiver.getCause();
            bl = throwable2 != null ? CordaPersistenceKt.hasSQLExceptionCause(throwable2) : false;
        }
        return bl;
    }

    @NotNull
    public static final /* synthetic */ InheritableThreadLocal access$get_contextDatabase$p() {
        return _contextDatabase;
    }

    public static final /* synthetic */ boolean access$hasSQLExceptionCause(@NotNull Throwable $receiver) {
        return CordaPersistenceKt.hasSQLExceptionCause($receiver);
    }
}

