/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.persistence;

import co.paralleluniverse.strands.Strand;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import com.zaxxer.hikari.util.ConcurrentBag;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.AttributeConverter;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.corda.core.internal.NamedCacheFactory;
import net.corda.core.schemas.MappedSchema;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.nodeapi.internal.persistence.CordaPersistence;
import net.corda.nodeapi.internal.persistence.CordaPersistenceKt;
import net.corda.nodeapi.internal.persistence.DatabaseConfig;
import net.corda.nodeapi.internal.persistence.DatabaseTransaction;
import net.corda.nodeapi.internal.persistence.DatabaseTransactionKt;
import net.corda.nodeapi.internal.persistence.HibernateConfigException;
import net.corda.nodeapi.internal.persistence.HibernateConfiguration;
import net.corda.nodeapi.internal.persistence.HibernateSchemaChangeException;
import net.corda.nodeapi.internal.persistence.TransactionIsolationLevel;
import org.hibernate.SessionFactory;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 W2\u00020\u0001:\u0002VWB~\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\f\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012#\b\u0002\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u0013\u00a2\u0006\u0002\u0010\u0019J\b\u0010>\u001a\u00020\u0018H\u0016J\u0006\u0010?\u001a\u00020@J\u0010\u0010A\u001a\u00020=2\b\b\u0002\u0010B\u001a\u00020\"J\u0010\u0010C\u001a\u00020=2\b\b\u0002\u0010D\u001a\u00020\"JD\u0010E\u001a\u0002HF\"\u0004\b\u0000\u0010F2\u0006\u0010B\u001a\u00020\"2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00112\u0017\u0010J\u001a\u0013\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002HF0\u0013\u00a2\u0006\u0002\bKH\u0002\u00a2\u0006\u0002\u0010LJ\u0010\u0010M\u001a\u00020=2\b\b\u0002\u0010D\u001a\u00020\"J\u0014\u0010N\u001a\u00020\u00182\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00180PJ\u000e\u0010Q\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001bJ2\u0010R\u001a\u0002HF\"\u0004\b\u0000\u0010F2\u0006\u0010G\u001a\u00020H2\u0017\u0010J\u001a\u0013\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002HF0\u0013\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\u0010SJ*\u0010R\u001a\u0002HF\"\u0004\b\u0000\u0010F2\u0017\u0010J\u001a\u0013\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002HF0\u0013\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\u0010TJB\u0010R\u001a\u0002HF\"\u0004\b\u0000\u0010F2\u0006\u0010B\u001a\u00020\"2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00112\u0017\u0010J\u001a\u0013\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002HF0\u0013\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\u0010LJ2\u0010R\u001a\u0002HF\"\u0004\b\u0000\u0010F2\u0006\u0010B\u001a\u00020\"2\u0017\u0010J\u001a\u0013\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002HF0\u0013\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\u0010UR\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R,\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001b\u0010)\u001a\u00020*8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b+\u0010,R/\u0010/\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020201\u0018\u0001008FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b7\u0010.\u0012\u0004\b3\u00104\u001a\u0004\b5\u00106R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u001a\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020=0;X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lnet/corda/nodeapi/internal/persistence/CordaPersistence;", "Ljava/io/Closeable;", "databaseConfig", "Lnet/corda/nodeapi/internal/persistence/DatabaseConfig;", "schemas", "", "Lnet/corda/core/schemas/MappedSchema;", "jdbcUrl", "", "cacheFactory", "Lnet/corda/core/internal/NamedCacheFactory;", "attributeConverters", "", "Ljavax/persistence/AttributeConverter;", "customClassLoader", "Ljava/lang/ClassLoader;", "closeConnection", "", "errorHandler", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "t", "", "(Lnet/corda/nodeapi/internal/persistence/DatabaseConfig;Ljava/util/Set;Ljava/lang/String;Lnet/corda/core/internal/NamedCacheFactory;Ljava/util/Collection;Ljava/lang/ClassLoader;ZLkotlin/jvm/functions/Function1;)V", "_dataSource", "Ljavax/sql/DataSource;", "getCloseConnection", "()Z", "dataSource", "getDataSource", "()Ljavax/sql/DataSource;", "defaultIsolationLevel", "Lnet/corda/nodeapi/internal/persistence/TransactionIsolationLevel;", "entityManagerFactory", "Lorg/hibernate/SessionFactory;", "getEntityManagerFactory", "()Lorg/hibernate/SessionFactory;", "getErrorHandler", "()Lkotlin/jvm/functions/Function1;", "hibernateConfig", "Lnet/corda/nodeapi/internal/persistence/HibernateConfiguration;", "getHibernateConfig", "()Lnet/corda/nodeapi/internal/persistence/HibernateConfiguration;", "hibernateConfig$delegate", "Lkotlin/Lazy;", "hikariPoolThreadLocal", "Ljava/lang/ThreadLocal;", "", "Ljava/lang/Object;", "hikariPoolThreadLocal$annotations", "()V", "getHikariPoolThreadLocal", "()Ljava/lang/ThreadLocal;", "hikariPoolThreadLocal$delegate", "getJdbcUrl", "()Ljava/lang/String;", "liveTransactions", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lnet/corda/nodeapi/internal/persistence/DatabaseTransaction;", "close", "createSession", "Ljava/sql/Connection;", "createTransaction", "isolationLevel", "currentOrNew", "isolation", "inTopLevelTransaction", "T", "recoverableFailureTolerance", "", "recoverAnyNestedSQLException", "statement", "Lkotlin/ExtensionFunctionType;", "(Lnet/corda/nodeapi/internal/persistence/TransactionIsolationLevel;IZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "newTransaction", "onAllOpenTransactionsClosed", "callback", "Lkotlin/Function0;", "start", "transaction", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Lnet/corda/nodeapi/internal/persistence/TransactionIsolationLevel;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Boundary", "Companion", "node-api"})
public final class CordaPersistence
implements Closeable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final TransactionIsolationLevel defaultIsolationLevel;
    @NotNull
    private final Lazy hibernateConfig$delegate;
    private DataSource _dataSource;
    private final ConcurrentHashMap<UUID, DatabaseTransaction> liveTransactions;
    @Nullable
    private final Lazy hikariPoolThreadLocal$delegate;
    @NotNull
    private final String jdbcUrl;
    private final boolean closeConnection;
    @NotNull
    private final Function1<Throwable, Unit> errorHandler;
    private static final Logger log;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(CordaPersistence.class), "hibernateConfig", "getHibernateConfig()Lnet/corda/nodeapi/internal/persistence/HibernateConfiguration;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(CordaPersistence.class), "hikariPoolThreadLocal", "getHikariPoolThreadLocal()Ljava/lang/ThreadLocal;"))};
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @NotNull
    public final HibernateConfiguration getHibernateConfig() {
        Lazy lazy = this.hibernateConfig$delegate;
        CordaPersistence cordaPersistence = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (HibernateConfiguration)lazy.getValue();
    }

    @NotNull
    public final SessionFactory getEntityManagerFactory() {
        return this.getHibernateConfig().getSessionFactoryForRegisteredSchemas();
    }

    @NotNull
    public final DataSource getDataSource() {
        DataSource dataSource = this._dataSource;
        if (dataSource == null) {
            String string = "CordaPersistence not started";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return dataSource;
    }

    public final void start(@NotNull DataSource dataSource) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        this._dataSource = dataSource;
        DatabaseTransaction databaseTransaction = DatabaseTransactionKt.getContextTransactionOrNull();
        if (databaseTransaction != null) {
            DatabaseTransaction databaseTransaction2;
            DatabaseTransaction it = databaseTransaction2 = databaseTransaction;
            String string = "Was not expecting to find existing database transaction on current strand when setting database: " + Strand.currentStrand() + ", " + it;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        CordaPersistenceKt.access$get_contextDatabase$p().set(this);
        this.transaction(start.2.INSTANCE);
    }

    @NotNull
    public final DatabaseTransaction currentOrNew(@NotNull TransactionIsolationLevel isolation) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)isolation), (String)"isolation");
        DatabaseTransaction databaseTransaction = DatabaseTransactionKt.getContextTransactionOrNull();
        if (databaseTransaction == null) {
            databaseTransaction = this.newTransaction(isolation);
        }
        return databaseTransaction;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ DatabaseTransaction currentOrNew$default(CordaPersistence cordaPersistence, TransactionIsolationLevel transactionIsolationLevel, int n, Object object) {
        if ((n & 1) != 0) {
            transactionIsolationLevel = cordaPersistence.defaultIsolationLevel;
        }
        return cordaPersistence.currentOrNew(transactionIsolationLevel);
    }

    @NotNull
    public final DatabaseTransaction newTransaction(@NotNull TransactionIsolationLevel isolation) {
        DatabaseTransaction databaseTransaction;
        Intrinsics.checkParameterIsNotNull((Object)((Object)isolation), (String)"isolation");
        Boolean bl = CordaPersistenceKt.get_prohibitDatabaseAccess().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"_prohibitDatabaseAccess.get()");
        if (bl.booleanValue()) {
            throw (Throwable)new IllegalAccessException("Database access is not allowed in the current context.");
        }
        DatabaseTransaction outerTransaction = DatabaseTransactionKt.getContextTransactionOrNull();
        DatabaseTransaction it = databaseTransaction = new DatabaseTransaction(isolation.getJdbcValue(), DatabaseTransactionKt.getContextTransactionOrNull(), this);
        DatabaseTransactionKt.setContextTransactionOrNull(it);
        if (outerTransaction == null) {
            this.liveTransactions.put(it.getId(), it);
            it.onClose((Function0<Unit>)((Function0)new Function0<Unit>(it, this, outerTransaction){
                final /* synthetic */ DatabaseTransaction $it;
                final /* synthetic */ CordaPersistence this$0;
                final /* synthetic */ DatabaseTransaction $outerTransaction$inlined;
                {
                    this.$it = databaseTransaction;
                    this.this$0 = cordaPersistence;
                    this.$outerTransaction$inlined = databaseTransaction2;
                    super(0);
                }

                public final void invoke() {
                    CordaPersistence.access$getLiveTransactions$p(this.this$0).remove(this.$it.getId());
                }
            }));
        }
        return databaseTransaction;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ DatabaseTransaction newTransaction$default(CordaPersistence cordaPersistence, TransactionIsolationLevel transactionIsolationLevel, int n, Object object) {
        if ((n & 1) != 0) {
            transactionIsolationLevel = cordaPersistence.defaultIsolationLevel;
        }
        return cordaPersistence.newTransaction(transactionIsolationLevel);
    }

    public final void onAllOpenTransactionsClosed(@NotNull Function0<Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        ArrayList<DatabaseTransaction> allOpen = new ArrayList<DatabaseTransaction>(this.liveTransactions.values());
        if (allOpen.isEmpty()) {
            callback.invoke();
        } else {
            AtomicInteger counter = new AtomicInteger(allOpen.size());
            Iterable $receiver$iv = allOpen;
            for (Object element$iv : $receiver$iv) {
                DatabaseTransaction it = (DatabaseTransaction)element$iv;
                it.onClose((Function0<Unit>)((Function0)new Function0<Unit>(counter, callback){
                    final /* synthetic */ AtomicInteger $counter$inlined;
                    final /* synthetic */ Function0 $callback$inlined;
                    {
                        this.$counter$inlined = atomicInteger;
                        this.$callback$inlined = function0;
                        super(0);
                    }

                    public final void invoke() {
                        if (this.$counter$inlined.decrementAndGet() == 0) {
                            this.$callback$inlined.invoke();
                        }
                    }
                }));
            }
        }
    }

    @NotNull
    public final DatabaseTransaction createTransaction(@NotNull TransactionIsolationLevel isolationLevel) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)isolationLevel), (String)"isolationLevel");
        CordaPersistenceKt.access$get_contextDatabase$p().set(this);
        return this.currentOrNew(isolationLevel);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ DatabaseTransaction createTransaction$default(CordaPersistence cordaPersistence, TransactionIsolationLevel transactionIsolationLevel, int n, Object object) {
        if ((n & 1) != 0) {
            transactionIsolationLevel = cordaPersistence.defaultIsolationLevel;
        }
        return cordaPersistence.createTransaction(transactionIsolationLevel);
    }

    @NotNull
    public final Connection createSession() {
        try {
            CordaPersistenceKt.access$get_contextDatabase$p().set(this);
            DatabaseTransactionKt.currentDBSession().flush();
            return DatabaseTransactionKt.getContextTransaction().getConnection();
        }
        catch (SQLException sqlException) {
            this.errorHandler.invoke((Object)sqlException);
            throw (Throwable)sqlException;
        }
        catch (PersistenceException persistenceException) {
            this.errorHandler.invoke((Object)persistenceException);
            throw (Throwable)persistenceException;
        }
    }

    public final <T> T transaction(@NotNull TransactionIsolationLevel isolationLevel, @NotNull Function1<? super DatabaseTransaction, ? extends T> statement) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)isolationLevel), (String)"isolationLevel");
        Intrinsics.checkParameterIsNotNull(statement, (String)"statement");
        return this.transaction(isolationLevel, 2, false, statement);
    }

    public final <T> T transaction(@NotNull Function1<? super DatabaseTransaction, ? extends T> statement) {
        Intrinsics.checkParameterIsNotNull(statement, (String)"statement");
        return this.transaction(this.defaultIsolationLevel, statement);
    }

    public final <T> T transaction(@NotNull TransactionIsolationLevel isolationLevel, int recoverableFailureTolerance, boolean recoverAnyNestedSQLException, @NotNull Function1<? super DatabaseTransaction, ? extends T> statement) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)isolationLevel), (String)"isolationLevel");
        Intrinsics.checkParameterIsNotNull(statement, (String)"statement");
        CordaPersistenceKt.access$get_contextDatabase$p().set(this);
        DatabaseTransaction outer = DatabaseTransactionKt.getContextTransactionOrNull();
        try {
            return (T)(outer != null ? statement.invoke((Object)outer) : this.inTopLevelTransaction(isolationLevel, recoverableFailureTolerance, recoverAnyNestedSQLException, statement));
        }
        catch (SQLException sqlException) {
            this.errorHandler.invoke((Object)sqlException);
            throw (Throwable)sqlException;
        }
        catch (PersistenceException persistenceException) {
            this.errorHandler.invoke((Object)persistenceException);
            throw (Throwable)persistenceException;
        }
    }

    public final <T> T transaction(int recoverableFailureTolerance, @NotNull Function1<? super DatabaseTransaction, ? extends T> statement) {
        Intrinsics.checkParameterIsNotNull(statement, (String)"statement");
        return this.transaction(this.defaultIsolationLevel, recoverableFailureTolerance, false, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T inTopLevelTransaction(TransactionIsolationLevel isolationLevel, int recoverableFailureTolerance, boolean recoverAnyNestedSQLException, Function1<? super DatabaseTransaction, ? extends T> statement) {
        int recoverableFailureCount = 0;
        inTopLevelTransaction.1 quietly$ = inTopLevelTransaction.1.INSTANCE;
        while (true) {
            Object object;
            DatabaseTransaction transaction = CordaPersistenceKt.getContextDatabase().currentOrNew(isolationLevel);
            try {
                Object answer = statement.invoke((Object)transaction);
                transaction.commit();
                object = answer;
                quietly$.invoke((Function0)new Function0<Unit>(transaction){

                    public final void invoke() {
                        ((DatabaseTransaction)this.receiver).close();
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(DatabaseTransaction.class);
                    }

                    public final String getName() {
                        return "close";
                    }

                    public final String getSignature() {
                        return "close()V";
                    }
                });
            }
            catch (Exception e) {
                try {
                    quietly$.invoke((Function0)new Function0<Unit>(transaction){

                        public final void invoke() {
                            ((DatabaseTransaction)this.receiver).rollback();
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(DatabaseTransaction.class);
                        }

                        public final String getName() {
                            return "rollback";
                        }

                        public final String getSignature() {
                            return "rollback()V";
                        }
                    });
                    if (e instanceof SQLException || recoverAnyNestedSQLException && CordaPersistenceKt.access$hasSQLExceptionCause(e)) {
                        if (++recoverableFailureCount > recoverableFailureTolerance) {
                            throw (Throwable)e;
                        }
                    } else {
                        throw (Throwable)e;
                    }
                    log.warn("Caught failure, will retry " + recoverableFailureCount + '/' + recoverableFailureTolerance + ':', (Throwable)e);
                    quietly$.invoke((Function0)new /* invalid duplicate definition of identical inner class */);
                }
                catch (Throwable throwable) {
                    quietly$.invoke((Function0)new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                continue;
            }
            return (T)object;
            break;
        }
    }

    @Override
    public void close() {
        block1: {
            DataSource dataSource = this._dataSource;
            if (!(dataSource instanceof AutoCloseable)) {
                dataSource = null;
            }
            AutoCloseable autoCloseable = (AutoCloseable)((Object)dataSource);
            if (autoCloseable == null) break block1;
            autoCloseable.close();
        }
    }

    public static /* synthetic */ void hikariPoolThreadLocal$annotations() {
    }

    @Nullable
    public final ThreadLocal<List<Object>> getHikariPoolThreadLocal() {
        Lazy lazy = this.hikariPoolThreadLocal$delegate;
        CordaPersistence cordaPersistence = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (ThreadLocal)lazy.getValue();
    }

    @NotNull
    public final String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public final boolean getCloseConnection() {
        return this.closeConnection;
    }

    @NotNull
    public final Function1<Throwable, Unit> getErrorHandler() {
        return this.errorHandler;
    }

    public CordaPersistence(@NotNull DatabaseConfig databaseConfig, @NotNull Set<? extends MappedSchema> schemas, @NotNull String jdbcUrl, @NotNull NamedCacheFactory cacheFactory, @NotNull Collection<? extends AttributeConverter<?, ?>> attributeConverters, @Nullable ClassLoader customClassLoader, boolean closeConnection, @NotNull Function1<? super Throwable, Unit> errorHandler) {
        Intrinsics.checkParameterIsNotNull((Object)databaseConfig, (String)"databaseConfig");
        Intrinsics.checkParameterIsNotNull(schemas, (String)"schemas");
        Intrinsics.checkParameterIsNotNull((Object)jdbcUrl, (String)"jdbcUrl");
        Intrinsics.checkParameterIsNotNull((Object)cacheFactory, (String)"cacheFactory");
        Intrinsics.checkParameterIsNotNull(attributeConverters, (String)"attributeConverters");
        Intrinsics.checkParameterIsNotNull(errorHandler, (String)"errorHandler");
        this.jdbcUrl = jdbcUrl;
        this.closeConnection = closeConnection;
        this.errorHandler = errorHandler;
        this.defaultIsolationLevel = databaseConfig.getTransactionIsolationLevel();
        this.hibernateConfig$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HibernateConfiguration>(this, schemas, databaseConfig, attributeConverters, cacheFactory, customClassLoader){
            final /* synthetic */ CordaPersistence this$0;
            final /* synthetic */ Set $schemas;
            final /* synthetic */ DatabaseConfig $databaseConfig;
            final /* synthetic */ Collection $attributeConverters;
            final /* synthetic */ NamedCacheFactory $cacheFactory;
            final /* synthetic */ ClassLoader $customClassLoader;

            @NotNull
            public final HibernateConfiguration invoke() {
                return (HibernateConfiguration)this.this$0.transaction((Function1)new Function1<DatabaseTransaction, HibernateConfiguration>(this){
                    final /* synthetic */ hibernateConfig.2 this$0;

                    @NotNull
                    public final HibernateConfiguration invoke(@NotNull DatabaseTransaction $receiver) {
                        HibernateConfiguration hibernateConfiguration;
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        try {
                            hibernateConfiguration = new HibernateConfiguration(this.this$0.$schemas, this.this$0.$databaseConfig, this.this$0.$attributeConverters, this.this$0.this$0.getJdbcUrl(), this.this$0.$cacheFactory, this.this$0.$customClassLoader);
                        }
                        catch (Exception e) {
                            Exception exception = e;
                            if (exception instanceof SchemaManagementException) {
                                throw (Throwable)new HibernateSchemaChangeException("Incompatible schema change detected. Please run the node with database.initialiseSchema=true. Reason: " + e.getMessage(), e);
                            }
                            throw (Throwable)new HibernateConfigException("Could not create Hibernate configuration: " + e.getMessage(), e);
                        }
                        return hibernateConfiguration;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = cordaPersistence;
                this.$schemas = set2;
                this.$databaseConfig = databaseConfig;
                this.$attributeConverters = collection;
                this.$cacheFactory = namedCacheFactory;
                this.$customClassLoader = classLoader;
                super(0);
            }
        }));
        this.liveTransactions = new ConcurrentHashMap();
        this.hikariPoolThreadLocal$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<ThreadLocal<List<? extends Object>>>(this){
            final /* synthetic */ CordaPersistence this$0;

            @Nullable
            public final ThreadLocal<List<Object>> invoke() {
                ThreadLocal threadLocal;
                HikariDataSource hikariDataSource;
                DataSource dataSource = this.this$0.getDataSource();
                if (!(dataSource instanceof HikariDataSource)) {
                    dataSource = null;
                }
                if ((hikariDataSource = (HikariDataSource)dataSource) == null) {
                    threadLocal = null;
                } else {
                    ThreadLocal threadList;
                    Field field = HikariDataSource.class.getDeclaredField("pool");
                    Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"HikariDataSource::class.\u2026.getDeclaredField(\"pool\")");
                    Field poolField = field;
                    poolField.setAccessible(true);
                    Object object = poolField.get(hikariDataSource);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.zaxxer.hikari.pool.HikariPool");
                    }
                    HikariPool pool = (HikariPool)object;
                    Field field2 = HikariPool.class.getDeclaredField("connectionBag");
                    Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"HikariPool::class.java.g\u2026redField(\"connectionBag\")");
                    Field connectionBagField = field2;
                    connectionBagField.setAccessible(true);
                    Object object2 = connectionBagField.get(pool);
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.zaxxer.hikari.util.ConcurrentBag<com.zaxxer.hikari.util.ConcurrentBag.IConcurrentBagEntry>");
                    }
                    ConcurrentBag connectionBag = (ConcurrentBag)object2;
                    Field field3 = ConcurrentBag.class.getDeclaredField("threadList");
                    Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"ConcurrentBag::class.jav\u2026claredField(\"threadList\")");
                    Field threadListField = field3;
                    threadListField.setAccessible(true);
                    Object object3 = threadListField.get(connectionBag);
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.ThreadLocal<kotlin.collections.List<java.lang.Object>>");
                    }
                    threadLocal = threadList = (ThreadLocal)object3;
                }
                return threadLocal;
            }
            {
                this.this$0 = cordaPersistence;
                super(0);
            }
        }));
    }

    public /* synthetic */ CordaPersistence(DatabaseConfig databaseConfig, Set set2, String string, NamedCacheFactory namedCacheFactory, Collection collection, ClassLoader classLoader, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            collection = SetsKt.emptySet();
        }
        if ((n & 0x20) != 0) {
            classLoader = null;
        }
        if ((n & 0x40) != 0) {
            bl = true;
        }
        if ((n & 0x80) != 0) {
            function1 = 1.INSTANCE;
        }
        this(databaseConfig, set2, string, namedCacheFactory, collection, classLoader, bl, (Function1<? super Throwable, Unit>)function1);
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getLiveTransactions$p(CordaPersistence $this) {
        return $this.liveTransactions;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnet/corda/nodeapi/internal/persistence/CordaPersistence$Boundary;", "", "txId", "Ljava/util/UUID;", "success", "", "(Ljava/util/UUID;Z)V", "getSuccess", "()Z", "getTxId", "()Ljava/util/UUID;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "node-api"})
    public static final class Boundary {
        @NotNull
        private final UUID txId;
        private final boolean success;

        @NotNull
        public final UUID getTxId() {
            return this.txId;
        }

        public final boolean getSuccess() {
            return this.success;
        }

        public Boundary(@NotNull UUID txId, boolean success) {
            Intrinsics.checkParameterIsNotNull((Object)txId, (String)"txId");
            this.txId = txId;
            this.success = success;
        }

        @NotNull
        public final UUID component1() {
            return this.txId;
        }

        public final boolean component2() {
            return this.success;
        }

        @NotNull
        public final Boundary copy(@NotNull UUID txId, boolean success) {
            Intrinsics.checkParameterIsNotNull((Object)txId, (String)"txId");
            return new Boundary(txId, success);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Boundary copy$default(Boundary boundary, UUID uUID, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = boundary.txId;
            }
            if ((n & 2) != 0) {
                bl = boundary.success;
            }
            return boundary.copy(uUID, bl);
        }

        @NotNull
        public String toString() {
            return "Boundary(txId=" + this.txId + ", success=" + this.success + ")";
        }

        public int hashCode() {
            UUID uUID = this.txId;
            int n = (uUID != null ? ((Object)uUID).hashCode() : 0) * 31;
            int n2 = this.success ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Boundary)) break block3;
                    Boundary boundary = (Boundary)object;
                    if (!Intrinsics.areEqual((Object)this.txId, (Object)boundary.txId) || !(this.success == boundary.success)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/nodeapi/internal/persistence/CordaPersistence$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "node-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

