/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.persistence;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import net.corda.core.crypto.SecureHash;
import net.corda.core.internal.PathUtilsKt;
import net.corda.core.internal.SignedDataWithCert;
import net.corda.core.node.NetworkParameters;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationFactory;
import net.corda.core.utilities.ByteArrays;
import net.corda.core.utilities.ByteSequence;
import net.corda.core.utilities.KotlinUtilsKt;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u001c"}, d2={"Lnet/corda/nodeapi/internal/persistence/AttachmentVersionNumberMigration;", "Lliquibase/change/custom/CustomTaskChange;", "()V", "execute", "", "database", "Lliquibase/database/Database;", "getAttachmentsWithDefaultVersion", "", "", "connection", "Lliquibase/database/jvm/JdbcConnection;", "getConfirmationMessage", "getNetworkParametersFromFile", "Lnet/corda/core/node/NetworkParameters;", "path", "Ljava/nio/file/Path;", "setFileOpener", "resourceAccessor", "Lliquibase/resource/ResourceAccessor;", "setUp", "updateVersion", "attachmentId", "version", "", "validate", "Lliquibase/exception/ValidationErrors;", "Companion", "node-api"})
public final class AttachmentVersionNumberMigration
implements CustomTaskChange {
    private static final Logger logger;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(@Nullable Database database) {
        Database database2 = database;
        Object object = database2 != null ? database2.getConnection() : null;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type liquibase.database.jvm.JdbcConnection");
        }
        JdbcConnection connection2 = (JdbcConnection)object;
        String msg = "Attachment version creation from whitelisted JARs";
        try {
            Path path;
            logger.info("Start executing...");
            Ref.ObjectRef networkParameters = new Ref.ObjectRef();
            String baseDir = System.getProperty("liquibase.nodeDaseDir");
            List<String> availableAttachments = this.getAttachmentsWithDefaultVersion(connection2);
            if (baseDir != null) {
                Path path2 = Paths.get(baseDir, new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(baseDir)");
                path = PathUtilsKt.div((Path)path2, (String)"network-parameters");
                networkParameters.element = this.getNetworkParametersFromFile(path);
                if ((NetworkParameters)networkParameters.element == null) {
                    if (availableAttachments.isEmpty()) {
                        logger.info(msg + " skipped, network parameters not found in " + path + ", but there are no available attachments to migrate.");
                        return;
                    }
                    logger.warn(msg + " skipped, network parameters not found in " + path + '.');
                    return;
                }
            } else {
                logger.error(msg + " skipped, network parameters not retrieved, could not determine node base directory due to system property liquibase.nodeDaseDir being not set.");
                return;
            }
            logger.info(msg + " using network parameters from " + path + ", whitelistedContractImplementations: " + ((NetworkParameters)networkParameters.element).getWhitelistedContractImplementations() + '.');
            if (availableAttachments.isEmpty()) {
                logger.info(msg + " skipped, no attachments not found.");
                return;
            }
            logger.info(msg + ", candidate attachments with version '1': " + availableAttachments);
            Iterable $receiver$iv = availableAttachments;
            for (Object element$iv : $receiver$iv) {
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv2;
                String attachmentId = (String)element$iv;
                Iterable iterable = $receiver$iv2 = (Iterable)((NetworkParameters)networkParameters.element).getWhitelistedContractImplementations().values();
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                Iterator iterator2 = $receiver$iv$iv.iterator();
                while (true) {
                    int n;
                    Collection collection;
                    block18: {
                        Iterator iterator3;
                        int index$iv;
                        if (iterator2.hasNext()) {
                            void it;
                            Object item$iv$iv = iterator2.next();
                            List list2 = (List)item$iv$iv;
                            collection = destination$iv$iv;
                            void $receiver$iv3 = it;
                            index$iv = 0;
                            iterator3 = $receiver$iv3.iterator();
                        } else {
                            $receiver$iv2 = (List)destination$iv$iv;
                            $receiver$iv$iv = $receiver$iv2;
                            destination$iv$iv = new ArrayList();
                            iterator2 = $receiver$iv$iv.iterator();
                            break;
                        }
                        while (iterator3.hasNext()) {
                            Object item$iv = iterator3.next();
                            SecureHash aid = (SecureHash)item$iv;
                            if (Intrinsics.areEqual((Object)aid.toString(), (Object)attachmentId)) {
                                n = index$iv;
                                break block18;
                            }
                            ++index$iv;
                        }
                        n = -1;
                    }
                    Integer n2 = n;
                    collection.add(n2);
                }
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    int it = ((Number)element$iv$iv).intValue();
                    if (!(it >= 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List versions = (List)destination$iv$iv;
                Integer n = (Integer)CollectionsKt.max((Iterable)versions);
                int maxPosition = n != null ? n : 0;
                if (maxPosition <= 0) continue;
                int version = maxPosition + 1;
                String updateVersionMsg = "Updating version of attachment " + attachmentId + " to '" + version + "'.";
                if (CollectionsKt.toSet((Iterable)versions).size() > 1) {
                    logger.warn("Several versions based on whitelistedContractImplementations position are available: " + CollectionsKt.toSet((Iterable)versions) + ". " + updateVersionMsg);
                } else {
                    logger.info(updateVersionMsg);
                }
                this.updateVersion(connection2, attachmentId, version);
            }
            return;
        }
        catch (Exception e) {
            logger.error(msg + " exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    public ValidationErrors validate(@Nullable Database database) {
        return null;
    }

    @Nullable
    public String getConfirmationMessage() {
        return null;
    }

    public void setFileOpener(@Nullable ResourceAccessor resourceAccessor) {
    }

    public void setUp() {
    }

    private final NetworkParameters getNetworkParametersFromFile(Path path) {
        NetworkParameters networkParameters;
        try {
            boolean bl;
            byte[] byArray;
            Path $receiver$iv = path;
            byte[] $receiver$iv$iv = PathUtilsKt.readAll((Path)$receiver$iv);
            SerializationFactory serializationFactory$iv$iv = SerializationFactory.Companion.getDefaultFactory();
            SerializationContext context$iv$iv = serializationFactory$iv$iv.getDefaultContext();
            byte[] byArray2 = byArray = $receiver$iv$iv;
            boolean bl2 = bl = !(byArray2.length == 0);
            if (!bl) {
                String string = "Empty bytes";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ByteSequence $receiver$iv$iv$iv = ByteArrays.sequence$default((byte[])$receiver$iv$iv, (int)0, (int)0, (int)3, null);
            SignedDataWithCert networkParametersBytes = (SignedDataWithCert)serializationFactory$iv$iv.deserialize($receiver$iv$iv$iv, SignedDataWithCert.class, context$iv$iv);
            $receiver$iv = networkParametersBytes.getRaw();
            SerializationFactory serializationFactory$iv = SerializationFactory.Companion.getDefaultFactory();
            SerializationContext context$iv = serializationFactory$iv.getDefaultContext();
            networkParameters = (NetworkParameters)serializationFactory$iv.deserialize((ByteSequence)$receiver$iv, NetworkParameters.class, context$iv);
        }
        catch (Exception e) {
            networkParameters = null;
        }
        return networkParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> getAttachmentsWithDefaultVersion(JdbcConnection connection2) {
        List list2;
        AutoCloseable autoCloseable = connection2.createStatement();
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            List attachments = new ArrayList();
            ResultSet rs = it.executeQuery("SELECT ATT_ID FROM NODE_ATTACHMENTS WHERE VERSION = 1");
            while (rs.next()) {
                String elem;
                String string = elem = rs.getString(1);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"elem");
                attachments.add(string);
            }
            rs.close();
            list2 = attachments;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateVersion(JdbcConnection connection2, String attachmentId, int version) {
        AutoCloseable autoCloseable = connection2.prepareStatement("UPDATE NODE_ATTACHMENTS SET VERSION = ? WHERE ATT_ID = ?");
        Throwable throwable = null;
        try {
            PreparedStatement it = (PreparedStatement)autoCloseable;
            it.setInt(1, version);
            it.setString(2, attachmentId);
            int n = it.executeUpdate();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    static {
        Companion = new Companion(null);
        logger = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/nodeapi/internal/persistence/AttachmentVersionNumberMigration$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "node-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

