/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.network;

import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.corda.core.crypto.SecureHash;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.PathUtilsKt;
import net.corda.core.node.NetworkParameters;
import net.corda.nodeapi.internal.ContractsJar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001aj\u0010\u0006\u001a\u001c\u0012\b\u0012\u00060\u0001j\u0002`\b\u0012\u000e\u0012\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\t0\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0001j\u0002`\b0\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0001j\u0002`\b0\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\t\u001a\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0017\u001a\u00020\u0015\u001a\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0017\u001a\u00020\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"EXCLUDE_WHITELIST_FILE_NAME", "", "INCLUDE_WHITELIST_FILE_NAME", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "generateWhitelist", "", "Lnet/corda/core/contracts/ContractClassName;", "", "Lnet/corda/core/crypto/SecureHash;", "Lnet/corda/core/node/services/AttachmentId;", "networkParameters", "Lnet/corda/core/node/NetworkParameters;", "excludeContracts", "cordappJars", "Lnet/corda/nodeapi/internal/ContractsJar;", "includeContracts", "optionalCordappJars", "readAllLines", "path", "Ljava/nio/file/Path;", "readExcludeWhitelist", "directory", "readIncludeWhitelist", "node-api"})
public final class WhitelistGeneratorKt {
    private static final String EXCLUDE_WHITELIST_FILE_NAME = "exclude_whitelist.txt";
    private static final String INCLUDE_WHITELIST_FILE_NAME = "include_whitelist.txt";
    private static final Logger logger = LoggerFactory.getLogger((String)"net.corda.nodeapi.internal.network.WhitelistGenerator");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<SecureHash>> generateWhitelist(@Nullable NetworkParameters networkParameters, @NotNull List<String> excludeContracts, @NotNull List<? extends ContractsJar> cordappJars, @NotNull List<String> includeContracts, @NotNull List<? extends ContractsJar> optionalCordappJars) {
        void $receiver$iv$iv;
        Object $receiver$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Object object;
        Iterable destination$iv$iv;
        Iterable $receiver$iv$iv3;
        Collection $receiver$iv3;
        Object element$iv2;
        Intrinsics.checkParameterIsNotNull(excludeContracts, (String)"excludeContracts");
        Intrinsics.checkParameterIsNotNull(cordappJars, (String)"cordappJars");
        Intrinsics.checkParameterIsNotNull(includeContracts, (String)"includeContracts");
        Intrinsics.checkParameterIsNotNull(optionalCordappJars, (String)"optionalCordappJars");
        Object object2 = networkParameters;
        if (object2 == null || (object2 = object2.getWhitelistedContractImplementations()) == null) {
            object2 = MapsKt.emptyMap();
        }
        Object existingWhitelist = object2;
        Collection collection = excludeContracts;
        if (!collection.isEmpty()) {
            logger.info("Exclude contracts from exclude_whitelist.txt: " + CollectionsKt.joinToString$default((Iterable)excludeContracts, null, null, null, (int)0, null, null, (int)63, null));
            Iterable $receiver$iv4 = existingWhitelist.keySet();
            for (Object element$iv2 : $receiver$iv4) {
                String it = (String)element$iv2;
                boolean bl = !excludeContracts.contains(it);
                if (bl) continue;
                String string = it + " is already part of the existing whitelist and cannot be excluded.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        Iterable iterable = cordappJars;
        element$iv2 = $receiver$iv3;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv3) {
            void $receiver$iv$iv4;
            Iterable $receiver$iv5;
            ContractsJar jar = (ContractsJar)element$iv$iv;
            Iterable $i$f$forEach = $receiver$iv5 = (Iterable)CollectionsKt.minus((Iterable)jar.scan(), (Iterable)excludeContracts);
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv5, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv4) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                object = TuplesKt.to((Object)it, (Object)jar.getHash());
                collection2.add(object);
            }
            Iterable list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Map newWhiteList = InternalUtils.toMultiMap((Iterable)((List)destination$iv$iv2));
        $receiver$iv3 = includeContracts;
        if (!$receiver$iv3.isEmpty()) {
            logger.info("Include contracts from include_whitelist.txt: " + CollectionsKt.joinToString$default((Iterable)includeContracts, null, null, null, (int)0, null, null, (int)63, null) + " present in JARs: " + optionalCordappJars + '.');
        }
        $receiver$iv$iv3 = optionalCordappJars;
        destination$iv$iv2 = $receiver$iv2;
        Iterable destination$iv$iv3 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            String it;
            Iterable $receiver$iv$iv5;
            ContractsJar jar = (ContractsJar)element$iv$iv;
            $receiver$iv = jar.scan();
            destination$iv$iv = $receiver$iv;
            Collection destination$iv$iv4 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv5) {
                it = (String)element$iv$iv2;
                if (!includeContracts.contains(it)) continue;
                destination$iv$iv4.add(element$iv$iv2);
            }
            $receiver$iv = (List)destination$iv$iv4;
            $receiver$iv$iv5 = $receiver$iv;
            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv5) {
                it = (String)item$iv$iv;
                object = destination$iv$iv4;
                Pair pair = TuplesKt.to((Object)it, (Object)jar.getHash());
                object.add(pair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv4;
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        Map newSignedJarsWhiteList = InternalUtils.toMultiMap((Iterable)((List)destination$iv$iv3));
        $receiver$iv2 = SetsKt.plus((Set)SetsKt.plus(newWhiteList.keySet(), (Iterable)existingWhitelist.keySet()), (Iterable)newSignedJarsWhiteList.keySet());
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10)), (int)16);
        destination$iv$iv3 = $receiver$iv2;
        Map destination$iv$iv5 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            List list2;
            List newHashes;
            List list3;
            List existingHashes;
            String it;
            $receiver$iv = (String)element$iv$iv;
            Map map = destination$iv$iv5;
            void var30_28 = it;
            it = (String)element$iv$iv;
            List list4 = (List)existingWhitelist.get(it);
            if (list4 == null) {
                list4 = existingHashes = CollectionsKt.emptyList();
            }
            if ((list3 = (List)newWhiteList.get(it)) == null) {
                list3 = newHashes = CollectionsKt.emptyList();
            }
            if ((list2 = (List)newSignedJarsWhiteList.get(it)) == null) {
                list2 = CollectionsKt.emptyList();
            }
            List newHashesFormSignedJar = list2;
            List list5 = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)existingHashes, (Iterable)newHashes), (Iterable)newHashesFormSignedJar));
            map.put(var30_28, list5);
        }
        return destination$iv$iv5;
    }

    @NotNull
    public static final List<String> readExcludeWhitelist(@NotNull Path directory) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        return WhitelistGeneratorKt.readAllLines(PathUtilsKt.div((Path)directory, (String)EXCLUDE_WHITELIST_FILE_NAME));
    }

    @NotNull
    public static final List<String> readIncludeWhitelist(@NotNull Path directory) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        return WhitelistGeneratorKt.readAllLines(PathUtilsKt.div((Path)directory, (String)INCLUDE_WHITELIST_FILE_NAME));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> readAllLines(Path path) {
        List list2;
        if (PathUtilsKt.exists((Path)path, (LinkOption[])new LinkOption[0])) {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)PathUtilsKt.readAllLines$default((Path)path, null, (int)1, null);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p1;
                void var7_7;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v0 = var7_7 = p1;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
                collection.add(string2);
            }
            list2 = (List)var3_3;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }
}

