/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.network;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.PathUtilsKt;
import net.corda.core.internal.ThreadBox;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.nodeapi.internal.network.NodeInfoFilesCopier;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import rx.Observable;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action1;
import rx.schedulers.Schedulers;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\r\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u0006\u0010\u001c\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/corda/nodeapi/internal/network/NodeInfoFilesCopier;", "Ljava/lang/AutoCloseable;", "scheduler", "Lrx/Scheduler;", "(Lrx/Scheduler;)V", "closed", "", "nodeDataMapBox", "Lnet/corda/core/internal/ThreadBox;", "", "Ljava/nio/file/Path;", "Lnet/corda/nodeapi/internal/network/NodeInfoFilesCopier$NodeData;", "subscription", "Lrx/Subscription;", "addConfig", "", "nodeDir", "allPreviouslySeenFiles", "", "atomicCopy", "source", "destination", "close", "poll", "processPath", "nodeData", "path", "removeConfig", "reset", "Companion", "NodeData", "node-api"})
public final class NodeInfoFilesCopier
implements AutoCloseable {
    private final ThreadBox<Map<Path, NodeData>> nodeDataMapBox;
    private boolean closed;
    private final Subscription subscription;
    private final Scheduler scheduler;
    private static final Logger log;
    @NotNull
    public static final String NODE_INFO_FILE_NAME_PREFIX = "nodeInfo-";
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConfig(@NotNull Path nodeDir) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)nodeDir, (String)"nodeDir");
        boolean bl2 = bl = !this.closed;
        if (!bl) {
            String string = "NodeInfoFilesCopier is already closed";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ThreadBox<Map<Path, NodeData>> this_$iv = this.nodeDataMapBox;
        Lock lock = this_$iv.getLock();
        lock.lock();
        try {
            Map $receiver = (Map)this_$iv.getContent();
            NodeData newNodeFile = new NodeData(nodeDir);
            $receiver.put(nodeDir, newNodeFile);
            for (Path previouslySeenFile : this.allPreviouslySeenFiles()) {
                Path path = newNodeFile.getAdditionalNodeInfoDirectory().resolve(previouslySeenFile.getFileName());
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"newNodeFile.additionalNo\u2026viouslySeenFile.fileName)");
                this.atomicCopy(previouslySeenFile, path);
            }
            log.info("Now watching: " + nodeDir);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeConfig(@NotNull Path nodeDir) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)nodeDir, (String)"nodeDir");
        boolean bl2 = bl = !this.closed;
        if (!bl) {
            String string = "NodeInfoFilesCopier is already closed";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ThreadBox<Map<Path, NodeData>> this_$iv = this.nodeDataMapBox;
        Lock lock = this_$iv.getLock();
        lock.lock();
        try {
            Map $receiver = (Map)this_$iv.getContent();
            if ((NodeData)$receiver.remove(nodeDir) == null) {
                return;
            }
            log.info("Stopped watching: " + nodeDir);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        boolean bl;
        boolean bl2 = bl = !this.closed;
        if (!bl) {
            String string = "NodeInfoFilesCopier is already closed";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ThreadBox<Map<Path, NodeData>> this_$iv = this.nodeDataMapBox;
        Lock lock = this_$iv.getLock();
        lock.lock();
        try {
            Map $receiver = (Map)this_$iv.getContent();
            $receiver.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.subscription.unsubscribe();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> allPreviouslySeenFiles() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        ThreadBox<Map<Path, NodeData>> this_$iv = this.nodeDataMapBox;
        boolean bl = this_$iv.getLock().isHeldByCurrentThread();
        if (!bl) {
            String string = "Expected " + this_$iv.getLock() + " to already be locked.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map $receiver = (Map)this_$iv.getContent();
        Iterable iterable = $receiver$iv = (Iterable)$receiver.values();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            NodeData it = (NodeData)element$iv$iv;
            Iterable list$iv$iv = it.getPreviouslySeenFiles().keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void poll() {
        ThreadBox<Map<Path, NodeData>> this_$iv = this.nodeDataMapBox;
        Lock lock = this_$iv.getLock();
        lock.lock();
        try {
            Map $receiver = (Map)this_$iv.getContent();
            for (NodeData nodeData : $receiver.values()) {
                Path $receiver$iv = nodeData.getNodeDir();
                AutoCloseable autoCloseable = Files.list($receiver$iv);
                Throwable throwable = null;
                try {
                    Stream paths = (Stream)autoCloseable;
                    paths.filter(poll.1.1.1.INSTANCE).filter(poll.1.1.2.INSTANCE).forEach(new Consumer<Path>(nodeData, this){
                        final /* synthetic */ NodeData $nodeData$inlined;
                        final /* synthetic */ NodeInfoFilesCopier this$0;
                        {
                            this.$nodeData$inlined = nodeData;
                            this.this$0 = nodeInfoFilesCopier;
                        }

                        public final void accept(Path it) {
                            Path path = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                            NodeInfoFilesCopier.access$processPath(this.this$0, this.$nodeData$inlined, path);
                        }
                    });
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void processPath(NodeData nodeData, Path path) {
        FileTime previousTimestamp;
        ThreadBox<Map<Path, NodeData>> this_$iv = this.nodeDataMapBox;
        boolean bl = this_$iv.getLock().isHeldByCurrentThread();
        if (!bl) {
            String string = "Expected " + this_$iv.getLock() + " to already be locked.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map $receiver = (Map)this_$iv.getContent();
        FileTime newTimestamp = PathUtilsKt.lastModifiedTime((Path)path, (LinkOption[])new LinkOption[0]);
        FileTime fileTime = nodeData.getPreviouslySeenFiles().put(path, newTimestamp);
        if (fileTime == null) {
            fileTime = previousTimestamp = FileTime.fromMillis(-1L);
        }
        if (newTimestamp.compareTo(previousTimestamp) > 0) {
            NodeData it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)$receiver.values();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (NodeData)element$iv$iv;
                if (!(Intrinsics.areEqual((Object)it.getNodeDir(), (Object)nodeData.getNodeDir()) ^ true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (NodeData)item$iv$iv;
                Collection collection = destination$iv$iv;
                Path path2 = it.getAdditionalNodeInfoDirectory();
                collection.add(path2);
            }
            for (Path destination : (List)destination$iv$iv) {
                Path fullDestinationPath;
                Path path3 = fullDestinationPath = destination.resolve(path.getFileName());
                Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"fullDestinationPath");
                this.atomicCopy(path, path3);
            }
        }
    }

    private final void atomicCopy(Path source, Path destination) {
        Path $i$a$1$debug;
        Logger $receiver$iv = log;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "" + '[' + this.scheduler.now() + "] Copying ... " + source + " -> " + destination;
            logger.debug(string);
        }
        try {
            $i$a$1$debug = Files.createTempFile(destination.getParent(), "", null, new FileAttribute[0]);
        }
        catch (IOException exception) {
            log.warn("Couldn't create a temporary file to copy " + source, (Throwable)exception);
            throw (Throwable)exception;
        }
        Path tempDestination = $i$a$1$debug;
        try {
            Path path = tempDestination;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"tempDestination");
            PathUtilsKt.copyTo((Path)source, (Path)path, (CopyOption[])new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING});
        }
        catch (IOException exception) {
            log.warn("Couldn't copy " + source + " to " + tempDestination + '.', (Throwable)exception);
            Path path = tempDestination;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"tempDestination");
            PathUtilsKt.delete((Path)path);
            throw (Throwable)exception;
        }
        try {
            PathUtilsKt.moveTo((Path)tempDestination, (Path)destination, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        catch (IOException exception) {
            log.warn("Couldn't move " + tempDestination + " to " + destination + '.', (Throwable)exception);
            PathUtilsKt.delete((Path)tempDestination);
            throw (Throwable)exception;
        }
    }

    public NodeInfoFilesCopier(@NotNull Scheduler scheduler) {
        ThreadBox threadBox;
        Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
        this.scheduler = scheduler;
        ThreadBox threadBox2 = threadBox;
        ThreadBox threadBox3 = threadBox;
        NodeInfoFilesCopier nodeInfoFilesCopier = this;
        Map map = new LinkedHashMap();
        threadBox2((Object)map, null, 2, null);
        nodeInfoFilesCopier.nodeDataMapBox = threadBox3;
        Subscription subscription = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)this.scheduler).subscribe((Action1)new Action1<Long>(){

            public final void call(Long it) {
                this.poll();
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)subscription, (String)"Observable.interval(1, T\u2026    .subscribe { poll() }");
        this.subscription = subscription;
    }

    public /* synthetic */ NodeInfoFilesCopier(Scheduler scheduler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Scheduler scheduler2 = Schedulers.io();
            Intrinsics.checkExpressionValueIsNotNull((Object)scheduler2, (String)"Schedulers.io()");
            scheduler = scheduler2;
        }
        this(scheduler);
    }

    public NodeInfoFilesCopier() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    public static final /* synthetic */ void access$processPath(NodeInfoFilesCopier $this, @NotNull NodeData nodeData, @NotNull Path path) {
        $this.processPath(nodeData, path);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lnet/corda/nodeapi/internal/network/NodeInfoFilesCopier$NodeData;", "", "nodeDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "additionalNodeInfoDirectory", "getAdditionalNodeInfoDirectory", "()Ljava/nio/file/Path;", "getNodeDir", "previouslySeenFiles", "", "Ljava/nio/file/attribute/FileTime;", "getPreviouslySeenFiles", "()Ljava/util/Map;", "node-api"})
    private static final class NodeData {
        @NotNull
        private final Path additionalNodeInfoDirectory;
        @NotNull
        private final Map<Path, FileTime> previouslySeenFiles;
        @NotNull
        private final Path nodeDir;

        @NotNull
        public final Path getAdditionalNodeInfoDirectory() {
            return this.additionalNodeInfoDirectory;
        }

        @NotNull
        public final Map<Path, FileTime> getPreviouslySeenFiles() {
            return this.previouslySeenFiles;
        }

        @NotNull
        public final Path getNodeDir() {
            return this.nodeDir;
        }

        public NodeData(@NotNull Path nodeDir) {
            Map map;
            Intrinsics.checkParameterIsNotNull((Object)nodeDir, (String)"nodeDir");
            this.nodeDir = nodeDir;
            Path path = this.nodeDir.resolve("additional-node-infos");
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"nodeDir.resolve(NODE_INFO_DIRECTORY)");
            this.additionalNodeInfoDirectory = path;
            NodeData nodeData = this;
            nodeData.previouslySeenFiles = map = (Map)new LinkedHashMap();
            PathUtilsKt.createDirectories((Path)this.additionalNodeInfoDirectory, (FileAttribute[])new FileAttribute[0]);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/corda/nodeapi/internal/network/NodeInfoFilesCopier$Companion;", "", "()V", "NODE_INFO_FILE_NAME_PREFIX", "", "log", "Lorg/slf4j/Logger;", "node-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

