/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.network;

import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.PathUtilsKt;
import net.corda.core.internal.SignedDataWithCert;
import net.corda.core.node.NetworkParameters;
import net.corda.core.serialization.SerializationAPIKt;
import net.corda.core.serialization.SerializedBytes;
import net.corda.nodeapi.internal.KeyStoreConfigHelpersKt;
import net.corda.nodeapi.internal.crypto.CertificateAndKeyPair;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lnet/corda/nodeapi/internal/network/NetworkParametersCopier;", "", "networkParameters", "Lnet/corda/core/node/NetworkParameters;", "signingCertAndKeyPair", "Lnet/corda/nodeapi/internal/crypto/CertificateAndKeyPair;", "overwriteFile", "", "update", "(Lnet/corda/core/node/NetworkParameters;Lnet/corda/nodeapi/internal/crypto/CertificateAndKeyPair;ZZ)V", "copyOptions", "", "Ljava/nio/file/StandardCopyOption;", "[Ljava/nio/file/StandardCopyOption;", "serialisedSignedNetParams", "Lnet/corda/core/serialization/SerializedBytes;", "Lnet/corda/core/internal/SignedDataWithCert;", "update$annotations", "()V", "getUpdate", "()Z", "install", "", "nodeDir", "Ljava/nio/file/Path;", "node-api"})
public final class NetworkParametersCopier {
    private final StandardCopyOption[] copyOptions;
    private final SerializedBytes<SignedDataWithCert<NetworkParameters>> serialisedSignedNetParams;
    private final boolean update;

    public final void install(@NotNull Path nodeDir) {
        Intrinsics.checkParameterIsNotNull((Object)nodeDir, (String)"nodeDir");
        String fileName = this.update ? "network-parameters-update" : "network-parameters";
        try {
            CopyOption[] copyOptionArray = this.copyOptions;
            InternalUtils.copyTo((InputStream)this.serialisedSignedNetParams.open(), (Path)PathUtilsKt.div((Path)nodeDir, (String)fileName), (CopyOption[])Arrays.copyOf(copyOptionArray, copyOptionArray.length));
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    public static /* synthetic */ void update$annotations() {
    }

    public final boolean getUpdate() {
        return this.update;
    }

    public NetworkParametersCopier(@NotNull NetworkParameters networkParameters, @NotNull CertificateAndKeyPair signingCertAndKeyPair, boolean overwriteFile, boolean update) {
        StandardCopyOption[] standardCopyOptionArray;
        Intrinsics.checkParameterIsNotNull((Object)networkParameters, (String)"networkParameters");
        Intrinsics.checkParameterIsNotNull((Object)signingCertAndKeyPair, (String)"signingCertAndKeyPair");
        this.update = update;
        NetworkParametersCopier networkParametersCopier = this;
        if (overwriteFile) {
            StandardCopyOption[] standardCopyOptionArray2 = new StandardCopyOption[1];
            standardCopyOptionArray = standardCopyOptionArray2;
            standardCopyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            NetworkParametersCopier networkParametersCopier2 = networkParametersCopier;
            StandardCopyOption[] standardCopyOptionArray3 = new StandardCopyOption[]{};
            networkParametersCopier = networkParametersCopier2;
            standardCopyOptionArray = standardCopyOptionArray3;
        }
        networkParametersCopier.copyOptions = standardCopyOptionArray;
        this.serialisedSignedNetParams = SerializationAPIKt.serialize$default(signingCertAndKeyPair.sign(networkParameters), null, null, (int)3, null);
    }

    public /* synthetic */ NetworkParametersCopier(NetworkParameters networkParameters, CertificateAndKeyPair certificateAndKeyPair, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            certificateAndKeyPair = KeyStoreConfigHelpersKt.createDevNetworkMapCa$default(null, 1, null);
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(networkParameters, certificateAndKeyPair, bl, bl2);
    }
}

