/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.network;

import com.typesafe.config.Config;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.corda.common.configuration.parsing.internal.Configuration;
import net.corda.common.configuration.parsing.internal.PropertyDelegate;
import net.corda.common.configuration.parsing.internal.UtilsKt;
import net.corda.common.validation.internal.Validated;
import net.corda.core.internal.CordaUtilsKt;
import net.corda.nodeapi.internal.crypto.KeyStoreUtilities;
import net.corda.nodeapi.internal.network.NetworkParameterOverridesSpec$$special$;
import net.corda.nodeapi.internal.network.NetworkParameterOverridesSpecKt;
import net.corda.nodeapi.internal.network.NetworkParametersOverrides;
import net.corda.nodeapi.internal.network.PackageOwner;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J&\u0010\u001a\u001a\u0018\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001c0\u001bj\b\u0012\u0004\u0012\u00020\f`\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0002J&\u0010\u001f\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001c0\u001bj\b\u0012\u0004\u0012\u00020\u0002`\u001d2\u0006\u0010 \u001a\u00020!H\u0014R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\n\u001a\u0004\b\r\u0010\bR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u0010\u0010\bR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0013\u0010\bR'\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\n\u001a\u0004\b\u0018\u0010\b\u00a8\u0006#"}, d2={"Lnet/corda/nodeapi/internal/network/NetworkParameterOverridesSpec;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Specification;", "Lnet/corda/nodeapi/internal/network/NetworkParametersOverrides;", "()V", "eventHorizon", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Optional;", "Ljava/time/Duration;", "getEventHorizon", "()Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Optional;", "eventHorizon$delegate", "Lkotlin/properties/ReadOnlyProperty;", "maxMessageSize", "", "getMaxMessageSize", "maxMessageSize$delegate", "maxTransactionSize", "getMaxTransactionSize", "maxTransactionSize$delegate", "minimumPlatformVersion", "getMinimumPlatformVersion", "minimumPlatformVersion$delegate", "packageOwnership", "", "Lnet/corda/nodeapi/internal/network/PackageOwner;", "getPackageOwnership", "packageOwnership$delegate", "parsePositiveInteger", "Lnet/corda/common/validation/internal/Validated;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "Lnet/corda/nodeapi/internal/network/Valid;", "rawValue", "parseValid", "configuration", "Lcom/typesafe/config/Config;", "PackageOwnershipSpec", "node-api"})
public final class NetworkParameterOverridesSpec
extends Configuration.Specification<NetworkParametersOverrides> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final ReadOnlyProperty minimumPlatformVersion$delegate;
    private static final ReadOnlyProperty maxMessageSize$delegate;
    private static final ReadOnlyProperty maxTransactionSize$delegate;
    private static final ReadOnlyProperty packageOwnership$delegate;
    private static final ReadOnlyProperty eventHorizon$delegate;
    public static final NetworkParameterOverridesSpec INSTANCE;

    static {
        PropertyDelegate.Standard $receiver$iv$iv;
        Object $receiver$iv;
        NetworkParameterOverridesSpec networkParameterOverridesSpec;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NetworkParameterOverridesSpec.class), "minimumPlatformVersion", "getMinimumPlatformVersion()Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Optional;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NetworkParameterOverridesSpec.class), "maxMessageSize", "getMaxMessageSize()Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Optional;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NetworkParameterOverridesSpec.class), "maxTransactionSize", "getMaxTransactionSize()Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Optional;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NetworkParameterOverridesSpec.class), "packageOwnership", "getPackageOwnership()Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Optional;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NetworkParameterOverridesSpec.class), "eventHorizon", "getEventHorizon()Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Optional;"))};
        INSTANCE = networkParameterOverridesSpec = new NetworkParameterOverridesSpec();
        PropertyDelegate.Standard standard = Configuration.Specification.int$default((Configuration.Specification)networkParameterOverridesSpec, null, (boolean)false, (int)3, null);
        Function1 convert$iv = (Function1)new Function1<Integer, Validated<Integer, Configuration.Validation.Error>>(INSTANCE){

            @NotNull
            public final Validated<Integer, Configuration.Validation.Error> invoke(int p1) {
                return NetworkParameterOverridesSpec.access$parsePositiveInteger((NetworkParameterOverridesSpec)((Object)this.receiver), p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(NetworkParameterOverridesSpec.class);
            }

            public final String getName() {
                return "parsePositiveInteger";
            }

            public final String getSignature() {
                return "parsePositiveInteger(I)Lnet/corda/common/validation/internal/Validated;";
            }
        };
        String string = Integer.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MAPPED::class.java.simpleName");
        minimumPlatformVersion$delegate = $receiver$iv.mapValid(string, convert$iv).optional().provideDelegate((Object)networkParameterOverridesSpec, $$delegatedProperties[0]);
        $receiver$iv = Configuration.Specification.int$default((Configuration.Specification)networkParameterOverridesSpec, null, (boolean)false, (int)3, null);
        convert$iv = (Function1)new Function1<Integer, Validated<Integer, Configuration.Validation.Error>>(INSTANCE){

            @NotNull
            public final Validated<Integer, Configuration.Validation.Error> invoke(int p1) {
                return NetworkParameterOverridesSpec.access$parsePositiveInteger((NetworkParameterOverridesSpec)((Object)this.receiver), p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(NetworkParameterOverridesSpec.class);
            }

            public final String getName() {
                return "parsePositiveInteger";
            }

            public final String getSignature() {
                return "parsePositiveInteger(I)Lnet/corda/common/validation/internal/Validated;";
            }
        };
        String string2 = Integer.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"MAPPED::class.java.simpleName");
        maxMessageSize$delegate = $receiver$iv.mapValid(string2, convert$iv).optional().provideDelegate((Object)networkParameterOverridesSpec, $$delegatedProperties[1]);
        $receiver$iv = Configuration.Specification.int$default((Configuration.Specification)networkParameterOverridesSpec, null, (boolean)false, (int)3, null);
        convert$iv = (Function1)new Function1<Integer, Validated<Integer, Configuration.Validation.Error>>(INSTANCE){

            @NotNull
            public final Validated<Integer, Configuration.Validation.Error> invoke(int p1) {
                return NetworkParameterOverridesSpec.access$parsePositiveInteger((NetworkParameterOverridesSpec)((Object)this.receiver), p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(NetworkParameterOverridesSpec.class);
            }

            public final String getName() {
                return "parsePositiveInteger";
            }

            public final String getSignature() {
                return "parsePositiveInteger(I)Lnet/corda/common/validation/internal/Validated;";
            }
        };
        String string3 = Integer.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"MAPPED::class.java.simpleName");
        maxTransactionSize$delegate = $receiver$iv.mapValid(string3, convert$iv).optional().provideDelegate((Object)networkParameterOverridesSpec, $$delegatedProperties[2]);
        $receiver$iv = networkParameterOverridesSpec;
        Configuration.Specification specification$iv = PackageOwnershipSpec.INSTANCE;
        String key$iv = null;
        boolean sensitive$iv = false;
        PropertyDelegate.Standard standard2 = $receiver$iv.nestedObject((Configuration.Schema)specification$iv, key$iv, sensitive$iv);
        Function1 convert$iv$iv = $special$$inlined$nested$1.INSTANCE;
        String string4 = Config.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"MAPPED::class.java.simpleName");
        $receiver$iv$iv = $receiver$iv$iv.map(string4, convert$iv$iv);
        convert$iv$iv = (Function1)new Function1<Config, Validated<PackageOwner, Configuration.Validation.Error>>(specification$iv){
            final /* synthetic */ Configuration.Specification $specification;
            {
                this.$specification = specification;
                super(1);
            }

            @NotNull
            public final Validated<PackageOwner, Configuration.Validation.Error> invoke(Config value) {
                Config config = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"value");
                return Configuration.Value.Parser.DefaultImpls.parse$default((Configuration.Value.Parser)this.$specification, (Config)config, null, (int)2, null);
            }
        };
        String string5 = PackageOwner.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"MAPPED::class.java.simpleName");
        packageOwnership$delegate = $receiver$iv$iv.mapValid(string5, convert$iv$iv).list().optional().provideDelegate((Object)networkParameterOverridesSpec, $$delegatedProperties[3]);
        eventHorizon$delegate = Configuration.Specification.duration$default((Configuration.Specification)networkParameterOverridesSpec, null, (boolean)false, (int)3, null).optional().provideDelegate((Object)networkParameterOverridesSpec, $$delegatedProperties[4]);
    }

    private final Configuration.Property.Definition.Optional<Integer> getMinimumPlatformVersion() {
        return (Configuration.Property.Definition.Optional)minimumPlatformVersion$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final Configuration.Property.Definition.Optional<Integer> getMaxMessageSize() {
        return (Configuration.Property.Definition.Optional)maxMessageSize$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final Configuration.Property.Definition.Optional<Integer> getMaxTransactionSize() {
        return (Configuration.Property.Definition.Optional)maxTransactionSize$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final Configuration.Property.Definition.Optional<List<PackageOwner>> getPackageOwnership() {
        return (Configuration.Property.Definition.Optional)packageOwnership$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    private final Configuration.Property.Definition.Optional<Duration> getEventHorizon() {
        return (Configuration.Property.Definition.Optional)eventHorizon$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Validated<NetworkParametersOverrides, Configuration.Validation.Error> parseValid(@NotNull Config configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        List packageOwnership = (List)UtilsKt.get((Config)configuration, (Configuration.Property.Definition)((Configuration.Property.Definition)this.getPackageOwnership()));
        if (packageOwnership != null) {
            Object[] objectArray;
            Collection collection;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)packageOwnership;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                PackageOwner packageOwner = (PackageOwner)item$iv$iv;
                collection = destination$iv$iv;
                objectArray = it.getJavaPackageName();
                collection.add(objectArray);
            }
            if (!CordaUtilsKt.noPackageOverlap((Collection)((List)destination$iv$iv))) {
                Object[] objectArray2;
                String string = null;
                String string2 = "packageOwnership";
                String string3 = "Package namespaces must not overlap";
                Configuration.Validation.Error.BadValue.Companion companion = Configuration.Validation.Error.BadValue.Companion;
                int n = 0;
                objectArray = objectArray2 = new Configuration.Validation.Error.BadValue[1];
                collection = Validated.Companion;
                List list2 = CollectionsKt.emptyList();
                objectArray2[n] = Configuration.Validation.Error.BadValue.Companion.of$default((Configuration.Validation.Error.BadValue.Companion)companion, (String)string3, (String)string2, string, (List)list2, (int)4, null);
                return (Validated)collection.invalid(SequencesKt.toSet((Sequence)SequencesKt.sequenceOf((Object[])objectArray)));
            }
        }
        return NetworkParameterOverridesSpecKt.valid(new NetworkParametersOverrides((Integer)UtilsKt.get((Config)configuration, (Configuration.Property.Definition)((Configuration.Property.Definition)this.getMinimumPlatformVersion())), (Integer)UtilsKt.get((Config)configuration, (Configuration.Property.Definition)((Configuration.Property.Definition)this.getMaxMessageSize())), (Integer)UtilsKt.get((Config)configuration, (Configuration.Property.Definition)((Configuration.Property.Definition)this.getMaxTransactionSize())), packageOwnership, (Duration)UtilsKt.get((Config)configuration, (Configuration.Property.Definition)((Configuration.Property.Definition)this.getEventHorizon()))));
    }

    private final Validated<Integer, Configuration.Validation.Error> parsePositiveInteger(int rawValue) {
        if (rawValue > 0) {
            return NetworkParameterOverridesSpecKt.valid(rawValue);
        }
        return NetworkParameterOverridesSpecKt.badValue("The value must be at least 1");
    }

    private NetworkParameterOverridesSpec() {
        super("DefaultNetworkParameters", null, 2, null);
    }

    @NotNull
    public static final /* synthetic */ Validated access$parsePositiveInteger(NetworkParameterOverridesSpec $this, int rawValue) {
        return $this.parsePositiveInteger(rawValue);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001b\u001a\u00020\fH\u0002R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\n\u001a\u0004\b\r\u0010\bR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u0010\u0010\bR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0013\u0010\b\u00a8\u0006\u001d"}, d2={"Lnet/corda/nodeapi/internal/network/NetworkParameterOverridesSpec$PackageOwnershipSpec;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Specification;", "Lnet/corda/nodeapi/internal/network/PackageOwner;", "()V", "keystore", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Standard;", "Ljava/nio/file/Path;", "getKeystore", "()Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Standard;", "keystore$delegate", "Lkotlin/properties/ReadOnlyProperty;", "keystoreAlias", "", "getKeystoreAlias", "keystoreAlias$delegate", "keystorePassword", "getKeystorePassword", "keystorePassword$delegate", "packageName", "getPackageName", "packageName$delegate", "parseValid", "Lnet/corda/common/validation/internal/Validated;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "configuration", "Lcom/typesafe/config/Config;", "toPackageName", "rawValue", "toPath", "node-api"})
    public static final class PackageOwnershipSpec
    extends Configuration.Specification<PackageOwner> {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        private static final ReadOnlyProperty packageName$delegate;
        private static final ReadOnlyProperty keystore$delegate;
        private static final ReadOnlyProperty keystorePassword$delegate;
        private static final ReadOnlyProperty keystoreAlias$delegate;
        public static final PackageOwnershipSpec INSTANCE;

        static {
            PropertyDelegate.Standard $receiver$iv;
            PackageOwnershipSpec packageOwnershipSpec;
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PackageOwnershipSpec.class), "packageName", "getPackageName()Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Standard;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PackageOwnershipSpec.class), "keystore", "getKeystore()Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Standard;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PackageOwnershipSpec.class), "keystorePassword", "getKeystorePassword()Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Standard;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PackageOwnershipSpec.class), "keystoreAlias", "getKeystoreAlias()Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Standard;"))};
            INSTANCE = packageOwnershipSpec = new PackageOwnershipSpec();
            PropertyDelegate.Standard standard = Configuration.Specification.string$default((Configuration.Specification)packageOwnershipSpec, null, (boolean)false, (int)3, null);
            Function1 convert$iv = (Function1)new Function1<String, Validated<String, Configuration.Validation.Error>>(INSTANCE){

                @NotNull
                public final Validated<String, Configuration.Validation.Error> invoke(@NotNull String p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return PackageOwnershipSpec.access$toPackageName((PackageOwnershipSpec)((Object)this.receiver), p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(PackageOwnershipSpec.class);
                }

                public final String getName() {
                    return "toPackageName";
                }

                public final String getSignature() {
                    return "toPackageName(Ljava/lang/String;)Lnet/corda/common/validation/internal/Validated;";
                }
            };
            String string = String.class.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MAPPED::class.java.simpleName");
            packageName$delegate = $receiver$iv.mapValid(string, convert$iv).provideDelegate((Object)packageOwnershipSpec, $$delegatedProperties[0]);
            $receiver$iv = Configuration.Specification.string$default((Configuration.Specification)packageOwnershipSpec, null, (boolean)false, (int)3, null);
            convert$iv = (Function1)new Function1<String, Validated<Path, Configuration.Validation.Error>>(INSTANCE){

                @NotNull
                public final Validated<Path, Configuration.Validation.Error> invoke(@NotNull String p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return PackageOwnershipSpec.access$toPath((PackageOwnershipSpec)((Object)this.receiver), p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(PackageOwnershipSpec.class);
                }

                public final String getName() {
                    return "toPath";
                }

                public final String getSignature() {
                    return "toPath(Ljava/lang/String;)Lnet/corda/common/validation/internal/Validated;";
                }
            };
            String string2 = Path.class.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"MAPPED::class.java.simpleName");
            keystore$delegate = $receiver$iv.mapValid(string2, convert$iv).provideDelegate((Object)packageOwnershipSpec, $$delegatedProperties[1]);
            keystorePassword$delegate = Configuration.Specification.string$default((Configuration.Specification)packageOwnershipSpec, null, (boolean)false, (int)3, null).provideDelegate((Object)packageOwnershipSpec, $$delegatedProperties[2]);
            keystoreAlias$delegate = Configuration.Specification.string$default((Configuration.Specification)packageOwnershipSpec, null, (boolean)false, (int)3, null).provideDelegate((Object)packageOwnershipSpec, $$delegatedProperties[3]);
        }

        private final Configuration.Property.Definition.Standard<String> getPackageName() {
            return (Configuration.Property.Definition.Standard)packageName$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final Configuration.Property.Definition.Standard<Path> getKeystore() {
            return (Configuration.Property.Definition.Standard)keystore$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        private final Configuration.Property.Definition.Standard<String> getKeystorePassword() {
            return (Configuration.Property.Definition.Standard)keystorePassword$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        private final Configuration.Property.Definition.Standard<String> getKeystoreAlias() {
            return (Configuration.Property.Definition.Standard)keystoreAlias$delegate.getValue((Object)this, $$delegatedProperties[3]);
        }

        @NotNull
        protected Validated<PackageOwner, Configuration.Validation.Error> parseValid(@NotNull Config configuration) {
            Validated validated;
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            Path suppliedKeystorePath = (Path)UtilsKt.get((Config)configuration, (Configuration.Property.Definition)((Configuration.Property.Definition)this.getKeystore()));
            String keystorePassword = (String)UtilsKt.get((Config)configuration, (Configuration.Property.Definition)((Configuration.Property.Definition)this.getKeystorePassword()));
            try {
                Object object;
                Path absoluteKeystorePath;
                String javaPackageName = (String)UtilsKt.get((Config)configuration, (Configuration.Property.Definition)((Configuration.Property.Definition)this.getPackageName()));
                Path path = absoluteKeystorePath = (suppliedKeystorePath.isAbsolute() ? suppliedKeystorePath : Paths.get(configuration.origin().filename(), new String[0]).resolveSibling(((Object)suppliedKeystorePath).toString())).toAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"absoluteKeystorePath");
                KeyStore ks = KeyStoreUtilities.loadKeyStore(path, keystorePassword);
                try {
                    PublicKey publicKey;
                    Certificate certificate = ks.getCertificate((String)UtilsKt.get((Config)configuration, (Configuration.Property.Definition)((Configuration.Property.Definition)this.getKeystoreAlias())));
                    Intrinsics.checkExpressionValueIsNotNull((Object)certificate, (String)"ks.getCertificate(configuration[keystoreAlias])");
                    PublicKey publicKey2 = publicKey = certificate.getPublicKey();
                    Intrinsics.checkExpressionValueIsNotNull((Object)publicKey2, (String)"publicKey");
                    object = NetworkParameterOverridesSpecKt.valid(new PackageOwner(javaPackageName, publicKey2));
                }
                catch (KeyStoreException kse) {
                    object = NetworkParameterOverridesSpecKt.badValue("Keystore has not been initialized for alias " + (String)UtilsKt.get((Config)configuration, (Configuration.Property.Definition)((Configuration.Property.Definition)this.getKeystoreAlias())) + '.');
                }
                return object;
            }
            catch (KeyStoreException kse) {
                validated = NetworkParameterOverridesSpecKt.badValue("Password is incorrect or the key store is damaged for keyStoreFilePath: " + suppliedKeystorePath + '.');
            }
            catch (IOException e) {
                validated = NetworkParameterOverridesSpecKt.badValue("Error reading the key store from the file for keyStoreFilePath: " + suppliedKeystorePath + ' ' + e.getMessage() + '.');
            }
            return validated;
        }

        private final Validated<String, Configuration.Validation.Error> toPackageName(String rawValue) {
            Validated<String, Configuration.Validation.Error> validated;
            try {
                CordaUtilsKt.requirePackageValid((String)rawValue);
                validated = NetworkParameterOverridesSpecKt.valid(rawValue);
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (string == null) {
                    string = e.toString();
                }
                return NetworkParameterOverridesSpecKt.badValue(string);
            }
            return validated;
        }

        private final Validated<Path, Configuration.Validation.Error> toPath(String rawValue) {
            Validated<Path, Configuration.Validation.Error> validated;
            try {
                Path path = Paths.get(rawValue, new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(rawValue)");
                validated = NetworkParameterOverridesSpecKt.valid(path);
            }
            catch (InvalidPathException e) {
                return NetworkParameterOverridesSpecKt.badValue("Path " + rawValue + " not found");
            }
            return validated;
        }

        private PackageOwnershipSpec() {
            super("PackageOwners", null, 2, null);
        }

        @NotNull
        public static final /* synthetic */ Validated access$toPackageName(PackageOwnershipSpec $this, @NotNull String rawValue) {
            return $this.toPackageName(rawValue);
        }

        @NotNull
        public static final /* synthetic */ Validated access$toPath(PackageOwnershipSpec $this, @NotNull String rawValue) {
            return $this.toPath(rawValue);
        }
    }
}

