/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.cryptoservice.bouncycastle;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.Crypto;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.crypto.SecureHashKt;
import net.corda.core.crypto.SignatureScheme;
import net.corda.core.crypto.internal.ProviderMapKt;
import net.corda.nodeapi.internal.config.CertificateStore;
import net.corda.nodeapi.internal.config.CertificateStoreSupplier;
import net.corda.nodeapi.internal.crypto.ContentSignerBuilder;
import net.corda.nodeapi.internal.crypto.X509KeyStore;
import net.corda.nodeapi.internal.crypto.X509Utilities;
import net.corda.nodeapi.internal.cryptoservice.CryptoService;
import net.corda.nodeapi.internal.cryptoservice.CryptoServiceException;
import net.corda.nodeapi.internal.cryptoservice.SupportedCryptoServices;
import org.bouncycastle.operator.ContentSigner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001dJ\"\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010\u0010H\u0016J \u0010%\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0010H\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lnet/corda/nodeapi/internal/cryptoservice/bouncycastle/BCCryptoService;", "Lnet/corda/nodeapi/internal/cryptoservice/CryptoService;", "legalName", "Ljavax/security/auth/x500/X500Principal;", "certificateStoreSupplier", "Lnet/corda/nodeapi/internal/config/CertificateStoreSupplier;", "(Ljavax/security/auth/x500/X500Principal;Lnet/corda/nodeapi/internal/config/CertificateStoreSupplier;)V", "certificateStore", "Lnet/corda/nodeapi/internal/config/CertificateStore;", "getCertificateStore", "()Lnet/corda/nodeapi/internal/config/CertificateStore;", "setCertificateStore", "(Lnet/corda/nodeapi/internal/config/CertificateStore;)V", "containsKey", "", "alias", "", "defaultIdentitySignatureScheme", "Lnet/corda/core/crypto/SignatureScheme;", "defaultTLSSignatureScheme", "generateKeyPair", "Ljava/security/PublicKey;", "scheme", "getPublicKey", "getSigner", "Lorg/bouncycastle/operator/ContentSigner;", "getType", "Lnet/corda/nodeapi/internal/cryptoservice/SupportedCryptoServices;", "importKey", "", "keyPair", "Ljava/security/KeyPair;", "resyncKeystore", "sign", "", "data", "signAlgorithm", "signWithAlgorithm", "node-api"})
public final class BCCryptoService
implements CryptoService {
    @NotNull
    private CertificateStore certificateStore;
    private final X500Principal legalName;
    private final CertificateStoreSupplier certificateStoreSupplier;

    @Override
    @NotNull
    public SupportedCryptoServices getType() {
        return SupportedCryptoServices.BC_SIMPLE;
    }

    @NotNull
    public final CertificateStore getCertificateStore() {
        return this.certificateStore;
    }

    public final void setCertificateStore(@NotNull CertificateStore certificateStore) {
        Intrinsics.checkParameterIsNotNull((Object)certificateStore, (String)"<set-?>");
        this.certificateStore = certificateStore;
    }

    @Override
    @NotNull
    public PublicKey generateKeyPair(@NotNull String alias, @NotNull SignatureScheme scheme) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
        try {
            KeyPair keyPair = Crypto.generateKeyPair((SignatureScheme)scheme);
            this.importKey(alias, keyPair);
            PublicKey publicKey = keyPair.getPublic();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.public");
            return publicKey;
        }
        catch (Exception e) {
            throw (Throwable)new CryptoServiceException("Cannot generate key for alias " + alias + " and signature scheme " + scheme.getSchemeCodeName() + " (id " + scheme.getSchemeNumberID() + ')', e);
        }
    }

    @Override
    public boolean containsKey(@NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        return this.certificateStore.contains(alias);
    }

    @Override
    @NotNull
    public PublicKey getPublicKey(@NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        try {
            return (PublicKey)this.certificateStore.query((Function1)new Function1<X509KeyStore, PublicKey>(alias){
                final /* synthetic */ String $alias;

                @NotNull
                public final PublicKey invoke(@NotNull X509KeyStore $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    return $receiver.getPublicKey(this.$alias);
                }
                {
                    this.$alias = string;
                    super(1);
                }
            });
        }
        catch (Exception e) {
            throw (Throwable)new CryptoServiceException("Cannot get public key for alias " + alias, e);
        }
    }

    @Override
    @NotNull
    public byte[] sign(@NotNull String alias, @NotNull byte[] data, @Nullable String signAlgorithm) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        try {
            String string = signAlgorithm;
            return string == null ? Crypto.doSign((PrivateKey)((PrivateKey)this.certificateStore.query((Function1)new Function1<X509KeyStore, PrivateKey>(this, alias){
                final /* synthetic */ BCCryptoService this$0;
                final /* synthetic */ String $alias;

                @NotNull
                public final PrivateKey invoke(@NotNull X509KeyStore $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    return $receiver.getPrivateKey(this.$alias, this.this$0.getCertificateStore().getEntryPassword());
                }
                {
                    this.this$0 = bCCryptoService;
                    this.$alias = string;
                    super(1);
                }
            })), (byte[])data) : this.signWithAlgorithm(alias, data, signAlgorithm);
        }
        catch (Exception e) {
            throw (Throwable)new CryptoServiceException("Cannot sign using the key with alias " + alias + ". SHA256 of data to be signed: " + SecureHashKt.sha256((byte[])data), e);
        }
    }

    private final byte[] signWithAlgorithm(String alias, byte[] data, String signAlgorithm) {
        PrivateKey privateKey2 = (PrivateKey)this.certificateStore.query((Function1)new Function1<X509KeyStore, PrivateKey>(this, alias){
            final /* synthetic */ BCCryptoService this$0;
            final /* synthetic */ String $alias;

            @NotNull
            public final PrivateKey invoke(@NotNull X509KeyStore $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                return $receiver.getPrivateKey(this.$alias, this.this$0.getCertificateStore().getEntryPassword());
            }
            {
                this.this$0 = bCCryptoService;
                this.$alias = string;
                super(1);
            }
        });
        Signature signature = Signature.getInstance(signAlgorithm, (Provider)ProviderMapKt.getCordaBouncyCastleProvider());
        signature.initSign(privateKey2, CryptoUtils.newSecureRandom());
        signature.update(data);
        byte[] byArray = signature.sign();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"signature.sign()");
        return byArray;
    }

    @Override
    @NotNull
    public ContentSigner getSigner(@NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        try {
            PrivateKey privateKey2 = (PrivateKey)this.certificateStore.query((Function1)new Function1<X509KeyStore, PrivateKey>(this, alias){
                final /* synthetic */ BCCryptoService this$0;
                final /* synthetic */ String $alias;

                @NotNull
                public final PrivateKey invoke(@NotNull X509KeyStore $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    return $receiver.getPrivateKey(this.$alias, this.this$0.getCertificateStore().getEntryPassword());
                }
                {
                    this.this$0 = bCCryptoService;
                    this.$alias = string;
                    super(1);
                }
            });
            SignatureScheme signatureScheme = Crypto.findSignatureScheme((PrivateKey)privateKey2);
            return ContentSignerBuilder.INSTANCE.build(signatureScheme, privateKey2, Crypto.findProvider((String)signatureScheme.getProviderName()), CryptoUtils.newSecureRandom());
        }
        catch (Exception e) {
            throw (Throwable)new CryptoServiceException("Cannot get Signer for key with alias " + alias, e);
        }
    }

    @Override
    @NotNull
    public SignatureScheme defaultIdentitySignatureScheme() {
        return X509Utilities.INSTANCE.getDEFAULT_IDENTITY_SIGNATURE_SCHEME();
    }

    @Override
    @NotNull
    public SignatureScheme defaultTLSSignatureScheme() {
        return X509Utilities.INSTANCE.getDEFAULT_TLS_SIGNATURE_SCHEME();
    }

    public final void resyncKeystore() {
        this.certificateStore = this.certificateStoreSupplier.get(true);
    }

    public final void importKey(@NotNull String alias, @NotNull KeyPair keyPair) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
        try {
            X509Certificate cert = X509Utilities.createSelfSignedCACertificate$default(this.legalName, keyPair, null, 4, null);
            this.certificateStore.query((Function1)new Function1<X509KeyStore, Unit>(this, alias, keyPair, cert){
                final /* synthetic */ BCCryptoService this$0;
                final /* synthetic */ String $alias;
                final /* synthetic */ KeyPair $keyPair;
                final /* synthetic */ X509Certificate $cert;

                public final void invoke(@NotNull X509KeyStore $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    PrivateKey privateKey2 = this.$keyPair.getPrivate();
                    Intrinsics.checkExpressionValueIsNotNull((Object)privateKey2, (String)"keyPair.private");
                    $receiver.setPrivateKey(this.$alias, privateKey2, CollectionsKt.listOf((Object)this.$cert), this.this$0.getCertificateStore().getEntryPassword());
                }
                {
                    this.this$0 = bCCryptoService;
                    this.$alias = string;
                    this.$keyPair = keyPair;
                    this.$cert = x509Certificate;
                    super(1);
                }
            });
        }
        catch (Exception e) {
            throw (Throwable)new CryptoServiceException("Cannot import key with alias " + alias, e);
        }
    }

    public BCCryptoService(@NotNull X500Principal legalName, @NotNull CertificateStoreSupplier certificateStoreSupplier) {
        Intrinsics.checkParameterIsNotNull((Object)legalName, (String)"legalName");
        Intrinsics.checkParameterIsNotNull((Object)certificateStoreSupplier, (String)"certificateStoreSupplier");
        this.legalName = legalName;
        this.certificateStoreSupplier = certificateStoreSupplier;
        this.certificateStore = this.certificateStoreSupplier.get(true);
    }
}

