/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.cryptoservice;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.identity.CordaX500Name;
import net.corda.nodeapi.internal.config.FileBasedCertificateStoreSupplier;
import net.corda.nodeapi.internal.cryptoservice.CryptoService;
import net.corda.nodeapi.internal.cryptoservice.SupportedCryptoServices;
import net.corda.nodeapi.internal.cryptoservice.bouncycastle.BCCryptoService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lnet/corda/nodeapi/internal/cryptoservice/CryptoServiceFactory;", "", "()V", "Companion", "node-api"})
public final class CryptoServiceFactory {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"Lnet/corda/nodeapi/internal/cryptoservice/CryptoServiceFactory$Companion;", "", "()V", "makeCryptoService", "Lnet/corda/nodeapi/internal/cryptoservice/CryptoService;", "cryptoServiceName", "Lnet/corda/nodeapi/internal/cryptoservice/SupportedCryptoServices;", "legalName", "Lnet/corda/core/identity/CordaX500Name;", "signingCertificateStore", "Lnet/corda/nodeapi/internal/config/FileBasedCertificateStoreSupplier;", "node-api"})
    public static final class Companion {
        @NotNull
        public final CryptoService makeCryptoService(@NotNull SupportedCryptoServices cryptoServiceName, @NotNull CordaX500Name legalName, @Nullable FileBasedCertificateStoreSupplier signingCertificateStore) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)cryptoServiceName), (String)"cryptoServiceName");
            Intrinsics.checkParameterIsNotNull((Object)legalName, (String)"legalName");
            if (cryptoServiceName != SupportedCryptoServices.BC_SIMPLE || signingCertificateStore == null) {
                throw (Throwable)new IllegalArgumentException("Currently only BouncyCastle is used as a crypto service. A valid signing certificate store is required.");
            }
            return new BCCryptoService(legalName.getX500Principal(), signingCertificateStore);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CryptoService makeCryptoService$default(Companion companion, SupportedCryptoServices supportedCryptoServices, CordaX500Name cordaX500Name, FileBasedCertificateStoreSupplier fileBasedCertificateStoreSupplier, int n, Object object) {
            if ((n & 4) != 0) {
                fileBasedCertificateStoreSupplier = null;
            }
            return companion.makeCryptoService(supportedCryptoServices, cordaX500Name, fileBasedCertificateStoreSupplier);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

