/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.crypto;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.Crypto;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.crypto.SignatureScheme;
import net.corda.core.internal.CertRole;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.PathUtilsKt;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.nodeapi.internal.crypto.CertificateType;
import net.corda.nodeapi.internal.crypto.ContentSignerBuilder;
import net.corda.nodeapi.internal.crypto.X509CertificateFactory;
import net.corda.nodeapi.internal.crypto.X509UtilitiesKt;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u001c\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!J\u001f\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0#\"\u00020\u001f\u00a2\u0006\u0002\u0010$J\u0014\u0010\u001c\u001a\u00020\u001d2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0!Jj\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0014\b\u0002\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f2\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007Jf\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'2\u0006\u00102\u001a\u00020,2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u0002030\u000f2\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bJn\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'2\u0006\u00102\u001a\u00020,2\u0006\u00104\u001a\u00020.2\u0006\u00105\u001a\u0002062\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u0002030\u000f2\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ(\u00107\u001a\u0002082\u0006\u0010+\u001a\u00020,2\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020*2\b\b\u0002\u0010;\u001a\u00020<J0\u00107\u001a\u0002082\u0006\u0010+\u001a\u00020,2\u0006\u00109\u001a\u00020\u00042\u0006\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u0002062\b\b\u0002\u0010;\u001a\u00020<Jf\u0010?\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u00102\u001a\u00020,2\u0006\u00104\u001a\u00020.2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u0002030\u000f2\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ.\u0010@\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,2\u0006\u0010:\u001a\u00020*2\u0014\b\u0002\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J.\u0010A\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u0002030\u000f2\u0006\u0010B\u001a\u00020\u00102\u0006\u0010C\u001a\u00020\u00102\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010E\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020GH\u0007J\u001a\u0010H\u001a\u0002032\u0006\u0010\u001e\u001a\u00020I2\b\u0010J\u001a\u0004\u0018\u000103H\u0002J\u001a\u0010K\u001a\u0002032\u0006\u0010\u001e\u001a\u00020I2\b\u0010J\u001a\u0004\u0018\u000103H\u0002J\u0018\u0010L\u001a\u00020\u00162\u0006\u0010M\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020GH\u0007J\u0016\u0010N\u001a\u00020\u00162\u0006\u0010O\u001a\u00020\u001f2\u0006\u0010P\u001a\u00020\u001dJ'\u0010Q\u001a\u00020\u00162\u0006\u0010O\u001a\u00020\u001f2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0#\"\u00020\u001f\u00a2\u0006\u0002\u0010RJ\u001c\u0010Q\u001a\u00020\u00162\u0006\u0010O\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lnet/corda/nodeapi/internal/crypto/X509Utilities;", "", "()V", "CORDA_CLIENT_CA", "", "CORDA_CLIENT_TLS", "CORDA_INTERMEDIATE_CA", "CORDA_ROOT_CA", "DEFAULT_IDENTITY_SIGNATURE_SCHEME", "Lnet/corda/core/crypto/SignatureScheme;", "getDEFAULT_IDENTITY_SIGNATURE_SCHEME", "()Lnet/corda/core/crypto/SignatureScheme;", "DEFAULT_TLS_SIGNATURE_SCHEME", "getDEFAULT_TLS_SIGNATURE_SCHEME", "DEFAULT_VALIDITY_WINDOW", "Lkotlin/Pair;", "Ljava/time/Duration;", "getDEFAULT_VALIDITY_WINDOW", "()Lkotlin/Pair;", "DISTRIBUTED_NOTARY_ALIAS_PREFIX", "NODE_IDENTITY_ALIAS_PREFIX", "addCrlInfo", "", "builder", "Lorg/bouncycastle/cert/X509v3CertificateBuilder;", "crlDistPoint", "crlIssuer", "Lorg/bouncycastle/asn1/x500/X500Name;", "buildCertPath", "Ljava/security/cert/CertPath;", "first", "Ljava/security/cert/X509Certificate;", "remaining", "", "certificates", "", "([Ljava/security/cert/X509Certificate;)Ljava/security/cert/CertPath;", "createCertificate", "certificateType", "Lnet/corda/nodeapi/internal/crypto/CertificateType;", "issuerCertificate", "issuerKeyPair", "Ljava/security/KeyPair;", "subject", "Ljavax/security/auth/x500/X500Principal;", "subjectPublicKey", "Ljava/security/PublicKey;", "validityWindow", "nameConstraints", "Lorg/bouncycastle/asn1/x509/NameConstraints;", "issuer", "Ljava/util/Date;", "issuerPublicKey", "issuerSigner", "Lorg/bouncycastle/operator/ContentSigner;", "createCertificateSigningRequest", "Lorg/bouncycastle/pkcs/PKCS10CertificationRequest;", "email", "keyPair", "certRole", "Lnet/corda/core/internal/CertRole;", "publicKey", "contentSigner", "createPartialCertificate", "createSelfSignedCACertificate", "getCertificateValidityWindow", "before", "after", "parent", "loadCertificateFromPEMFile", "file", "Ljava/nio/file/Path;", "max", "Ljava/time/Instant;", "second", "min", "saveCertificateAsPEMFile", "certificate", "validateCertPath", "trustedRoot", "certPath", "validateCertificateChain", "(Ljava/security/cert/X509Certificate;[Ljava/security/cert/X509Certificate;)V", "node-api"})
public final class X509Utilities {
    @NotNull
    private static final SignatureScheme DEFAULT_IDENTITY_SIGNATURE_SCHEME;
    @NotNull
    private static final SignatureScheme DEFAULT_TLS_SIGNATURE_SCHEME;
    @NotNull
    public static final String CORDA_ROOT_CA = "cordarootca";
    @NotNull
    public static final String CORDA_INTERMEDIATE_CA = "cordaintermediateca";
    @NotNull
    public static final String CORDA_CLIENT_TLS = "cordaclienttls";
    @NotNull
    public static final String CORDA_CLIENT_CA = "cordaclientca";
    @NotNull
    public static final String NODE_IDENTITY_ALIAS_PREFIX = "identity";
    @NotNull
    public static final String DISTRIBUTED_NOTARY_ALIAS_PREFIX = "distributed-notary";
    @NotNull
    private static final Pair<Duration, Duration> DEFAULT_VALIDITY_WINDOW;
    public static final X509Utilities INSTANCE;

    @NotNull
    public final SignatureScheme getDEFAULT_IDENTITY_SIGNATURE_SCHEME() {
        return DEFAULT_IDENTITY_SIGNATURE_SCHEME;
    }

    @NotNull
    public final SignatureScheme getDEFAULT_TLS_SIGNATURE_SCHEME() {
        return DEFAULT_TLS_SIGNATURE_SCHEME;
    }

    @NotNull
    public final Pair<Duration, Duration> getDEFAULT_VALIDITY_WINDOW() {
        return DEFAULT_VALIDITY_WINDOW;
    }

    private final Date max(Instant first, Date second) {
        return second != null && second.getTime() > first.toEpochMilli() ? second : new Date(first.toEpochMilli());
    }

    private final Date min(Instant first, Date second) {
        return second != null && second.getTime() < first.toEpochMilli() ? second : new Date(first.toEpochMilli());
    }

    @NotNull
    public final Pair<Date, Date> getCertificateValidityWindow(@NotNull Duration before, @NotNull Duration after, @Nullable X509Certificate parent) {
        Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
        Intrinsics.checkParameterIsNotNull((Object)after, (String)"after");
        Instant startOfDayUTC = Instant.now().truncatedTo(ChronoUnit.DAYS);
        Instant instant = startOfDayUTC.minus(before);
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"startOfDayUTC - before");
        X509Certificate x509Certificate = parent;
        Date notBefore = this.max(instant, x509Certificate != null ? x509Certificate.getNotBefore() : null);
        Instant instant2 = startOfDayUTC.plus(after);
        Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"startOfDayUTC + after");
        X509Certificate x509Certificate2 = parent;
        Date notAfter = this.min(instant2, x509Certificate2 != null ? x509Certificate2.getNotAfter() : null);
        return new Pair((Object)notBefore, (Object)notAfter);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Pair getCertificateValidityWindow$default(X509Utilities x509Utilities, Duration duration, Duration duration2, X509Certificate x509Certificate, int n, Object object) {
        if ((n & 4) != 0) {
            x509Certificate = null;
        }
        return x509Utilities.getCertificateValidityWindow(duration, duration2, x509Certificate);
    }

    @JvmStatic
    @NotNull
    public static final X509Certificate createSelfSignedCACertificate(@NotNull X500Principal subject, @NotNull KeyPair keyPair, @NotNull Pair<Duration, Duration> validityWindow) {
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
        Intrinsics.checkParameterIsNotNull(validityWindow, (String)"validityWindow");
        Pair window = X509Utilities.getCertificateValidityWindow$default(INSTANCE, (Duration)validityWindow.getFirst(), (Duration)validityWindow.getSecond(), null, 4, null);
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.public");
        return X509Utilities.createCertificate$default(INSTANCE, CertificateType.ROOT_CA, subject, keyPair, subject, publicKey, window, null, null, null, 448, null);
    }

    @JvmStatic
    @NotNull
    public static /* bridge */ /* synthetic */ X509Certificate createSelfSignedCACertificate$default(X500Principal x500Principal, KeyPair keyPair, Pair pair, int n, Object object) {
        if ((n & 4) != 0) {
            pair = DEFAULT_VALIDITY_WINDOW;
        }
        return X509Utilities.createSelfSignedCACertificate(x500Principal, keyPair, pair);
    }

    public final void validateCertificateChain(@NotNull X509Certificate trustedRoot, X509Certificate ... certificates) {
        Intrinsics.checkParameterIsNotNull((Object)trustedRoot, (String)"trustedRoot");
        Intrinsics.checkParameterIsNotNull((Object)certificates, (String)"certificates");
        this.validateCertificateChain(trustedRoot, ArraysKt.asList((Object[])certificates));
    }

    public final void validateCertificateChain(@NotNull X509Certificate trustedRoot, @NotNull List<? extends X509Certificate> certificates) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)trustedRoot, (String)"trustedRoot");
        Intrinsics.checkParameterIsNotNull(certificates, (String)"certificates");
        Collection collection = certificates;
        boolean bl2 = bl = !collection.isEmpty();
        if (!bl) {
            String string = "Certificate path must contain at least one certificate";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.validateCertPath(trustedRoot, this.buildCertPath(certificates));
    }

    public final void validateCertPath(@NotNull X509Certificate trustedRoot, @NotNull CertPath certPath) {
        Intrinsics.checkParameterIsNotNull((Object)trustedRoot, (String)"trustedRoot");
        Intrinsics.checkParameterIsNotNull((Object)certPath, (String)"certPath");
        InternalUtils.validate$default((CertPath)certPath, (TrustAnchor)new TrustAnchor(trustedRoot, null), (boolean)false, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void saveCertificateAsPEMFile(@NotNull X509Certificate certificate, @NotNull Path file) {
        Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Closeable closeable = (Closeable)new JcaPEMWriter((Writer)PathUtilsKt.writer$default((Path)file, null, (OpenOption[])new OpenOption[0], (int)1, null));
        Throwable throwable = null;
        try {
            JcaPEMWriter it = (JcaPEMWriter)closeable;
            it.writeObject((Object)certificate);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final X509Certificate loadCertificateFromPEMFile(@NotNull Path file) {
        X509Certificate x509Certificate;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Closeable closeable = PathUtilsKt.reader$default((Path)file, null, (int)1, null);
        Throwable throwable = null;
        try {
            X509CertificateHolder x509CertificateHolder;
            PemObject pemObject;
            BufferedReader it = (BufferedReader)closeable;
            PemObject pemObject2 = pemObject = new PemReader((Reader)it).readPemObject();
            Intrinsics.checkExpressionValueIsNotNull((Object)pemObject2, (String)"pemObject");
            X509CertificateHolder $receiver = x509CertificateHolder = new X509CertificateHolder(pemObject2.getContent());
            $receiver.isValidOn(new Date());
            x509Certificate = X509UtilitiesKt.toJca($receiver);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return x509Certificate;
    }

    @NotNull
    public final X509v3CertificateBuilder createPartialCertificate(@NotNull CertificateType certificateType, @NotNull X500Principal issuer, @NotNull PublicKey issuerPublicKey, @NotNull X500Principal subject, @NotNull PublicKey subjectPublicKey, @NotNull Pair<? extends Date, ? extends Date> validityWindow, @Nullable NameConstraints nameConstraints, @Nullable String crlDistPoint, @Nullable X500Name crlIssuer) {
        DERSequence dERSequence;
        Intrinsics.checkParameterIsNotNull((Object)((Object)certificateType), (String)"certificateType");
        Intrinsics.checkParameterIsNotNull((Object)issuer, (String)"issuer");
        Intrinsics.checkParameterIsNotNull((Object)issuerPublicKey, (String)"issuerPublicKey");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)subjectPublicKey, (String)"subjectPublicKey");
        Intrinsics.checkParameterIsNotNull(validityWindow, (String)"validityWindow");
        BigInteger serial = BigInteger.valueOf(CryptoUtils.random63BitValue());
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        DERSequence dERSequence2 = dERSequence;
        DERSequence dERSequence3 = dERSequence;
        ASN1EncodableVector $receiver = aSN1EncodableVector;
        KeyPurposeId[] $receiver$iv = certificateType.getPurposes();
        int n = $receiver$iv.length;
        for (int j = 0; j < n; ++j) {
            KeyPurposeId element$iv;
            KeyPurposeId it = element$iv = $receiver$iv[j];
            $receiver.add((ASN1Encodable)it);
        }
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        dERSequence2(aSN1EncodableVector2);
        DERSequence keyPurposes = dERSequence3;
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)ASN1Sequence.getInstance((Object)subjectPublicKey.getEncoded()));
        CertRole role = certificateType.getRole();
        X509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, (Date)validityWindow.getFirst(), (Date)validityWindow.getSecond(), subject, subjectPublicKey).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new BcX509ExtensionUtils().createSubjectKeyIdentifier(subjectPublicKeyInfo)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(certificateType.isCA())).addExtension(Extension.keyUsage, false, (ASN1Encodable)certificateType.getKeyUsage()).addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)keyPurposes).addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createAuthorityKeyIdentifier(issuerPublicKey));
        if (role != null) {
            builder.addExtension(new ASN1ObjectIdentifier("1.3.6.1.4.1.50530.1.1"), false, (ASN1Encodable)role);
        }
        X509v3CertificateBuilder x509v3CertificateBuilder = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)x509v3CertificateBuilder, (String)"builder");
        this.addCrlInfo(x509v3CertificateBuilder, crlDistPoint, crlIssuer);
        if (nameConstraints != null) {
            builder.addExtension(Extension.nameConstraints, true, (ASN1Encodable)nameConstraints);
        }
        return builder;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ X509v3CertificateBuilder createPartialCertificate$default(X509Utilities x509Utilities, CertificateType certificateType, X500Principal x500Principal, PublicKey publicKey, X500Principal x500Principal2, PublicKey publicKey2, Pair pair, NameConstraints nameConstraints, String string, X500Name x500Name, int n, Object object) {
        if ((n & 0x40) != 0) {
            nameConstraints = null;
        }
        if ((n & 0x80) != 0) {
            string = null;
        }
        if ((n & 0x100) != 0) {
            x500Name = null;
        }
        return x509Utilities.createPartialCertificate(certificateType, x500Principal, publicKey, x500Principal2, publicKey2, (Pair<? extends Date, ? extends Date>)pair, nameConstraints, string, x500Name);
    }

    @JvmStatic
    @NotNull
    public static final X509Certificate createCertificate(@NotNull CertificateType certificateType, @NotNull X509Certificate issuerCertificate, @NotNull KeyPair issuerKeyPair, @NotNull X500Principal subject, @NotNull PublicKey subjectPublicKey, @NotNull Pair<Duration, Duration> validityWindow, @Nullable NameConstraints nameConstraints, @Nullable String crlDistPoint, @Nullable X500Name crlIssuer) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)certificateType), (String)"certificateType");
        Intrinsics.checkParameterIsNotNull((Object)issuerCertificate, (String)"issuerCertificate");
        Intrinsics.checkParameterIsNotNull((Object)issuerKeyPair, (String)"issuerKeyPair");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)subjectPublicKey, (String)"subjectPublicKey");
        Intrinsics.checkParameterIsNotNull(validityWindow, (String)"validityWindow");
        Pair<Date, Date> window = INSTANCE.getCertificateValidityWindow((Duration)validityWindow.getFirst(), (Duration)validityWindow.getSecond(), issuerCertificate);
        X500Principal x500Principal = issuerCertificate.getSubjectX500Principal();
        Intrinsics.checkExpressionValueIsNotNull((Object)x500Principal, (String)"issuerCertificate.subjectX500Principal");
        return INSTANCE.createCertificate(certificateType, x500Principal, issuerKeyPair, subject, subjectPublicKey, window, nameConstraints, crlDistPoint, crlIssuer);
    }

    @JvmStatic
    @NotNull
    public static /* bridge */ /* synthetic */ X509Certificate createCertificate$default(CertificateType certificateType, X509Certificate x509Certificate, KeyPair keyPair, X500Principal x500Principal, PublicKey publicKey, Pair pair, NameConstraints nameConstraints, String string, X500Name x500Name, int n, Object object) {
        if ((n & 0x20) != 0) {
            pair = DEFAULT_VALIDITY_WINDOW;
        }
        if ((n & 0x40) != 0) {
            nameConstraints = null;
        }
        if ((n & 0x80) != 0) {
            string = null;
        }
        if ((n & 0x100) != 0) {
            x500Name = null;
        }
        return X509Utilities.createCertificate(certificateType, x509Certificate, keyPair, x500Principal, publicKey, pair, nameConstraints, string, x500Name);
    }

    @NotNull
    public final X509Certificate createCertificate(@NotNull CertificateType certificateType, @NotNull X500Principal issuer, @NotNull PublicKey issuerPublicKey, @NotNull ContentSigner issuerSigner, @NotNull X500Principal subject, @NotNull PublicKey subjectPublicKey, @NotNull Pair<? extends Date, ? extends Date> validityWindow, @Nullable NameConstraints nameConstraints, @Nullable String crlDistPoint, @Nullable X500Name crlIssuer) {
        X509CertificateHolder x509CertificateHolder;
        Intrinsics.checkParameterIsNotNull((Object)((Object)certificateType), (String)"certificateType");
        Intrinsics.checkParameterIsNotNull((Object)issuer, (String)"issuer");
        Intrinsics.checkParameterIsNotNull((Object)issuerPublicKey, (String)"issuerPublicKey");
        Intrinsics.checkParameterIsNotNull((Object)issuerSigner, (String)"issuerSigner");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)subjectPublicKey, (String)"subjectPublicKey");
        Intrinsics.checkParameterIsNotNull(validityWindow, (String)"validityWindow");
        X509v3CertificateBuilder builder = this.createPartialCertificate(certificateType, issuer, issuerPublicKey, subject, subjectPublicKey, validityWindow, nameConstraints, crlDistPoint, crlIssuer);
        X509CertificateHolder $receiver = x509CertificateHolder = builder.build(issuerSigner);
        boolean bl = $receiver.isValidOn(new Date());
        if (!bl) {
            String string = "Certificate is not valid at instant now";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return X509UtilitiesKt.toJca($receiver);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ X509Certificate createCertificate$default(X509Utilities x509Utilities, CertificateType certificateType, X500Principal x500Principal, PublicKey publicKey, ContentSigner contentSigner, X500Principal x500Principal2, PublicKey publicKey2, Pair pair, NameConstraints nameConstraints, String string, X500Name x500Name, int n, Object object) {
        if ((n & 0x80) != 0) {
            nameConstraints = null;
        }
        if ((n & 0x100) != 0) {
            string = null;
        }
        if ((n & 0x200) != 0) {
            x500Name = null;
        }
        return x509Utilities.createCertificate(certificateType, x500Principal, publicKey, contentSigner, x500Principal2, publicKey2, (Pair<? extends Date, ? extends Date>)pair, nameConstraints, string, x500Name);
    }

    @NotNull
    public final X509Certificate createCertificate(@NotNull CertificateType certificateType, @NotNull X500Principal issuer, @NotNull KeyPair issuerKeyPair, @NotNull X500Principal subject, @NotNull PublicKey subjectPublicKey, @NotNull Pair<? extends Date, ? extends Date> validityWindow, @Nullable NameConstraints nameConstraints, @Nullable String crlDistPoint, @Nullable X500Name crlIssuer) {
        X509CertificateHolder x509CertificateHolder;
        Intrinsics.checkParameterIsNotNull((Object)((Object)certificateType), (String)"certificateType");
        Intrinsics.checkParameterIsNotNull((Object)issuer, (String)"issuer");
        Intrinsics.checkParameterIsNotNull((Object)issuerKeyPair, (String)"issuerKeyPair");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)subjectPublicKey, (String)"subjectPublicKey");
        Intrinsics.checkParameterIsNotNull(validityWindow, (String)"validityWindow");
        PrivateKey privateKey2 = issuerKeyPair.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey2, (String)"issuerKeyPair.private");
        SignatureScheme signatureScheme = Crypto.findSignatureScheme((PrivateKey)privateKey2);
        Provider provider = Crypto.findProvider((String)signatureScheme.getProviderName());
        PrivateKey privateKey3 = issuerKeyPair.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey3, (String)"issuerKeyPair.private");
        ContentSigner signer = ContentSignerBuilder.build$default(ContentSignerBuilder.INSTANCE, signatureScheme, privateKey3, provider, null, 8, null);
        PublicKey publicKey = issuerKeyPair.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"issuerKeyPair.public");
        X509v3CertificateBuilder builder = this.createPartialCertificate(certificateType, issuer, publicKey, subject, subjectPublicKey, validityWindow, nameConstraints, crlDistPoint, crlIssuer);
        X509CertificateHolder $receiver = x509CertificateHolder = builder.build(signer);
        boolean bl = $receiver.isValidOn(new Date());
        if (!bl) {
            String string = "Certificate is not valid at instant now";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = $receiver.isSignatureValid(new JcaContentVerifierProviderBuilder().build(issuerKeyPair.getPublic()));
        if (!bl) {
            String string = "Invalid signature";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return X509UtilitiesKt.toJca($receiver);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ X509Certificate createCertificate$default(X509Utilities x509Utilities, CertificateType certificateType, X500Principal x500Principal, KeyPair keyPair, X500Principal x500Principal2, PublicKey publicKey, Pair pair, NameConstraints nameConstraints, String string, X500Name x500Name, int n, Object object) {
        if ((n & 0x40) != 0) {
            nameConstraints = null;
        }
        if ((n & 0x80) != 0) {
            string = null;
        }
        if ((n & 0x100) != 0) {
            x500Name = null;
        }
        return x509Utilities.createCertificate(certificateType, x500Principal, keyPair, x500Principal2, publicKey, (Pair<? extends Date, ? extends Date>)pair, nameConstraints, string, x500Name);
    }

    @NotNull
    public final PKCS10CertificationRequest createCertificateSigningRequest(@NotNull X500Principal subject, @NotNull String email, @NotNull PublicKey publicKey, @NotNull ContentSigner contentSigner, @NotNull CertRole certRole) {
        PKCS10CertificationRequest pKCS10CertificationRequest;
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        Intrinsics.checkParameterIsNotNull((Object)contentSigner, (String)"contentSigner");
        Intrinsics.checkParameterIsNotNull((Object)certRole, (String)"certRole");
        PKCS10CertificationRequest $receiver = pKCS10CertificationRequest = new JcaPKCS10CertificationRequestBuilder(subject, publicKey).addAttribute(BCStyle.E, (ASN1Encodable)new DERUTF8String(email)).addAttribute(new ASN1ObjectIdentifier("1.3.6.1.4.1.50530.1.1"), (ASN1Encodable)certRole).build(contentSigner);
        if (!X509UtilitiesKt.isSignatureValid($receiver)) {
            throw (Throwable)new SignatureException("The certificate signing request signature validation failed.");
        }
        PKCS10CertificationRequest pKCS10CertificationRequest2 = pKCS10CertificationRequest;
        Intrinsics.checkExpressionValueIsNotNull((Object)pKCS10CertificationRequest2, (String)"JcaPKCS10CertificationRe\u2026      }\n                }");
        return pKCS10CertificationRequest2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ PKCS10CertificationRequest createCertificateSigningRequest$default(X509Utilities x509Utilities, X500Principal x500Principal, String string, PublicKey publicKey, ContentSigner contentSigner, CertRole certRole, int n, Object object) {
        if ((n & 0x10) != 0) {
            certRole = CertRole.NODE_CA;
        }
        return x509Utilities.createCertificateSigningRequest(x500Principal, string, publicKey, contentSigner, certRole);
    }

    @NotNull
    public final PKCS10CertificationRequest createCertificateSigningRequest(@NotNull X500Principal subject, @NotNull String email, @NotNull KeyPair keyPair, @NotNull CertRole certRole) {
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
        Intrinsics.checkParameterIsNotNull((Object)certRole, (String)"certRole");
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.public");
        SignatureScheme signatureScheme = Crypto.findSignatureScheme((PublicKey)publicKey);
        PrivateKey privateKey2 = keyPair.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey2, (String)"keyPair.private");
        ContentSigner signer = ContentSignerBuilder.build$default(ContentSignerBuilder.INSTANCE, signatureScheme, privateKey2, Crypto.findProvider((String)signatureScheme.getProviderName()), null, 8, null);
        PublicKey publicKey2 = keyPair.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey2, (String)"keyPair.public");
        return this.createCertificateSigningRequest(subject, email, publicKey2, signer, certRole);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ PKCS10CertificationRequest createCertificateSigningRequest$default(X509Utilities x509Utilities, X500Principal x500Principal, String string, KeyPair keyPair, CertRole certRole, int n, Object object) {
        if ((n & 8) != 0) {
            certRole = CertRole.NODE_CA;
        }
        return x509Utilities.createCertificateSigningRequest(x500Principal, string, keyPair, certRole);
    }

    @NotNull
    public final CertPath buildCertPath(@NotNull X509Certificate first, @NotNull List<? extends X509Certificate> remaining) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull(remaining, (String)"remaining");
        ArrayList certificates = new ArrayList(1 + remaining.size());
        Collection collection = certificates;
        collection.add(first);
        collection = certificates;
        CollectionsKt.addAll((Collection)collection, (Iterable)remaining);
        return this.buildCertPath(certificates);
    }

    @NotNull
    public final CertPath buildCertPath(X509Certificate ... certificates) {
        Intrinsics.checkParameterIsNotNull((Object)certificates, (String)"certificates");
        return new X509CertificateFactory().generateCertPath(Arrays.copyOf(certificates, certificates.length));
    }

    @NotNull
    public final CertPath buildCertPath(@NotNull List<? extends X509Certificate> certificates) {
        Intrinsics.checkParameterIsNotNull(certificates, (String)"certificates");
        return new X509CertificateFactory().generateCertPath(certificates);
    }

    private final void addCrlInfo(X509v3CertificateBuilder builder, String crlDistPoint, X500Name crlIssuer) {
        if (crlDistPoint != null) {
            GeneralNames generalNames;
            DistributionPointName distPointName = new DistributionPointName(new GeneralNames(new GeneralName(6, crlDistPoint)));
            X500Name x500Name = crlIssuer;
            if (x500Name != null) {
                X500Name x500Name2;
                X500Name it = x500Name2 = x500Name;
                generalNames = new GeneralNames(new GeneralName(crlIssuer));
            } else {
                generalNames = null;
            }
            GeneralNames crlIssuerGeneralNames = generalNames;
            DistributionPoint distPoint = new DistributionPoint(distPointName, null, crlIssuerGeneralNames);
            builder.addExtension(Extension.cRLDistributionPoints, false, (ASN1Encodable)new CRLDistPoint(new DistributionPoint[]{distPoint}));
        }
    }

    private X509Utilities() {
    }

    static {
        X509Utilities x509Utilities;
        INSTANCE = x509Utilities = new X509Utilities();
        DEFAULT_IDENTITY_SIGNATURE_SCHEME = Crypto.EDDSA_ED25519_SHA512;
        DEFAULT_TLS_SIGNATURE_SCHEME = Crypto.ECDSA_SECP256R1_SHA256;
        DEFAULT_VALIDITY_WINDOW = new Pair((Object)KotlinUtilsKt.getMillis((int)0), (Object)KotlinUtilsKt.getDays((int)3650));
    }
}

