/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.crypto;

import java.io.InputStream;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.Crypto;
import net.corda.core.internal.InternalUtils;
import net.corda.nodeapi.internal.crypto.CertificateAndKeyPair;
import net.corda.nodeapi.internal.crypto.KeyStoreUtilities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B-\b\u0002\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011J\b\u0010\u0012\u001a\u00020\nH\u0002J\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0005J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\u0006\u0010\u0014\u001a\u00020\u0005J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0016J,\u0010$\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u001d2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\u0006\u0010\u0019\u001a\u00020\u0005J\u001f\u0010'\u001a\u00020!2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020!0)\u00a2\u0006\u0002\b*R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lnet/corda/nodeapi/internal/crypto/X509KeyStore;", "", "keyStore", "Ljava/security/KeyStore;", "storePassword", "", "(Ljava/security/KeyStore;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "internal", "keyStoreFile", "Ljava/nio/file/Path;", "saveSupported", "", "(Ljava/security/KeyStore;Ljava/lang/String;Ljava/nio/file/Path;Z)V", "getInternal", "()Ljava/security/KeyStore;", "aliases", "", "checkWritableToFile", "contains", "alias", "getCertificate", "Ljava/security/cert/X509Certificate;", "getCertificateAndKeyPair", "Lnet/corda/nodeapi/internal/crypto/CertificateAndKeyPair;", "keyPassword", "getCertificateChain", "", "getPrivateKey", "Ljava/security/PrivateKey;", "getPublicKey", "Ljava/security/PublicKey;", "save", "", "setCertificate", "certificate", "setPrivateKey", "key", "certificates", "update", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Companion", "node-api"})
public final class X509KeyStore {
    @NotNull
    private final KeyStore internal;
    private final String storePassword;
    private final Path keyStoreFile;
    private final boolean saveSupported;
    public static final Companion Companion = new Companion(null);

    public final boolean contains(@NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        return this.internal.containsAlias(alias);
    }

    @NotNull
    public final Iterator<String> aliases() {
        Enumeration<String> enumeration = this.internal.aliases();
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"internal.aliases()");
        return CollectionsKt.iterator(enumeration);
    }

    @NotNull
    public final X509Certificate getCertificate(@NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        return KeyStoreUtilities.getX509Certificate(this.internal, alias);
    }

    @NotNull
    public final List<X509Certificate> getCertificateChain(@NotNull String alias) {
        boolean bl;
        Object[] certArray;
        block3: {
            boolean bl2;
            Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
            Object[] objectArray = this.internal.getCertificateChain(alias);
            if (objectArray == null) {
                String string = "No certificate chain under the alias " + alias;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            for (Certificate certificate : certArray = objectArray) {
                Certificate it = certificate;
                if (it instanceof X509Certificate) continue;
                bl2 = false;
                break block3;
            }
            bl2 = bl = true;
        }
        if (!bl) {
            String string = "Certificate chain under alias " + alias + " is not X.509";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (List)InternalUtils.uncheckedCast((Object)ArraysKt.asList((Object[])certArray));
    }

    @NotNull
    public final CertificateAndKeyPair getCertificateAndKeyPair(@NotNull String alias, @NotNull String keyPassword) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)keyPassword, (String)"keyPassword");
        X509Certificate cert = this.getCertificate(alias);
        PublicKey publicKey = this.getPublicKey(alias);
        return new CertificateAndKeyPair(cert, new KeyPair(publicKey, this.getPrivateKey(alias, keyPassword)));
    }

    @NotNull
    public final PublicKey getPublicKey(@NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        PublicKey publicKey = this.getCertificate(alias).getPublicKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"getCertificate(alias).publicKey");
        return Crypto.toSupportedPublicKey((PublicKey)publicKey);
    }

    @NotNull
    public final PrivateKey getPrivateKey(@NotNull String alias, @NotNull String keyPassword) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)keyPassword, (String)"keyPassword");
        return KeyStoreUtilities.getSupportedKey(this.internal, alias, keyPassword);
    }

    /*
     * WARNING - void declaration
     */
    public final void setPrivateKey(@NotNull String alias, @NotNull PrivateKey key, @NotNull List<? extends X509Certificate> certificates, @NotNull String keyPassword) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(certificates, (String)"certificates");
        Intrinsics.checkParameterIsNotNull((Object)keyPassword, (String)"keyPassword");
        Object object = keyPassword;
        Key key2 = key;
        String string = alias;
        KeyStore keyStore = this.internal;
        char[] cArray = ((String)object).toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        object = certificates;
        void thisCollection$iv = $receiver$iv;
        X509Certificate[] x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
        if (x509CertificateArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        X509Certificate[] x509CertificateArray2 = x509CertificateArray;
        keyStore.setKeyEntry(string, key2, cArray2, x509CertificateArray2);
        this.save();
    }

    public final void setCertificate(@NotNull String alias, @NotNull X509Certificate certificate) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
        this.internal.setCertificateEntry(alias, certificate);
        this.save();
    }

    public final void save() {
        if (this.saveSupported) {
            KeyStoreUtilities.save(this.internal, this.checkWritableToFile(), this.storePassword);
        }
    }

    public final void update(@NotNull Function1<? super X509KeyStore, Unit> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        this.checkWritableToFile();
        action.invoke((Object)this);
        this.save();
    }

    private final Path checkWritableToFile() {
        Path path = this.keyStoreFile;
        if (path == null) {
            throw (Throwable)new IllegalStateException("This key store cannot be written to");
        }
        return path;
    }

    @NotNull
    public final KeyStore getInternal() {
        return this.internal;
    }

    private X509KeyStore(KeyStore internal, String storePassword, Path keyStoreFile, boolean saveSupported) {
        this.internal = internal;
        this.storePassword = storePassword;
        this.keyStoreFile = keyStoreFile;
        this.saveSupported = saveSupported;
    }

    /* synthetic */ X509KeyStore(KeyStore keyStore, String string, Path path, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            path = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(keyStore, string, path, bl);
    }

    public X509KeyStore(@NotNull KeyStore keyStore, @NotNull String storePassword) {
        Intrinsics.checkParameterIsNotNull((Object)keyStore, (String)"keyStore");
        Intrinsics.checkParameterIsNotNull((Object)storePassword, (String)"storePassword");
        this(keyStore, storePassword, null, false);
    }

    public X509KeyStore(@NotNull String storePassword) {
        KeyStore keyStore;
        Intrinsics.checkParameterIsNotNull((Object)storePassword, (String)"storePassword");
        KeyStore keyStore2 = KeyStore.getInstance("JKS");
        X509KeyStore x509KeyStore = this;
        KeyStore $receiver = keyStore2;
        String string = storePassword;
        InputStream inputStream = null;
        KeyStore keyStore3 = $receiver;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        keyStore3.load(inputStream, cArray2);
        KeyStore keyStore4 = keyStore = keyStore2;
        Intrinsics.checkExpressionValueIsNotNull((Object)keyStore4, (String)"KeyStore.getInstance(KEY\u2026Password.toCharArray()) }");
        x509KeyStore(keyStore4, storePassword);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Lnet/corda/nodeapi/internal/crypto/X509KeyStore$Companion;", "", "()V", "fromFile", "Lnet/corda/nodeapi/internal/crypto/X509KeyStore;", "keyStoreFile", "Ljava/nio/file/Path;", "storePassword", "", "createNew", "", "fromInputStream", "stream", "Ljava/io/InputStream;", "node-api"})
    public static final class Companion {
        @NotNull
        public final X509KeyStore fromFile(@NotNull Path keyStoreFile, @NotNull String storePassword, boolean createNew) {
            Intrinsics.checkParameterIsNotNull((Object)keyStoreFile, (String)"keyStoreFile");
            Intrinsics.checkParameterIsNotNull((Object)storePassword, (String)"storePassword");
            KeyStore internal = createNew ? KeyStoreUtilities.loadOrCreateKeyStore(keyStoreFile, storePassword) : KeyStoreUtilities.loadKeyStore(keyStoreFile, storePassword);
            return new X509KeyStore(internal, storePassword, keyStoreFile, false, 8, null);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ X509KeyStore fromFile$default(Companion companion, Path path, String string, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.fromFile(path, string, bl);
        }

        @NotNull
        public final X509KeyStore fromInputStream(@NotNull InputStream stream, @NotNull String storePassword) {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            Intrinsics.checkParameterIsNotNull((Object)storePassword, (String)"storePassword");
            KeyStore internal = KeyStoreUtilities.loadKeyStore(stream, storePassword);
            return new X509KeyStore(internal, storePassword);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

