/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.crypto;

import java.io.InputStream;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.nodeapi.internal.crypto.X509UtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/nodeapi/internal/crypto/X509CertificateFactory;", "", "()V", "delegate", "Ljava/security/cert/CertificateFactory;", "getDelegate", "()Ljava/security/cert/CertificateFactory;", "generateCertPath", "Ljava/security/cert/CertPath;", "certificates", "", "Ljava/security/cert/X509Certificate;", "([Ljava/security/cert/X509Certificate;)Ljava/security/cert/CertPath;", "", "generateCertificate", "input", "Ljava/io/InputStream;", "node-api"})
public final class X509CertificateFactory {
    @NotNull
    private final CertificateFactory delegate;

    @NotNull
    public final CertificateFactory getDelegate() {
        return this.delegate;
    }

    @NotNull
    public final X509Certificate generateCertificate(@NotNull InputStream input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Certificate certificate = this.delegate.generateCertificate(input);
        Intrinsics.checkExpressionValueIsNotNull((Object)certificate, (String)"delegate.generateCertificate(input)");
        return X509UtilitiesKt.getX509(certificate);
    }

    @NotNull
    public final CertPath generateCertPath(X509Certificate ... certificates) {
        Intrinsics.checkParameterIsNotNull((Object)certificates, (String)"certificates");
        return this.generateCertPath(ArraysKt.asList((Object[])certificates));
    }

    @NotNull
    public final CertPath generateCertPath(@NotNull List<? extends X509Certificate> certificates) {
        Intrinsics.checkParameterIsNotNull(certificates, (String)"certificates");
        CertPath certPath = this.delegate.generateCertPath(certificates);
        Intrinsics.checkExpressionValueIsNotNull((Object)certPath, (String)"delegate.generateCertPath(certificates)");
        return certPath;
    }

    public X509CertificateFactory() {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Intrinsics.checkExpressionValueIsNotNull((Object)certificateFactory, (String)"CertificateFactory.getInstance(\"X.509\")");
        this.delegate = certificateFactory;
    }
}

