/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.crypto;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.Crypto;
import net.corda.core.internal.PathUtilsKt;
import net.corda.nodeapi.internal.crypto.CertificateAndKeyPair;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0016\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\u00032\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a7\u0010\u000f\u001a\u00020\u000b*\u00020\u00032\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0015\u00a2\u0006\u0002\u0010\u0016\u001a\u001a\u0010\u0017\u001a\u00020\u0018*\u00020\u00032\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u001a\u0010\u001a\u001a\u00020\u001b*\u00020\u00032\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u0012\u0010\u001c\u001a\u00020\u001d*\u00020\u00032\u0006\u0010\f\u001a\u00020\u0001\u001a\u001a\u0010\u001e\u001a\u00020\u000b*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"KEYSTORE_TYPE", "", "loadKeyStore", "Ljava/security/KeyStore;", "input", "Ljava/io/InputStream;", "storePassword", "keyStoreFilePath", "Ljava/nio/file/Path;", "loadOrCreateKeyStore", "addOrReplaceCertificate", "", "alias", "cert", "Ljava/security/cert/Certificate;", "addOrReplaceKey", "key", "Ljava/security/Key;", "password", "", "chain", "", "(Ljava/security/KeyStore;Ljava/lang/String;Ljava/security/Key;[C[Ljava/security/cert/Certificate;)V", "getCertificateAndKeyPair", "Lnet/corda/nodeapi/internal/crypto/CertificateAndKeyPair;", "keyPassword", "getSupportedKey", "Ljava/security/PrivateKey;", "getX509Certificate", "Ljava/security/cert/X509Certificate;", "save", "node-api"})
@JvmName(name="KeyStoreUtilities")
public final class KeyStoreUtilities {
    @NotNull
    public static final String KEYSTORE_TYPE = "JKS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final KeyStore loadOrCreateKeyStore(@NotNull Path keyStoreFilePath, @NotNull String storePassword) {
        Intrinsics.checkParameterIsNotNull((Object)keyStoreFilePath, (String)"keyStoreFilePath");
        Intrinsics.checkParameterIsNotNull((Object)storePassword, (String)"storePassword");
        String string = storePassword;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] pass = cArray;
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        if (PathUtilsKt.exists((Path)keyStoreFilePath, (LinkOption[])new LinkOption[0])) {
            void $receiver$iv;
            Path path = keyStoreFilePath;
            OpenOption[] options$iv = new OpenOption[]{};
            Closeable closeable = PathUtilsKt.inputStream((Path)$receiver$iv, (OpenOption[])Arrays.copyOf(options$iv, options$iv.length));
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                keyStore.load(it, pass);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        keyStore.load(null, pass);
        Path path = keyStoreFilePath.toAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"keyStoreFilePath.toAbsolutePath()");
        Path path2 = path.getParent();
        if (path2 != null && (path2 = PathUtilsKt.safeSymbolicRead((Path)path2)) != null) {
            PathUtilsKt.createDirectories((Path)path2, (FileAttribute[])new FileAttribute[0]);
        }
        Path $receiver$iv = keyStoreFilePath;
        boolean createDirs$iv = false;
        OpenOption[] options$iv = new OpenOption[]{};
        Closeable closeable = PathUtilsKt.outputStream((Path)$receiver$iv, (OpenOption[])Arrays.copyOf(options$iv, options$iv.length));
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            keyStore.store(it, pass);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        KeyStore keyStore2 = keyStore;
        Intrinsics.checkExpressionValueIsNotNull((Object)keyStore2, (String)"keyStore");
        return keyStore2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final KeyStore loadKeyStore(@NotNull Path keyStoreFilePath, @NotNull String storePassword) throws KeyStoreException, IOException {
        KeyStore keyStore;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)keyStoreFilePath, (String)"keyStoreFilePath");
        Intrinsics.checkParameterIsNotNull((Object)storePassword, (String)"storePassword");
        Path path = keyStoreFilePath;
        OpenOption[] options$iv = new OpenOption[]{};
        Closeable closeable = PathUtilsKt.inputStream((Path)$receiver$iv, (OpenOption[])Arrays.copyOf(options$iv, options$iv.length));
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            keyStore = KeyStoreUtilities.loadKeyStore(it, storePassword);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final KeyStore loadKeyStore(@NotNull InputStream input, @NotNull String storePassword) throws KeyStoreException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)storePassword, (String)"storePassword");
        String string = storePassword;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] pass = cArray;
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        Closeable closeable = input;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            keyStore.load(input, pass);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        KeyStore keyStore2 = keyStore;
        Intrinsics.checkExpressionValueIsNotNull((Object)keyStore2, (String)"keyStore");
        return keyStore2;
    }

    public static final void addOrReplaceKey(@NotNull KeyStore $receiver, @NotNull String alias, @NotNull Key key, @NotNull char[] password, @NotNull Certificate[] chain) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        if ($receiver.containsAlias(alias)) {
            $receiver.deleteEntry(alias);
        }
        $receiver.setKeyEntry(alias, key, password, chain);
    }

    public static final void addOrReplaceCertificate(@NotNull KeyStore $receiver, @NotNull String alias, @NotNull Certificate cert) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)cert, (String)"cert");
        if ($receiver.containsAlias(alias)) {
            $receiver.deleteEntry(alias);
        }
        $receiver.setCertificateEntry(alias, cert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void save(@NotNull KeyStore $receiver, @NotNull Path keyStoreFilePath, @NotNull String storePassword) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)keyStoreFilePath, (String)"keyStoreFilePath");
        Intrinsics.checkParameterIsNotNull((Object)storePassword, (String)"storePassword");
        Path $receiver$iv = keyStoreFilePath;
        boolean createDirs$iv = false;
        OpenOption[] options$iv = new OpenOption[]{};
        Closeable closeable = PathUtilsKt.outputStream((Path)$receiver$iv, (OpenOption[])Arrays.copyOf(options$iv, options$iv.length));
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            String string = storePassword;
            OutputStream outputStream = it;
            KeyStore keyStore = $receiver;
            char[] cArray = string.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] cArray2 = cArray;
            keyStore.store(outputStream, cArray2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final CertificateAndKeyPair getCertificateAndKeyPair(@NotNull KeyStore $receiver, @NotNull String alias, @NotNull String keyPassword) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)keyPassword, (String)"keyPassword");
        X509Certificate certificate = KeyStoreUtilities.getX509Certificate($receiver, alias);
        PublicKey publicKey = certificate.getPublicKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"certificate.publicKey");
        PublicKey publicKey2 = Crypto.toSupportedPublicKey((PublicKey)publicKey);
        return new CertificateAndKeyPair(certificate, new KeyPair(publicKey2, KeyStoreUtilities.getSupportedKey($receiver, alias, keyPassword)));
    }

    @NotNull
    public static final X509Certificate getX509Certificate(@NotNull KeyStore $receiver, @NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Certificate certificate = $receiver.getCertificate(alias);
        if (certificate == null) {
            throw (Throwable)new IllegalArgumentException("No certificate under alias \"" + alias + "\".");
        }
        Certificate certificate2 = certificate;
        Certificate certificate3 = certificate2;
        if (!(certificate3 instanceof X509Certificate)) {
            certificate3 = null;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate3;
        if (x509Certificate == null) {
            throw (Throwable)new IllegalStateException("Certificate under alias \"" + alias + "\" is not an X.509 certificate: " + certificate2);
        }
        return x509Certificate;
    }

    @NotNull
    public static final PrivateKey getSupportedKey(@NotNull KeyStore $receiver, @NotNull String alias, @NotNull String keyPassword) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)keyPassword, (String)"keyPassword");
        String string = keyPassword;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] keyPass = cArray;
        Key key = $receiver.getKey(alias, keyPass);
        if (key == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.PrivateKey");
        }
        PrivateKey key2 = (PrivateKey)key;
        return Crypto.toSupportedPrivateKey((PrivateKey)key2);
    }
}

