/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.crypto;

import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.Crypto;
import net.corda.core.crypto.SignatureScheme;
import net.corda.core.crypto.internal.Instances;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\u000e"}, d2={"Lnet/corda/nodeapi/internal/crypto/ContentSignerBuilder;", "", "()V", "build", "Lorg/bouncycastle/operator/ContentSigner;", "signatureScheme", "Lnet/corda/core/crypto/SignatureScheme;", "privateKey", "Ljava/security/PrivateKey;", "provider", "Ljava/security/Provider;", "random", "Ljava/security/SecureRandom;", "SignatureOutputStream", "node-api"})
public final class ContentSignerBuilder {
    public static final ContentSignerBuilder INSTANCE;

    @NotNull
    public final ContentSigner build(@NotNull SignatureScheme signatureScheme, @NotNull PrivateKey privateKey2, @NotNull Provider provider, @Nullable SecureRandom random) {
        Signature signature;
        Intrinsics.checkParameterIsNotNull((Object)signatureScheme, (String)"signatureScheme");
        Intrinsics.checkParameterIsNotNull((Object)privateKey2, (String)"privateKey");
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        AlgorithmIdentifier sigAlgId = signatureScheme.getSignatureOID();
        Signature $receiver = signature = Instances.INSTANCE.getSignatureInstance(signatureScheme.getSignatureName(), provider);
        if (random != null && Intrinsics.areEqual((Object)signatureScheme, (Object)Crypto.SPHINCS256_SHA256) ^ true) {
            $receiver.initSign(privateKey2, random);
        } else {
            $receiver.initSign(privateKey2);
        }
        Signature sig = signature;
        return new ContentSigner(sigAlgId, sig){
            private final SignatureOutputStream stream;
            final /* synthetic */ AlgorithmIdentifier $sigAlgId;
            final /* synthetic */ Signature $sig;

            @NotNull
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return this.$sigAlgId;
            }

            @NotNull
            public OutputStream getOutputStream() {
                return this.stream;
            }

            @NotNull
            public byte[] getSignature() {
                return this.stream.getSignature$node_api();
            }
            {
                this.$sigAlgId = $captured_local_variable$0;
                this.$sig = $captured_local_variable$1;
                Signature signature = $captured_local_variable$1;
                Intrinsics.checkExpressionValueIsNotNull((Object)signature, (String)"sig");
                this.stream = new SignatureOutputStream(signature);
            }
        };
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ContentSigner build$default(ContentSignerBuilder contentSignerBuilder, SignatureScheme signatureScheme, PrivateKey privateKey2, Provider provider, SecureRandom secureRandom, int n, Object object) {
        if ((n & 8) != 0) {
            secureRandom = null;
        }
        return contentSignerBuilder.build(signatureScheme, privateKey2, provider, secureRandom);
    }

    private ContentSignerBuilder() {
    }

    static {
        ContentSignerBuilder contentSignerBuilder;
        INSTANCE = contentSignerBuilder = new ContentSignerBuilder();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lnet/corda/nodeapi/internal/crypto/ContentSignerBuilder$SignatureOutputStream;", "Ljava/io/OutputStream;", "sig", "Ljava/security/Signature;", "(Ljava/security/Signature;)V", "signature", "", "getSignature$node_api", "()[B", "write", "", "bytes", "off", "", "len", "b", "node-api"})
    private static final class SignatureOutputStream
    extends OutputStream {
        private final Signature sig;

        @NotNull
        public final byte[] getSignature$node_api() {
            byte[] byArray = this.sig.sign();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"sig.sign()");
            return byArray;
        }

        @Override
        public void write(@NotNull byte[] bytes, int off, int len) {
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            this.sig.update(bytes, off, len);
        }

        @Override
        public void write(@NotNull byte[] bytes) {
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            this.sig.update(bytes);
        }

        @Override
        public void write(int b) {
            this.sig.update((byte)b);
        }

        public SignatureOutputStream(@NotNull Signature sig) {
            Intrinsics.checkParameterIsNotNull((Object)sig, (String)"sig");
            this.sig = sig;
        }
    }
}

