/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.crypto;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.SignedDataWithCert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J#\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\b\b\u0000\u0010\u0015*\u00020\u00012\u0006\u0010\u0016\u001a\u0002H\u0015\u00a2\u0006\u0002\u0010\u0017J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lnet/corda/nodeapi/internal/crypto/CertificateAndKeyPair;", "", "certificate", "Ljava/security/cert/X509Certificate;", "keyPair", "Ljava/security/KeyPair;", "(Ljava/security/cert/X509Certificate;Ljava/security/KeyPair;)V", "getCertificate", "()Ljava/security/cert/X509Certificate;", "getKeyPair", "()Ljava/security/KeyPair;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "sign", "Lnet/corda/core/internal/SignedDataWithCert;", "T", "obj", "(Ljava/lang/Object;)Lnet/corda/core/internal/SignedDataWithCert;", "toString", "", "node-api"})
public final class CertificateAndKeyPair {
    @NotNull
    private final X509Certificate certificate;
    @NotNull
    private final KeyPair keyPair;

    @NotNull
    public final <T> SignedDataWithCert<T> sign(@NotNull T obj) {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        PrivateKey privateKey2 = this.keyPair.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey2, (String)"keyPair.private");
        return InternalUtils.signWithCert(obj, (PrivateKey)privateKey2, (X509Certificate)this.certificate);
    }

    @NotNull
    public final X509Certificate getCertificate() {
        return this.certificate;
    }

    @NotNull
    public final KeyPair getKeyPair() {
        return this.keyPair;
    }

    public CertificateAndKeyPair(@NotNull X509Certificate certificate, @NotNull KeyPair keyPair) {
        Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
        Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
        this.certificate = certificate;
        this.keyPair = keyPair;
    }

    @NotNull
    public final X509Certificate component1() {
        return this.certificate;
    }

    @NotNull
    public final KeyPair component2() {
        return this.keyPair;
    }

    @NotNull
    public final CertificateAndKeyPair copy(@NotNull X509Certificate certificate, @NotNull KeyPair keyPair) {
        Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
        Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
        return new CertificateAndKeyPair(certificate, keyPair);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CertificateAndKeyPair copy$default(CertificateAndKeyPair certificateAndKeyPair, X509Certificate x509Certificate, KeyPair keyPair, int n, Object object) {
        if ((n & 1) != 0) {
            x509Certificate = certificateAndKeyPair.certificate;
        }
        if ((n & 2) != 0) {
            keyPair = certificateAndKeyPair.keyPair;
        }
        return certificateAndKeyPair.copy(x509Certificate, keyPair);
    }

    @NotNull
    public String toString() {
        return "CertificateAndKeyPair(certificate=" + this.certificate + ", keyPair=" + this.keyPair + ")";
    }

    public int hashCode() {
        X509Certificate x509Certificate = this.certificate;
        KeyPair keyPair = this.keyPair;
        return (x509Certificate != null ? ((Object)x509Certificate).hashCode() : 0) * 31 + (keyPair != null ? keyPair.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CertificateAndKeyPair)) break block3;
                CertificateAndKeyPair certificateAndKeyPair = (CertificateAndKeyPair)object;
                if (!Intrinsics.areEqual((Object)this.certificate, (Object)certificateAndKeyPair.certificate) || !Intrinsics.areEqual((Object)this.keyPair, (Object)certificateAndKeyPair.keyPair)) break block3;
            }
            return true;
        }
        return false;
    }
}

