/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.config;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.nodeapi.internal.config.CertificateStore;
import net.corda.nodeapi.internal.config.CertificateStoreSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0011"}, d2={"Lnet/corda/nodeapi/internal/config/FileBasedCertificateStoreSupplier;", "Lnet/corda/nodeapi/internal/config/CertificateStoreSupplier;", "path", "Ljava/nio/file/Path;", "storePassword", "", "entryPassword", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;)V", "getEntryPassword", "()Ljava/lang/String;", "getPath", "()Ljava/nio/file/Path;", "getStorePassword", "get", "Lnet/corda/nodeapi/internal/config/CertificateStore;", "createNew", "", "node-api"})
public final class FileBasedCertificateStoreSupplier
implements CertificateStoreSupplier {
    @NotNull
    private final Path path;
    @NotNull
    private final String storePassword;
    @NotNull
    private final String entryPassword;

    @Override
    @NotNull
    public CertificateStore get(boolean createNew) {
        return CertificateStore.Companion.fromFile(this.path, this.storePassword, this.entryPassword, createNew);
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final String getStorePassword() {
        return this.storePassword;
    }

    @NotNull
    public final String getEntryPassword() {
        return this.entryPassword;
    }

    public FileBasedCertificateStoreSupplier(@NotNull Path path, @NotNull String storePassword, @NotNull String entryPassword) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)storePassword, (String)"storePassword");
        Intrinsics.checkParameterIsNotNull((Object)entryPassword, (String)"entryPassword");
        this.path = path;
        this.storePassword = storePassword;
        this.entryPassword = entryPassword;
    }

    @Override
    @Nullable
    public CertificateStore getOptional() {
        return CertificateStoreSupplier.DefaultImpls.getOptional(this);
    }
}

