/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.bridging;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import net.corda.core.concurrent.CordaFuture;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.nodeapi.internal.ArtemisMessagingClient;
import net.corda.nodeapi.internal.ArtemisMessagingComponent;
import net.corda.nodeapi.internal.ArtemisSessionProvider;
import net.corda.nodeapi.internal.bridging.AMQPBridgeManager;
import net.corda.nodeapi.internal.bridging.AMQPBridgeManager$sam$i$org_apache_activemq_artemis_api_core_client_MessageHandler$0;
import net.corda.nodeapi.internal.bridging.BridgeManager;
import net.corda.nodeapi.internal.bridging.BridgeMetricsService;
import net.corda.nodeapi.internal.config.CertificateStore;
import net.corda.nodeapi.internal.config.CertificateStoreSupplier;
import net.corda.nodeapi.internal.config.MutualSslConfiguration;
import net.corda.nodeapi.internal.protonwrapper.messages.MessageStatus;
import net.corda.nodeapi.internal.protonwrapper.messages.SendableMessage;
import net.corda.nodeapi.internal.protonwrapper.netty.AMQPClient;
import net.corda.nodeapi.internal.protonwrapper.netty.AMQPConfiguration;
import net.corda.nodeapi.internal.protonwrapper.netty.ConnectionChange;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.MDC;
import rx.Subscription;
import rx.functions.Action1;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 +2\u00020\u0001:\u0003)*+B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001d\u001a\u00020\u001eH\u0016J,\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016J\u001e\u0010&\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\"H\u0016J\b\u0010'\u001a\u00020\u001eH\u0016J\b\u0010(\u001a\u00020\u001eH\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lnet/corda/nodeapi/internal/bridging/AMQPBridgeManager;", "Lnet/corda/nodeapi/internal/bridging/BridgeManager;", "config", "Lnet/corda/nodeapi/internal/config/MutualSslConfiguration;", "p2pAddress", "Lnet/corda/core/utilities/NetworkHostAndPort;", "maxMessageSize", "", "crlCheckSoftFail", "", "(Lnet/corda/nodeapi/internal/config/MutualSslConfiguration;Lnet/corda/core/utilities/NetworkHostAndPort;IZ)V", "artemisMessageClientFactory", "Lkotlin/Function0;", "Lnet/corda/nodeapi/internal/ArtemisSessionProvider;", "bridgeMetricsService", "Lnet/corda/nodeapi/internal/bridging/BridgeMetricsService;", "(Lnet/corda/nodeapi/internal/config/MutualSslConfiguration;IZLkotlin/jvm/functions/Function0;Lnet/corda/nodeapi/internal/bridging/BridgeMetricsService;)V", "amqpConfig", "Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPConfiguration;", "artemis", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "queueNamesToBridgesMap", "", "", "", "Lnet/corda/nodeapi/internal/bridging/AMQPBridgeManager$AMQPBridge;", "sharedEventLoopGroup", "Lio/netty/channel/EventLoopGroup;", "close", "", "deployBridge", "queueName", "targets", "", "legalNames", "", "Lnet/corda/core/identity/CordaX500Name;", "destroyBridge", "start", "stop", "AMQPBridge", "AMQPConfigurationImpl", "Companion", "node-api"})
public final class AMQPBridgeManager
implements BridgeManager {
    private final ReentrantLock lock;
    private final Map<String, List<AMQPBridge>> queueNamesToBridgesMap;
    private final AMQPConfiguration amqpConfig;
    private EventLoopGroup sharedEventLoopGroup;
    private ArtemisSessionProvider artemis;
    private final Function0<ArtemisSessionProvider> artemisMessageClientFactory;
    private final BridgeMetricsService bridgeMetricsService;
    private static final int NUM_BRIDGE_THREADS = 0;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void deployBridge(@NotNull String queueName, @NotNull List<NetworkHostAndPort> targets, @NotNull Set<CordaX500Name> legalNames) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)queueName, (String)"queueName");
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        Intrinsics.checkParameterIsNotNull(legalNames, (String)"legalNames");
        Lock lock = this.lock;
        lock.lock();
        try {
            Object object2;
            void $receiver$iv;
            Map<String, List<AMQPBridge>> map = this.queueNamesToBridgesMap;
            String key$iv = queueName;
            Object value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                List answer$iv = new ArrayList();
                $receiver$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            List bridges = (List)object2;
            for (NetworkHostAndPort target : targets) {
                boolean bl;
                block13: {
                    Iterable $receiver$iv2 = bridges;
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv2) {
                            AMQPBridge it = (AMQPBridge)element$iv;
                            if (!it.getTargets().contains(target)) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                return;
            }
            EventLoopGroup eventLoopGroup = this.sharedEventLoopGroup;
            if (eventLoopGroup == null) {
                Intrinsics.throwNpe();
            }
            ArtemisSessionProvider artemisSessionProvider = this.artemis;
            if (artemisSessionProvider == null) {
                Intrinsics.throwNpe();
            }
            AMQPBridge newBridge = new AMQPBridge(queueName, targets, legalNames, this.amqpConfig, eventLoopGroup, artemisSessionProvider, this.bridgeMetricsService);
            object = bridges;
            object.add(newBridge);
            BridgeMetricsService bridgeMetricsService = this.bridgeMetricsService;
            if (bridgeMetricsService != null) {
                bridgeMetricsService.bridgeCreated(targets, legalNames);
            }
            object = newBridge;
        }
        finally {
            lock.unlock();
        }
        Object newBridge = object;
        ((AMQPBridge)newBridge).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyBridge(@NotNull String queueName, @NotNull List<NetworkHostAndPort> targets) {
        Intrinsics.checkParameterIsNotNull((Object)queueName, (String)"queueName");
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        Lock lock = this.lock;
        lock.lock();
        try {
            List list2 = this.queueNamesToBridgesMap.get(queueName);
            if (list2 == null) {
                list2 = new ArrayList();
            }
            List bridges = list2;
            for (NetworkHostAndPort target : targets) {
                AMQPBridge bridge;
                Object v1;
                block7: {
                    Iterable $receiver$iv = bridges;
                    for (Object element$iv : $receiver$iv) {
                        AMQPBridge it = (AMQPBridge)element$iv;
                        if (!it.getTargets().contains(target)) continue;
                        v1 = element$iv;
                        break block7;
                    }
                    v1 = null;
                }
                if ((bridge = (AMQPBridge)v1) == null) continue;
                Collection collection = bridges;
                collection.remove(bridge);
                if (bridges.isEmpty()) {
                    this.queueNamesToBridgesMap.remove(queueName);
                }
                bridge.stop();
                BridgeMetricsService bridgeMetricsService = this.bridgeMetricsService;
                if (bridgeMetricsService == null) continue;
                bridgeMetricsService.bridgeDestroyed(bridge.getTargets(), bridge.getLegalNames());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void start() {
        ArtemisSessionProvider artemis;
        this.sharedEventLoopGroup = (EventLoopGroup)new NioEventLoopGroup(0);
        this.artemis = artemis = (ArtemisSessionProvider)this.artemisMessageClientFactory.invoke();
        artemis.start();
    }

    @Override
    public void stop() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Lock lock = this.lock;
        lock.lock();
        try {
            Unit unit;
            EventLoopGroup eventLoopGroup;
            for (AMQPBridge bridge : CollectionsKt.flatten((Iterable)this.queueNamesToBridgesMap.values())) {
                bridge.stop();
            }
            EventLoopGroup eventLoopGroup2 = this.sharedEventLoopGroup;
            if (eventLoopGroup2 != null) {
                eventLoopGroup2.shutdownGracefully();
            }
            if ((eventLoopGroup = this.sharedEventLoopGroup) != null && (eventLoopGroup = eventLoopGroup.terminationFuture()) != null) {
                eventLoopGroup.sync();
            }
            this.sharedEventLoopGroup = null;
            this.queueNamesToBridgesMap.clear();
            ArtemisSessionProvider artemisSessionProvider = this.artemis;
            if (artemisSessionProvider != null) {
                artemisSessionProvider.stop();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
    }

    public AMQPBridgeManager(@NotNull MutualSslConfiguration config, int maxMessageSize2, boolean crlCheckSoftFail, @NotNull Function0<? extends ArtemisSessionProvider> artemisMessageClientFactory, @Nullable BridgeMetricsService bridgeMetricsService) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(artemisMessageClientFactory, (String)"artemisMessageClientFactory");
        this.artemisMessageClientFactory = artemisMessageClientFactory;
        this.bridgeMetricsService = bridgeMetricsService;
        this.lock = new ReentrantLock();
        AMQPBridgeManager aMQPBridgeManager = this;
        aMQPBridgeManager.queueNamesToBridgesMap = map = (Map)new LinkedHashMap();
        this.amqpConfig = new AMQPConfigurationImpl(config, maxMessageSize2, crlCheckSoftFail);
    }

    public /* synthetic */ AMQPBridgeManager(MutualSslConfiguration mutualSslConfiguration, int n, boolean bl, Function0 function0, BridgeMetricsService bridgeMetricsService, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            bridgeMetricsService = null;
        }
        this(mutualSslConfiguration, n, bl, (Function0<? extends ArtemisSessionProvider>)function0, bridgeMetricsService);
    }

    public AMQPBridgeManager(final @NotNull MutualSslConfiguration config, final @NotNull NetworkHostAndPort p2pAddress, final int maxMessageSize2, boolean crlCheckSoftFail) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)p2pAddress, (String)"p2pAddress");
        this(config, maxMessageSize2, crlCheckSoftFail, (Function0)new Function0<ArtemisMessagingClient>(){

            @NotNull
            public final ArtemisMessagingClient invoke() {
                return new ArtemisMessagingClient(config, p2pAddress, maxMessageSize2, null, 8, null);
            }
        }, null, 16, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0002\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lnet/corda/nodeapi/internal/bridging/AMQPBridgeManager$AMQPConfigurationImpl;", "Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPConfiguration;", "config", "Lnet/corda/nodeapi/internal/config/MutualSslConfiguration;", "maxMessageSize", "", "crlCheckSoftFail", "", "(Lnet/corda/nodeapi/internal/config/MutualSslConfiguration;IZ)V", "keyStore", "Lnet/corda/nodeapi/internal/config/CertificateStore;", "trustStore", "(Lnet/corda/nodeapi/internal/config/CertificateStore;Lnet/corda/nodeapi/internal/config/CertificateStore;IZ)V", "getCrlCheckSoftFail", "()Z", "getKeyStore", "()Lnet/corda/nodeapi/internal/config/CertificateStore;", "getMaxMessageSize", "()I", "getTrustStore", "node-api"})
    private static final class AMQPConfigurationImpl
    implements AMQPConfiguration {
        @NotNull
        private final CertificateStore keyStore;
        @NotNull
        private final CertificateStore trustStore;
        private final int maxMessageSize;
        private final boolean crlCheckSoftFail;

        @Override
        @NotNull
        public CertificateStore getKeyStore() {
            return this.keyStore;
        }

        @Override
        @NotNull
        public CertificateStore getTrustStore() {
            return this.trustStore;
        }

        @Override
        public int getMaxMessageSize() {
            return this.maxMessageSize;
        }

        @Override
        public boolean getCrlCheckSoftFail() {
            return this.crlCheckSoftFail;
        }

        private AMQPConfigurationImpl(CertificateStore keyStore, CertificateStore trustStore, int maxMessageSize2, boolean crlCheckSoftFail) {
            this.keyStore = keyStore;
            this.trustStore = trustStore;
            this.maxMessageSize = maxMessageSize2;
            this.crlCheckSoftFail = crlCheckSoftFail;
        }

        public AMQPConfigurationImpl(@NotNull MutualSslConfiguration config, int maxMessageSize2, boolean crlCheckSoftFail) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            this(CertificateStoreSupplier.DefaultImpls.get$default(config.getKeyStore(), false, 1, null), CertificateStoreSupplier.DefaultImpls.get$default(config.getTrustStore(), false, 1, null), maxMessageSize2, crlCheckSoftFail);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000 52\u00020\u0001:\u00015BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020&2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030+H\u0002J\u0010\u0010,\u001a\u00020&2\u0006\u0010*\u001a\u00020\u0003H\u0002J\u0010\u0010-\u001a\u00020&2\u0006\u0010*\u001a\u00020\u0003H\u0002J\u0010\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u000200H\u0002J\u0006\u00101\u001a\u00020&J\u0006\u00102\u001a\u00020&J\u0016\u00103\u001a\u00020&2\f\u00104\u001a\b\u0012\u0004\u0012\u00020&0+H\u0002R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00066"}, d2={"Lnet/corda/nodeapi/internal/bridging/AMQPBridgeManager$AMQPBridge;", "", "queueName", "", "targets", "", "Lnet/corda/core/utilities/NetworkHostAndPort;", "legalNames", "", "Lnet/corda/core/identity/CordaX500Name;", "amqpConfig", "Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPConfiguration;", "sharedEventGroup", "Lio/netty/channel/EventLoopGroup;", "artemis", "Lnet/corda/nodeapi/internal/ArtemisSessionProvider;", "bridgeMetricsService", "Lnet/corda/nodeapi/internal/bridging/BridgeMetricsService;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/Set;Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPConfiguration;Lio/netty/channel/EventLoopGroup;Lnet/corda/nodeapi/internal/ArtemisSessionProvider;Lnet/corda/nodeapi/internal/bridging/BridgeMetricsService;)V", "amqpClient", "Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPClient;", "getAmqpClient", "()Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPClient;", "connectedSubscription", "Lrx/Subscription;", "consumer", "Lorg/apache/activemq/artemis/api/core/client/ClientConsumer;", "getLegalNames", "()Ljava/util/Set;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getQueueName", "()Ljava/lang/String;", "session", "Lorg/apache/activemq/artemis/api/core/client/ClientSession;", "getTargets", "()Ljava/util/List;", "clientArtemisMessageHandler", "", "artemisMessage", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "logDebugWithMDC", "msg", "Lkotlin/Function0;", "logInfoWithMDC", "logWarnWithMDC", "onSocketConnected", "connected", "", "start", "stop", "withMDC", "block", "Companion", "node-api"})
    private static final class AMQPBridge {
        @NotNull
        private final AMQPClient amqpClient;
        private final ReentrantLock lock;
        private ClientSession session;
        private ClientConsumer consumer;
        private Subscription connectedSubscription;
        @NotNull
        private final String queueName;
        @NotNull
        private final List<NetworkHostAndPort> targets;
        @NotNull
        private final Set<CordaX500Name> legalNames;
        private final AMQPConfiguration amqpConfig;
        private final ArtemisSessionProvider artemis;
        private final BridgeMetricsService bridgeMetricsService;
        private static final Logger log;
        public static final Companion Companion;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void withMDC(Function0<Unit> block) {
            Map map = MDC.getCopyOfContextMap();
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map oldMDC = map;
            try {
                MDC.put((String)"queueName", (String)this.queueName);
                MDC.put((String)"targets", (String)CollectionsKt.joinToString$default((Iterable)this.targets, (CharSequence)";", null, null, (int)0, null, (Function1)withMDC.1.INSTANCE, (int)30, null));
                MDC.put((String)"legalNames", (String)CollectionsKt.joinToString$default((Iterable)this.legalNames, (CharSequence)";", null, null, (int)0, null, (Function1)withMDC.2.INSTANCE, (int)30, null));
                MDC.put((String)"maxMessageSize", (String)String.valueOf(this.amqpConfig.getMaxMessageSize()));
                block.invoke();
            }
            finally {
                MDC.setContextMap((Map)oldMDC);
            }
        }

        private final void logDebugWithMDC(Function0<String> msg) {
            if (log.isDebugEnabled()) {
                this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(msg){
                    final /* synthetic */ Function0 $msg;

                    public final void invoke() {
                        AMQPBridge.access$getLog$cp().debug((String)this.$msg.invoke());
                    }
                    {
                        this.$msg = function0;
                        super(0);
                    }
                }));
            }
        }

        private final void logInfoWithMDC(String msg) {
            this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(msg){
                final /* synthetic */ String $msg;

                public final void invoke() {
                    AMQPBridge.access$getLog$cp().info(this.$msg);
                }
                {
                    this.$msg = string;
                    super(0);
                }
            }));
        }

        private final void logWarnWithMDC(String msg) {
            this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(msg){
                final /* synthetic */ String $msg;

                public final void invoke() {
                    AMQPBridge.access$getLog$cp().warn(this.$msg);
                }
                {
                    this.$msg = string;
                    super(0);
                }
            }));
        }

        @NotNull
        public final AMQPClient getAmqpClient() {
            return this.amqpClient;
        }

        public final void start() {
            this.logInfoWithMDC("Create new AMQP bridge");
            this.connectedSubscription = this.amqpClient.getOnConnection().subscribe((Action1)new Action1<ConnectionChange>(this){
                final /* synthetic */ AMQPBridge this$0;

                public final void call(ConnectionChange x) {
                    AMQPBridge.access$onSocketConnected(this.this$0, x.getConnected());
                }
                {
                    this.this$0 = aMQPBridge;
                }
            });
            this.amqpClient.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stop() {
            this.logInfoWithMDC("Stopping AMQP bridge");
            Lock lock = this.lock;
            lock.lock();
            try {
                Unit unit;
                ArtemisSessionProvider artemisSessionProvider = this.artemis;
                synchronized (artemisSessionProvider) {
                    ClientConsumer clientConsumer = this.consumer;
                    if (clientConsumer != null) {
                        clientConsumer.close();
                    }
                    this.consumer = null;
                    ClientSession clientSession = this.session;
                    if (clientSession != null) {
                        clientSession.stop();
                    }
                    this.session = null;
                    unit = Unit.INSTANCE;
                }
                unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            this.amqpClient.stop();
            Subscription subscription = this.connectedSubscription;
            if (subscription != null) {
                subscription.unsubscribe();
            }
            this.connectedSubscription = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onSocketConnected(boolean connected) {
            Lock lock = this.lock;
            lock.lock();
            try {
                Unit unit;
                ArtemisSessionProvider artemisSessionProvider = this.artemis;
                synchronized (artemisSessionProvider) {
                    Unit unit2;
                    if (connected) {
                        ClientConsumer consumer;
                        ClientSession session;
                        this.logInfoWithMDC("Bridge Connected");
                        BridgeMetricsService bridgeMetricsService = this.bridgeMetricsService;
                        if (bridgeMetricsService != null) {
                            bridgeMetricsService.bridgeConnected(this.targets, this.legalNames);
                        }
                        ArtemisMessagingClient.Started started = this.artemis.getStarted();
                        if (started == null) {
                            Intrinsics.throwNpe();
                        }
                        ClientSessionFactory sessionFactory = started.getSessionFactory();
                        this.session = session = sessionFactory.createSession("SystemUsers/Node", "SystemUsers/Node", false, true, true, false, 0x100000);
                        this.consumer = consumer = session.createConsumer(this.queueName);
                        Function1 function1 = (Function1)new Function1<ClientMessage, Unit>(this){

                            public final void invoke(@NotNull ClientMessage p1) {
                                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                                AMQPBridge.access$clientArtemisMessageHandler((AMQPBridge)this.receiver, p1);
                            }

                            public final KDeclarationContainer getOwner() {
                                return Reflection.getOrCreateKotlinClass(AMQPBridge.class);
                            }

                            public final String getName() {
                                return "clientArtemisMessageHandler";
                            }

                            public final String getSignature() {
                                return "clientArtemisMessageHandler(Lorg/apache/activemq/artemis/api/core/client/ClientMessage;)V";
                            }
                        };
                        consumer.setMessageHandler((MessageHandler)new AMQPBridgeManager$sam$i$org_apache_activemq_artemis_api_core_client_MessageHandler$0(function1));
                        unit2 = session.start();
                    } else {
                        this.logInfoWithMDC("Bridge Disconnected");
                        BridgeMetricsService bridgeMetricsService = this.bridgeMetricsService;
                        if (bridgeMetricsService != null) {
                            bridgeMetricsService.bridgeDisconnected(this.targets, this.legalNames);
                        }
                        ClientConsumer clientConsumer = this.consumer;
                        if (clientConsumer != null) {
                            clientConsumer.close();
                        }
                        this.consumer = null;
                        ClientSession clientSession = this.session;
                        if (clientSession != null) {
                            clientSession.stop();
                        }
                        this.session = null;
                        unit2 = Unit.INSTANCE;
                    }
                    unit = unit2;
                }
                Unit unit3 = unit;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void clientArtemisMessageHandler(ClientMessage artemisMessage) {
            block13: {
                Object object;
                Object object2;
                byte[] byArray;
                if (artemisMessage.getBodySize() > this.amqpConfig.getMaxMessageSize()) {
                    String msg = "Message exceeds maxMessageSize network parameter, maxMessageSize: [" + this.amqpConfig.getMaxMessageSize() + "], message size: [" + artemisMessage.getBodySize() + "], " + "dropping message, uuid: " + artemisMessage.getObjectProperty("_AMQ_DUPL_ID");
                    this.logWarnWithMDC(msg);
                    BridgeMetricsService bridgeMetricsService = this.bridgeMetricsService;
                    if (bridgeMetricsService != null) {
                        bridgeMetricsService.packetDropEvent(artemisMessage, msg);
                    }
                    artemisMessage.individualAcknowledge();
                    return;
                }
                byte[] $receiver = byArray = new byte[artemisMessage.getBodySize()];
                artemisMessage.getBodyBuffer().readBytes($receiver);
                byte[] data = byArray;
                HashMap properties = new HashMap();
                for (String key : ArtemisMessagingComponent.Companion.P2PMessagingHeaders.INSTANCE.getWhitelistedHeaders()) {
                    if (!artemisMessage.containsProperty(key)) continue;
                    Object value = artemisMessage.getObjectProperty(key);
                    if (value instanceof SimpleString) {
                        value = value.toString();
                    }
                    object2 = properties;
                    object = value;
                    object2.put(key, object);
                }
                this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(this, artemisMessage){
                    final /* synthetic */ AMQPBridge this$0;
                    final /* synthetic */ ClientMessage $artemisMessage;

                    @NotNull
                    public final String invoke() {
                        return "Bridged Send to " + (CordaX500Name)CollectionsKt.first((Iterable)this.this$0.getLegalNames()) + " uuid: " + this.$artemisMessage.getObjectProperty("_AMQ_DUPL_ID");
                    }
                    {
                        this.this$0 = aMQPBridge;
                        this.$artemisMessage = clientMessage;
                        super(0);
                    }
                }));
                String peerInbox = ArtemisMessagingComponent.RemoteInboxAddress.Companion.translateLocalQueueToInboxAddress(this.queueName);
                SendableMessage sendableMessage = this.amqpClient.createMessage(data, peerInbox, ((CordaX500Name)CollectionsKt.first((Iterable)this.legalNames)).toString(), properties);
                sendableMessage.getOnComplete().then((Function1)new Function1<CordaFuture<MessageStatus>, Object>(this, sendableMessage, artemisMessage){
                    final /* synthetic */ AMQPBridge this$0;
                    final /* synthetic */ SendableMessage $sendableMessage;
                    final /* synthetic */ ClientMessage $artemisMessage;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Nullable
                    public final Object invoke(@NotNull CordaFuture<MessageStatus> it) {
                        ClientMessage clientMessage;
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        AMQPBridge.access$logDebugWithMDC(this.this$0, (Function0)new Function0<String>(this){
                            final /* synthetic */ clientArtemisMessageHandler.2 this$0;

                            @NotNull
                            public final String invoke() {
                                return "Bridge ACK " + (Object)((Object)((MessageStatus)((Object)this.this$0.$sendableMessage.getOnComplete().get())));
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                        Lock lock = AMQPBridge.access$getLock$p(this.this$0);
                        lock.lock();
                        try {
                            ClientMessage clientMessage2;
                            if ((MessageStatus)((Object)this.$sendableMessage.getOnComplete().get()) == MessageStatus.Acknowledged) {
                                clientMessage2 = this.$artemisMessage.individualAcknowledge();
                            } else {
                                AMQPBridge.access$logInfoWithMDC(this.this$0, "Rollback rejected message uuid: " + this.$artemisMessage.getObjectProperty("_AMQ_DUPL_ID"));
                                ClientSession clientSession = AMQPBridge.access$getSession$p(this.this$0);
                                if (clientSession != null) {
                                    clientSession.commit();
                                }
                                ClientSession clientSession2 = AMQPBridge.access$getSession$p(this.this$0);
                                if (clientSession2 != null) {
                                    clientSession2.rollback(false);
                                    clientMessage2 = Unit.INSTANCE;
                                } else {
                                    clientMessage2 = null;
                                }
                            }
                            clientMessage = clientMessage2;
                        }
                        finally {
                            lock.unlock();
                        }
                        return clientMessage;
                    }
                    {
                        this.this$0 = aMQPBridge;
                        this.$sendableMessage = sendableMessage;
                        this.$artemisMessage = clientMessage;
                        super(1);
                    }
                });
                try {
                    this.amqpClient.write(sendableMessage);
                }
                catch (IllegalStateException ex) {
                    object2 = this.lock;
                    object2.lock();
                    try {
                        Unit unit;
                        String string = ex.getMessage();
                        if (string != null) {
                            Object it = object = string;
                            this.logInfoWithMDC((String)it);
                        }
                        this.logInfoWithMDC("Rollback rejected message uuid: " + artemisMessage.getObjectProperty("_AMQ_DUPL_ID"));
                        ClientSession clientSession = this.session;
                        if (clientSession != null) {
                            clientSession.commit();
                        }
                        ClientSession clientSession2 = this.session;
                        if (clientSession2 != null) {
                            clientSession2.rollback(false);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                    }
                    finally {
                        object2.unlock();
                    }
                }
                BridgeMetricsService bridgeMetricsService = this.bridgeMetricsService;
                if (bridgeMetricsService == null) break block13;
                bridgeMetricsService.packetAcceptedEvent(sendableMessage);
            }
        }

        @NotNull
        public final String getQueueName() {
            return this.queueName;
        }

        @NotNull
        public final List<NetworkHostAndPort> getTargets() {
            return this.targets;
        }

        @NotNull
        public final Set<CordaX500Name> getLegalNames() {
            return this.legalNames;
        }

        public AMQPBridge(@NotNull String queueName, @NotNull List<NetworkHostAndPort> targets, @NotNull Set<CordaX500Name> legalNames, @NotNull AMQPConfiguration amqpConfig, @NotNull EventLoopGroup sharedEventGroup, @NotNull ArtemisSessionProvider artemis, @Nullable BridgeMetricsService bridgeMetricsService) {
            Intrinsics.checkParameterIsNotNull((Object)queueName, (String)"queueName");
            Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
            Intrinsics.checkParameterIsNotNull(legalNames, (String)"legalNames");
            Intrinsics.checkParameterIsNotNull((Object)amqpConfig, (String)"amqpConfig");
            Intrinsics.checkParameterIsNotNull((Object)sharedEventGroup, (String)"sharedEventGroup");
            Intrinsics.checkParameterIsNotNull((Object)artemis, (String)"artemis");
            this.queueName = queueName;
            this.targets = targets;
            this.legalNames = legalNames;
            this.amqpConfig = amqpConfig;
            this.artemis = artemis;
            this.bridgeMetricsService = bridgeMetricsService;
            this.amqpClient = new AMQPClient(this.targets, this.legalNames, this.amqpConfig, sharedEventGroup);
            this.lock = new ReentrantLock();
        }

        static {
            Companion = new Companion(null);
            log = KotlinUtilsKt.contextLogger((Object)Companion);
        }

        @NotNull
        public static final /* synthetic */ Logger access$getLog$cp() {
            return log;
        }

        public static final /* synthetic */ void access$onSocketConnected(AMQPBridge $this, boolean connected) {
            $this.onSocketConnected(connected);
        }

        public static final /* synthetic */ void access$clientArtemisMessageHandler(AMQPBridge $this, @NotNull ClientMessage artemisMessage) {
            $this.clientArtemisMessageHandler(artemisMessage);
        }

        public static final /* synthetic */ void access$logDebugWithMDC(AMQPBridge $this, @NotNull Function0 msg) {
            $this.logDebugWithMDC((Function0<String>)msg);
        }

        @NotNull
        public static final /* synthetic */ ReentrantLock access$getLock$p(AMQPBridge $this) {
            return $this.lock;
        }

        public static final /* synthetic */ void access$logInfoWithMDC(AMQPBridge $this, @NotNull String msg) {
            $this.logInfoWithMDC(msg);
        }

        @Nullable
        public static final /* synthetic */ ClientSession access$getSession$p(AMQPBridge $this) {
            return $this.session;
        }

        public static final /* synthetic */ void access$setSession$p(AMQPBridge $this, @Nullable ClientSession clientSession) {
            $this.session = clientSession;
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/nodeapi/internal/bridging/AMQPBridgeManager$AMQPBridge$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "node-api"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/nodeapi/internal/bridging/AMQPBridgeManager$Companion;", "", "()V", "NUM_BRIDGE_THREADS", "", "node-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

