/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.utilities.KotlinUtilsKt;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000f*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u000fB\u000f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00028\u00002\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lnet/corda/nodeapi/internal/MessageSizeChecksInterceptor;", "T", "", "Lorg/apache/activemq/artemis/api/core/BaseInterceptor;", "maxMessageSize", "", "(I)V", "getMessageSize", "packet", "(Ljava/lang/Object;)Ljava/lang/Integer;", "intercept", "", "connection", "Lorg/apache/activemq/artemis/spi/core/protocol/RemotingConnection;", "(Ljava/lang/Object;Lorg/apache/activemq/artemis/spi/core/protocol/RemotingConnection;)Z", "Companion", "Lnet/corda/nodeapi/internal/ArtemisMessageSizeChecksInterceptor;", "Lnet/corda/nodeapi/internal/AmqpMessageSizeChecksInterceptor;", "node-api"})
public abstract class MessageSizeChecksInterceptor<T>
implements BaseInterceptor<T> {
    private final int maxMessageSize;
    private static final Logger logger;
    public static final Companion Companion;

    public boolean intercept(@NotNull T packet, @Nullable RemotingConnection connection2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(packet, (String)"packet");
        Integer n = this.getMessageSize(packet);
        if (n == null) {
            return true;
        }
        int messageSize = n;
        if (messageSize > this.maxMessageSize) {
            RemotingConnection remotingConnection = connection2;
            logger.warn("Message size exceeds maxMessageSize network parameter, maxMessageSize: [" + this.maxMessageSize + "], message size: [" + messageSize + "], " + "dropping message, client id :" + (remotingConnection != null ? remotingConnection.getClientID() : null));
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @Nullable
    public abstract Integer getMessageSize(@Nullable T var1);

    private MessageSizeChecksInterceptor(int maxMessageSize2) {
        this.maxMessageSize = maxMessageSize2;
    }

    static {
        Companion = new Companion(null);
        logger = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    public /* synthetic */ MessageSizeChecksInterceptor(int maxMessageSize2, DefaultConstructorMarker $constructor_marker) {
        this(maxMessageSize2);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/nodeapi/internal/MessageSizeChecksInterceptor$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "node-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

