/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.Crypto;
import net.corda.core.crypto.SecureHash;
import net.corda.core.crypto.SecureHashKt;
import net.corda.core.crypto.SignatureScheme;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.PartyAndCertificate;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.X500UtilsKt;
import net.corda.core.utilities.OpaqueBytes;
import net.corda.nodeapi.internal.DevCaHelper;
import net.corda.nodeapi.internal.config.CertificateStore;
import net.corda.nodeapi.internal.crypto.CertificateAndKeyPair;
import net.corda.nodeapi.internal.crypto.CertificateType;
import net.corda.nodeapi.internal.crypto.X509KeyStore;
import net.corda.nodeapi.internal.crypto.X509Utilities;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0013\u001a\u00020\t2\b\b\u0002\u0010\u0014\u001a\u00020\t\u001a \u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u001a\u0010\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\u0010\u0010\u001f\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a0\u0010 \u001a\u00020!*\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\"\u001a\u00020#2\b\b\u0002\u0010\u0016\u001a\u00020\t2\b\b\u0002\u0010$\u001a\u00020\t\u001a0\u0010%\u001a\u00020!*\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\"\u001a\u00020#2\b\b\u0002\u0010\u0016\u001a\u00020\t2\b\b\u0002\u0010$\u001a\u00020\t\u001a\u001c\u0010&\u001a\u00020'*\u00020\u001c2\u0006\u0010(\u001a\u00020\u00012\b\b\u0002\u0010)\u001a\u00020\u001a\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0011\u0010\u0011\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006*"}, d2={"DEV_CA_KEY_STORE_FILE", "", "DEV_CA_KEY_STORE_PASS", "DEV_CA_PRIVATE_KEY_PASS", "DEV_CA_TRUST_STORE_FILE", "DEV_CA_TRUST_STORE_PASS", "DEV_CA_TRUST_STORE_PRIVATE_KEY_PASS", "DEV_CORDAPP_CODE_SIGNING_STR", "DEV_INTERMEDIATE_CA", "Lnet/corda/nodeapi/internal/crypto/CertificateAndKeyPair;", "getDEV_INTERMEDIATE_CA", "()Lnet/corda/nodeapi/internal/crypto/CertificateAndKeyPair;", "DEV_PUB_KEY_HASHES", "", "Lnet/corda/core/crypto/SecureHash$SHA256;", "getDEV_PUB_KEY_HASHES", "()Ljava/util/List;", "DEV_ROOT_CA", "getDEV_ROOT_CA", "createDevNetworkMapCa", "rootCa", "createDevNodeCa", "intermediateCa", "legalName", "Lnet/corda/core/identity/CordaX500Name;", "nodeKeyPair", "Ljava/security/KeyPair;", "loadDevCaKeyStore", "Lnet/corda/nodeapi/internal/config/CertificateStore;", "classLoader", "Ljava/lang/ClassLoader;", "loadDevCaTrustStore", "installDevNodeCaCertPath", "", "rootCert", "Ljava/security/cert/X509Certificate;", "devNodeCa", "registerDevP2pCertificates", "storeLegalIdentity", "Lnet/corda/core/identity/PartyAndCertificate;", "alias", "keyPair", "node-api"})
public final class KeyStoreConfigHelpersKt {
    @NotNull
    public static final String DEV_CA_PRIVATE_KEY_PASS = "cordacadevkeypass";
    @NotNull
    public static final String DEV_CA_KEY_STORE_FILE = "cordadevcakeys.jks";
    @NotNull
    public static final String DEV_CA_KEY_STORE_PASS = "cordacadevpass";
    @NotNull
    public static final String DEV_CA_TRUST_STORE_FILE = "cordatruststore.jks";
    @NotNull
    public static final String DEV_CA_TRUST_STORE_PASS = "trustpass";
    @NotNull
    public static final String DEV_CA_TRUST_STORE_PRIVATE_KEY_PASS = "trustpasskeypass";
    @NotNull
    public static final String DEV_CORDAPP_CODE_SIGNING_STR = "AA59D829F2CA8FDDF5ABEA40D815F937E3E54E572B65B93B5C216AE6594E7D6B";

    public static final void installDevNodeCaCertPath(@NotNull CertificateStore $receiver, @NotNull CordaX500Name legalName, @NotNull X509Certificate rootCert, @NotNull CertificateAndKeyPair intermediateCa, @NotNull CertificateAndKeyPair devNodeCa) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)legalName, (String)"legalName");
        Intrinsics.checkParameterIsNotNull((Object)rootCert, (String)"rootCert");
        Intrinsics.checkParameterIsNotNull((Object)intermediateCa, (String)"intermediateCa");
        Intrinsics.checkParameterIsNotNull((Object)devNodeCa, (String)"devNodeCa");
        $receiver.update((Function1<? super X509KeyStore, Unit>)((Function1)new Function1<X509KeyStore, Unit>($receiver, devNodeCa, intermediateCa, rootCert){
            final /* synthetic */ CertificateStore receiver$0;
            final /* synthetic */ CertificateAndKeyPair $devNodeCa;
            final /* synthetic */ CertificateAndKeyPair $intermediateCa;
            final /* synthetic */ X509Certificate $rootCert;

            public final void invoke(@NotNull X509KeyStore $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                PrivateKey privateKey2 = this.$devNodeCa.getKeyPair().getPrivate();
                Intrinsics.checkExpressionValueIsNotNull((Object)privateKey2, (String)"devNodeCa.keyPair.private");
                $receiver.setPrivateKey("cordaclientca", privateKey2, CollectionsKt.listOf((Object[])new X509Certificate[]{this.$devNodeCa.getCertificate(), this.$intermediateCa.getCertificate(), this.$rootCert}), this.receiver$0.getEntryPassword());
            }
            {
                this.receiver$0 = certificateStore;
                this.$devNodeCa = certificateAndKeyPair;
                this.$intermediateCa = certificateAndKeyPair2;
                this.$rootCert = x509Certificate;
                super(1);
            }
        }));
    }

    public static /* bridge */ /* synthetic */ void installDevNodeCaCertPath$default(CertificateStore certificateStore, CordaX500Name cordaX500Name, X509Certificate x509Certificate, CertificateAndKeyPair certificateAndKeyPair, CertificateAndKeyPair certificateAndKeyPair2, int n, Object object) {
        if ((n & 2) != 0) {
            x509Certificate = KeyStoreConfigHelpersKt.getDEV_ROOT_CA().getCertificate();
        }
        if ((n & 4) != 0) {
            certificateAndKeyPair = KeyStoreConfigHelpersKt.getDEV_INTERMEDIATE_CA();
        }
        if ((n & 8) != 0) {
            certificateAndKeyPair2 = KeyStoreConfigHelpersKt.createDevNodeCa$default(certificateAndKeyPair, cordaX500Name, null, 4, null);
        }
        KeyStoreConfigHelpersKt.installDevNodeCaCertPath(certificateStore, cordaX500Name, x509Certificate, certificateAndKeyPair, certificateAndKeyPair2);
    }

    public static final void registerDevP2pCertificates(@NotNull CertificateStore $receiver, @NotNull CordaX500Name legalName, @NotNull X509Certificate rootCert, @NotNull CertificateAndKeyPair intermediateCa, @NotNull CertificateAndKeyPair devNodeCa) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)legalName, (String)"legalName");
        Intrinsics.checkParameterIsNotNull((Object)rootCert, (String)"rootCert");
        Intrinsics.checkParameterIsNotNull((Object)intermediateCa, (String)"intermediateCa");
        Intrinsics.checkParameterIsNotNull((Object)devNodeCa, (String)"devNodeCa");
        $receiver.update((Function1<? super X509KeyStore, Unit>)((Function1)new Function1<X509KeyStore, Unit>($receiver, devNodeCa, legalName, intermediateCa, rootCert){
            final /* synthetic */ CertificateStore receiver$0;
            final /* synthetic */ CertificateAndKeyPair $devNodeCa;
            final /* synthetic */ CordaX500Name $legalName;
            final /* synthetic */ CertificateAndKeyPair $intermediateCa;
            final /* synthetic */ X509Certificate $rootCert;

            public final void invoke(@NotNull X509KeyStore $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                KeyPair tlsKeyPair = Crypto.generateKeyPair((SignatureScheme)X509Utilities.INSTANCE.getDEFAULT_TLS_SIGNATURE_SCHEME());
                X509Certificate x509Certificate = this.$devNodeCa.getCertificate();
                KeyPair keyPair = this.$devNodeCa.getKeyPair();
                X500Principal x500Principal = this.$legalName.getX500Principal();
                PublicKey publicKey = tlsKeyPair.getPublic();
                Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"tlsKeyPair.public");
                X509Certificate tlsCert = X509Utilities.createCertificate$default(CertificateType.TLS, x509Certificate, keyPair, x500Principal, publicKey, null, null, null, null, 480, null);
                PrivateKey privateKey2 = tlsKeyPair.getPrivate();
                Intrinsics.checkExpressionValueIsNotNull((Object)privateKey2, (String)"tlsKeyPair.private");
                $receiver.setPrivateKey("cordaclienttls", privateKey2, CollectionsKt.listOf((Object[])new X509Certificate[]{tlsCert, this.$devNodeCa.getCertificate(), this.$intermediateCa.getCertificate(), this.$rootCert}), this.receiver$0.getEntryPassword());
            }
            {
                this.receiver$0 = certificateStore;
                this.$devNodeCa = certificateAndKeyPair;
                this.$legalName = cordaX500Name;
                this.$intermediateCa = certificateAndKeyPair2;
                this.$rootCert = x509Certificate;
                super(1);
            }
        }));
    }

    public static /* bridge */ /* synthetic */ void registerDevP2pCertificates$default(CertificateStore certificateStore, CordaX500Name cordaX500Name, X509Certificate x509Certificate, CertificateAndKeyPair certificateAndKeyPair, CertificateAndKeyPair certificateAndKeyPair2, int n, Object object) {
        if ((n & 2) != 0) {
            x509Certificate = KeyStoreConfigHelpersKt.getDEV_ROOT_CA().getCertificate();
        }
        if ((n & 4) != 0) {
            certificateAndKeyPair = KeyStoreConfigHelpersKt.getDEV_INTERMEDIATE_CA();
        }
        if ((n & 8) != 0) {
            certificateAndKeyPair2 = KeyStoreConfigHelpersKt.createDevNodeCa$default(certificateAndKeyPair, cordaX500Name, null, 4, null);
        }
        KeyStoreConfigHelpersKt.registerDevP2pCertificates(certificateStore, cordaX500Name, x509Certificate, certificateAndKeyPair, certificateAndKeyPair2);
    }

    @NotNull
    public static final PartyAndCertificate storeLegalIdentity(@NotNull CertificateStore $receiver, @NotNull String alias, @NotNull KeyPair keyPair) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
        List identityCertPath2 = (List)$receiver.query((Function1)new Function1<X509KeyStore, List<? extends X509Certificate>>($receiver, keyPair){
            final /* synthetic */ CertificateStore receiver$0;
            final /* synthetic */ KeyPair $keyPair;

            @NotNull
            public final List<X509Certificate> invoke(@NotNull X509KeyStore $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                List<X509Certificate> nodeCaCertPath = $receiver.getCertificateChain("cordaclientca");
                CertificateAndKeyPair nodeCaCertAndKeyPair = $receiver.getCertificateAndKeyPair("cordaclientca", this.receiver$0.getEntryPassword());
                X509Certificate x509Certificate = nodeCaCertAndKeyPair.getCertificate();
                KeyPair keyPair = nodeCaCertAndKeyPair.getKeyPair();
                X500Principal x500Principal = nodeCaCertAndKeyPair.getCertificate().getSubjectX500Principal();
                Intrinsics.checkExpressionValueIsNotNull((Object)x500Principal, (String)"nodeCaCertAndKeyPair.cer\u2026cate.subjectX500Principal");
                PublicKey publicKey = this.$keyPair.getPublic();
                Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.public");
                X509Certificate identityCert = X509Utilities.createCertificate$default(CertificateType.LEGAL_IDENTITY, x509Certificate, keyPair, x500Principal, publicKey, null, null, null, null, 480, null);
                return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)identityCert), (Iterable)nodeCaCertPath);
            }
            {
                this.receiver$0 = certificateStore;
                this.$keyPair = keyPair;
                super(1);
            }
        });
        $receiver.update((Function1<? super X509KeyStore, Unit>)((Function1)new Function1<X509KeyStore, Unit>($receiver, alias, keyPair, identityCertPath2){
            final /* synthetic */ CertificateStore receiver$0;
            final /* synthetic */ String $alias;
            final /* synthetic */ KeyPair $keyPair;
            final /* synthetic */ List $identityCertPath;

            public final void invoke(@NotNull X509KeyStore $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                PrivateKey privateKey2 = this.$keyPair.getPrivate();
                Intrinsics.checkExpressionValueIsNotNull((Object)privateKey2, (String)"keyPair.private");
                $receiver.setPrivateKey(this.$alias, privateKey2, this.$identityCertPath, this.receiver$0.getEntryPassword());
            }
            {
                this.receiver$0 = certificateStore;
                this.$alias = string;
                this.$keyPair = keyPair;
                this.$identityCertPath = list2;
                super(1);
            }
        }));
        return new PartyAndCertificate(X509Utilities.INSTANCE.buildCertPath(identityCertPath2));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ PartyAndCertificate storeLegalIdentity$default(CertificateStore certificateStore, String string, KeyPair keyPair, int n, Object object) {
        if ((n & 2) != 0) {
            keyPair = Crypto.generateKeyPair$default(null, (int)1, null);
        }
        return KeyStoreConfigHelpersKt.storeLegalIdentity(certificateStore, string, keyPair);
    }

    @NotNull
    public static final CertificateAndKeyPair createDevNetworkMapCa(@NotNull CertificateAndKeyPair rootCa) {
        Intrinsics.checkParameterIsNotNull((Object)rootCa, (String)"rootCa");
        KeyPair keyPair = Crypto.generateKeyPair$default(null, (int)1, null);
        X509Certificate x509Certificate = rootCa.getCertificate();
        KeyPair keyPair2 = rootCa.getKeyPair();
        X500Principal x500Principal = new X500Principal("CN=Network Map,O=R3 Ltd,L=London,C=GB");
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.public");
        X509Certificate cert = X509Utilities.createCertificate$default(CertificateType.NETWORK_MAP, x509Certificate, keyPair2, x500Principal, publicKey, null, null, null, null, 480, null);
        return new CertificateAndKeyPair(cert, keyPair);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CertificateAndKeyPair createDevNetworkMapCa$default(CertificateAndKeyPair certificateAndKeyPair, int n, Object object) {
        if ((n & 1) != 0) {
            certificateAndKeyPair = KeyStoreConfigHelpersKt.getDEV_ROOT_CA();
        }
        return KeyStoreConfigHelpersKt.createDevNetworkMapCa(certificateAndKeyPair);
    }

    @NotNull
    public static final CertificateAndKeyPair createDevNodeCa(@NotNull CertificateAndKeyPair intermediateCa, @NotNull CordaX500Name legalName, @NotNull KeyPair nodeKeyPair) {
        Intrinsics.checkParameterIsNotNull((Object)intermediateCa, (String)"intermediateCa");
        Intrinsics.checkParameterIsNotNull((Object)legalName, (String)"legalName");
        Intrinsics.checkParameterIsNotNull((Object)nodeKeyPair, (String)"nodeKeyPair");
        NameConstraints nameConstraints = new NameConstraints(new GeneralSubtree[]{new GeneralSubtree(new GeneralName(4, (ASN1Encodable)X500UtilsKt.toX500Name((CordaX500Name)legalName)))}, new GeneralSubtree[0]);
        X509Certificate x509Certificate = intermediateCa.getCertificate();
        KeyPair keyPair = intermediateCa.getKeyPair();
        X500Principal x500Principal = legalName.getX500Principal();
        PublicKey publicKey = nodeKeyPair.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"nodeKeyPair.public");
        X509Certificate cert = X509Utilities.createCertificate$default(CertificateType.NODE_CA, x509Certificate, keyPair, x500Principal, publicKey, null, nameConstraints, null, null, 416, null);
        return new CertificateAndKeyPair(cert, nodeKeyPair);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CertificateAndKeyPair createDevNodeCa$default(CertificateAndKeyPair certificateAndKeyPair, CordaX500Name cordaX500Name, KeyPair keyPair, int n, Object object) {
        if ((n & 4) != 0) {
            keyPair = Crypto.generateKeyPair((SignatureScheme)X509Utilities.INSTANCE.getDEFAULT_TLS_SIGNATURE_SCHEME());
        }
        return KeyStoreConfigHelpersKt.createDevNodeCa(certificateAndKeyPair, cordaX500Name, keyPair);
    }

    @NotNull
    public static final CertificateAndKeyPair getDEV_INTERMEDIATE_CA() {
        return DevCaHelper.INSTANCE.loadDevCa("cordaintermediateca");
    }

    @NotNull
    public static final CertificateAndKeyPair getDEV_ROOT_CA() {
        return DevCaHelper.INSTANCE.loadDevCa("cordarootca");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SecureHash.SHA256> getDEV_PUB_KEY_HASHES() {
        void var2_2;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.listOf((Object[])new X509Certificate[]{KeyStoreConfigHelpersKt.getDEV_INTERMEDIATE_CA().getCertificate(), KeyStoreConfigHelpersKt.getDEV_ROOT_CA().getCertificate()});
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            X509Certificate x509Certificate = (X509Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            PublicKey publicKey = it.getPublicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"it.publicKey");
            SecureHash.SHA256 sHA256 = SecureHashKt.sha256((OpaqueBytes)((OpaqueBytes)InternalUtils.getHash((PublicKey)publicKey)));
            collection.add(sHA256);
        }
        return CollectionsKt.plus((Collection)((List)var2_2), (Object)SecureHashKt.sha256((OpaqueBytes)((OpaqueBytes)SecureHash.Companion.parse(DEV_CORDAPP_CODE_SIGNING_STR))));
    }

    @NotNull
    public static final CertificateStore loadDevCaKeyStore(@NotNull ClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        return CertificateStore.Companion.fromResource("certificates/cordadevcakeys.jks", DEV_CA_KEY_STORE_PASS, DEV_CA_PRIVATE_KEY_PASS, classLoader);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CertificateStore loadDevCaKeyStore$default(ClassLoader classLoader, int n, Object object) {
        if ((n & 1) != 0) {
            ClassLoader classLoader2 = DevCaHelper.class.getClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"DevCaHelper::class.java.classLoader");
            classLoader = classLoader2;
        }
        return KeyStoreConfigHelpersKt.loadDevCaKeyStore(classLoader);
    }

    @NotNull
    public static final CertificateStore loadDevCaTrustStore(@NotNull ClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        return CertificateStore.Companion.fromResource("certificates/cordatruststore.jks", DEV_CA_TRUST_STORE_PASS, DEV_CA_TRUST_STORE_PRIVATE_KEY_PASS, classLoader);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CertificateStore loadDevCaTrustStore$default(ClassLoader classLoader, int n, Object object) {
        if ((n & 1) != 0) {
            ClassLoader classLoader2 = DevCaHelper.class.getClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"DevCaHelper::class.java.classLoader");
            classLoader = classLoader2;
        }
        return KeyStoreConfigHelpersKt.loadDevCaTrustStore(classLoader);
    }
}

