/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.corda.core.contracts.Contract;
import net.corda.core.contracts.UpgradedContract;
import net.corda.core.contracts.UpgradedContractWithLegacyConstraint;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.PathUtilsKt;
import net.corda.nodeapi.internal.ContractsJarFile;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a=\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\"\u0010\r\u001a\u001e\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u000f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002H\n0\u000e\u00a2\u0006\u0002\u0010\u0012\"\u001f\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"coreContractClasses", "", "Lkotlin/reflect/KClass;", "Lnet/corda/core/contracts/Contract;", "getCoreContractClasses", "()Ljava/util/Set;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "withContractsInJar", "T", "jarInputStream", "Ljava/io/InputStream;", "withContracts", "Lkotlin/Function2;", "", "", "Lnet/corda/core/contracts/ContractClassName;", "(Ljava/io/InputStream;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "node-api"})
public final class ContractsScanningKt {
    @NotNull
    private static final Set<KClass<? extends Contract>> coreContractClasses = SetsKt.setOf((Object[])new KClass[]{Reflection.getOrCreateKotlinClass(Contract.class), Reflection.getOrCreateKotlinClass(UpgradedContractWithLegacyConstraint.class), Reflection.getOrCreateKotlinClass(UpgradedContract.class)});
    private static final Logger logger = LoggerFactory.getLogger((String)"ClassloaderUtils");

    @NotNull
    public static final Set<KClass<? extends Contract>> getCoreContractClasses() {
        return coreContractClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final <T> T withContractsInJar(@NotNull InputStream jarInputStream, @NotNull Function2<? super List<String>, ? super InputStream, ? extends T> withContracts) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)jarInputStream, (String)"jarInputStream");
        Intrinsics.checkParameterIsNotNull(withContracts, (String)"withContracts");
        Path tempFile = Files.createTempFile("attachment", ".jar", new FileAttribute[0]);
        try {
            Object object2;
            void $receiver$iv;
            Closeable closeable = jarInputStream;
            Throwable throwable = null;
            try {
                InputStream it22 = (InputStream)closeable;
                Path path = tempFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"tempFile");
                long it22 = InternalUtils.copyTo((InputStream)it22, (Path)path, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            }
            catch (Throwable it22) {
                throwable = it22;
                throw it22;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Path cordappJar = tempFile.toAbsolutePath();
            List contracts2 = (List)InternalUtils.logElapsedTime((String)("Contracts loading for '" + cordappJar + '\''), (Logger)logger, (Function0)((Function0)new Function0<List<? extends String>>(tempFile){
                final /* synthetic */ Path $tempFile;

                @NotNull
                public final List<String> invoke() {
                    Path path = this.$tempFile.toAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"tempFile.toAbsolutePath()");
                    return new ContractsJarFile(path).scan();
                }
                {
                    this.$tempFile = path;
                    super(0);
                }
            }));
            Path it22 = tempFile;
            OpenOption[] options$iv = new OpenOption[]{};
            Closeable closeable2 = PathUtilsKt.inputStream((Path)$receiver$iv, (OpenOption[])Arrays.copyOf(options$iv, options$iv.length));
            Throwable throwable2 = null;
            try {
                InputStream it = (InputStream)closeable2;
                object2 = withContracts.invoke((Object)contracts2, (Object)it);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            object = object2;
        }
        catch (Throwable throwable) {
            Path path = tempFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"tempFile");
            PathUtilsKt.deleteIfExists((Path)path);
            throw throwable;
        }
        PathUtilsKt.deleteIfExists((Path)tempFile);
        return (T)object;
    }
}

