/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0006\u00a8\u0006\u0007"}, d2={"requireMessageSize", "", "messageSize", "", "limit", "requireOnDefaultFileSystem", "Ljava/nio/file/Path;", "node-api"})
@JvmName(name="ArtemisUtils")
public final class ArtemisUtils {
    public static final void requireOnDefaultFileSystem(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = Intrinsics.areEqual((Object)$receiver.getFileSystem(), (Object)FileSystems.getDefault());
        if (!bl) {
            String string = "Artemis only uses the default file system";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public static final void requireMessageSize(int messageSize, int limit) {
        boolean bl;
        boolean bl2 = bl = messageSize <= limit;
        if (!bl) {
            String string = "Message exceeds maxMessageSize network parameter, maxMessageSize: [" + limit + "], message size: [" + messageSize + ']';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }
}

