/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.nodeapi.internal.MessageSizeChecksInterceptor;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacket;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lnet/corda/nodeapi/internal/ArtemisMessageSizeChecksInterceptor;", "Lnet/corda/nodeapi/internal/MessageSizeChecksInterceptor;", "Lorg/apache/activemq/artemis/core/protocol/core/Packet;", "Lorg/apache/activemq/artemis/api/core/Interceptor;", "maxMessageSize", "", "(I)V", "getMessageSize", "packet", "(Lorg/apache/activemq/artemis/core/protocol/core/Packet;)Ljava/lang/Integer;", "node-api"})
public final class ArtemisMessageSizeChecksInterceptor
extends MessageSizeChecksInterceptor<Packet>
implements Interceptor {
    @Override
    @Nullable
    public Integer getMessageSize(@Nullable Packet packet) {
        Integer n;
        Packet packet2 = packet;
        if (packet2 instanceof MessagePacket) {
            ICoreMessage iCoreMessage = ((MessagePacket)packet).getMessage();
            Intrinsics.checkExpressionValueIsNotNull((Object)iCoreMessage, (String)"packet.message");
            long l = iCoreMessage.getPersistentSize();
            ICoreMessage iCoreMessage2 = ((MessagePacket)packet).getMessage();
            Intrinsics.checkExpressionValueIsNotNull((Object)iCoreMessage2, (String)"packet.message");
            n = (int)(l - (long)iCoreMessage2.getHeadersAndPropertiesEncodeSize() - (long)4);
        } else {
            n = null;
        }
        return n;
    }

    public ArtemisMessageSizeChecksInterceptor(int maxMessageSize2) {
        super(maxMessageSize2, null);
    }
}

