/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.context.Actor;
import net.corda.core.context.AuthServiceId;
import net.corda.core.context.Trace;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.utilities.Id;
import net.corda.nodeapi.RPCApiKt;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013\u001ai\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\f\b\u0000\u0010\u0015*\u0006\u0012\u0002\b\u00030\u0016*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u000126\u0010\u0019\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u0002H\u00150\u001aH\u0002\u00a2\u0006\u0002\u0010 \u001a\f\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u0013\u001a\u001e\u0010#\u001a\u0004\u0018\u00010$*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0002\u001a4\u0010%\u001a\u00020\u0012*\u00020\u00122\u0006\u0010&\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0001H\u0002\u001a\u0014\u0010%\u001a\u00020)*\u00020$2\u0006\u0010&\u001a\u00020\u0013H\u0002\u001a\u0014\u0010%\u001a\u00020)*\u00020*2\u0006\u0010&\u001a\u00020\u0013H\u0002\u001a*\u0010%\u001a\u00020)*\b\u0012\u0004\u0012\u00020\u00010\u00162\u0006\u0010&\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0002\u001a\u0014\u0010+\u001a\u00020\u0012*\u00020\u00122\u0006\u0010&\u001a\u00020\u0013H\u0002\u001a\u0014\u0010,\u001a\u00020)*\u00020\"2\u0006\u0010&\u001a\u00020\u0013H\u0002\u001a\f\u0010-\u001a\u00020$*\u00020.H\u0002\u001a\n\u0010/\u001a\u00020$*\u00020\u0013\u001a\n\u00100\u001a\u00020**\u00020\u0013\u001a\u001e\u00100\u001a\u0004\u0018\u00010**\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0002\u001a\u0014\u00101\u001a\u00020)*\u00020.2\u0006\u0010#\u001a\u00020$H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"DEDUPLICATION_IDENTITY_FIELD_NAME", "", "METHOD_NAME_FIELD_NAME", "OBSERVABLE_ID_FIELD_NAME", "OBSERVABLE_ID_TIMESTAMP_FIELD_NAME", "RPC_EXTERNAL_ID_FIELD_NAME", "RPC_EXTERNAL_ID_TIMESTAMP_FIELD_NAME", "RPC_EXTERNAL_SESSION_ID_FIELD_NAME", "RPC_EXTERNAL_SESSION_ID_TIMESTAMP_FIELD_NAME", "RPC_ID_FIELD_NAME", "RPC_ID_TIMESTAMP_FIELD_NAME", "RPC_IMPERSONATED_ACTOR_ID", "RPC_IMPERSONATED_ACTOR_OWNING_LEGAL_IDENTITY", "RPC_IMPERSONATED_ACTOR_STORE_ID", "RPC_SESSION_ID_FIELD_NAME", "RPC_SESSION_ID_TIMESTAMP_FIELD_NAME", "TAG_FIELD_NAME", "externalTrace", "Lnet/corda/core/context/Trace;", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "id", "ID", "Lnet/corda/core/utilities/Id;", "valueProperty", "timestampProperty", "construct", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "value", "Ljava/time/Instant;", "timestamp", "(Lorg/apache/activemq/artemis/api/core/client/ClientMessage;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Lnet/corda/core/utilities/Id;", "impersonatedActor", "Lnet/corda/core/context/Actor;", "invocationId", "Lnet/corda/core/context/Trace$InvocationId;", "mapTo", "message", "sessionValueProperty", "sessionTimestampProperty", "", "Lnet/corda/core/context/Trace$SessionId;", "mapToExternal", "mapToImpersonated", "readInvocationId", "Lorg/apache/activemq/artemis/api/core/ActiveMQBuffer;", "replyId", "sessionId", "writeInvocationId", "node-api"})
public final class RPCApiKt {
    private static final String TAG_FIELD_NAME = "tag";
    private static final String RPC_ID_FIELD_NAME = "rpc-id";
    private static final String RPC_ID_TIMESTAMP_FIELD_NAME = "rpc-id-timestamp";
    private static final String RPC_SESSION_ID_FIELD_NAME = "rpc-session-id";
    private static final String RPC_SESSION_ID_TIMESTAMP_FIELD_NAME = "rpc-session-id-timestamp";
    private static final String RPC_EXTERNAL_ID_FIELD_NAME = "rpc-external-id";
    private static final String RPC_EXTERNAL_ID_TIMESTAMP_FIELD_NAME = "rpc-external-id-timestamp";
    private static final String RPC_EXTERNAL_SESSION_ID_FIELD_NAME = "rpc-external-session-id";
    private static final String RPC_EXTERNAL_SESSION_ID_TIMESTAMP_FIELD_NAME = "rpc-external-session-id-timestamp";
    private static final String RPC_IMPERSONATED_ACTOR_ID = "rpc-impersonated-actor-id";
    private static final String RPC_IMPERSONATED_ACTOR_STORE_ID = "rpc-impersonated-actor-store-id";
    private static final String RPC_IMPERSONATED_ACTOR_OWNING_LEGAL_IDENTITY = "rpc-impersonated-actor-owningLegalIdentity";
    private static final String DEDUPLICATION_IDENTITY_FIELD_NAME = "deduplication-identity";
    private static final String OBSERVABLE_ID_FIELD_NAME = "observable-id";
    private static final String OBSERVABLE_ID_TIMESTAMP_FIELD_NAME = "observable-id-timestamp";
    private static final String METHOD_NAME_FIELD_NAME = "method-name";

    @NotNull
    public static final Trace.InvocationId replyId(@NotNull ClientMessage $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Trace.InvocationId invocationId2 = RPCApiKt.invocationId($receiver, RPC_ID_FIELD_NAME, RPC_ID_TIMESTAMP_FIELD_NAME);
        if (invocationId2 == null) {
            throw (Throwable)new IllegalStateException("Cannot extract reply id from client message.");
        }
        return invocationId2;
    }

    @NotNull
    public static final Trace.SessionId sessionId(@NotNull ClientMessage $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Trace.SessionId sessionId2 = RPCApiKt.sessionId($receiver, RPC_SESSION_ID_FIELD_NAME, RPC_SESSION_ID_TIMESTAMP_FIELD_NAME);
        if (sessionId2 == null) {
            throw (Throwable)new IllegalStateException("Cannot extract the session id from client message.");
        }
        return sessionId2;
    }

    @Nullable
    public static final Trace externalTrace(@NotNull ClientMessage $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Trace.InvocationId invocationId2 = RPCApiKt.invocationId($receiver, RPC_EXTERNAL_ID_FIELD_NAME, RPC_EXTERNAL_ID_TIMESTAMP_FIELD_NAME);
        Trace.SessionId sessionId2 = RPCApiKt.sessionId($receiver, RPC_EXTERNAL_SESSION_ID_FIELD_NAME, RPC_EXTERNAL_SESSION_ID_TIMESTAMP_FIELD_NAME);
        return invocationId2 == null || sessionId2 == null ? null : new Trace(invocationId2, sessionId2);
    }

    @Nullable
    public static final Actor impersonatedActor(@NotNull ClientMessage $receiver) {
        Actor actor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getStringProperty(RPC_IMPERSONATED_ACTOR_ID);
        if (string != null) {
            String string2;
            String it = string2 = string;
            String impersonatedStoreId = $receiver.getStringProperty(RPC_IMPERSONATED_ACTOR_STORE_ID);
            String impersonatingOwningLegalIdentity = $receiver.getStringProperty(RPC_IMPERSONATED_ACTOR_OWNING_LEGAL_IDENTITY);
            if (impersonatedStoreId == null || impersonatingOwningLegalIdentity == null) {
                throw (Throwable)new IllegalStateException("Cannot extract impersonated actor from client message.");
            }
            actor = new Actor(new Actor.Id(it), new AuthServiceId(impersonatedStoreId), CordaX500Name.Companion.parse(impersonatingOwningLegalIdentity));
        } else {
            actor = null;
        }
        return actor;
    }

    private static final void mapTo(@NotNull Id<String> $receiver, ClientMessage message, String valueProperty, String timestampProperty) {
        message.putStringProperty(valueProperty, (String)$receiver.getValue());
        message.putLongProperty(timestampProperty, $receiver.getTimestamp().toEpochMilli());
    }

    private static final void writeInvocationId(@NotNull ActiveMQBuffer $receiver, Trace.InvocationId invocationId2) {
        $receiver.writeString((String)invocationId2.getValue());
        $receiver.writeLong(invocationId2.getTimestamp().toEpochMilli());
    }

    private static final Trace.InvocationId readInvocationId(@NotNull ActiveMQBuffer $receiver) {
        String value = $receiver.readString();
        long timestamp = $receiver.readLong();
        String string = value;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
        Instant instant = Instant.ofEpochMilli(timestamp);
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.ofEpochMilli(timestamp)");
        return new Trace.InvocationId(string, instant);
    }

    private static final void mapTo(@NotNull Trace.InvocationId $receiver, ClientMessage message) {
        RPCApiKt.mapTo((Id<String>)((Id)$receiver), message, RPC_ID_FIELD_NAME, RPC_ID_TIMESTAMP_FIELD_NAME);
    }

    private static final void mapTo(@NotNull Trace.SessionId $receiver, ClientMessage message) {
        RPCApiKt.mapTo((Id<String>)((Id)$receiver), message, RPC_SESSION_ID_FIELD_NAME, RPC_SESSION_ID_TIMESTAMP_FIELD_NAME);
    }

    private static final Trace mapToExternal(@NotNull Trace $receiver, ClientMessage message) {
        return RPCApiKt.mapTo($receiver, message, RPC_EXTERNAL_ID_FIELD_NAME, RPC_EXTERNAL_ID_TIMESTAMP_FIELD_NAME, RPC_EXTERNAL_SESSION_ID_FIELD_NAME, RPC_EXTERNAL_SESSION_ID_TIMESTAMP_FIELD_NAME);
    }

    private static final void mapToImpersonated(@NotNull Actor $receiver, ClientMessage message) {
        message.putStringProperty(RPC_IMPERSONATED_ACTOR_ID, $receiver.getId().getValue());
        message.putStringProperty(RPC_IMPERSONATED_ACTOR_STORE_ID, $receiver.getServiceId().getValue());
        message.putStringProperty(RPC_IMPERSONATED_ACTOR_OWNING_LEGAL_IDENTITY, $receiver.getOwningLegalIdentity().toString());
    }

    private static final Trace mapTo(@NotNull Trace $receiver, ClientMessage message, String valueProperty, String timestampProperty, String sessionValueProperty, String sessionTimestampProperty) {
        Trace.InvocationId invocationId2;
        Trace trace;
        Trace $receiver2 = trace = $receiver;
        Trace.InvocationId $receiver3 = invocationId2 = $receiver2.getInvocationId();
        message.putStringProperty(valueProperty, (String)$receiver3.getValue());
        message.putLongProperty(timestampProperty, $receiver3.getTimestamp().toEpochMilli());
        $receiver3 = invocationId2 = $receiver2.getSessionId();
        message.putStringProperty(sessionValueProperty, (String)$receiver3.getValue());
        message.putLongProperty(sessionTimestampProperty, $receiver3.getTimestamp().toEpochMilli());
        return trace;
    }

    private static final Trace.InvocationId invocationId(@NotNull ClientMessage $receiver, String valueProperty, String timestampProperty) {
        return (Trace.InvocationId)RPCApiKt.id($receiver, valueProperty, timestampProperty, invocationId.1.INSTANCE);
    }

    private static final Trace.SessionId sessionId(@NotNull ClientMessage $receiver, String valueProperty, String timestampProperty) {
        return (Trace.SessionId)RPCApiKt.id($receiver, valueProperty, timestampProperty, sessionId.1.INSTANCE);
    }

    private static final <ID extends Id<?>> ID id(@NotNull ClientMessage $receiver, String valueProperty, String timestampProperty, Function2<? super String, ? super Instant, ? extends ID> construct) {
        Long timestampRaw;
        String string = $receiver.getStringProperty(valueProperty);
        if (string == null) {
            return null;
        }
        String idRaw = string;
        Long l = timestampRaw = $receiver.getLongProperty(timestampProperty);
        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"timestampRaw");
        Instant instant = Instant.ofEpochMilli(l);
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.ofEpochMilli(timestampRaw)");
        return (ID)((Id)construct.invoke((Object)idRaw, (Object)instant));
    }

    public static final /* synthetic */ void access$mapTo(@NotNull Trace.InvocationId $receiver, @NotNull ClientMessage message) {
        RPCApiKt.mapTo($receiver, message);
    }

    public static final /* synthetic */ void access$mapTo(@NotNull Trace.SessionId $receiver, @NotNull ClientMessage message) {
        RPCApiKt.mapTo($receiver, message);
    }

    @NotNull
    public static final /* synthetic */ Trace access$mapToExternal(@NotNull Trace $receiver, @NotNull ClientMessage message) {
        return RPCApiKt.mapToExternal($receiver, message);
    }

    public static final /* synthetic */ void access$mapToImpersonated(@NotNull Actor $receiver, @NotNull ClientMessage message) {
        RPCApiKt.mapToImpersonated($receiver, message);
    }

    public static final /* synthetic */ void access$writeInvocationId(@NotNull ActiveMQBuffer $receiver, @NotNull Trace.InvocationId invocationId2) {
        RPCApiKt.writeInvocationId($receiver, invocationId2);
    }

    @NotNull
    public static final /* synthetic */ Trace.InvocationId access$readInvocationId(@NotNull ActiveMQBuffer $receiver) {
        return RPCApiKt.readInvocationId($receiver);
    }

    public static final /* synthetic */ void access$mapTo(@NotNull Id $receiver, @NotNull ClientMessage message, @NotNull String valueProperty, @NotNull String timestampProperty) {
        RPCApiKt.mapTo((Id<String>)$receiver, message, valueProperty, timestampProperty);
    }

    @Nullable
    public static final /* synthetic */ Trace.InvocationId access$invocationId(@NotNull ClientMessage $receiver, @NotNull String valueProperty, @NotNull String timestampProperty) {
        return RPCApiKt.invocationId($receiver, valueProperty, timestampProperty);
    }
}

