/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.context.Actor;
import net.corda.core.context.Trace;
import net.corda.core.serialization.SerializationAPIKt;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationFactory;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteArrays;
import net.corda.core.utilities.ByteSequence;
import net.corda.core.utilities.Id;
import net.corda.core.utilities.OpaqueBytes;
import net.corda.core.utilities.Try;
import net.corda.nodeapi.RPCApi;
import net.corda.nodeapi.RPCApi$ClientToServer$Companion$WhenMappings;
import net.corda.nodeapi.RPCApi$ServerToClient$Companion$WhenMappings;
import net.corda.nodeapi.RPCApiKt;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rx.Notification;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/corda/nodeapi/RPCApi;", "", "()V", "CLASS_METHOD_DIVIDER", "", "DEDUPLICATION_SEQUENCE_NUMBER_FIELD_NAME", "RPC_CLIENT_BINDING_ADDITIONS", "RPC_CLIENT_BINDING_ADDITION_FILTER_EXPRESSION", "getRPC_CLIENT_BINDING_ADDITION_FILTER_EXPRESSION", "()Ljava/lang/String;", "RPC_CLIENT_BINDING_REMOVALS", "RPC_CLIENT_BINDING_REMOVAL_FILTER_EXPRESSION", "getRPC_CLIENT_BINDING_REMOVAL_FILTER_EXPRESSION", "RPC_CLIENT_QUEUE_NAME_PREFIX", "RPC_SERVER_QUEUE_NAME", "RPC_TARGET_LEGAL_IDENTITY", "getBodyAsByteArray", "", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "ClientToServer", "RpcRequestOrObservableIdKey", "ServerToClient", "node-api"})
public final class RPCApi {
    @NotNull
    public static final String RPC_SERVER_QUEUE_NAME = "rpc.server";
    @NotNull
    public static final String RPC_CLIENT_QUEUE_NAME_PREFIX = "rpc.client";
    @NotNull
    public static final String RPC_CLIENT_BINDING_REMOVALS = "rpc.clientqueueremovals";
    @NotNull
    public static final String RPC_CLIENT_BINDING_ADDITIONS = "rpc.clientqueueadditions";
    @NotNull
    public static final String RPC_TARGET_LEGAL_IDENTITY = "rpc-target-legal-identity";
    @NotNull
    public static final String DEDUPLICATION_SEQUENCE_NUMBER_FIELD_NAME = "deduplication-sequence-number";
    @NotNull
    public static final String CLASS_METHOD_DIVIDER = "#";
    @NotNull
    private static final String RPC_CLIENT_BINDING_REMOVAL_FILTER_EXPRESSION;
    @NotNull
    private static final String RPC_CLIENT_BINDING_ADDITION_FILTER_EXPRESSION;
    public static final RPCApi INSTANCE;

    @NotNull
    public final String getRPC_CLIENT_BINDING_REMOVAL_FILTER_EXPRESSION() {
        return RPC_CLIENT_BINDING_REMOVAL_FILTER_EXPRESSION;
    }

    @NotNull
    public final String getRPC_CLIENT_BINDING_ADDITION_FILTER_EXPRESSION() {
        return RPC_CLIENT_BINDING_ADDITION_FILTER_EXPRESSION;
    }

    private final byte[] getBodyAsByteArray(@NotNull ClientMessage $receiver) {
        byte[] byArray;
        byte[] $receiver2 = byArray = new byte[$receiver.getBodySize()];
        $receiver.getBodyBuffer().readBytes($receiver2);
        return byArray;
    }

    private RPCApi() {
    }

    static {
        RPCApi rPCApi;
        INSTANCE = rPCApi = new RPCApi();
        RPC_CLIENT_BINDING_REMOVAL_FILTER_EXPRESSION = ManagementHelper.HDR_NOTIFICATION_TYPE + " = '" + CoreNotificationType.BINDING_REMOVED.name() + "' AND " + ManagementHelper.HDR_ROUTING_NAME + " LIKE 'rpc.client.%'";
        RPC_CLIENT_BINDING_ADDITION_FILTER_EXPRESSION = ManagementHelper.HDR_NOTIFICATION_TYPE + " = '" + CoreNotificationType.BINDING_ADDED.name() + "' AND " + ManagementHelper.HDR_ROUTING_NAME + " LIKE 'rpc.client.%'";
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/nodeapi/RPCApi$RpcRequestOrObservableIdKey;", "", "()V", "node-api"})
    public static final class RpcRequestOrObservableIdKey {
        public static final RpcRequestOrObservableIdKey INSTANCE;

        private RpcRequestOrObservableIdKey() {
        }

        static {
            RpcRequestOrObservableIdKey rpcRequestOrObservableIdKey;
            INSTANCE = rpcRequestOrObservableIdKey = new RpcRequestOrObservableIdKey();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00072\u00020\u0001:\u0004\u0007\b\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lnet/corda/nodeapi/RPCApi$ClientToServer;", "", "()V", "writeToClientMessage", "", "message", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "Companion", "ObservablesClosed", "RpcRequest", "Tag", "Lnet/corda/nodeapi/RPCApi$ClientToServer$RpcRequest;", "Lnet/corda/nodeapi/RPCApi$ClientToServer$ObservablesClosed;", "node-api"})
    public static abstract class ClientToServer {
        public static final Companion Companion = new Companion(null);

        public abstract void writeToClientMessage(@NotNull ClientMessage var1);

        private ClientToServer() {
        }

        public /* synthetic */ ClientToServer(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/nodeapi/RPCApi$ClientToServer$Tag;", "", "(Ljava/lang/String;I)V", "RPC_REQUEST", "OBSERVABLES_CLOSED", "node-api"})
        private static final class Tag
        extends Enum<Tag> {
            public static final /* enum */ Tag RPC_REQUEST;
            public static final /* enum */ Tag OBSERVABLES_CLOSED;
            private static final /* synthetic */ Tag[] $VALUES;

            static {
                Tag[] tagArray = new Tag[2];
                Tag[] tagArray2 = tagArray;
                tagArray[0] = RPC_REQUEST = new Tag();
                tagArray[1] = OBSERVABLES_CLOSED = new Tag();
                $VALUES = tagArray;
            }

            public static Tag[] values() {
                return (Tag[])$VALUES.clone();
            }

            public static Tag valueOf(String string) {
                return Enum.valueOf(Tag.class, string);
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003JS\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0005H\u00d6\u0001J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00062"}, d2={"Lnet/corda/nodeapi/RPCApi$ClientToServer$RpcRequest;", "Lnet/corda/nodeapi/RPCApi$ClientToServer;", "clientAddress", "Lorg/apache/activemq/artemis/api/core/SimpleString;", "methodName", "", "serialisedArguments", "Lnet/corda/core/utilities/OpaqueBytes;", "replyId", "Lnet/corda/core/context/Trace$InvocationId;", "sessionId", "Lnet/corda/core/context/Trace$SessionId;", "externalTrace", "Lnet/corda/core/context/Trace;", "impersonatedActor", "Lnet/corda/core/context/Actor;", "(Lorg/apache/activemq/artemis/api/core/SimpleString;Ljava/lang/String;Lnet/corda/core/utilities/OpaqueBytes;Lnet/corda/core/context/Trace$InvocationId;Lnet/corda/core/context/Trace$SessionId;Lnet/corda/core/context/Trace;Lnet/corda/core/context/Actor;)V", "getClientAddress", "()Lorg/apache/activemq/artemis/api/core/SimpleString;", "getExternalTrace", "()Lnet/corda/core/context/Trace;", "getImpersonatedActor", "()Lnet/corda/core/context/Actor;", "getMethodName", "()Ljava/lang/String;", "getReplyId", "()Lnet/corda/core/context/Trace$InvocationId;", "getSerialisedArguments", "()Lnet/corda/core/utilities/OpaqueBytes;", "getSessionId", "()Lnet/corda/core/context/Trace$SessionId;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "", "toString", "writeToClientMessage", "", "message", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "node-api"})
        public static final class RpcRequest
        extends ClientToServer {
            @NotNull
            private final SimpleString clientAddress;
            @NotNull
            private final String methodName;
            @NotNull
            private final OpaqueBytes serialisedArguments;
            @NotNull
            private final Trace.InvocationId replyId;
            @NotNull
            private final Trace.SessionId sessionId;
            @Nullable
            private final Trace externalTrace;
            @Nullable
            private final Actor impersonatedActor;

            @Override
            public void writeToClientMessage(@NotNull ClientMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                MessageUtil.setJMSReplyTo((Message)((Message)message), (SimpleString)this.clientAddress);
                message.putIntProperty("tag", Tag.RPC_REQUEST.ordinal());
                RPCApiKt.access$mapTo(this.replyId, message);
                RPCApiKt.access$mapTo(this.sessionId, message);
                Trace trace = this.externalTrace;
                if (trace != null) {
                    RPCApiKt.access$mapToExternal(trace, message);
                }
                Actor actor = this.impersonatedActor;
                if (actor != null) {
                    RPCApiKt.access$mapToImpersonated(actor, message);
                }
                message.putStringProperty("method-name", this.methodName);
                message.getBodyBuffer().writeBytes(this.serialisedArguments.getBytes());
            }

            @NotNull
            public final SimpleString getClientAddress() {
                return this.clientAddress;
            }

            @NotNull
            public final String getMethodName() {
                return this.methodName;
            }

            @NotNull
            public final OpaqueBytes getSerialisedArguments() {
                return this.serialisedArguments;
            }

            @NotNull
            public final Trace.InvocationId getReplyId() {
                return this.replyId;
            }

            @NotNull
            public final Trace.SessionId getSessionId() {
                return this.sessionId;
            }

            @Nullable
            public final Trace getExternalTrace() {
                return this.externalTrace;
            }

            @Nullable
            public final Actor getImpersonatedActor() {
                return this.impersonatedActor;
            }

            public RpcRequest(@NotNull SimpleString clientAddress, @NotNull String methodName, @NotNull OpaqueBytes serialisedArguments, @NotNull Trace.InvocationId replyId, @NotNull Trace.SessionId sessionId2, @Nullable Trace externalTrace, @Nullable Actor impersonatedActor) {
                Intrinsics.checkParameterIsNotNull((Object)clientAddress, (String)"clientAddress");
                Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
                Intrinsics.checkParameterIsNotNull((Object)serialisedArguments, (String)"serialisedArguments");
                Intrinsics.checkParameterIsNotNull((Object)replyId, (String)"replyId");
                Intrinsics.checkParameterIsNotNull((Object)sessionId2, (String)"sessionId");
                super(null);
                this.clientAddress = clientAddress;
                this.methodName = methodName;
                this.serialisedArguments = serialisedArguments;
                this.replyId = replyId;
                this.sessionId = sessionId2;
                this.externalTrace = externalTrace;
                this.impersonatedActor = impersonatedActor;
            }

            public /* synthetic */ RpcRequest(SimpleString simpleString, String string, OpaqueBytes opaqueBytes, Trace.InvocationId invocationId2, Trace.SessionId sessionId2, Trace trace, Actor actor, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 0x20) != 0) {
                    trace = null;
                }
                if ((n & 0x40) != 0) {
                    actor = null;
                }
                this(simpleString, string, opaqueBytes, invocationId2, sessionId2, trace, actor);
            }

            @NotNull
            public final SimpleString component1() {
                return this.clientAddress;
            }

            @NotNull
            public final String component2() {
                return this.methodName;
            }

            @NotNull
            public final OpaqueBytes component3() {
                return this.serialisedArguments;
            }

            @NotNull
            public final Trace.InvocationId component4() {
                return this.replyId;
            }

            @NotNull
            public final Trace.SessionId component5() {
                return this.sessionId;
            }

            @Nullable
            public final Trace component6() {
                return this.externalTrace;
            }

            @Nullable
            public final Actor component7() {
                return this.impersonatedActor;
            }

            @NotNull
            public final RpcRequest copy(@NotNull SimpleString clientAddress, @NotNull String methodName, @NotNull OpaqueBytes serialisedArguments, @NotNull Trace.InvocationId replyId, @NotNull Trace.SessionId sessionId2, @Nullable Trace externalTrace, @Nullable Actor impersonatedActor) {
                Intrinsics.checkParameterIsNotNull((Object)clientAddress, (String)"clientAddress");
                Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
                Intrinsics.checkParameterIsNotNull((Object)serialisedArguments, (String)"serialisedArguments");
                Intrinsics.checkParameterIsNotNull((Object)replyId, (String)"replyId");
                Intrinsics.checkParameterIsNotNull((Object)sessionId2, (String)"sessionId");
                return new RpcRequest(clientAddress, methodName, serialisedArguments, replyId, sessionId2, externalTrace, impersonatedActor);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ RpcRequest copy$default(RpcRequest rpcRequest, SimpleString simpleString, String string, OpaqueBytes opaqueBytes, Trace.InvocationId invocationId2, Trace.SessionId sessionId2, Trace trace, Actor actor, int n, Object object) {
                if ((n & 1) != 0) {
                    simpleString = rpcRequest.clientAddress;
                }
                if ((n & 2) != 0) {
                    string = rpcRequest.methodName;
                }
                if ((n & 4) != 0) {
                    opaqueBytes = rpcRequest.serialisedArguments;
                }
                if ((n & 8) != 0) {
                    invocationId2 = rpcRequest.replyId;
                }
                if ((n & 0x10) != 0) {
                    sessionId2 = rpcRequest.sessionId;
                }
                if ((n & 0x20) != 0) {
                    trace = rpcRequest.externalTrace;
                }
                if ((n & 0x40) != 0) {
                    actor = rpcRequest.impersonatedActor;
                }
                return rpcRequest.copy(simpleString, string, opaqueBytes, invocationId2, sessionId2, trace, actor);
            }

            @NotNull
            public String toString() {
                return "RpcRequest(clientAddress=" + this.clientAddress + ", methodName=" + this.methodName + ", serialisedArguments=" + this.serialisedArguments + ", replyId=" + this.replyId + ", sessionId=" + this.sessionId + ", externalTrace=" + this.externalTrace + ", impersonatedActor=" + this.impersonatedActor + ")";
            }

            public int hashCode() {
                SimpleString simpleString = this.clientAddress;
                String string = this.methodName;
                OpaqueBytes opaqueBytes = this.serialisedArguments;
                Trace.InvocationId invocationId2 = this.replyId;
                Trace.SessionId sessionId2 = this.sessionId;
                Trace trace = this.externalTrace;
                Actor actor = this.impersonatedActor;
                return ((((((simpleString != null ? simpleString.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (opaqueBytes != null ? opaqueBytes.hashCode() : 0)) * 31 + (invocationId2 != null ? invocationId2.hashCode() : 0)) * 31 + (sessionId2 != null ? sessionId2.hashCode() : 0)) * 31 + (trace != null ? trace.hashCode() : 0)) * 31 + (actor != null ? actor.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof RpcRequest)) break block3;
                        RpcRequest rpcRequest = (RpcRequest)object;
                        if (!Intrinsics.areEqual((Object)this.clientAddress, (Object)rpcRequest.clientAddress) || !Intrinsics.areEqual((Object)this.methodName, (Object)rpcRequest.methodName) || !Intrinsics.areEqual((Object)this.serialisedArguments, (Object)rpcRequest.serialisedArguments) || !Intrinsics.areEqual((Object)this.replyId, (Object)rpcRequest.replyId) || !Intrinsics.areEqual((Object)this.sessionId, (Object)rpcRequest.sessionId) || !Intrinsics.areEqual((Object)this.externalTrace, (Object)rpcRequest.externalTrace) || !Intrinsics.areEqual((Object)this.impersonatedActor, (Object)rpcRequest.impersonatedActor)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lnet/corda/nodeapi/RPCApi$ClientToServer$ObservablesClosed;", "Lnet/corda/nodeapi/RPCApi$ClientToServer;", "ids", "", "Lnet/corda/core/context/Trace$InvocationId;", "(Ljava/util/List;)V", "getIds", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "writeToClientMessage", "", "message", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "node-api"})
        public static final class ObservablesClosed
        extends ClientToServer {
            @NotNull
            private final List<Trace.InvocationId> ids;

            @Override
            public void writeToClientMessage(@NotNull ClientMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                message.putIntProperty("tag", Tag.OBSERVABLES_CLOSED.ordinal());
                ActiveMQBuffer buffer = message.getBodyBuffer();
                buffer.writeInt(this.ids.size());
                Iterable $receiver$iv = this.ids;
                for (Object element$iv : $receiver$iv) {
                    Trace.InvocationId it = (Trace.InvocationId)element$iv;
                    ActiveMQBuffer activeMQBuffer = buffer;
                    Intrinsics.checkExpressionValueIsNotNull((Object)activeMQBuffer, (String)"buffer");
                    RPCApiKt.access$writeInvocationId(activeMQBuffer, it);
                }
            }

            @NotNull
            public final List<Trace.InvocationId> getIds() {
                return this.ids;
            }

            public ObservablesClosed(@NotNull List<Trace.InvocationId> ids) {
                Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
                super(null);
                this.ids = ids;
            }

            @NotNull
            public final List<Trace.InvocationId> component1() {
                return this.ids;
            }

            @NotNull
            public final ObservablesClosed copy(@NotNull List<Trace.InvocationId> ids) {
                Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
                return new ObservablesClosed(ids);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ ObservablesClosed copy$default(ObservablesClosed observablesClosed, List list2, int n, Object object) {
                if ((n & 1) != 0) {
                    list2 = observablesClosed.ids;
                }
                return observablesClosed.copy(list2);
            }

            @NotNull
            public String toString() {
                return "ObservablesClosed(ids=" + this.ids + ")";
            }

            public int hashCode() {
                List<Trace.InvocationId> list2 = this.ids;
                return list2 != null ? ((Object)list2).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ObservablesClosed)) break block3;
                        ObservablesClosed observablesClosed = (ObservablesClosed)object;
                        if (!Intrinsics.areEqual(this.ids, observablesClosed.ids)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/nodeapi/RPCApi$ClientToServer$Companion;", "", "()V", "fromClientMessage", "Lnet/corda/nodeapi/RPCApi$ClientToServer;", "message", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "node-api"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ClientToServer fromClientMessage(@NotNull ClientMessage message) {
                ClientToServer clientToServer;
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Tag[] tagArray = Tag.values();
                Integer n = message.getIntProperty("tag");
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"message.getIntProperty(TAG_FIELD_NAME)");
                Tag tag = tagArray[n];
                switch (RPCApi$ClientToServer$Companion$WhenMappings.$EnumSwitchMapping$0[tag.ordinal()]) {
                    case 1: {
                        SimpleString simpleString = MessageUtil.getJMSReplyTo((Message)((Message)message));
                        Intrinsics.checkExpressionValueIsNotNull((Object)simpleString, (String)"MessageUtil.getJMSReplyTo(message)");
                        String string = message.getStringProperty("method-name");
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.getStringProperty(METHOD_NAME_FIELD_NAME)");
                        clientToServer = new RpcRequest(simpleString, string, new OpaqueBytes(INSTANCE.getBodyAsByteArray(message)), RPCApiKt.replyId(message), RPCApiKt.sessionId(message), RPCApiKt.externalTrace(message), RPCApiKt.impersonatedActor(message));
                        break;
                    }
                    case 2: {
                        ArrayList<Trace.InvocationId> ids = new ArrayList<Trace.InvocationId>();
                        ActiveMQBuffer buffer = message.getBodyBuffer();
                        int numberOfIds = buffer.readInt();
                        int n2 = 1;
                        int n3 = numberOfIds;
                        if (n2 <= n3) {
                            while (true) {
                                void i2;
                                ActiveMQBuffer activeMQBuffer = buffer;
                                Intrinsics.checkExpressionValueIsNotNull((Object)activeMQBuffer, (String)"buffer");
                                ids.add(RPCApiKt.access$readInvocationId(activeMQBuffer));
                                if (i2 == n3) break;
                                ++i2;
                            }
                        }
                        clientToServer = new ObservablesClosed((List<Trace.InvocationId>)ids);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return clientToServer;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \r2\u00020\u0001:\u0005\r\u000e\u000f\u0010\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lnet/corda/nodeapi/RPCApi$ServerToClient;", "", "()V", "deduplicationIdentity", "", "getDeduplicationIdentity", "()Ljava/lang/String;", "writeToClientMessage", "", "context", "Lnet/corda/core/serialization/SerializationContext;", "message", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "Companion", "FailedToDeserializeReply", "Observation", "RpcReply", "Tag", "Lnet/corda/nodeapi/RPCApi$ServerToClient$RpcReply;", "Lnet/corda/nodeapi/RPCApi$ServerToClient$Observation;", "node-api"})
    public static abstract class ServerToClient {
        public static final Companion Companion = new Companion(null);

        public abstract void writeToClientMessage(@NotNull SerializationContext var1, @NotNull ClientMessage var2);

        @NotNull
        public abstract String getDeduplicationIdentity();

        private ServerToClient() {
        }

        public /* synthetic */ ServerToClient(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/nodeapi/RPCApi$ServerToClient$Tag;", "", "(Ljava/lang/String;I)V", "RPC_REPLY", "OBSERVATION", "node-api"})
        private static final class Tag
        extends Enum<Tag> {
            public static final /* enum */ Tag RPC_REPLY;
            public static final /* enum */ Tag OBSERVATION;
            private static final /* synthetic */ Tag[] $VALUES;

            static {
                Tag[] tagArray = new Tag[2];
                Tag[] tagArray2 = tagArray;
                tagArray[0] = RPC_REPLY = new Tag();
                tagArray[1] = OBSERVATION = new Tag();
                $VALUES = tagArray;
            }

            public static Tag[] values() {
                return (Tag[])$VALUES.clone();
            }

            public static Tag valueOf(String string) {
                return Enum.valueOf(Tag.class, string);
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J/\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\bH\u00d6\u0001J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lnet/corda/nodeapi/RPCApi$ServerToClient$RpcReply;", "Lnet/corda/nodeapi/RPCApi$ServerToClient;", "id", "Lnet/corda/core/context/Trace$InvocationId;", "result", "Lnet/corda/core/utilities/Try;", "", "deduplicationIdentity", "", "(Lnet/corda/core/context/Trace$InvocationId;Lnet/corda/core/utilities/Try;Ljava/lang/String;)V", "getDeduplicationIdentity", "()Ljava/lang/String;", "getId", "()Lnet/corda/core/context/Trace$InvocationId;", "getResult", "()Lnet/corda/core/utilities/Try;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "writeToClientMessage", "", "context", "Lnet/corda/core/serialization/SerializationContext;", "message", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "node-api"})
        public static final class RpcReply
        extends ServerToClient {
            @NotNull
            private final Trace.InvocationId id;
            @NotNull
            private final Try<Object> result;
            @NotNull
            private final String deduplicationIdentity;

            @Override
            public void writeToClientMessage(@NotNull SerializationContext context, @NotNull ClientMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                message.putIntProperty("tag", Tag.RPC_REPLY.ordinal());
                message.putStringProperty("deduplication-identity", this.getDeduplicationIdentity());
                RPCApiKt.access$mapTo((Id)this.id, message, "rpc-id", "rpc-id-timestamp");
                message.getBodyBuffer().writeBytes(Companion.safeSerialize(this.result, context, (Function1<? super Throwable, ? extends Object>)writeToClientMessage.1.INSTANCE).getBytes());
            }

            @NotNull
            public final Trace.InvocationId getId() {
                return this.id;
            }

            @NotNull
            public final Try<Object> getResult() {
                return this.result;
            }

            @Override
            @NotNull
            public String getDeduplicationIdentity() {
                return this.deduplicationIdentity;
            }

            public RpcReply(@NotNull Trace.InvocationId id, @NotNull Try<? extends Object> result, @NotNull String deduplicationIdentity) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull(result, (String)"result");
                Intrinsics.checkParameterIsNotNull((Object)deduplicationIdentity, (String)"deduplicationIdentity");
                super(null);
                this.id = id;
                this.result = result;
                this.deduplicationIdentity = deduplicationIdentity;
            }

            @NotNull
            public final Trace.InvocationId component1() {
                return this.id;
            }

            @NotNull
            public final Try<Object> component2() {
                return this.result;
            }

            @NotNull
            public final String component3() {
                return this.getDeduplicationIdentity();
            }

            @NotNull
            public final RpcReply copy(@NotNull Trace.InvocationId id, @NotNull Try<? extends Object> result, @NotNull String deduplicationIdentity) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull(result, (String)"result");
                Intrinsics.checkParameterIsNotNull((Object)deduplicationIdentity, (String)"deduplicationIdentity");
                return new RpcReply(id, result, deduplicationIdentity);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ RpcReply copy$default(RpcReply rpcReply, Trace.InvocationId invocationId2, Try try_, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    invocationId2 = rpcReply.id;
                }
                if ((n & 2) != 0) {
                    try_ = rpcReply.result;
                }
                if ((n & 4) != 0) {
                    string = rpcReply.getDeduplicationIdentity();
                }
                return rpcReply.copy(invocationId2, try_, string);
            }

            @NotNull
            public String toString() {
                return "RpcReply(id=" + this.id + ", result=" + this.result + ", deduplicationIdentity=" + this.getDeduplicationIdentity() + ")";
            }

            public int hashCode() {
                Trace.InvocationId invocationId2 = this.id;
                Try<Object> try_ = this.result;
                String string = this.getDeduplicationIdentity();
                return ((invocationId2 != null ? invocationId2.hashCode() : 0) * 31 + (try_ != null ? try_.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof RpcReply)) break block3;
                        RpcReply rpcReply = (RpcReply)object;
                        if (!Intrinsics.areEqual((Object)this.id, (Object)rpcReply.id) || !Intrinsics.areEqual(this.result, rpcReply.result) || !Intrinsics.areEqual((Object)this.getDeduplicationIdentity(), (Object)rpcReply.getDeduplicationIdentity())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lnet/corda/nodeapi/RPCApi$ServerToClient$Observation;", "Lnet/corda/nodeapi/RPCApi$ServerToClient;", "id", "Lnet/corda/core/context/Trace$InvocationId;", "content", "Lrx/Notification;", "deduplicationIdentity", "", "(Lnet/corda/core/context/Trace$InvocationId;Lrx/Notification;Ljava/lang/String;)V", "getContent", "()Lrx/Notification;", "getDeduplicationIdentity", "()Ljava/lang/String;", "getId", "()Lnet/corda/core/context/Trace$InvocationId;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "writeToClientMessage", "", "context", "Lnet/corda/core/serialization/SerializationContext;", "message", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "node-api"})
        public static final class Observation
        extends ServerToClient {
            @NotNull
            private final Trace.InvocationId id;
            @NotNull
            private final Notification<?> content;
            @NotNull
            private final String deduplicationIdentity;

            @Override
            public void writeToClientMessage(@NotNull SerializationContext context, @NotNull ClientMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                message.putIntProperty("tag", Tag.OBSERVATION.ordinal());
                message.putStringProperty("deduplication-identity", this.getDeduplicationIdentity());
                RPCApiKt.access$mapTo((Id)this.id, message, "observable-id", "observable-id-timestamp");
                message.getBodyBuffer().writeBytes(Companion.safeSerialize(this.content, context, (Function1<? super Throwable, ? extends Object>)writeToClientMessage.1.INSTANCE).getBytes());
            }

            @NotNull
            public final Trace.InvocationId getId() {
                return this.id;
            }

            @NotNull
            public final Notification<?> getContent() {
                return this.content;
            }

            @Override
            @NotNull
            public String getDeduplicationIdentity() {
                return this.deduplicationIdentity;
            }

            public Observation(@NotNull Trace.InvocationId id, @NotNull Notification<?> content, @NotNull String deduplicationIdentity) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull(content, (String)"content");
                Intrinsics.checkParameterIsNotNull((Object)deduplicationIdentity, (String)"deduplicationIdentity");
                super(null);
                this.id = id;
                this.content = content;
                this.deduplicationIdentity = deduplicationIdentity;
            }

            @NotNull
            public final Trace.InvocationId component1() {
                return this.id;
            }

            @NotNull
            public final Notification<?> component2() {
                return this.content;
            }

            @NotNull
            public final String component3() {
                return this.getDeduplicationIdentity();
            }

            @NotNull
            public final Observation copy(@NotNull Trace.InvocationId id, @NotNull Notification<?> content, @NotNull String deduplicationIdentity) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull(content, (String)"content");
                Intrinsics.checkParameterIsNotNull((Object)deduplicationIdentity, (String)"deduplicationIdentity");
                return new Observation(id, content, deduplicationIdentity);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Observation copy$default(Observation observation, Trace.InvocationId invocationId2, Notification notification, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    invocationId2 = observation.id;
                }
                if ((n & 2) != 0) {
                    notification = observation.content;
                }
                if ((n & 4) != 0) {
                    string = observation.getDeduplicationIdentity();
                }
                return observation.copy(invocationId2, notification, string);
            }

            @NotNull
            public String toString() {
                return "Observation(id=" + this.id + ", content=" + this.content + ", deduplicationIdentity=" + this.getDeduplicationIdentity() + ")";
            }

            public int hashCode() {
                Trace.InvocationId invocationId2 = this.id;
                Notification<?> notification = this.content;
                String string = this.getDeduplicationIdentity();
                return ((invocationId2 != null ? invocationId2.hashCode() : 0) * 31 + (notification != null ? notification.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Observation)) break block3;
                        Observation observation = (Observation)object;
                        if (!Intrinsics.areEqual((Object)this.id, (Object)observation.id) || !Intrinsics.areEqual(this.content, observation.content) || !Intrinsics.areEqual((Object)this.getDeduplicationIdentity(), (Object)observation.getDeduplicationIdentity())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lnet/corda/nodeapi/RPCApi$ServerToClient$FailedToDeserializeReply;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "id", "Lnet/corda/core/context/Trace$InvocationId;", "cause", "", "(Lnet/corda/core/context/Trace$InvocationId;Ljava/lang/Throwable;)V", "getId", "()Lnet/corda/core/context/Trace$InvocationId;", "node-api"})
        public static final class FailedToDeserializeReply
        extends RuntimeException {
            @NotNull
            private final Trace.InvocationId id;

            @NotNull
            public final Trace.InvocationId getId() {
                return this.id;
            }

            public FailedToDeserializeReply(@NotNull Trace.InvocationId id, @NotNull Throwable cause) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
                super("Failed to deserialize RPC reply: " + cause.getMessage(), cause);
                this.id = id;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ.\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0002\u00a8\u0006\u000e"}, d2={"Lnet/corda/nodeapi/RPCApi$ServerToClient$Companion;", "", "()V", "fromClientMessage", "Lnet/corda/nodeapi/RPCApi$ServerToClient;", "context", "Lnet/corda/core/serialization/SerializationContext;", "message", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "safeSerialize", "Lnet/corda/core/serialization/SerializedBytes;", "wrap", "Lkotlin/Function1;", "", "node-api"})
        public static final class Companion {
            private final SerializedBytes<Object> safeSerialize(@NotNull Object $receiver, SerializationContext context, Function1<? super Throwable, ? extends Object> wrap) {
                SerializedBytes serializedBytes;
                try {
                    serializedBytes = SerializationAPIKt.serialize$default((Object)$receiver, null, (SerializationContext)context, (int)1, null);
                }
                catch (Exception e) {
                    serializedBytes = SerializationAPIKt.serialize$default((Object)wrap.invoke((Object)e), null, (SerializationContext)context, (int)1, null);
                }
                return serializedBytes;
            }

            @NotNull
            public final ServerToClient fromClientMessage(@NotNull SerializationContext context, @NotNull ClientMessage message) {
                ServerToClient serverToClient;
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Tag[] tagArray = Tag.values();
                Integer n = message.getIntProperty("tag");
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"message.getIntProperty(TAG_FIELD_NAME)");
                Tag tag = tagArray[n];
                String deduplicationIdentity = message.getStringProperty("deduplication-identity");
                switch (RPCApi$ServerToClient$Companion$WhenMappings.$EnumSwitchMapping$0[tag.ordinal()]) {
                    case 1: {
                        Object $receiver$iv;
                        Trace.InvocationId invocationId2 = RPCApiKt.access$invocationId(message, "rpc-id", "rpc-id-timestamp");
                        if (invocationId2 == null) {
                            throw (Throwable)new IllegalStateException("Cannot parse invocation id from client message.");
                        }
                        Trace.InvocationId id = invocationId2;
                        SerializationContext poolWithIdContext = context.withProperty((Object)RpcRequestOrObservableIdKey.INSTANCE, (Object)id);
                        try {
                            boolean bl;
                            byte[] byArray;
                            $receiver$iv = INSTANCE.getBodyAsByteArray(message);
                            SerializationFactory serializationFactory$iv = SerializationFactory.Companion.getDefaultFactory();
                            byte[] byArray2 = byArray = $receiver$iv;
                            boolean bl2 = bl = !(byArray2.length == 0);
                            if (!bl) {
                                String string = "Empty bytes";
                                throw (Throwable)new IllegalArgumentException(string.toString());
                            }
                            ByteSequence $receiver$iv$iv = ByteArrays.sequence$default((byte[])$receiver$iv, (int)0, (int)0, (int)3, null);
                            $receiver$iv = (Try)serializationFactory$iv.deserialize($receiver$iv$iv, Try.class, poolWithIdContext);
                        }
                        catch (Exception e) {
                            throw (Throwable)new FailedToDeserializeReply(id, (Throwable)e);
                        }
                        Object result = $receiver$iv;
                        String string = deduplicationIdentity;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"deduplicationIdentity");
                        $receiver$iv = result;
                        String e = string;
                        serverToClient = new RpcReply(id, (Try<? extends Object>)$receiver$iv, e);
                        break;
                    }
                    case 2: {
                        byte[] $receiver$iv$iv;
                        Trace.InvocationId invocationId3 = RPCApiKt.access$invocationId(message, "observable-id", "observable-id-timestamp");
                        if (invocationId3 == null) {
                            throw (Throwable)new IllegalStateException("Cannot parse invocation id from client message.");
                        }
                        Trace.InvocationId observableId = invocationId3;
                        SerializationContext poolWithIdContext = context.withProperty((Object)RpcRequestOrObservableIdKey.INSTANCE, (Object)observableId);
                        byte[] $receiver$iv = INSTANCE.getBodyAsByteArray(message);
                        SerializationFactory serializationFactory$iv = SerializationFactory.Companion.getDefaultFactory();
                        byte[] $i$f$deserialize = $receiver$iv$iv = $receiver$iv;
                        boolean bl = $receiver$iv$iv = !($i$f$deserialize.length == 0);
                        if (!$receiver$iv$iv) {
                            String string = "Empty bytes";
                            throw (Throwable)new IllegalArgumentException(string.toString());
                        }
                        ByteSequence $receiver$iv$iv2 = ByteArrays.sequence$default((byte[])$receiver$iv, (int)0, (int)0, (int)3, null);
                        Notification payload = (Notification)serializationFactory$iv.deserialize($receiver$iv$iv2, Notification.class, poolWithIdContext);
                        String string = deduplicationIdentity;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"deduplicationIdentity");
                        Notification notification = payload;
                        String string2 = string;
                        serverToClient = new Observation(observableId, notification, string2);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return serverToClient;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

