/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.mock;

import java.util.Currency;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.corda.client.mock.Generator;
import net.corda.client.mock.Generators;
import net.corda.core.contracts.Amount;
import net.corda.core.utilities.OpaqueBytes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a:\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\u001a\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0001\u001a\"\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"generateAmount", "Lnet/corda/client/mock/Generator;", "Lnet/corda/core/contracts/Amount;", "T", "", "min", "", "max", "tokenGenerator", "generateCurrency", "Ljava/util/Currency;", "generateCurrencyAmount", "generateIssueRef", "Lnet/corda/core/utilities/OpaqueBytes;", "size", "", "mock"})
@JvmName(name="Generators")
public final class Generators {
    @NotNull
    public static final Generator<Currency> generateCurrency() {
        Set<Currency> set = Currency.getAvailableCurrencies();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getAvailableCurrencies(...)");
        return Generator.Companion.pickOne(CollectionsKt.toList((Iterable)set));
    }

    @NotNull
    public static final <T> Generator<Amount<T>> generateAmount(long min, long max, @NotNull Generator<? extends T> tokenGenerator) {
        Intrinsics.checkNotNullParameter(tokenGenerator, (String)"tokenGenerator");
        return Generator.Companion.longRange(min, max).combine(tokenGenerator, generateAmount.1.INSTANCE);
    }

    @NotNull
    public static final Generator<Amount<Currency>> generateCurrencyAmount(long min, long max) {
        return Generators.generateAmount(min, max, Generators.generateCurrency());
    }

    @NotNull
    public static final Generator<OpaqueBytes> generateIssueRef(int size) {
        return Generator.Companion.bytes(size).map(generateIssueRef.1.INSTANCE);
    }
}

