/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.mock;

import java.util.Currency;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import net.corda.client.mock.EventGenerator;
import net.corda.client.mock.Generator;
import net.corda.core.contracts.Amount;
import net.corda.core.identity.Party;
import net.corda.core.utilities.OpaqueBytes;
import net.corda.finance.Currencies;
import net.corda.finance.flows.AbstractCashFlow;
import net.corda.finance.flows.CashExitFlow;
import net.corda.finance.flows.CashIssueAndPaymentFlow;
import net.corda.finance.flows.CashPaymentFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u000bH\u0004R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\rR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\rR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000fR\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\r\u00a8\u0006."}, d2={"Lnet/corda/client/mock/EventGenerator;", "", "parties", "", "Lnet/corda/core/identity/Party;", "currencies", "Ljava/util/Currency;", "notary", "(Ljava/util/List;Ljava/util/List;Lnet/corda/core/identity/Party;)V", "amountGenerator", "Lnet/corda/client/mock/Generator;", "", "getAmountGenerator", "()Lnet/corda/client/mock/Generator;", "getCurrencies", "()Ljava/util/List;", "currencyGenerator", "getCurrencyGenerator", "currencyMap", "", "getCurrencyMap", "()Ljava/util/Map;", "exitCashGenerator", "Lnet/corda/finance/flows/CashExitFlow$ExitRequest;", "getExitCashGenerator", "issueCashGenerator", "Lnet/corda/finance/flows/CashIssueAndPaymentFlow$IssueAndPaymentRequest;", "getIssueCashGenerator", "issueRefGenerator", "Lnet/corda/core/utilities/OpaqueBytes;", "getIssueRefGenerator", "issuerGenerator", "Lnet/corda/finance/flows/AbstractCashFlow$AbstractRequest;", "getIssuerGenerator", "moveCashGenerator", "Lnet/corda/finance/flows/CashPaymentFlow$PaymentRequest;", "getMoveCashGenerator", "getNotary", "()Lnet/corda/core/identity/Party;", "getParties", "partyGenerator", "getPartyGenerator", "addToMap", "", "ccy", "amount", "mock"})
public class EventGenerator {
    @NotNull
    private final List<Party> parties;
    @NotNull
    private final List<Currency> currencies;
    @NotNull
    private final Party notary;
    @NotNull
    private final Generator<Party> partyGenerator;
    @NotNull
    private final Generator<OpaqueBytes> issueRefGenerator;
    @NotNull
    private final Generator<Long> amountGenerator;
    @NotNull
    private final Generator<Currency> currencyGenerator;
    @NotNull
    private final Map<Currency, Long> currencyMap;
    @NotNull
    private final Generator<CashIssueAndPaymentFlow.IssueAndPaymentRequest> issueCashGenerator;
    @NotNull
    private final Generator<CashExitFlow.ExitRequest> exitCashGenerator;
    @NotNull
    private final Generator<CashPaymentFlow.PaymentRequest> moveCashGenerator;
    @NotNull
    private final Generator<AbstractCashFlow.AbstractRequest> issuerGenerator;

    public EventGenerator(@NotNull List<Party> parties, @NotNull List<Currency> currencies, @NotNull Party notary) {
        Intrinsics.checkNotNullParameter(parties, (String)"parties");
        Intrinsics.checkNotNullParameter(currencies, (String)"currencies");
        Intrinsics.checkNotNullParameter((Object)notary, (String)"notary");
        this.parties = parties;
        this.currencies = currencies;
        this.notary = notary;
        this.partyGenerator = Generator.Companion.pickOne(this.parties);
        this.issueRefGenerator = Generator.Companion.intRange(0, 1).map(issueRefGenerator.1.INSTANCE);
        this.amountGenerator = Generator.Companion.longRange(10000L, 1000000L);
        this.currencyGenerator = Generator.Companion.pickOne(this.currencies);
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)Currencies.USD, (Object)0L), TuplesKt.to((Object)Currencies.GBP, (Object)0L)};
        this.currencyMap = MapsKt.mutableMapOf((Pair[])objectArray);
        this.issueCashGenerator = this.amountGenerator.combine(this.partyGenerator, this.issueRefGenerator, this.currencyGenerator, (Function4)new Function4<Long, Party, OpaqueBytes, Currency, CashIssueAndPaymentFlow.IssueAndPaymentRequest>(this){
            final /* synthetic */ EventGenerator this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            @NotNull
            public final CashIssueAndPaymentFlow.IssueAndPaymentRequest invoke(long amount, @NotNull Party to, @NotNull OpaqueBytes issueRef, @NotNull Currency ccy) {
                Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                Intrinsics.checkNotNullParameter((Object)issueRef, (String)"issueRef");
                Intrinsics.checkNotNullParameter((Object)ccy, (String)"ccy");
                this.this$0.addToMap(ccy, amount);
                return new CashIssueAndPaymentFlow.IssueAndPaymentRequest(new Amount(amount, (Object)ccy), issueRef, to, this.this$0.getNotary(), true);
            }
        });
        this.exitCashGenerator = this.amountGenerator.combine(this.issueRefGenerator, this.currencyGenerator, (Function3)new Function3<Long, OpaqueBytes, Currency, CashExitFlow.ExitRequest>(this){
            final /* synthetic */ EventGenerator this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            @NotNull
            public final CashExitFlow.ExitRequest invoke(long amount, @NotNull OpaqueBytes issueRef, @NotNull Currency ccy) {
                Intrinsics.checkNotNullParameter((Object)issueRef, (String)"issueRef");
                Intrinsics.checkNotNullParameter((Object)ccy, (String)"ccy");
                this.this$0.addToMap(ccy, -amount);
                return new CashExitFlow.ExitRequest(new Amount(amount, (Object)ccy), issueRef);
            }
        });
        this.moveCashGenerator = this.amountGenerator.combine(this.partyGenerator, this.currencyGenerator, moveCashGenerator.1.INSTANCE);
        objectArray = new Pair[]{TuplesKt.to((Object)0.1, this.exitCashGenerator), TuplesKt.to((Object)0.9, this.issueCashGenerator)};
        this.issuerGenerator = Generator.Companion.frequency(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final List<Party> getParties() {
        return this.parties;
    }

    @NotNull
    public final List<Currency> getCurrencies() {
        return this.currencies;
    }

    @NotNull
    public final Party getNotary() {
        return this.notary;
    }

    @NotNull
    protected final Generator<Party> getPartyGenerator() {
        return this.partyGenerator;
    }

    @NotNull
    protected final Generator<OpaqueBytes> getIssueRefGenerator() {
        return this.issueRefGenerator;
    }

    @NotNull
    protected final Generator<Long> getAmountGenerator() {
        return this.amountGenerator;
    }

    @NotNull
    protected final Generator<Currency> getCurrencyGenerator() {
        return this.currencyGenerator;
    }

    @NotNull
    protected final Map<Currency, Long> getCurrencyMap() {
        return this.currencyMap;
    }

    protected final void addToMap(@NotNull Currency ccy, long amount) {
        Intrinsics.checkNotNullParameter((Object)ccy, (String)"ccy");
        this.currencyMap.computeIfPresent(ccy, (arg_0, arg_1) -> EventGenerator.addToMap$lambda$0((Function2)new Function2<Currency, Long, Long>(amount){
            final /* synthetic */ long $amount;
            {
                this.$amount = $amount;
                super(2);
            }

            @Nullable
            public final Long invoke(@NotNull Currency currency, @NotNull Long value) {
                Intrinsics.checkNotNullParameter((Object)currency, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return Math.max(0L, value + this.$amount);
            }
        }, arg_0, arg_1));
    }

    @NotNull
    protected final Generator<CashIssueAndPaymentFlow.IssueAndPaymentRequest> getIssueCashGenerator() {
        return this.issueCashGenerator;
    }

    @NotNull
    protected final Generator<CashExitFlow.ExitRequest> getExitCashGenerator() {
        return this.exitCashGenerator;
    }

    @NotNull
    public Generator<CashPaymentFlow.PaymentRequest> getMoveCashGenerator() {
        return this.moveCashGenerator;
    }

    @NotNull
    public Generator<AbstractCashFlow.AbstractRequest> getIssuerGenerator() {
        return this.issuerGenerator;
    }

    private static final Long addToMap$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Long)$tmp0.invoke(p0, p1);
    }
}

