/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.mock;

import java.util.Currency;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import net.corda.client.mock.ErrorFlowsEventGenerator;
import net.corda.client.mock.EventGenerator;
import net.corda.client.mock.Generator;
import net.corda.core.contracts.Amount;
import net.corda.core.identity.Party;
import net.corda.core.utilities.OpaqueBytes;
import net.corda.finance.flows.AbstractCashFlow;
import net.corda.finance.flows.CashExitFlow;
import net.corda.finance.flows.CashPaymentFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0017B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/corda/client/mock/ErrorFlowsEventGenerator;", "Lnet/corda/client/mock/EventGenerator;", "parties", "", "Lnet/corda/core/identity/Party;", "currencies", "Ljava/util/Currency;", "notary", "(Ljava/util/List;Ljava/util/List;Lnet/corda/core/identity/Party;)V", "errorExitCashGenerator", "Lnet/corda/client/mock/Generator;", "Lnet/corda/finance/flows/CashExitFlow$ExitRequest;", "errorGenerator", "Lnet/corda/client/mock/ErrorFlowsEventGenerator$IssuerEvents;", "errorMoveGenerator", "Lnet/corda/finance/flows/CashPaymentFlow$PaymentRequest;", "issuerGenerator", "Lnet/corda/finance/flows/AbstractCashFlow$AbstractRequest;", "getIssuerGenerator", "()Lnet/corda/client/mock/Generator;", "moveCashGenerator", "getMoveCashGenerator", "normalMoveGenerator", "IssuerEvents", "mock"})
public final class ErrorFlowsEventGenerator
extends EventGenerator {
    @NotNull
    private final Generator<IssuerEvents> errorGenerator;
    @NotNull
    private final Generator<CashExitFlow.ExitRequest> errorExitCashGenerator;
    @NotNull
    private final Generator<CashPaymentFlow.PaymentRequest> normalMoveGenerator;
    @NotNull
    private final Generator<CashPaymentFlow.PaymentRequest> errorMoveGenerator;
    @NotNull
    private final Generator<CashPaymentFlow.PaymentRequest> moveCashGenerator;
    @NotNull
    private final Generator<AbstractCashFlow.AbstractRequest> issuerGenerator;

    public ErrorFlowsEventGenerator(@NotNull List<Party> parties, @NotNull List<Currency> currencies, @NotNull Party notary) {
        Intrinsics.checkNotNullParameter(parties, (String)"parties");
        Intrinsics.checkNotNullParameter(currencies, (String)"currencies");
        Intrinsics.checkNotNullParameter((Object)notary, (String)"notary");
        super(parties, currencies, notary);
        this.errorGenerator = Generator.Companion.pickOne(ArraysKt.toList((Object[])IssuerEvents.values()));
        this.errorExitCashGenerator = this.getAmountGenerator().combine(this.getIssueRefGenerator(), this.getCurrencyGenerator(), this.errorGenerator, (Function4)new Function4<Long, OpaqueBytes, Currency, IssuerEvents, CashExitFlow.ExitRequest>(this){
            final /* synthetic */ ErrorFlowsEventGenerator this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            @NotNull
            public final CashExitFlow.ExitRequest invoke(long amount, @NotNull OpaqueBytes issueRef, @NotNull Currency ccy, @NotNull IssuerEvents errorType) {
                Intrinsics.checkNotNullParameter((Object)issueRef, (String)"issueRef");
                Intrinsics.checkNotNullParameter((Object)ccy, (String)"ccy");
                Intrinsics.checkNotNullParameter((Object)((Object)errorType), (String)"errorType");
                return switch (errorExitCashGenerator.WhenMappings.$EnumSwitchMapping$0[errorType.ordinal()]) {
                    case 1 -> {
                        System.out.println((Object)"Normal exit");
                        Long v0 = this.this$0.getCurrencyMap().get(ccy);
                        Intrinsics.checkNotNull((Object)v0);
                        if (((Number)v0).longValue() <= amount) {
                            this.this$0.addToMap(ccy, -amount);
                        }
                        yield new CashExitFlow.ExitRequest(new Amount(amount, (Object)ccy), issueRef);
                    }
                    case 2 -> {
                        System.out.println((Object)"Exit error");
                        Long v2 = this.this$0.getCurrencyMap().get(ccy);
                        Intrinsics.checkNotNull((Object)v2);
                        yield new CashExitFlow.ExitRequest(new Amount(((Number)v2).longValue() * (long)2, (Object)ccy), issueRef);
                    }
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
        });
        this.normalMoveGenerator = this.getAmountGenerator().combine(this.getPartyGenerator(), this.getCurrencyGenerator(), normalMoveGenerator.1.INSTANCE);
        this.errorMoveGenerator = this.getPartyGenerator().combine(this.getCurrencyGenerator(), (Function2)new Function2<Party, Currency, CashPaymentFlow.PaymentRequest>(this){
            final /* synthetic */ ErrorFlowsEventGenerator this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final CashPaymentFlow.PaymentRequest invoke(@NotNull Party recipient, @NotNull Currency currency) {
                Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
                Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
                Long l = this.this$0.getCurrencyMap().get(currency);
                Intrinsics.checkNotNull((Object)l);
                return new CashPaymentFlow.PaymentRequest(new Amount(((Number)l).longValue() * (long)2, (Object)currency), recipient, true, null, null, 24, null);
            }
        });
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)0.2, this.errorMoveGenerator), TuplesKt.to((Object)0.8, this.normalMoveGenerator)};
        this.moveCashGenerator = Generator.Companion.frequency(CollectionsKt.listOf((Object[])objectArray));
        objectArray = new Pair[]{TuplesKt.to((Object)0.3, this.errorExitCashGenerator), TuplesKt.to((Object)0.7, this.getIssueCashGenerator())};
        this.issuerGenerator = Generator.Companion.frequency(CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @NotNull
    public Generator<CashPaymentFlow.PaymentRequest> getMoveCashGenerator() {
        return this.moveCashGenerator;
    }

    @Override
    @NotNull
    public Generator<AbstractCashFlow.AbstractRequest> getIssuerGenerator() {
        return this.issuerGenerator;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/client/mock/ErrorFlowsEventGenerator$IssuerEvents;", "", "(Ljava/lang/String;I)V", "NORMAL_EXIT", "EXIT_ERROR", "mock"})
    public static final class IssuerEvents
    extends Enum<IssuerEvents> {
        public static final /* enum */ IssuerEvents NORMAL_EXIT = new IssuerEvents();
        public static final /* enum */ IssuerEvents EXIT_ERROR = new IssuerEvents();
        private static final /* synthetic */ IssuerEvents[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static IssuerEvents[] values() {
            return (IssuerEvents[])$VALUES.clone();
        }

        public static IssuerEvents valueOf(String value) {
            return Enum.valueOf(IssuerEvents.class, value);
        }

        @NotNull
        public static EnumEntries<IssuerEvents> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = issuerEventsArray = new IssuerEvents[]{IssuerEvents.NORMAL_EXIT, IssuerEvents.EXIT_ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

