/*
 * Decompiled with CFR 0.152.
 */
package net.corda.internal.ledger.serialization.transactions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.impl.ledger.serialization.transactions.WireTransactionContainerImpl;
import net.corda.impl.ledger.transactions.WireTransactionImpl;
import net.corda.internal.ledger.serialization.transactions.WireTransactionContainer;
import net.corda.internal.ledger.serialization.transactions.WireTransactionDeserializationException;
import net.corda.internal.ledger.serialization.transactions.WireTransactionType;
import net.corda.internal.ledger.serialization.transactions.WireTransactionVersion;
import net.corda.internal.serialization.amqp.CustomSerializer;
import net.corda.internal.serialization.amqp.LocalSerializerFactory;
import net.corda.internal.serialization.amqp.SerializerFactory;
import net.corda.v5.base.annotations.CordaSerializable;
import net.corda.v5.crypto.DigestService;
import net.corda.v5.ledger.transactions.WireTransaction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/corda/internal/ledger/serialization/transactions/WireTransactionInterfaceSerializer;", "Lnet/corda/internal/serialization/amqp/CustomSerializer$Proxy;", "Lnet/corda/v5/ledger/transactions/WireTransaction;", "Lnet/corda/internal/ledger/serialization/transactions/WireTransactionInterfaceSerializer$WireTransactionContainerRef;", "factory", "Lnet/corda/internal/serialization/amqp/SerializerFactory;", "hashingService", "Lnet/corda/v5/crypto/DigestService;", "(Lnet/corda/internal/serialization/amqp/SerializerFactory;Lnet/corda/v5/crypto/DigestService;)V", "fromProxy", "proxy", "toProxy", "obj", "WireTransactionContainerRef", "ledger-serialization"})
public final class WireTransactionInterfaceSerializer
extends CustomSerializer.Proxy<WireTransaction, WireTransactionContainerRef> {
    private final DigestService hashingService;

    @NotNull
    protected WireTransactionContainerRef toProxy(@NotNull WireTransaction obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return new WireTransactionContainerRef(new WireTransactionContainerImpl(WireTransactionType.WIRE_TRANSACTION, WireTransactionVersion.VERSION_1, obj.getComponentGroups(), obj.getPrivacySalt(), obj.getTransactionDigestAlgorithmNames(), null, 32, null));
    }

    @NotNull
    protected WireTransaction fromProxy(@NotNull WireTransactionContainerRef proxy) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        WireTransactionContainer wtc = proxy.getWtxc();
        if (wtc.getType() == WireTransactionType.WIRE_TRANSACTION && wtc.getVersion() == WireTransactionVersion.VERSION_1) {
            return (WireTransaction)new WireTransactionImpl(wtc.getComponentGroups(), wtc.getPrivacySalt(), wtc.getTransactionDigestAlgorithmNames(), this.hashingService);
        }
        throw (Throwable)((Object)new WireTransactionDeserializationException(wtc));
    }

    public WireTransactionInterfaceSerializer(@NotNull SerializerFactory factory, @NotNull DigestService hashingService) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)hashingService, (String)"hashingService");
        super(WireTransaction.class, WireTransactionContainerRef.class, (LocalSerializerFactory)factory, false, 8, null);
        this.hashingService = hashingService;
    }

    @CordaSerializable
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/internal/ledger/serialization/transactions/WireTransactionInterfaceSerializer$WireTransactionContainerRef;", "", "wtxc", "Lnet/corda/internal/ledger/serialization/transactions/WireTransactionContainer;", "(Lnet/corda/internal/ledger/serialization/transactions/WireTransactionContainer;)V", "getWtxc", "()Lnet/corda/internal/ledger/serialization/transactions/WireTransactionContainer;", "ledger-serialization"})
    public static final class WireTransactionContainerRef {
        @NotNull
        private final WireTransactionContainer wtxc;

        @NotNull
        public final WireTransactionContainer getWtxc() {
            return this.wtxc;
        }

        public WireTransactionContainerRef(@NotNull WireTransactionContainer wtxc) {
            Intrinsics.checkNotNullParameter((Object)wtxc, (String)"wtxc");
            this.wtxc = wtxc;
        }
    }
}

