/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.jfx.utils;

import java.util.Currency;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.corda.client.jfx.model.ExchangeRate;
import net.corda.client.jfx.utils.AmountBindings;
import net.corda.core.contracts.Amount;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b\u0012\u0004\u0012\u00020\t0\u00070\u00050\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004J=\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\b0\u000e\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\b0\u00112\u0006\u0010\u0012\u001a\u0002H\u000f\u00a2\u0006\u0002\u0010\u0013JB\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u00042\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0004\u00a8\u0006\u0017"}, d2={"Lnet/corda/client/jfx/utils/AmountBindings;", "", "()V", "exchange", "Ljavafx/beans/value/ObservableValue;", "Lkotlin/Pair;", "Ljava/util/Currency;", "Lkotlin/Function1;", "Lnet/corda/core/contracts/Amount;", "", "observableCurrency", "observableExchangeRate", "Lnet/corda/client/jfx/model/ExchangeRate;", "sum", "Lorg/fxmisc/easybind/monadic/MonadicBinding;", "T", "amounts", "Ljavafx/collections/ObservableList;", "token", "(Ljavafx/collections/ObservableList;Ljava/lang/Object;)Lorg/fxmisc/easybind/monadic/MonadicBinding;", "sumAmountExchange", "currency", "exchangeRate", "jfx"})
public final class AmountBindings {
    @NotNull
    public static final AmountBindings INSTANCE = new AmountBindings();

    private AmountBindings() {
    }

    @NotNull
    public final <T> MonadicBinding<Amount<T>> sum(@NotNull ObservableList<Amount<T>> amounts, @NotNull T token) {
        Intrinsics.checkNotNullParameter(amounts, (String)"amounts");
        Intrinsics.checkNotNullParameter(token, (String)"token");
        Observable[] observableArray = new Observable[]{amounts};
        MonadicBinding monadicBinding = EasyBind.map((ObservableValue)((ObservableValue)Bindings.createLongBinding(() -> AmountBindings.sum$lambda$1(amounts, token), (Observable[])observableArray)), arg_0 -> AmountBindings.sum$lambda$2(token, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)monadicBinding, (String)"map(...)");
        return monadicBinding;
    }

    @NotNull
    public final ObservableValue<Pair<Currency, Function1<Amount<Currency>, Long>>> exchange(@NotNull ObservableValue<Currency> observableCurrency, @NotNull ObservableValue<ExchangeRate> observableExchangeRate) {
        Intrinsics.checkNotNullParameter(observableCurrency, (String)"observableCurrency");
        Intrinsics.checkNotNullParameter(observableExchangeRate, (String)"observableExchangeRate");
        MonadicBinding monadicBinding = EasyBind.combine(observableCurrency, observableExchangeRate, AmountBindings::exchange$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)monadicBinding, (String)"combine(...)");
        return (ObservableValue)monadicBinding;
    }

    @NotNull
    public final ObservableValue<Amount<Currency>> sumAmountExchange(@NotNull ObservableList<Amount<Currency>> amounts, @NotNull ObservableValue<Currency> currency, @NotNull ObservableValue<ExchangeRate> exchangeRate2) {
        Intrinsics.checkNotNullParameter(amounts, (String)"amounts");
        Intrinsics.checkNotNullParameter(currency, (String)"currency");
        Intrinsics.checkNotNullParameter(exchangeRate2, (String)"exchangeRate");
        MonadicBinding monadicBinding = EasyBind.monadic(this.exchange(currency, exchangeRate2)).flatMap(arg_0 -> AmountBindings.sumAmountExchange$lambda$4((Function1)new Function1<Pair<? extends Currency, ? extends Function1<? super Amount<Currency>, ? extends Long>>, ObservableValue<Amount<Currency>>>(amounts){
            final /* synthetic */ ObservableList<Amount<Currency>> $amounts;
            {
                this.$amounts = $amounts;
                super(1);
            }

            public final ObservableValue<Amount<Currency>> invoke(Pair<Currency, ? extends Function1<? super Amount<Currency>, Long>> it) {
                Currency currencyValue = (Currency)it.component1();
                Function1 exchange2 = (Function1)it.component2();
                Observable[] observableArray = new Observable[]{this.$amounts};
                return (ObservableValue)EasyBind.map((ObservableValue)((ObservableValue)Bindings.createLongBinding(() -> sumAmountExchange.1.invoke$lambda$1(this.$amounts, exchange2), (Observable[])observableArray)), arg_0 -> sumAmountExchange.1.invoke$lambda$2(currencyValue, arg_0));
            }

            private static final long invoke$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return ((Number)$tmp0.invoke(p0)).longValue();
            }

            private static final Long invoke$lambda$1(ObservableList $amounts, Function1 $exchange) {
                Intrinsics.checkNotNullParameter((Object)$amounts, (String)"$amounts");
                Intrinsics.checkNotNullParameter((Object)$exchange, (String)"$exchange");
                return $amounts.stream().collect(Collectors.summingLong(arg_0 -> sumAmountExchange.1.invoke$lambda$1$lambda$0((Function1)new Function1<Amount<Currency>, Long>((Function1<? super Amount<Currency>, Long>)$exchange){
                    final /* synthetic */ Function1<Amount<Currency>, Long> $exchange;
                    {
                        this.$exchange = $exchange;
                        super(1);
                    }

                    @NotNull
                    public final Long invoke(Amount<Currency> it) {
                        Intrinsics.checkNotNull(it);
                        return (Long)this.$exchange.invoke(it);
                    }
                }, arg_0)));
            }

            private static final Amount invoke$lambda$2(Currency $currencyValue, Number it) {
                Intrinsics.checkNotNullParameter((Object)$currencyValue, (String)"$currencyValue");
                return new Amount(it.longValue(), (Object)$currencyValue);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)monadicBinding, (String)"flatMap(...)");
        return (ObservableValue)monadicBinding;
    }

    private static final long sum$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final Long sum$lambda$1(ObservableList $amounts, Object $token) {
        Intrinsics.checkNotNullParameter((Object)$amounts, (String)"$amounts");
        Intrinsics.checkNotNullParameter((Object)$token, (String)"$token");
        return $amounts.stream().collect(Collectors.summingLong(arg_0 -> AmountBindings.sum$lambda$1$lambda$0((Function1)new Function1<Amount<T>, Long>($token){
            final /* synthetic */ T $token;
            {
                this.$token = $token;
                super(1);
            }

            @NotNull
            public final Long invoke(Amount<T> it) {
                if (!Intrinsics.areEqual((Object)it.getToken(), this.$token)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                return it.getQuantity();
            }
        }, arg_0)));
    }

    private static final Amount sum$lambda$2(Object $token, Number sum2) {
        Intrinsics.checkNotNullParameter((Object)$token, (String)"$token");
        return new Amount(sum2.longValue(), $token);
    }

    private static final Pair exchange$lambda$3(Currency currency, ExchangeRate exchangeRate2) {
        Intrinsics.checkNotNull((Object)currency);
        return new Pair((Object)currency, (Object)new Function1<Amount<Currency>, Long>(exchangeRate2, currency){
            final /* synthetic */ ExchangeRate $exchangeRate;
            final /* synthetic */ Currency $currency;
            {
                this.$exchangeRate = $exchangeRate;
                this.$currency = $currency;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull Amount<Currency> amount) {
                Intrinsics.checkNotNullParameter(amount, (String)"amount");
                Currency currency = this.$currency;
                Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"$currency");
                return this.$exchangeRate.exchangeAmount(amount, currency).getQuantity();
            }
        });
    }

    private static final ObservableValue sumAmountExchange$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ObservableValue)$tmp0.invoke(p0);
    }
}

