/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.jfx.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002:\u0001$B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0003\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0002J\u0016\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u001e\u0010\u001f\u001a\u00020\u001d2\u0014\u0010 \u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030!H\u0014J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R7\u0010\b\u001a(\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lnet/corda/client/jfx/utils/AbstractConcatenatedList;", "A", "Ljavafx/collections/transformation/TransformationList;", "Ljavafx/collections/ObservableList;", "sourceList", "(Ljavafx/collections/ObservableList;)V", "firstInvalidatedPosition", "", "indexMap", "Ljava/util/HashMap;", "Lnet/corda/client/jfx/utils/AbstractConcatenatedList$WrappedObservableList;", "Lkotlin/Pair;", "Ljavafx/collections/ListChangeListener;", "getIndexMap", "()Ljava/util/HashMap;", "nestedIndexOffsets", "Ljava/util/ArrayList;", "getNestedIndexOffsets", "()Ljava/util/ArrayList;", "size", "getSize", "()I", "createListener", "wrapped", "get", "index", "(I)Ljava/lang/Object;", "getSourceIndex", "invalidateOffsets", "", "recalculateOffsets", "sourceChanged", "change", "Ljavafx/collections/ListChangeListener$Change;", "startingOffsetOf", "listIndex", "WrappedObservableList", "jfx"})
@SourceDebugExtension(value={"SMAP\nAbstractConcatenatedList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractConcatenatedList.kt\nnet/corda/client/jfx/utils/AbstractConcatenatedList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n1864#2,3:293\n1360#2:296\n1446#2,5:297\n1864#2,3:302\n*S KotlinDebug\n*F\n+ 1 AbstractConcatenatedList.kt\nnet/corda/client/jfx/utils/AbstractConcatenatedList\n*L\n47#1:293,3\n201#1:296\n201#1:297,5\n216#1:302,3\n*E\n"})
public abstract class AbstractConcatenatedList<A>
extends TransformationList<A, ObservableList<A>> {
    @NotNull
    private final HashMap<WrappedObservableList<? extends A>, Pair<Integer, ListChangeListener<A>>> indexMap;
    @NotNull
    private final ArrayList<Integer> nestedIndexOffsets;
    private int firstInvalidatedPosition;

    /*
     * WARNING - void declaration
     */
    public AbstractConcatenatedList(@NotNull ObservableList<ObservableList<A>> sourceList2) {
        Intrinsics.checkNotNullParameter(sourceList2, (String)"sourceList");
        super(sourceList2);
        this.indexMap = new HashMap();
        this.nestedIndexOffsets = new ArrayList(sourceList2.size());
        int offset = 0;
        Iterable $this$forEachIndexed$iv = (Iterable)sourceList2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void observableList;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ObservableList observableList2 = (ObservableList)item$iv;
            int index2 = n;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)observableList);
            WrappedObservableList wrapped = new WrappedObservableList(observableList);
            ((Map)this.indexMap).put(wrapped, new Pair((Object)index2, this.createListener(wrapped)));
            this.nestedIndexOffsets.add(offset += observableList.size());
        }
        this.firstInvalidatedPosition = sourceList2.size();
    }

    @NotNull
    public final HashMap<WrappedObservableList<? extends A>, Pair<Integer, ListChangeListener<A>>> getIndexMap() {
        return this.indexMap;
    }

    @NotNull
    public final ArrayList<Integer> getNestedIndexOffsets() {
        return this.nestedIndexOffsets;
    }

    private final int startingOffsetOf(int listIndex2) {
        int n;
        if (listIndex2 == 0) {
            n = 0;
        } else {
            Integer n2 = this.nestedIndexOffsets.get(listIndex2 - 1);
            Intrinsics.checkNotNull((Object)n2);
            n = ((Number)n2).intValue();
        }
        return n;
    }

    private final ListChangeListener<A> createListener(WrappedObservableList<A> wrapped) {
        ListChangeListener listener = arg_0 -> AbstractConcatenatedList.createListener$lambda$1(this, wrapped, arg_0);
        wrapped.getObservableList().addListener(listener);
        return listener;
    }

    /*
     * WARNING - void declaration
     */
    protected void sourceChanged(@NotNull ListChangeListener.Change<? extends ObservableList<A>> change) {
        Intrinsics.checkNotNullParameter(change, (String)"change");
        this.beginChange();
        while (change.next()) {
            if (change.wasPermutated()) {
                int i;
                int firstTouched;
                Object object;
                Iterator iterator = iterator = ((Map)this.indexMap).entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    object = (Pair)entry.getValue();
                    int index2 = ((Number)object.component1()).intValue();
                    ListChangeListener listener = (ListChangeListener)object.component2();
                    if (index2 < change.getFrom() || index2 >= change.getTo()) continue;
                    entry.setValue(new Pair((Object)change.getPermutation(index2), (Object)listener));
                }
                int[] newSubNestedIndexOffsets = new int[change.getTo() - change.getFrom()];
                object = change.getFrom() == 0 ? Integer.valueOf(0) : this.nestedIndexOffsets.get(change.getFrom() - 1);
                Intrinsics.checkNotNull((Object)object);
                int currentOffset = firstTouched = ((Number)object).intValue();
                int listener = change.getTo() - change.getFrom();
                for (int i2 = 0; i2 < listener; ++i2) {
                    newSubNestedIndexOffsets[i2] = currentOffset += ((ObservableList)this.getSource().get(change.getFrom() + i2)).size();
                }
                int[] concatenatedPermutation = new int[ArraysKt.last((int[])newSubNestedIndexOffsets)];
                int offset = 0;
                int n = change.getFrom();
                for (i = 0; i < n; ++i) {
                    ObservableList nestedList = (ObservableList)this.getSource().get(i);
                    int n2 = offset + nestedList.size();
                    for (int j = offset; j < n2; ++j) {
                        concatenatedPermutation[j] = j;
                    }
                    offset += nestedList.size();
                }
                n = newSubNestedIndexOffsets.length;
                for (i = 0; i < n; ++i) {
                    int startingOffset = this.startingOffsetOf(change.getFrom() + i);
                    int permutedListIndex = change.getPermutation(change.getFrom() + i);
                    int permutedOffset = permutedListIndex == 0 ? 0 : newSubNestedIndexOffsets[permutedListIndex - 1];
                    int n3 = ((ObservableList)this.getSource().get(permutedListIndex)).size();
                    for (int j = 0; j < n3; ++j) {
                        concatenatedPermutation[startingOffset + j] = permutedOffset + j;
                    }
                }
                n = newSubNestedIndexOffsets.length;
                for (i = 0; i < n; ++i) {
                    this.nestedIndexOffsets.set(change.getFrom() + i, newSubNestedIndexOffsets[i]);
                }
                this.nextPermutation(firstTouched, ArraysKt.last((int[])newSubNestedIndexOffsets), concatenatedPermutation);
            } else {
                if (change.wasUpdated()) {
                    throw new UnsupportedOperationException("Updates not supported");
                }
                if (change.wasRemoved()) {
                    void $this$flatMapTo$iv$iv;
                    Iterator newSubNestedIndexOffsets = iterator = ((Map)this.indexMap).entrySet().iterator();
                    while (newSubNestedIndexOffsets.hasNext()) {
                        Map.Entry entry = newSubNestedIndexOffsets.next();
                        WrappedObservableList wrapped = (WrappedObservableList)entry.getKey();
                        Pair pair = (Pair)entry.getValue();
                        int index3 = ((Number)pair.component1()).intValue();
                        ListChangeListener listener = (ListChangeListener)pair.component2();
                        if (index3 < change.getFrom()) continue;
                        int removeEnd = change.getFrom() + change.getRemovedSize();
                        if (index3 < removeEnd) {
                            wrapped.getObservableList().removeListener(listener);
                            iterator.remove();
                            continue;
                        }
                        entry.setValue(new Pair((Object)(index3 - change.getRemovedSize()), (Object)listener));
                    }
                    this.invalidateOffsets(change.getFrom());
                    int removeStart = this.startingOffsetOf(change.getFrom());
                    List list = change.getRemoved();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRemoved(...)");
                    Iterable $this$flatMap$iv = list;
                    boolean $i$f$flatMap = false;
                    Iterable index3 = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        ObservableList it = (ObservableList)element$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        Iterable list$iv$iv = (Iterable)it;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    List removed = (List)destination$iv$iv;
                    this.nextRemove(removeStart, removed);
                }
                if (change.wasAdded()) {
                    if (change.getFrom() != this.indexMap.size()) {
                        Iterator removeStart = iterator = ((Map)this.indexMap).entrySet().iterator();
                        while (removeStart.hasNext()) {
                            Map.Entry entry = removeStart.next();
                            Pair pair = (Pair)entry.getValue();
                            int index4 = ((Number)pair.component1()).intValue();
                            ListChangeListener listener = (ListChangeListener)pair.component2();
                            if (index4 < change.getFrom()) continue;
                            entry.setValue(new Pair((Object)(index4 + change.getAddedSize()), (Object)listener));
                        }
                    }
                    List list = change.getAddedSubList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAddedSubList(...)");
                    Iterable $this$forEachIndexed$iv = list;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        void observableList;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        ObservableList destination$iv$iv = (ObservableList)item$iv;
                        int sublistIndex = n;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)observableList);
                        WrappedObservableList wrapped = new WrappedObservableList(observableList);
                        ((Map)this.indexMap).put(wrapped, new Pair((Object)(change.getFrom() + sublistIndex), this.createListener(wrapped)));
                    }
                    this.invalidateOffsets(change.getFrom());
                    this.recalculateOffsets();
                    int n = this.startingOffsetOf(change.getFrom());
                    Integer n4 = this.nestedIndexOffsets.get(change.getTo() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"get(...)");
                    this.nextAdd(n, ((Number)n4).intValue());
                }
            }
            this.recalculateOffsets();
        }
        this.endChange();
    }

    private final void invalidateOffsets(int index2) {
        this.firstInvalidatedPosition = Math.min(this.firstInvalidatedPosition, index2);
    }

    private final void recalculateOffsets() {
        if (this.firstInvalidatedPosition < this.getSource().size()) {
            int firstInvalid = this.firstInvalidatedPosition;
            Integer n = firstInvalid == 0 ? Integer.valueOf(0) : this.nestedIndexOffsets.get(firstInvalid - 1);
            Intrinsics.checkNotNull((Object)n);
            int offset = ((Number)n).intValue();
            int n2 = this.getSource().size();
            for (int i = firstInvalid; i < n2; ++i) {
                offset += ((ObservableList)this.getSource().get(i)).size();
                if (i < this.nestedIndexOffsets.size()) {
                    this.nestedIndexOffsets.set(i, offset);
                    continue;
                }
                this.nestedIndexOffsets.add(offset);
            }
            while (this.nestedIndexOffsets.size() > this.getSource().size()) {
                this.nestedIndexOffsets.remove(this.getSource().size());
            }
            this.firstInvalidatedPosition = this.nestedIndexOffsets.size();
        }
    }

    public int getSize() {
        this.recalculateOffsets();
        return this.nestedIndexOffsets.size() > 0 ? ((Number)CollectionsKt.last((List)this.nestedIndexOffsets)).intValue() : 0;
    }

    public int getSourceIndex(int index2) {
        throw new UnsupportedOperationException("Source index not supported in concatenation");
    }

    public A get(int index2) {
        Object object;
        this.recalculateOffsets();
        int listIndex2 = CollectionsKt.binarySearch$default((List)this.nestedIndexOffsets, (int)0, (int)0, (Function1)((Function1)new Function1<Integer, Integer>(index2){
            final /* synthetic */ int $index;
            {
                this.$index = $index;
                super(1);
            }

            @NotNull
            public final Integer invoke(int offset) {
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(offset), (Comparable)Integer.valueOf(this.$index));
            }
        }), (int)3, null);
        if (listIndex2 >= 0) {
            int nonEmptyListIndex = listIndex2 + 1;
            while (((ObservableList)this.getSource().get(nonEmptyListIndex)).isEmpty()) {
                ++nonEmptyListIndex;
            }
            object = ((ObservableList)this.getSource().get(nonEmptyListIndex)).get(0);
        } else {
            int rangeListIndex = -listIndex2 - 1;
            int subListOffset = index2 - this.startingOffsetOf(rangeListIndex);
            object = ((ObservableList)this.getSource().get(rangeListIndex)).get(subListOffset);
        }
        return (A)object;
    }

    private static final void createListener$lambda$1(AbstractConcatenatedList this$0, WrappedObservableList $wrapped, ListChangeListener.Change change) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$wrapped, (String)"$wrapped");
        this$0.beginChange();
        while (change.next()) {
            if (change.wasPermutated()) {
                int i;
                Pair pair = this$0.indexMap.get($wrapped);
                Intrinsics.checkNotNull(pair);
                int nestedListIndex = ((Number)pair.getFirst()).intValue();
                int[] permutation = new int[change.getTo()];
                int startingOffset = this$0.startingOffsetOf(nestedListIndex);
                int firstTouched = startingOffset + change.getFrom();
                for (i = 0; i < firstTouched; ++i) {
                    permutation[i] = i;
                }
                int n = startingOffset + change.getTo();
                for (i = firstTouched; i < n; ++i) {
                    permutation[startingOffset + i] = change.getPermutation(i);
                }
                this$0.nextPermutation(firstTouched, startingOffset + change.getTo(), permutation);
            } else if (change.wasUpdated()) {
                Pair pair = this$0.indexMap.get($wrapped);
                Intrinsics.checkNotNull(pair);
                listIndex = ((Number)pair.getFirst()).intValue();
                int startingOffset = this$0.startingOffsetOf(listIndex);
                int n = change.getTo();
                for (int i = change.getFrom(); i < n; ++i) {
                    this$0.nextUpdate(startingOffset + i);
                }
            } else {
                if (change.wasRemoved()) {
                    Pair pair = this$0.indexMap.get($wrapped);
                    Intrinsics.checkNotNull(pair);
                    listIndex = ((Number)pair.getFirst()).intValue();
                    if (!change.wasAdded() || change.getAddedSize() != change.getRemovedSize()) {
                        this$0.invalidateOffsets(listIndex);
                    }
                    int startingOffset = this$0.startingOffsetOf(listIndex);
                    this$0.nextRemove(startingOffset + change.getFrom(), change.getRemoved());
                }
                if (change.wasAdded()) {
                    Pair pair = this$0.indexMap.get($wrapped);
                    Intrinsics.checkNotNull(pair);
                    listIndex = ((Number)pair.getFirst()).intValue();
                    if (!change.wasRemoved() || change.getAddedSize() != change.getRemovedSize()) {
                        this$0.invalidateOffsets(listIndex);
                    }
                    int startingOffset = this$0.startingOffsetOf(listIndex);
                    this$0.nextAdd(startingOffset + change.getFrom(), startingOffset + change.getTo());
                }
            }
            this$0.recalculateOffsets();
        }
        this$0.endChange();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/client/jfx/utils/AbstractConcatenatedList$WrappedObservableList;", "A", "", "observableList", "Ljavafx/collections/ObservableList;", "(Ljavafx/collections/ObservableList;)V", "getObservableList", "()Ljavafx/collections/ObservableList;", "jfx"})
    public static final class WrappedObservableList<A> {
        @NotNull
        private final ObservableList<A> observableList;

        public WrappedObservableList(@NotNull ObservableList<A> observableList) {
            Intrinsics.checkNotNullParameter(observableList, (String)"observableList");
            this.observableList = observableList;
        }

        @NotNull
        public final ObservableList<A> getObservableList() {
            return this.observableList;
        }
    }
}

