/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.jfx.model;

import java.math.BigInteger;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.corda.client.jfx.model.Unknown;
import net.corda.client.jfx.utils.ObservableUtilities;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.StateRef;
import net.corda.core.contracts.TransactionState;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.crypto.SecureHash;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.TransactionDeserialisationException;
import net.corda.core.transactions.BaseTransaction;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.transactions.WireTransaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001f !B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00060\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u00c6\u0003J\u0017\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00060\u0005H\u00c6\u0003JA\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0016\b\u0002\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001f\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lnet/corda/client/jfx/model/PartiallyResolvedTransaction;", "", "transaction", "Lnet/corda/core/transactions/SignedTransaction;", "inputs", "", "Ljavafx/beans/value/ObservableValue;", "Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$InputResolution;", "outputs", "Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$OutputResolution;", "(Lnet/corda/core/transactions/SignedTransaction;Ljava/util/List;Ljava/util/List;)V", "id", "Lnet/corda/core/crypto/SecureHash;", "getId", "()Lnet/corda/core/crypto/SecureHash;", "getInputs", "()Ljava/util/List;", "getOutputs", "getTransaction", "()Lnet/corda/core/transactions/SignedTransaction;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "InputResolution", "OutputResolution", "jfx"})
public final class PartiallyResolvedTransaction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SignedTransaction transaction;
    @NotNull
    private final List<ObservableValue<InputResolution>> inputs;
    @NotNull
    private final List<ObservableValue<? extends OutputResolution>> outputs;
    @NotNull
    private final SecureHash id;
    @NotNull
    private static final Party DUMMY_NOTARY;

    public PartiallyResolvedTransaction(@NotNull SignedTransaction transaction, @NotNull List<? extends ObservableValue<InputResolution>> inputs, @NotNull List<? extends ObservableValue<? extends OutputResolution>> outputs) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        this.transaction = transaction;
        this.inputs = inputs;
        this.outputs = outputs;
        this.id = this.transaction.getId();
    }

    @NotNull
    public final SignedTransaction getTransaction() {
        return this.transaction;
    }

    @NotNull
    public final List<ObservableValue<InputResolution>> getInputs() {
        return this.inputs;
    }

    @NotNull
    public final List<ObservableValue<? extends OutputResolution>> getOutputs() {
        return this.outputs;
    }

    @NotNull
    public final SecureHash getId() {
        return this.id;
    }

    @NotNull
    public final SignedTransaction component1() {
        return this.transaction;
    }

    @NotNull
    public final List<ObservableValue<InputResolution>> component2() {
        return this.inputs;
    }

    @NotNull
    public final List<ObservableValue<? extends OutputResolution>> component3() {
        return this.outputs;
    }

    @NotNull
    public final PartiallyResolvedTransaction copy(@NotNull SignedTransaction transaction, @NotNull List<? extends ObservableValue<InputResolution>> inputs, @NotNull List<? extends ObservableValue<? extends OutputResolution>> outputs) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        return new PartiallyResolvedTransaction(transaction, inputs, outputs);
    }

    public static /* synthetic */ PartiallyResolvedTransaction copy$default(PartiallyResolvedTransaction partiallyResolvedTransaction, SignedTransaction signedTransaction, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            signedTransaction = partiallyResolvedTransaction.transaction;
        }
        if ((n & 2) != 0) {
            list = partiallyResolvedTransaction.inputs;
        }
        if ((n & 4) != 0) {
            list2 = partiallyResolvedTransaction.outputs;
        }
        return partiallyResolvedTransaction.copy(signedTransaction, list, list2);
    }

    @NotNull
    public String toString() {
        return "PartiallyResolvedTransaction(transaction=" + this.transaction + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ")";
    }

    public int hashCode() {
        int result = this.transaction.hashCode();
        result = result * 31 + ((Object)this.inputs).hashCode();
        result = result * 31 + ((Object)this.outputs).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PartiallyResolvedTransaction)) {
            return false;
        }
        PartiallyResolvedTransaction partiallyResolvedTransaction = (PartiallyResolvedTransaction)other;
        if (!Intrinsics.areEqual((Object)this.transaction, (Object)partiallyResolvedTransaction.transaction)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inputs, partiallyResolvedTransaction.inputs)) {
            return false;
        }
        return Intrinsics.areEqual(this.outputs, partiallyResolvedTransaction.outputs);
    }

    static {
        CordaX500Name cordaX500Name = new CordaX500Name("Dummy Notary", "Nowhere", "ZZ");
        BigInteger bigInteger = BigInteger.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO");
        PublicKey publicKey = CryptoUtils.entropyToKeyPair((BigInteger)bigInteger).getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        DUMMY_NOTARY = new Party(cordaX500Name, publicKey);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\b0\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$Companion;", "", "()V", "DUMMY_NOTARY", "Lnet/corda/core/identity/Party;", "fromSignedTransaction", "Lnet/corda/client/jfx/model/PartiallyResolvedTransaction;", "transaction", "Lnet/corda/core/transactions/SignedTransaction;", "inputTransactions", "", "Lnet/corda/core/contracts/StateRef;", "jfx"})
    @SourceDebugExtension(value={"SMAP\nTransactionDataModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionDataModel.kt\nnet/corda/client/jfx/model/PartiallyResolvedTransaction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BaseTransaction.kt\nnet/corda/core/transactions/BaseTransaction\n*L\n1#1,122:1\n1549#2:123\n1620#2,3:124\n1549#2:128\n1620#2,3:129\n1549#2:132\n1620#2,3:133\n1549#2:136\n1620#2,3:137\n137#3:127\n*S KotlinDebug\n*F\n+ 1 TransactionDataModel.kt\nnet/corda/client/jfx/model/PartiallyResolvedTransaction$Companion\n*L\n77#1:123\n77#1:124,3\n86#1:128\n86#1:129,3\n92#1:132\n92#1:133,3\n93#1:136\n93#1:137,3\n86#1:127\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PartiallyResolvedTransaction fromSignedTransaction(@NotNull SignedTransaction transaction, @NotNull Map<StateRef, SignedTransaction> inputTransactions) {
            Collection collection;
            Collection collection2;
            SignedTransaction signedTransaction;
            StateAndRef stateRef;
            Collection collection3;
            Object object;
            Iterable $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(inputTransactions, (String)"inputTransactions");
            ContractState contractState = Unknown.State.INSTANCE;
            String string = Unknown.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Party party = transaction.getNotary();
            if (party == null) {
                party = DUMMY_NOTARY;
            }
            TransactionState unknownTransactionState = new TransactionState(contractState, string, party, null, null, 24, null);
            InternalUtils.eagerDeserialise((List)transaction.getCoreTransaction().getOutputs(), (Function2)((Function2)new Function2<TransactionDeserialisationException, Integer, TransactionState<? extends ContractState>>((TransactionState<Unknown.State>)unknownTransactionState){
                final /* synthetic */ TransactionState<Unknown.State> $unknownTransactionState;
                {
                    this.$unknownTransactionState = $unknownTransactionState;
                    super(2);
                }

                @Nullable
                public final TransactionState<ContractState> invoke(@NotNull TransactionDeserialisationException transactionDeserialisationException, int n) {
                    Intrinsics.checkNotNullParameter((Object)transactionDeserialisationException, (String)"<anonymous parameter 0>");
                    return this.$unknownTransactionState;
                }
            }));
            Iterable iterable = transaction.getInputs();
            SignedTransaction signedTransaction2 = transaction;
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                object = (StateRef)item$iv$iv;
                collection3 = destination$iv$iv;
                boolean bl = false;
                SignedTransaction tx = inputTransactions.get(stateRef);
                collection3.add(ObservableUtilities.lift(tx == null ? (InputResolution)new InputResolution.Unresolved((StateRef)stateRef) : (InputResolution)new InputResolution.Resolved((StateAndRef<? extends ContractState>)tx.getCoreTransaction().outRef(stateRef.getIndex()))));
            }
            List list = (List)destination$iv$iv;
            SignedTransaction signedTransaction3 = signedTransaction2;
            if (transaction.getCoreTransaction() instanceof WireTransaction) {
                Object this_$iv = (BaseTransaction)transaction.getTx();
                boolean $i$f$outRefsOfType = false;
                this_$iv = this_$iv.outRefsOfType(ContractState.class);
                collection3 = list;
                signedTransaction2 = signedTransaction3;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    stateRef = (StateAndRef)item$iv$iv;
                    var18_24 = destination$iv$iv;
                    boolean bl = false;
                    var18_24.add(ObservableUtilities.lift(new OutputResolution.Resolved((StateAndRef<? extends ContractState>)it)));
                }
                var18_24 = (List)destination$iv$iv;
                signedTransaction = signedTransaction2;
                collection2 = collection3;
                collection = var18_24;
            } else {
                Iterable $this$mapTo$iv$iv2;
                Iterable $this$map$iv2;
                int outputCount = transaction.getCoreTransaction().getInputs().size();
                $this$mapTo$iv$iv = (Iterable)RangesKt.until((int)0, (int)outputCount);
                collection3 = list;
                signedTransaction2 = signedTransaction3;
                boolean $i$f$map2 = false;
                void $i$f$mapTo2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo3 = false;
                object = $this$mapTo$iv$iv2.iterator();
                while (object.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int tx = item$iv$iv = ((IntIterator)object).nextInt();
                    var18_24 = destination$iv$iv2;
                    boolean bl = false;
                    var18_24.add((ObservableValue<OutputResolution>)new StateRef(transaction.getId(), (int)it));
                }
                var18_24 = (List)destination$iv$iv2;
                List stateRefs = var18_24;
                $this$map$iv2 = stateRefs;
                $i$f$map2 = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void stateRef2;
                    StateRef it = (StateRef)item$iv$iv;
                    var18_24 = destination$iv$iv2;
                    boolean bl = false;
                    SignedTransaction tx = inputTransactions.get(stateRef2);
                    var18_24.add(ObservableUtilities.lift(tx == null ? (OutputResolution)new OutputResolution.Unresolved((StateRef)stateRef2) : (OutputResolution)new OutputResolution.Resolved((StateAndRef<? extends ContractState>)tx.getCoreTransaction().outRef(stateRef2.getIndex()))));
                }
                var18_24 = (List)destination$iv$iv2;
                signedTransaction = signedTransaction2;
                collection2 = collection3;
                collection = var18_24;
            }
            List list2 = collection;
            Collection collection4 = collection2;
            SignedTransaction signedTransaction4 = signedTransaction;
            return new PartiallyResolvedTransaction(signedTransaction4, (List<? extends ObservableValue<InputResolution>>)collection4, list2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$InputResolution;", "", "()V", "stateRef", "Lnet/corda/core/contracts/StateRef;", "getStateRef", "()Lnet/corda/core/contracts/StateRef;", "Resolved", "Unresolved", "Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$InputResolution$Resolved;", "Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$InputResolution$Unresolved;", "jfx"})
    public static abstract class InputResolution {
        private InputResolution() {
        }

        @NotNull
        public abstract StateRef getStateRef();

        public /* synthetic */ InputResolution(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$InputResolution$Resolved;", "Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$InputResolution;", "stateAndRef", "Lnet/corda/core/contracts/StateAndRef;", "Lnet/corda/core/contracts/ContractState;", "(Lnet/corda/core/contracts/StateAndRef;)V", "getStateAndRef", "()Lnet/corda/core/contracts/StateAndRef;", "stateRef", "Lnet/corda/core/contracts/StateRef;", "getStateRef", "()Lnet/corda/core/contracts/StateRef;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jfx"})
        public static final class Resolved
        extends InputResolution {
            @NotNull
            private final StateAndRef<ContractState> stateAndRef;

            public Resolved(@NotNull StateAndRef<? extends ContractState> stateAndRef) {
                Intrinsics.checkNotNullParameter(stateAndRef, (String)"stateAndRef");
                super(null);
                this.stateAndRef = stateAndRef;
            }

            @NotNull
            public final StateAndRef<ContractState> getStateAndRef() {
                return this.stateAndRef;
            }

            @Override
            @NotNull
            public StateRef getStateRef() {
                return this.stateAndRef.getRef();
            }

            @NotNull
            public final StateAndRef<ContractState> component1() {
                return this.stateAndRef;
            }

            @NotNull
            public final Resolved copy(@NotNull StateAndRef<? extends ContractState> stateAndRef) {
                Intrinsics.checkNotNullParameter(stateAndRef, (String)"stateAndRef");
                return new Resolved(stateAndRef);
            }

            public static /* synthetic */ Resolved copy$default(Resolved resolved, StateAndRef stateAndRef, int n, Object object) {
                if ((n & 1) != 0) {
                    stateAndRef = resolved.stateAndRef;
                }
                return resolved.copy(stateAndRef);
            }

            @NotNull
            public String toString() {
                return "Resolved(stateAndRef=" + this.stateAndRef + ")";
            }

            public int hashCode() {
                return this.stateAndRef.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Resolved)) {
                    return false;
                }
                Resolved resolved = (Resolved)other;
                return Intrinsics.areEqual(this.stateAndRef, resolved.stateAndRef);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$InputResolution$Unresolved;", "Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$InputResolution;", "stateRef", "Lnet/corda/core/contracts/StateRef;", "(Lnet/corda/core/contracts/StateRef;)V", "getStateRef", "()Lnet/corda/core/contracts/StateRef;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jfx"})
        public static final class Unresolved
        extends InputResolution {
            @NotNull
            private final StateRef stateRef;

            public Unresolved(@NotNull StateRef stateRef) {
                Intrinsics.checkNotNullParameter((Object)stateRef, (String)"stateRef");
                super(null);
                this.stateRef = stateRef;
            }

            @Override
            @NotNull
            public StateRef getStateRef() {
                return this.stateRef;
            }

            @NotNull
            public final StateRef component1() {
                return this.stateRef;
            }

            @NotNull
            public final Unresolved copy(@NotNull StateRef stateRef) {
                Intrinsics.checkNotNullParameter((Object)stateRef, (String)"stateRef");
                return new Unresolved(stateRef);
            }

            public static /* synthetic */ Unresolved copy$default(Unresolved unresolved, StateRef stateRef, int n, Object object) {
                if ((n & 1) != 0) {
                    stateRef = unresolved.stateRef;
                }
                return unresolved.copy(stateRef);
            }

            @NotNull
            public String toString() {
                return "Unresolved(stateRef=" + this.stateRef + ")";
            }

            public int hashCode() {
                return this.stateRef.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unresolved)) {
                    return false;
                }
                Unresolved unresolved = (Unresolved)other;
                return Intrinsics.areEqual((Object)this.stateRef, (Object)unresolved.stateRef);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$OutputResolution;", "", "()V", "stateRef", "Lnet/corda/core/contracts/StateRef;", "getStateRef", "()Lnet/corda/core/contracts/StateRef;", "Resolved", "Unresolved", "Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$OutputResolution$Resolved;", "Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$OutputResolution$Unresolved;", "jfx"})
    public static abstract class OutputResolution {
        private OutputResolution() {
        }

        @NotNull
        public abstract StateRef getStateRef();

        public /* synthetic */ OutputResolution(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$OutputResolution$Resolved;", "Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$OutputResolution;", "stateAndRef", "Lnet/corda/core/contracts/StateAndRef;", "Lnet/corda/core/contracts/ContractState;", "(Lnet/corda/core/contracts/StateAndRef;)V", "getStateAndRef", "()Lnet/corda/core/contracts/StateAndRef;", "stateRef", "Lnet/corda/core/contracts/StateRef;", "getStateRef", "()Lnet/corda/core/contracts/StateRef;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jfx"})
        public static final class Resolved
        extends OutputResolution {
            @NotNull
            private final StateAndRef<ContractState> stateAndRef;

            public Resolved(@NotNull StateAndRef<? extends ContractState> stateAndRef) {
                Intrinsics.checkNotNullParameter(stateAndRef, (String)"stateAndRef");
                super(null);
                this.stateAndRef = stateAndRef;
            }

            @NotNull
            public final StateAndRef<ContractState> getStateAndRef() {
                return this.stateAndRef;
            }

            @Override
            @NotNull
            public StateRef getStateRef() {
                return this.stateAndRef.getRef();
            }

            @NotNull
            public final StateAndRef<ContractState> component1() {
                return this.stateAndRef;
            }

            @NotNull
            public final Resolved copy(@NotNull StateAndRef<? extends ContractState> stateAndRef) {
                Intrinsics.checkNotNullParameter(stateAndRef, (String)"stateAndRef");
                return new Resolved(stateAndRef);
            }

            public static /* synthetic */ Resolved copy$default(Resolved resolved, StateAndRef stateAndRef, int n, Object object) {
                if ((n & 1) != 0) {
                    stateAndRef = resolved.stateAndRef;
                }
                return resolved.copy(stateAndRef);
            }

            @NotNull
            public String toString() {
                return "Resolved(stateAndRef=" + this.stateAndRef + ")";
            }

            public int hashCode() {
                return this.stateAndRef.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Resolved)) {
                    return false;
                }
                Resolved resolved = (Resolved)other;
                return Intrinsics.areEqual(this.stateAndRef, resolved.stateAndRef);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$OutputResolution$Unresolved;", "Lnet/corda/client/jfx/model/PartiallyResolvedTransaction$OutputResolution;", "stateRef", "Lnet/corda/core/contracts/StateRef;", "(Lnet/corda/core/contracts/StateRef;)V", "getStateRef", "()Lnet/corda/core/contracts/StateRef;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jfx"})
        public static final class Unresolved
        extends OutputResolution {
            @NotNull
            private final StateRef stateRef;

            public Unresolved(@NotNull StateRef stateRef) {
                Intrinsics.checkNotNullParameter((Object)stateRef, (String)"stateRef");
                super(null);
                this.stateRef = stateRef;
            }

            @Override
            @NotNull
            public StateRef getStateRef() {
                return this.stateRef;
            }

            @NotNull
            public final StateRef component1() {
                return this.stateRef;
            }

            @NotNull
            public final Unresolved copy(@NotNull StateRef stateRef) {
                Intrinsics.checkNotNullParameter((Object)stateRef, (String)"stateRef");
                return new Unresolved(stateRef);
            }

            public static /* synthetic */ Unresolved copy$default(Unresolved unresolved, StateRef stateRef, int n, Object object) {
                if ((n & 1) != 0) {
                    stateRef = unresolved.stateRef;
                }
                return unresolved.copy(stateRef);
            }

            @NotNull
            public String toString() {
                return "Unresolved(stateRef=" + this.stateRef + ")";
            }

            public int hashCode() {
                return this.stateRef.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unresolved)) {
                    return false;
                }
                Unresolved unresolved = (Unresolved)other;
                return Intrinsics.areEqual((Object)this.stateRef, (Object)unresolved.stateRef);
            }
        }
    }
}

