/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.jfx.model;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Currency;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.client.jfx.model.ExchangeRate;
import net.corda.client.jfx.model.ExchangeRateModelKt;
import net.corda.finance.Currencies;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/client/jfx/model/ExchangeRateModel;", "", "()V", "exchangeRate", "Ljavafx/beans/value/ObservableValue;", "Lnet/corda/client/jfx/model/ExchangeRate;", "getExchangeRate", "()Ljavafx/beans/value/ObservableValue;", "jfx"})
public final class ExchangeRateModel {
    @NotNull
    private final ObservableValue<ExchangeRate> exchangeRate = (ObservableValue)new SimpleObjectProperty((Object)new ExchangeRate(){

        @NotNull
        public BigDecimal rate(@NotNull Currency from, @NotNull Currency to) {
            BigDecimal bigDecimal;
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            if (Intrinsics.areEqual((Object)from, (Object)to)) {
                BigDecimal bigDecimal2 = BigDecimal.ONE;
                bigDecimal = bigDecimal2;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"ONE");
            } else if (Intrinsics.areEqual((Object)Currencies.USD, (Object)to)) {
                bigDecimal = ExchangeRateModelKt.access$safeFetchRate(from);
            } else if (Intrinsics.areEqual((Object)Currencies.USD, (Object)from)) {
                BigDecimal bigDecimal3 = BigDecimal.ONE.divide(ExchangeRateModelKt.access$safeFetchRate(to), MathContext.DECIMAL64);
                bigDecimal = bigDecimal3;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"divide(...)");
            } else {
                BigDecimal bigDecimal4 = ExchangeRateModelKt.access$safeFetchRate(from).divide(ExchangeRateModelKt.access$safeFetchRate(to), MathContext.DECIMAL64);
                bigDecimal = bigDecimal4;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"divide(...)");
            }
            return bigDecimal;
        }
    });

    @NotNull
    public final ObservableValue<ExchangeRate> getExchangeRate() {
        return this.exchangeRate;
    }
}

