/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.httprpc.client.internal.stream;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.base.stream.Cursor;
import net.corda.v5.base.stream.FiniteDurableCursor;
import net.corda.v5.base.stream.PositionManager;
import net.corda.v5.base.util.KotlinUtilsKt;
import net.corda.v5.httprpc.client.auth.RequestContext;
import net.corda.v5.httprpc.client.config.AuthenticationConfig;
import net.corda.v5.httprpc.client.internal.processing.MethodInformationResolverKt;
import net.corda.v5.httprpc.client.internal.processing.ParametersResolverKt;
import net.corda.v5.httprpc.client.internal.processing.ResolvedParameters;
import net.corda.v5.httprpc.client.internal.remote.HttpVerb;
import net.corda.v5.httprpc.client.internal.remote.RemoteClient;
import net.corda.v5.httprpc.client.internal.remote.WebRequest;
import net.corda.v5.httprpc.client.internal.remote.WebResponse;
import net.corda.v5.httprpc.client.internal.stream.DurableCursorTransferObject;
import net.corda.v5.httprpc.client.internal.stream.HttpRpcClientDurableStreamContext;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0002\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001c\u0010\t\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0002\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/corda/v5/httprpc/client/internal/stream/HttpRpcFiniteDurableCursorClientImpl;", "Lnet/corda/v5/base/stream/FiniteDurableCursor;", "", "client", "Lnet/corda/v5/httprpc/client/internal/remote/RemoteClient;", "method", "Ljava/lang/reflect/Method;", "rawPath", "", "args", "", "authenticationConfig", "Lnet/corda/v5/httprpc/client/config/AuthenticationConfig;", "positionManager", "Lnet/corda/v5/base/stream/PositionManager;", "(Lnet/corda/v5/httprpc/client/internal/remote/RemoteClient;Ljava/lang/reflect/Method;Ljava/lang/String;[Ljava/lang/Object;Lnet/corda/v5/httprpc/client/config/AuthenticationConfig;Lnet/corda/v5/base/stream/PositionManager;)V", "[Ljava/lang/Object;", "getPositionManager", "()Lnet/corda/v5/base/stream/PositionManager;", "poll", "Lnet/corda/v5/base/stream/Cursor$PollResult;", "maxCount", "", "awaitForResultTimeout", "Ljava/time/Duration;", "Companion", "http-rpc-client"})
final class HttpRpcFiniteDurableCursorClientImpl
implements FiniteDurableCursor<Object> {
    private final RemoteClient client;
    private final Method method;
    private final String rawPath;
    private final Object[] args;
    private final AuthenticationConfig authenticationConfig;
    @NotNull
    private final PositionManager positionManager;
    private static final Logger log;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Cursor.PollResult<Object> poll(int maxCount, @NotNull Duration awaitForResultTimeout) {
        Intrinsics.checkNotNullParameter((Object)awaitForResultTimeout, (String)"awaitForResultTimeout");
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            String string = "Poll maxCount: " + maxCount + ", timeout: " + awaitForResultTimeout + '.';
            logger.trace(string);
        }
        Object object = this.getPositionManager().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"positionManager.get()");
        ResolvedParameters parameters = ParametersResolverKt.parametersFrom(this.method, this.args, MapsKt.mapOf((Pair)TuplesKt.to((Object)"context", (Object)new HttpRpcClientDurableStreamContext(((Number)object).longValue(), maxCount, awaitForResultTimeout))));
        Type type = this.method.getGenericReturnType();
        if (type == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
        }
        ParameterizedType methodParameterizedType = (ParameterizedType)type;
        Type itemType = methodParameterizedType.getActualTypeArguments()[0];
        ParameterizedType pollResultParamType = TypeUtils.parameterize(DurableCursorTransferObject.Companion.PollResultImpl.class, (Type[])new Type[]{itemType});
        HttpVerb httpVerb = MethodInformationResolverKt.getEndpointHttpVerb(this.method);
        WebRequest<Object> webRequest = ParametersResolverKt.toWebRequest(parameters, this.rawPath);
        ParameterizedType parameterizedType = pollResultParamType;
        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"pollResultParamType");
        WebResponse<Object> response = this.client.call(httpVerb, webRequest, parameterizedType, RequestContext.Companion.fromAuthenticationConfig$http_rpc_client(this.authenticationConfig));
        Object object2 = response.getBody();
        Intrinsics.checkNotNull((Object)object2);
        return (Cursor.PollResult)KotlinUtilsKt.uncheckedCast((Object)object2);
    }

    @NotNull
    public PositionManager getPositionManager() {
        return this.positionManager;
    }

    public HttpRpcFiniteDurableCursorClientImpl(@NotNull RemoteClient client, @NotNull Method method, @NotNull String rawPath, @Nullable Object[] args, @NotNull AuthenticationConfig authenticationConfig, @NotNull PositionManager positionManager) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)rawPath, (String)"rawPath");
        Intrinsics.checkNotNullParameter((Object)authenticationConfig, (String)"authenticationConfig");
        Intrinsics.checkNotNullParameter((Object)positionManager, (String)"positionManager");
        this.client = client;
        this.method = method;
        this.rawPath = rawPath;
        this.args = args;
        this.authenticationConfig = authenticationConfig;
        this.positionManager = positionManager;
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/v5/httprpc/client/internal/stream/HttpRpcFiniteDurableCursorClientImpl$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "http-rpc-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

