/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.httprpc.client.internal.remote;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kong.unirest.Config;
import kong.unirest.GenericType;
import kong.unirest.Header;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import kong.unirest.apache.ApacheClient;
import kong.unirest.jackson.JacksonObjectMapper;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.corda.common.json.serialization.JsonSerializationKt;
import net.corda.v5.base.util.KotlinUtilsKt;
import net.corda.v5.httprpc.client.auth.RequestContext;
import net.corda.v5.httprpc.client.auth.scheme.AuthenticationScheme;
import net.corda.v5.httprpc.client.exceptions.InternalErrorException;
import net.corda.v5.httprpc.client.exceptions.MissingRequestedResourceException;
import net.corda.v5.httprpc.client.exceptions.PermissionException;
import net.corda.v5.httprpc.client.exceptions.RequestErrorException;
import net.corda.v5.httprpc.client.internal.HttpRpcClientSerializationKt;
import net.corda.v5.httprpc.client.internal.remote.HttpVerb;
import net.corda.v5.httprpc.client.internal.remote.RemoteClient;
import net.corda.v5.httprpc.client.internal.remote.RemoteUnirestClient;
import net.corda.v5.httprpc.client.internal.remote.RemoteUnirestClient$WhenMappings;
import net.corda.v5.httprpc.client.internal.remote.WebRequest;
import net.corda.v5.httprpc.client.internal.remote.WebResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J:\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J2\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J_\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00180\f\"\u0004\b\u0000\u0010\u000e\"\b\b\u0001\u0010\u0018*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00122\u0006\u0010\u0015\u001a\u00020\u00162!\u0010\u0019\u001a\u001d\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u001c0\u001a\u00a2\u0006\u0002\b\u001dH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/corda/v5/httprpc/client/internal/remote/RemoteUnirestClient;", "Lnet/corda/v5/httprpc/client/internal/remote/RemoteClient;", "baseAddress", "", "enableSsl", "", "(Ljava/lang/String;Z)V", "getBaseAddress", "()Ljava/lang/String;", "addSslParams", "", "call", "Lnet/corda/v5/httprpc/client/internal/remote/WebResponse;", "", "T", "verb", "Lnet/corda/v5/httprpc/client/internal/remote/HttpVerb;", "webRequest", "Lnet/corda/v5/httprpc/client/internal/remote/WebRequest;", "responseType", "Ljava/lang/reflect/Type;", "context", "Lnet/corda/v5/httprpc/client/auth/RequestContext;", "doCall", "R", "remoteCallFn", "Lkotlin/Function1;", "Lkong/unirest/HttpRequest;", "Lkong/unirest/HttpResponse;", "Lkotlin/ExtensionFunctionType;", "Companion", "http-rpc-client"})
public final class RemoteUnirestClient
implements RemoteClient {
    @NotNull
    private final String baseAddress;
    private final boolean enableSsl;
    private static final Logger log;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public <T> WebResponse<Object> call(@NotNull HttpVerb verb, @NotNull WebRequest<T> webRequest, @NotNull Type responseType, @NotNull RequestContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)verb), (String)"verb");
        Intrinsics.checkNotNullParameter(webRequest, (String)"webRequest");
        Intrinsics.checkNotNullParameter((Object)responseType, (String)"responseType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.doCall(verb, webRequest, context, (Function1)new Function1<HttpRequest<?>, HttpResponse<Object>>(responseType){
            final /* synthetic */ Type $responseType;

            @NotNull
            public final HttpResponse<Object> invoke(@NotNull HttpRequest<?> $this$doCall) {
                Intrinsics.checkNotNullParameter($this$doCall, (String)"$receiver");
                GenericType<Object> genericType2 = new GenericType<Object>(this){
                    final /* synthetic */ call.1 this$0;

                    @NotNull
                    public Type getType() {
                        return this.this$0.$responseType;
                    }

                    @NotNull
                    public Class<?> getTypeClass() {
                        return this.this$0.$responseType.getClass();
                    }
                    {
                        this.this$0 = this$0;
                    }
                };
                HttpResponse httpResponse = $this$doCall.asObject((GenericType)genericType2);
                Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"asObject(genericType)");
                return httpResponse;
            }
            {
                this.$responseType = type;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public <T> WebResponse<String> call(@NotNull HttpVerb verb, @NotNull WebRequest<T> webRequest, @NotNull RequestContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)verb), (String)"verb");
        Intrinsics.checkNotNullParameter(webRequest, (String)"webRequest");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.doCall(verb, webRequest, context, call.2.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final <T, R> WebResponse<R> doCall(HttpVerb verb, WebRequest<T> webRequest, RequestContext context, Function1<? super HttpRequest<?>, ? extends HttpResponse<R>> remoteCallFn) {
        Iterator<Map.Entry<String, Object>> iterator;
        boolean bl;
        HttpRequest httpRequest;
        String path = this.getBaseAddress() + webRequest.getPath();
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            String string = "Do call \"" + (Object)((Object)verb) + ' ' + path + "\".";
            logger.trace(string);
        }
        this.addSslParams();
        switch (RemoteUnirestClient$WhenMappings.$EnumSwitchMapping$0[verb.ordinal()]) {
            case 1: {
                httpRequest = (HttpRequest)Unirest.get((String)path);
                break;
            }
            case 2: {
                httpRequest = (HttpRequest)Unirest.post((String)path);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HttpRequest request = httpRequest;
        request.header("accept", "application/json");
        request.header("accept", "text/plain");
        AuthenticationScheme authenticationScheme = context.getAuthenticationScheme();
        Object object = context.getCredentials();
        HttpRequest httpRequest2 = request;
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest2, (String)"request");
        authenticationScheme.authenticate(object, httpRequest2, context);
        if (webRequest.getBody() != null && request instanceof HttpRequestWithBody) {
            request = (HttpRequest)((HttpRequestWithBody)request).body(webRequest.getBody());
        }
        Map<String, Object> map = webRequest.getQueryParameters();
        if (map != null) {
            Map<String, Object> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Map<String, Object> map2 = $this$forEach$iv;
            bl = false;
            iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> item = element$iv = iterator.next();
                boolean bl3 = false;
                if (item.getValue() instanceof Collection) {
                    Object object2 = item.getValue();
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Collection<*>");
                    }
                    Iterable $this$forEach$iv2 = (Collection)object2;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator2 = $this$forEach$iv2.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv2;
                        Object it = element$iv2 = iterator2.next();
                        boolean bl4 = false;
                        request = request.queryString(item.getKey(), it);
                    }
                    continue;
                }
                request = request.queryString(item.getKey(), item.getValue());
            }
        }
        try {
            Map map3;
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            HttpResponse response;
            block26: {
                block25: {
                    HttpRequest httpRequest3 = request;
                    Intrinsics.checkNotNullExpressionValue((Object)httpRequest3, (String)"request");
                    response = (HttpResponse)remoteCallFn.invoke((Object)httpRequest3);
                    if (!response.isSuccess()) break block25;
                    Optional optional = response.getParsingError();
                    Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"response.parsingError");
                    if (!optional.isPresent()) break block26;
                }
                Object object3 = response.mapError(String.class);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"response.mapError(String::class.java)");
                String errorResponseJson = JsonSerializationKt.formatAsJson$default((Object)object3, null, (int)1, null);
                switch (response.getStatus()) {
                    case 400: {
                        throw (Throwable)((Object)new RequestErrorException(errorResponseJson));
                    }
                    case 401: 
                    case 403: 
                    case 405: 
                    case 407: {
                        throw (Throwable)((Object)new PermissionException(errorResponseJson));
                    }
                    case 404: {
                        throw (Throwable)((Object)new MissingRequestedResourceException(errorResponseJson));
                    }
                }
                throw (Throwable)((Object)new InternalErrorException(errorResponseJson));
            }
            Object object4 = response.getBody();
            List list = response.getHeaders().all();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"response.headers.all()");
            Iterable errorResponseJson = list;
            Object object5 = object4;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            iterator = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Header it;
                Header $i$f$forEach2 = (Header)element$iv$iv;
                map3 = destination$iv$iv;
                boolean bl5 = false;
                void v11 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"it");
                String string = v11.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                String string2 = string;
                it = (Header)element$iv$iv;
                boolean bl6 = false;
                Header header = it;
                Intrinsics.checkNotNullExpressionValue((Object)header, (String)"it");
                String string3 = header.getValue();
                map3.put(string2, string3);
            }
            map3 = destination$iv$iv;
            String string = response.getStatusText();
            int n = response.getStatus();
            Map map4 = map3;
            Object object6 = object5;
            WebResponse<Object> webResponse = new WebResponse<Object>(object6, map4, n, string);
            boolean bl7 = false;
            bl = false;
            WebResponse<Object> it = webResponse;
            boolean bl8 = false;
            Logger $this$trace$iv2 = log;
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                Logger logger = $this$trace$iv2;
                boolean bl9 = false;
                String string4 = "Do call \"" + (Object)((Object)verb) + ' ' + path + "\" completed.";
                logger.trace(string4);
            }
            return webResponse;
        }
        catch (UnirestException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "No message provided";
            }
            throw (Throwable)((Object)new InternalErrorException(string));
        }
    }

    private final void addSslParams() {
        String string;
        Logger logger;
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            string = "Add Ssl params.";
            logger.trace(string);
        }
        if (this.enableSsl) {
            SSLContext sSLContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
            Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"SSLContexts.custom()\n   \u2026                 .build()");
            SSLContext sslContext = sSLContext;
            CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();
            Config bl = Unirest.config();
            boolean bl2 = false;
            boolean bl3 = false;
            Config config = bl;
            boolean bl4 = false;
            config.httpClient(ApacheClient.builder((HttpClient)((HttpClient)httpClient)).apply(config));
        }
        $this$trace$iv = log;
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            string = "Add Ssl params completed.";
            logger.trace(string);
        }
    }

    @Override
    @NotNull
    public String getBaseAddress() {
        return this.baseAddress;
    }

    public RemoteUnirestClient(@NotNull String baseAddress, boolean enableSsl) {
        Intrinsics.checkNotNullParameter((Object)baseAddress, (String)"baseAddress");
        this.baseAddress = baseAddress;
        this.enableSsl = enableSsl;
        Config config = Unirest.config();
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"Unirest.config()");
        config.setObjectMapper((ObjectMapper)new JacksonObjectMapper(HttpRpcClientSerializationKt.getObjectMapper()));
    }

    public /* synthetic */ RemoteUnirestClient(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/v5/httprpc/client/internal/remote/RemoteUnirestClient$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "http-rpc-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

