/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.httprpc.client.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.base.util.KotlinUtilsKt;
import net.corda.v5.crypto.SecureHash;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/corda/v5/httprpc/client/internal/SecureHashDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lnet/corda/v5/crypto/SecureHash;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "http-rpc-client"})
public final class SecureHashDeserializer
extends JsonDeserializer<SecureHash> {
    private static final Logger log;
    @NotNull
    public static final SecureHashDeserializer INSTANCE;

    @NotNull
    public SecureHash deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Logger logger = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        Object $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger2 = $this$trace$iv;
            boolean bl2 = false;
            String string = "Deserialize.";
            logger2.trace(string);
        }
        try {
            String string = parser.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parser.text");
            $this$trace$iv = KotlinUtilsKt.uncheckedCast((Object)SecureHash.Companion.create(string));
            boolean bl3 = false;
            bl = false;
            SecureHash it = (SecureHash)$this$trace$iv;
            boolean bl4 = false;
            Logger logger3 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"log");
            Logger $this$trace$iv2 = logger3;
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                Logger logger4 = $this$trace$iv2;
                boolean bl5 = false;
                String string2 = "Deserialize completed.";
                logger4.trace(string2);
            }
            return (SecureHash)$this$trace$iv;
        }
        catch (Exception e) {
            String string = "Invalid hash " + parser.getText() + ": " + e.getMessage();
            bl = false;
            boolean bl6 = false;
            String it = string;
            boolean bl7 = false;
            log.error(it);
            throw (Throwable)new JsonParseException(parser, it, (Throwable)e);
        }
    }

    private SecureHashDeserializer() {
    }

    static {
        SecureHashDeserializer secureHashDeserializer;
        INSTANCE = secureHashDeserializer = new SecureHashDeserializer();
        log = LoggerFactory.getLogger(((Object)((Object)secureHashDeserializer)).getClass());
    }
}

