/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.httprpc.client.internal;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.application.messaging.RPCOps;
import net.corda.v5.base.util.KotlinUtilsKt;
import net.corda.v5.httprpc.client.HttpRpcConnection;
import net.corda.v5.httprpc.client.HttpRpcConnectionListener;
import net.corda.v5.httprpc.client.auth.credentials.CredentialsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001fB!\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\r\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0017\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0017\u0010\u0019\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\b\u001aJ'\u0010\u001b\u001a\u00020\u00132\u001d\u0010\u001c\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\u00130\u001d\u00a2\u0006\u0002\b\u001eH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lnet/corda/v5/httprpc/client/internal/HttpRpcConnectionListenerDistributor;", "I", "Lnet/corda/v5/application/messaging/RPCOps;", "", "listeners", "", "Lnet/corda/v5/httprpc/client/HttpRpcConnectionListener;", "credentialsProvider", "Lnet/corda/v5/httprpc/client/auth/credentials/CredentialsProvider;", "(Ljava/lang/Iterable;Lnet/corda/v5/httprpc/client/auth/credentials/CredentialsProvider;)V", "connected", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connectionOpt", "Lnet/corda/v5/httprpc/client/HttpRpcConnection;", "getConnectionOpt$http_rpc_client", "()Lnet/corda/v5/httprpc/client/HttpRpcConnection;", "setConnectionOpt$http_rpc_client", "(Lnet/corda/v5/httprpc/client/HttpRpcConnection;)V", "onConnect", "", "onConnect$http_rpc_client", "onDisconnect", "throwableOpt", "", "onDisconnect$http_rpc_client", "onPermanentFailure", "onPermanentFailure$http_rpc_client", "safeForEachListener", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Companion", "http-rpc-client"})
public final class HttpRpcConnectionListenerDistributor<I extends RPCOps> {
    @Nullable
    private volatile HttpRpcConnection<? extends I> connectionOpt;
    private final AtomicBoolean connected;
    private final Iterable<HttpRpcConnectionListener<I>> listeners;
    private final CredentialsProvider credentialsProvider;
    private static final Logger log;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final HttpRpcConnection<I> getConnectionOpt$http_rpc_client() {
        return this.connectionOpt;
    }

    public final void setConnectionOpt$http_rpc_client(@Nullable HttpRpcConnection<? extends I> httpRpcConnection) {
        this.connectionOpt = httpRpcConnection;
    }

    public final void onConnect$http_rpc_client() {
        String string;
        Logger logger;
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            string = "On connect.";
            logger.trace(string);
        }
        if (this.connected.compareAndSet(false, true)) {
            this.safeForEachListener((Function1)new Function1<HttpRpcConnectionListener<I>, Unit>(this){
                final /* synthetic */ HttpRpcConnectionListenerDistributor this$0;

                public final void invoke(@NotNull HttpRpcConnectionListener<I> $this$safeForEachListener) {
                    Intrinsics.checkNotNullParameter($this$safeForEachListener, (String)"$receiver");
                    $this$safeForEachListener.onConnect(new Companion.HttpRpcConnectionContextImpl<I>(HttpRpcConnectionListenerDistributor.access$getCredentialsProvider$p(this.this$0), this.this$0.getConnectionOpt$http_rpc_client(), null));
                }
                {
                    this.this$0 = httpRpcConnectionListenerDistributor;
                    super(1);
                }
            });
        } else {
            Logger $this$debug$iv = log;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                logger = $this$debug$iv;
                boolean bl = false;
                string = "Not distributing onConnect as already connected";
                logger.debug(string);
            }
        }
        $this$trace$iv = log;
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            string = "On connect completed.";
            logger.trace(string);
        }
    }

    public final void onDisconnect$http_rpc_client(@Nullable Throwable throwableOpt) {
        boolean $i$f$debug;
        Logger $this$debug$iv;
        String string;
        Logger logger;
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            string = "On disconnect.";
            logger.trace(string);
        }
        if (this.connectionOpt != null) {
            if (this.connected.compareAndSet(true, false)) {
                this.safeForEachListener((Function1)new Function1<HttpRpcConnectionListener<I>, Unit>(this, throwableOpt){
                    final /* synthetic */ HttpRpcConnectionListenerDistributor this$0;
                    final /* synthetic */ Throwable $throwableOpt;

                    public final void invoke(@NotNull HttpRpcConnectionListener<I> $this$safeForEachListener) {
                        Intrinsics.checkNotNullParameter($this$safeForEachListener, (String)"$receiver");
                        $this$safeForEachListener.onDisconnect(new Companion.HttpRpcConnectionContextImpl<I>(HttpRpcConnectionListenerDistributor.access$getCredentialsProvider$p(this.this$0), this.this$0.getConnectionOpt$http_rpc_client(), this.$throwableOpt));
                    }
                    {
                        this.this$0 = httpRpcConnectionListenerDistributor;
                        this.$throwableOpt = throwable;
                        super(1);
                    }
                });
            } else {
                $this$debug$iv = log;
                $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    logger = $this$debug$iv;
                    boolean bl = false;
                    string = "Not distributing onDisconnect as already disconnected";
                    logger.debug(string);
                }
            }
        } else {
            $this$debug$iv = log;
            $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                logger = $this$debug$iv;
                boolean bl = false;
                string = "Not distributing onDisconnect as connection has never been established";
                logger.debug(string);
            }
        }
        $this$trace$iv = log;
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            string = "On disconnect completed.";
            logger.trace(string);
        }
    }

    public final void onPermanentFailure$http_rpc_client(@Nullable Throwable throwableOpt) {
        String string;
        Logger logger;
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            string = "On permanent failure.";
            logger.trace(string);
        }
        this.safeForEachListener((Function1)new Function1<HttpRpcConnectionListener<I>, Unit>(this, throwableOpt){
            final /* synthetic */ HttpRpcConnectionListenerDistributor this$0;
            final /* synthetic */ Throwable $throwableOpt;

            public final void invoke(@NotNull HttpRpcConnectionListener<I> $this$safeForEachListener) {
                Intrinsics.checkNotNullParameter($this$safeForEachListener, (String)"$receiver");
                $this$safeForEachListener.onPermanentFailure(new Companion.HttpRpcConnectionContextImpl<I>(HttpRpcConnectionListenerDistributor.access$getCredentialsProvider$p(this.this$0), this.this$0.getConnectionOpt$http_rpc_client(), this.$throwableOpt));
            }
            {
                this.this$0 = httpRpcConnectionListenerDistributor;
                this.$throwableOpt = throwable;
                super(1);
            }
        });
        $this$trace$iv = log;
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            string = "On permanent failure completed.";
            logger.trace(string);
        }
    }

    private final void safeForEachListener(Function1<? super HttpRpcConnectionListener<I>, Unit> action) {
        String string;
        Logger logger;
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            string = "Safe for each listener.";
            logger.trace(string);
        }
        Iterable<HttpRpcConnectionListener<I>> $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        Iterator<HttpRpcConnectionListener<I>> bl = $this$forEach$iv.iterator();
        while (bl.hasNext()) {
            HttpRpcConnectionListener<I> element$iv;
            HttpRpcConnectionListener<I> it = element$iv = bl.next();
            boolean bl2 = false;
            try {
                action.invoke(it);
            }
            catch (Exception ex) {
                log.error("Exception during distribution to: " + it, (Throwable)ex);
            }
        }
        $this$trace$iv = log;
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl3 = false;
            string = "Safe for each listener completed.";
            logger.trace(string);
        }
    }

    public HttpRpcConnectionListenerDistributor(@NotNull Iterable<? extends HttpRpcConnectionListener<I>> listeners, @NotNull CredentialsProvider credentialsProvider) {
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        Intrinsics.checkNotNullParameter((Object)credentialsProvider, (String)"credentialsProvider");
        this.listeners = listeners;
        this.credentialsProvider = credentialsProvider;
        this.connected = new AtomicBoolean();
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    public static final /* synthetic */ CredentialsProvider access$getCredentialsProvider$p(HttpRpcConnectionListenerDistributor $this) {
        return $this.credentialsProvider;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/corda/v5/httprpc/client/internal/HttpRpcConnectionListenerDistributor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "HttpRpcConnectionContextImpl", "http-rpc-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u0011\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u00c6\u0003J7\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u001c\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lnet/corda/v5/httprpc/client/internal/HttpRpcConnectionListenerDistributor$Companion$HttpRpcConnectionContextImpl;", "I", "Lnet/corda/v5/application/messaging/RPCOps;", "Lnet/corda/v5/httprpc/client/HttpRpcConnectionListener$HttpRpcConnectionContext;", "credentialsProvider", "Lnet/corda/v5/httprpc/client/auth/credentials/CredentialsProvider;", "connectionOpt", "Lnet/corda/v5/httprpc/client/HttpRpcConnection;", "throwableOpt", "", "(Lnet/corda/v5/httprpc/client/auth/credentials/CredentialsProvider;Lnet/corda/v5/httprpc/client/HttpRpcConnection;Ljava/lang/Throwable;)V", "getConnectionOpt", "()Lnet/corda/v5/httprpc/client/HttpRpcConnection;", "getCredentialsProvider", "()Lnet/corda/v5/httprpc/client/auth/credentials/CredentialsProvider;", "getThrowableOpt", "()Ljava/lang/Throwable;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "http-rpc-client"})
        private static final class HttpRpcConnectionContextImpl<I extends RPCOps>
        implements HttpRpcConnectionListener.HttpRpcConnectionContext<I> {
            @NotNull
            private final CredentialsProvider credentialsProvider;
            @Nullable
            private final HttpRpcConnection<I> connectionOpt;
            @Nullable
            private final Throwable throwableOpt;

            @Override
            @NotNull
            public CredentialsProvider getCredentialsProvider() {
                return this.credentialsProvider;
            }

            @Override
            @Nullable
            public HttpRpcConnection<I> getConnectionOpt() {
                return this.connectionOpt;
            }

            @Override
            @Nullable
            public Throwable getThrowableOpt() {
                return this.throwableOpt;
            }

            public HttpRpcConnectionContextImpl(@NotNull CredentialsProvider credentialsProvider, @Nullable HttpRpcConnection<? extends I> connectionOpt, @Nullable Throwable throwableOpt) {
                Intrinsics.checkNotNullParameter((Object)credentialsProvider, (String)"credentialsProvider");
                this.credentialsProvider = credentialsProvider;
                this.connectionOpt = connectionOpt;
                this.throwableOpt = throwableOpt;
            }

            @NotNull
            public final CredentialsProvider component1() {
                return this.getCredentialsProvider();
            }

            @Nullable
            public final HttpRpcConnection<I> component2() {
                return this.getConnectionOpt();
            }

            @Nullable
            public final Throwable component3() {
                return this.getThrowableOpt();
            }

            @NotNull
            public final HttpRpcConnectionContextImpl<I> copy(@NotNull CredentialsProvider credentialsProvider, @Nullable HttpRpcConnection<? extends I> connectionOpt, @Nullable Throwable throwableOpt) {
                Intrinsics.checkNotNullParameter((Object)credentialsProvider, (String)"credentialsProvider");
                return new HttpRpcConnectionContextImpl<I>(credentialsProvider, connectionOpt, throwableOpt);
            }

            public static /* synthetic */ HttpRpcConnectionContextImpl copy$default(HttpRpcConnectionContextImpl httpRpcConnectionContextImpl, CredentialsProvider credentialsProvider, HttpRpcConnection httpRpcConnection, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    credentialsProvider = httpRpcConnectionContextImpl.getCredentialsProvider();
                }
                if ((n & 2) != 0) {
                    httpRpcConnection = httpRpcConnectionContextImpl.getConnectionOpt();
                }
                if ((n & 4) != 0) {
                    throwable = httpRpcConnectionContextImpl.getThrowableOpt();
                }
                return httpRpcConnectionContextImpl.copy(credentialsProvider, httpRpcConnection, throwable);
            }

            @NotNull
            public String toString() {
                return "HttpRpcConnectionContextImpl(credentialsProvider=" + this.getCredentialsProvider() + ", connectionOpt=" + this.getConnectionOpt() + ", throwableOpt=" + this.getThrowableOpt() + ")";
            }

            public int hashCode() {
                CredentialsProvider credentialsProvider = this.getCredentialsProvider();
                HttpRpcConnection<I> httpRpcConnection = this.getConnectionOpt();
                Throwable throwable = this.getThrowableOpt();
                return ((credentialsProvider != null ? credentialsProvider.hashCode() : 0) * 31 + (httpRpcConnection != null ? httpRpcConnection.hashCode() : 0)) * 31 + (throwable != null ? throwable.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof HttpRpcConnectionContextImpl)) break block3;
                        HttpRpcConnectionContextImpl httpRpcConnectionContextImpl = (HttpRpcConnectionContextImpl)object;
                        if (!Intrinsics.areEqual((Object)this.getCredentialsProvider(), (Object)httpRpcConnectionContextImpl.getCredentialsProvider()) || !Intrinsics.areEqual(this.getConnectionOpt(), httpRpcConnectionContextImpl.getConnectionOpt()) || !Intrinsics.areEqual((Object)this.getThrowableOpt(), (Object)httpRpcConnectionContextImpl.getThrowableOpt())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

