/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.httprpc.client.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.corda.v5.application.messaging.RPCOps;
import net.corda.v5.base.stream.MethodKt;
import net.corda.v5.base.util.KotlinUtilsKt;
import net.corda.v5.httprpc.api.annotations.HttpRpcGET;
import net.corda.v5.httprpc.api.annotations.HttpRpcPOST;
import net.corda.v5.httprpc.api.annotations.HttpRpcResource;
import net.corda.v5.httprpc.client.auth.RequestContext;
import net.corda.v5.httprpc.client.config.AuthenticationConfig;
import net.corda.v5.httprpc.client.internal.processing.MethodInformationResolverKt;
import net.corda.v5.httprpc.client.internal.processing.ParametersResolverKt;
import net.corda.v5.httprpc.client.internal.processing.ResolvedParameters;
import net.corda.v5.httprpc.client.internal.remote.HttpVerb;
import net.corda.v5.httprpc.client.internal.remote.RemoteClient;
import net.corda.v5.httprpc.client.internal.remote.WebRequest;
import net.corda.v5.httprpc.client.internal.stream.HttpRpcFiniteDurableCursorClientBuilderImpl;
import net.corda.v5.httprpc.tools.StaticExposedMethodsKt;
import net.corda.v5.httprpc.tools.annotations.extensions.HttpRpcEndpointKt;
import net.corda.v5.httprpc.tools.annotations.extensions.HttpRpcResourceKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001dB#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ4\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00102\u0012\u0010\u0017\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u0018H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lnet/corda/v5/httprpc/client/internal/HttpRpcClientProxyHandler;", "I", "Lnet/corda/v5/application/messaging/RPCOps;", "Ljava/lang/reflect/InvocationHandler;", "client", "Lnet/corda/v5/httprpc/client/internal/remote/RemoteClient;", "authenticationConfig", "Lnet/corda/v5/httprpc/client/config/AuthenticationConfig;", "rpcOpsClass", "Ljava/lang/Class;", "(Lnet/corda/v5/httprpc/client/internal/remote/RemoteClient;Lnet/corda/v5/httprpc/client/config/AuthenticationConfig;Ljava/lang/Class;)V", "serverProtocolVersion", "", "Ljava/lang/Integer;", "endpointPath", "", "Ljava/lang/reflect/Method;", "getEndpointPath", "(Ljava/lang/reflect/Method;)Ljava/lang/String;", "invoke", "", "proxy", "method", "args", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "setServerProtocolVersion", "", "version", "Companion", "http-rpc-client"})
public final class HttpRpcClientProxyHandler<I extends RPCOps>
implements InvocationHandler {
    private Integer serverProtocolVersion;
    private final RemoteClient client;
    private final AuthenticationConfig authenticationConfig;
    private final Class<I> rpcOpsClass;
    private static final Logger log;
    @NotNull
    private static final Companion Companion;

    public final void setServerProtocolVersion(int version) {
        if (this.serverProtocolVersion != null) {
            throw (Throwable)new IllegalStateException("setServerProtocolVersion called, but the protocol version was already set!");
        }
        this.serverProtocolVersion = version;
    }

    @Override
    @Nullable
    public Object invoke(@NotNull Object proxy, @NotNull Method method, @Nullable Object[] args) {
        String string;
        Object object;
        Object element$iv2;
        block23: {
            block22: {
                boolean isExemptFromChecks;
                block20: {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Logger $this$trace$iv = log;
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl2 = false;
                        String string2 = "Invoke \"" + method.getName() + "\".";
                        logger.trace(string2);
                    }
                    Iterable $this$any$iv = StaticExposedMethodsKt.getStaticExposedGetMethods();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            String it222 = (String)element$iv2;
                            boolean bl3 = false;
                            if (!StringsKt.equals((String)it222, (String)method.getName(), (boolean)true)) continue;
                            bl = true;
                            break block20;
                        }
                        bl = isExemptFromChecks = false;
                    }
                }
                if (!isExemptFromChecks) {
                    boolean bl;
                    block21: {
                        Annotation[] annotationArray = method.getAnnotations();
                        Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"method.annotations");
                        Annotation[] $this$none$iv = annotationArray;
                        boolean $i$f$none = false;
                        Annotation[] annotationArray2 = $this$none$iv;
                        int element$iv2 = annotationArray2.length;
                        for (int it222 = 0; it222 < element$iv2; ++it222) {
                            Annotation element$iv3;
                            Annotation it = element$iv3 = annotationArray2[it222];
                            boolean bl4 = false;
                            if (!(it instanceof HttpRpcGET || it instanceof HttpRpcPOST)) continue;
                            bl = false;
                            break block21;
                        }
                        bl = true;
                    }
                    if (bl) {
                        throw (Throwable)new UnsupportedOperationException("Http RPC proxy can not make remote calls for functions not annotated with HttpRpcGET, HttpRpcPOST or known as implicitly exposed.");
                    }
                }
                if ((object = this.rpcOpsClass.getAnnotation(HttpRpcResource.class)) == null || (object = HttpRpcResourceKt.path((HttpRpcResource)object, this.rpcOpsClass)) == null) break block22;
                Object $i$f$none = object;
                boolean bl = false;
                Object object2 = $i$f$none;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)object2).toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                object = string3;
                if (string3 != null) break block23;
            }
            throw (Throwable)new UnsupportedOperationException("Http RPC proxy can not make remote calls for interfaces not annotated with HttpRpcResource.");
        }
        Object resourceName = object;
        String endpointName = this.getEndpointPath(method);
        element$iv2 = (String)resourceName + '/' + endpointName;
        boolean it222 = false;
        Object object3 = element$iv2;
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = ((String)object3).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        element$iv2 = string4;
        String it222 = "/+";
        boolean bl = false;
        it222 = new Regex(it222);
        String string5 = "/";
        boolean it = false;
        String rawPath = it222.replace((CharSequence)element$iv2, string5);
        if (MethodKt.returnsDurableCursorBuilder((Method)method)) {
            element$iv2 = new HttpRpcFiniteDurableCursorClientBuilderImpl(this.client, method, rawPath, args, this.authenticationConfig);
            boolean it222 = false;
            boolean bl5 = false;
            Object it3 = element$iv2;
            boolean bl6 = false;
            Logger $this$trace$iv = log;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl7 = false;
                String string6 = "Invoke \"" + method.getName() + "\" completed.";
                logger.trace(string6);
            }
            return element$iv2;
        }
        ResolvedParameters parameters = ParametersResolverKt.parametersFrom$default(method, args, null, 2, null);
        RequestContext context = RequestContext.Companion.fromAuthenticationConfig$http_rpc_client(this.authenticationConfig);
        if (method.getReturnType().isAssignableFrom(Void.class) || method.getReturnType().isAssignableFrom(Void.TYPE)) {
            this.client.call(MethodInformationResolverKt.getEndpointHttpVerb(method), ParametersResolverKt.toWebRequest(parameters, rawPath), context);
            string = null;
        } else {
            Object object4;
            if (Intrinsics.areEqual(method.getReturnType(), String.class)) {
                object4 = this.client.call(MethodInformationResolverKt.getEndpointHttpVerb(method), ParametersResolverKt.toWebRequest(parameters, rawPath), context).getBody();
            } else {
                HttpVerb httpVerb = MethodInformationResolverKt.getEndpointHttpVerb(method);
                WebRequest<Object> webRequest = ParametersResolverKt.toWebRequest(parameters, rawPath);
                Type type = method.getGenericReturnType();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"method.genericReturnType");
                object4 = this.client.call(httpVerb, webRequest, type, context).getBody();
            }
            string5 = object4;
            boolean bl8 = false;
            boolean bl9 = false;
            String it4 = string5;
            boolean bl10 = false;
            Logger $this$trace$iv = log;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl11 = false;
                String string7 = "Invoke \"" + method.getName() + "\" completed.";
                logger.trace(string7);
            }
            string = string5;
        }
        return string;
    }

    private final String getEndpointPath(Method $this$endpointPath) {
        String string;
        Annotation annotation;
        block8: {
            Annotation[] annotationArray = $this$endpointPath.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"this.annotations");
            Annotation[] $this$singleOrNull$iv = annotationArray;
            boolean $i$f$singleOrNull = false;
            Annotation single$iv = null;
            boolean found$iv = false;
            Annotation[] annotationArray2 = $this$singleOrNull$iv;
            int n = annotationArray2.length;
            for (int i = 0; i < n; ++i) {
                Annotation element$iv;
                Annotation it = element$iv = annotationArray2[i];
                boolean bl = false;
                if (!(it instanceof HttpRpcPOST || it instanceof HttpRpcGET)) continue;
                if (found$iv) {
                    annotation = null;
                    break block8;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            annotation = !found$iv ? null : single$iv;
        }
        Annotation annotation2 = annotation;
        boolean bl = false;
        boolean bl2 = false;
        Annotation it = annotation2;
        boolean bl3 = false;
        Annotation annotation3 = it;
        if (annotation3 instanceof HttpRpcGET) {
            string = HttpRpcEndpointKt.path((HttpRpcGET)((HttpRpcGET)it), (Method)$this$endpointPath);
        } else if (annotation3 instanceof HttpRpcPOST) {
            string = HttpRpcEndpointKt.path((HttpRpcPOST)((HttpRpcPOST)it), (Method)$this$endpointPath);
        } else if (StaticExposedMethodsKt.getStaticExposedGetMethods().contains($this$endpointPath.getName())) {
            string = $this$endpointPath.getName();
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown endpoint path");
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.annotations.singleO\u2026          }\n            }");
        return string;
    }

    public HttpRpcClientProxyHandler(@NotNull RemoteClient client, @NotNull AuthenticationConfig authenticationConfig, @NotNull Class<I> rpcOpsClass) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)authenticationConfig, (String)"authenticationConfig");
        Intrinsics.checkNotNullParameter(rpcOpsClass, (String)"rpcOpsClass");
        this.client = client;
        this.authenticationConfig = authenticationConfig;
        this.rpcOpsClass = rpcOpsClass;
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/v5/httprpc/client/internal/HttpRpcClientProxyHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "http-rpc-client"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

