/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.httprpc.client.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.application.identity.CordaX500Name;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/corda/v5/httprpc/client/internal/CordaX500NameDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lnet/corda/v5/application/identity/CordaX500Name;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "http-rpc-client"})
public final class CordaX500NameDeserializer
extends JsonDeserializer<CordaX500Name> {
    private static final Logger log;
    @NotNull
    public static final CordaX500NameDeserializer INSTANCE;

    @NotNull
    public CordaX500Name deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) {
        CordaX500Name cordaX500Name;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Logger logger = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger2 = $this$trace$iv;
            boolean bl = false;
            String string = "Deserialize.";
            logger2.trace(string);
        }
        try {
            String string = parser.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parser.text");
            cordaX500Name = CordaX500Name.Companion.parse(string);
        }
        catch (IllegalArgumentException e) {
            String string = "Invalid Corda X.500 name " + parser.getText() + ": " + e.getMessage();
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            log.error(it);
            throw (Throwable)new JsonParseException(parser, it, (Throwable)e);
        }
        boolean bl = false;
        boolean bl4 = false;
        CordaX500Name it = cordaX500Name;
        boolean bl5 = false;
        Logger logger3 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"log");
        Logger $this$trace$iv2 = logger3;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            Logger logger4 = $this$trace$iv2;
            boolean bl6 = false;
            String string = "Deserialize completed.";
            logger4.trace(string);
        }
        return cordaX500Name;
    }

    private CordaX500NameDeserializer() {
    }

    static {
        CordaX500NameDeserializer cordaX500NameDeserializer;
        INSTANCE = cordaX500NameDeserializer = new CordaX500NameDeserializer();
        log = LoggerFactory.getLogger(((Object)((Object)cordaX500NameDeserializer)).getClass());
    }
}

