/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.httprpc.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.application.messaging.RPCOps;
import net.corda.v5.base.util.KotlinUtilsKt;
import net.corda.v5.httprpc.client.HttpRpcClient;
import net.corda.v5.httprpc.client.HttpRpcConnection;
import net.corda.v5.httprpc.client.HttpRpcConnectionListener;
import net.corda.v5.httprpc.client.config.HttpRpcClientConfig;
import net.corda.v5.httprpc.client.internal.HttpRpcClientProxyHandler;
import net.corda.v5.httprpc.client.internal.HttpRpcConnectionListenerDistributor;
import net.corda.v5.httprpc.client.internal.remote.RemoteUnirestClient;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 1*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u00011B%\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB-\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rBq\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012B\u0010\u000e\u001a>\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0006\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0012\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bJ\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020(H\u0002J\u0014\u0010-\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bJ\b\u0010.\u001a\u00020\u0018H\u0002J\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u000000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001c\u001a\u00028\u0000X\u0080.\u00a2\u0006\u0016\n\u0002\u0010#\u0012\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"RJ\u0010\u000e\u001a>\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0006\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0012\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010&\u00a8\u00062"}, d2={"Lnet/corda/v5/httprpc/client/HttpRpcClient;", "I", "Lnet/corda/v5/application/messaging/RPCOps;", "Ljava/lang/AutoCloseable;", "baseAddress", "", "rpcOpsClass", "Ljava/lang/Class;", "clientConfig", "Lnet/corda/v5/httprpc/client/config/HttpRpcClientConfig;", "(Ljava/lang/String;Ljava/lang/Class;Lnet/corda/v5/httprpc/client/config/HttpRpcClientConfig;)V", "healthCheckInterval", "", "(Ljava/lang/String;Ljava/lang/Class;Lnet/corda/v5/httprpc/client/config/HttpRpcClientConfig;J)V", "proxyGenerator", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "Lnet/corda/v5/httprpc/client/internal/HttpRpcClientProxyHandler;", "proxyHandler", "(Ljava/lang/String;Ljava/lang/Class;Lnet/corda/v5/httprpc/client/config/HttpRpcClientConfig;JLkotlin/jvm/functions/Function2;)V", "connectionEventDistributor", "Lnet/corda/v5/httprpc/client/internal/HttpRpcConnectionListenerDistributor;", "healthCheckTimer", "Ljava/util/Timer;", "listeners", "", "Lnet/corda/v5/httprpc/client/HttpRpcConnectionListener;", "ops", "getOps$http_rpc_client$annotations", "()V", "getOps$http_rpc_client", "()Lnet/corda/v5/application/messaging/RPCOps;", "setOps$http_rpc_client", "(Lnet/corda/v5/application/messaging/RPCOps;)V", "Lnet/corda/v5/application/messaging/RPCOps;", "serverProtocolVersion", "", "Ljava/lang/Integer;", "addConnectionListener", "", "listener", "close", "", "healthCheck", "removeConnectionListener", "schedulePeriodicHealthCheck", "start", "Lnet/corda/v5/httprpc/client/HttpRpcConnection;", "Companion", "http-rpc-client"})
public final class HttpRpcClient<I extends RPCOps>
implements AutoCloseable {
    private final Set<HttpRpcConnectionListener<I>> listeners;
    private final HttpRpcConnectionListenerDistributor<I> connectionEventDistributor;
    private Integer serverProtocolVersion;
    private Timer healthCheckTimer;
    public I ops;
    private final String baseAddress;
    private final Class<I> rpcOpsClass;
    private final HttpRpcClientConfig clientConfig;
    private final long healthCheckInterval;
    private final Function2<Class<I>, HttpRpcClientProxyHandler<I>, I> proxyGenerator;
    private static final Logger log;
    private static final long defaultHealthCheckInterval = 10000L;
    @NotNull
    private static final Companion Companion;

    public static /* synthetic */ void getOps$http_rpc_client$annotations() {
    }

    @NotNull
    public final I getOps$http_rpc_client() {
        I i = this.ops;
        if (i == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ops");
        }
        return i;
    }

    public final void setOps$http_rpc_client(@NotNull I i) {
        Intrinsics.checkNotNullParameter(i, (String)"<set-?>");
        this.ops = i;
    }

    @NotNull
    public final HttpRpcConnection<I> start() {
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            String string = "Start.";
            logger.trace(string);
        }
        Object object = HttpRpcClient.Companion.logElapsedTime(HttpRpcClient.log, "Http Rpc client", (Function0)new Function0<start.2>(this){
            final /* synthetic */ HttpRpcClient this$0;

            @NotNull
            public final start.2 invoke() {
                HttpRpcConnection<I> httpRpcConnection;
                HttpRpcClientProxyHandler<I> proxyHandler = new HttpRpcClientProxyHandler<I>(new RemoteUnirestClient(HttpRpcClient.access$getBaseAddress$p(this.this$0), HttpRpcClient.access$getClientConfig$p(this.this$0).getEnableSSL()), HttpRpcClient.access$getClientConfig$p(this.this$0).getAuthenticationConfig(), HttpRpcClient.access$getRpcOpsClass$p(this.this$0));
                try {
                    this.this$0.setOps$http_rpc_client((RPCOps)HttpRpcClient.access$getProxyGenerator$p(this.this$0).invoke((Object)HttpRpcClient.access$getRpcOpsClass$p(this.this$0), proxyHandler));
                    HttpRpcClient.access$setServerProtocolVersion$p(this.this$0, this.this$0.getOps$http_rpc_client().getProtocolVersion());
                    Integer n = HttpRpcClient.access$getServerProtocolVersion$p(this.this$0);
                    Intrinsics.checkNotNull((Object)n);
                    if (n < HttpRpcClient.access$getClientConfig$p(this.this$0).getMinimumServerProtocolVersion()) {
                        throw (Throwable)new IllegalArgumentException("Requested minimum protocol version " + '(' + HttpRpcClient.access$getClientConfig$p(this.this$0).getMinimumServerProtocolVersion() + ") is higher" + " than the server's supported protocol version (" + HttpRpcClient.access$getServerProtocolVersion$p(this.this$0) + ')');
                    }
                    Integer n2 = HttpRpcClient.access$getServerProtocolVersion$p(this.this$0);
                    Intrinsics.checkNotNull((Object)n2);
                    proxyHandler.setServerProtocolVersion(n2);
                    HttpRpcClient.access$Companion();
                    Logger $this$debug$iv = HttpRpcClient.access$getLog$cp();
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        Logger logger = $this$debug$iv;
                        boolean bl = false;
                        String string = "Http RPC connected, returning proxy";
                        logger.debug(string);
                    }
                    httpRpcConnection = new HttpRpcConnection<I>(this){
                        final /* synthetic */ start.2 this$0;

                        @NotNull
                        public I getProxy() {
                            return this.this$0.this$0.getOps$http_rpc_client();
                        }

                        public int getServerProtocolVersion() {
                            Integer n = HttpRpcClient.access$getServerProtocolVersion$p(this.this$0.this$0);
                            Intrinsics.checkNotNull((Object)n);
                            return n;
                        }
                        {
                            this.this$0 = this$0;
                        }
                    };
                    $i$f$debug = false;
                    boolean bl = false;
                    HttpRpcConnection<I> it = httpRpcConnection;
                    boolean bl2 = false;
                    HttpRpcClient.access$getConnectionEventDistributor$p(this.this$0).setConnectionOpt$http_rpc_client((HttpRpcConnection)it);
                    HttpRpcClient.access$getConnectionEventDistributor$p(this.this$0).onConnect$http_rpc_client();
                    HttpRpcClient.access$setHealthCheckTimer$p(this.this$0, HttpRpcClient.access$schedulePeriodicHealthCheck(this.this$0));
                }
                catch (Throwable throwable) {
                    HttpRpcClient.access$Companion();
                    HttpRpcClient.access$getLog$cp().error("Unexpected error when starting", throwable);
                    HttpRpcClient.access$getConnectionEventDistributor$p(this.this$0).onPermanentFailure$http_rpc_client(throwable);
                    throw throwable;
                }
                return httpRpcConnection;
            }
            {
                this.this$0 = httpRpcClient;
                super(0);
            }
        });
        boolean bl = false;
        boolean bl2 = false;
        start.2 it = object;
        boolean bl3 = false;
        Logger $this$trace$iv2 = log;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            Logger logger = $this$trace$iv2;
            boolean bl4 = false;
            String string = "Start completed.";
            logger.trace(string);
        }
        return (HttpRpcConnection)object;
    }

    public final boolean addConnectionListener(@NotNull HttpRpcConnectionListener<I> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            String string = "\"Add connection listener \"" + listener.getClass().getSimpleName() + "\".";
            logger.trace(string);
        }
        return this.listeners.add(listener);
    }

    public final boolean removeConnectionListener(@NotNull HttpRpcConnectionListener<I> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            String string = "Remove connection listener \"" + listener.getClass().getSimpleName() + "\".";
            logger.trace(string);
        }
        return this.listeners.remove(listener);
    }

    @Override
    public void close() {
        String string;
        Logger logger;
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            string = "Close.";
            logger.trace(string);
        }
        if (this.healthCheckTimer != null) {
            Timer timer = this.healthCheckTimer;
            if (timer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"healthCheckTimer");
            }
            timer.cancel();
        }
        this.connectionEventDistributor.onDisconnect$http_rpc_client(null);
        $this$trace$iv = log;
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            string = "Close completed.";
            logger.trace(string);
        }
    }

    private final Timer schedulePeriodicHealthCheck() {
        Timer timer;
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            String string = "Schedule periodic health check.";
            logger.trace(string);
        }
        Timer timer2 = timer = new Timer("KeepAliveHttpRpcClient Health Check", true);
        long l = 0L;
        long l2 = this.healthCheckInterval;
        boolean bl = false;
        boolean bl2 = false;
        TimerTask timerTask = new TimerTask(this){
            final /* synthetic */ HttpRpcClient this$0;
            {
                this.this$0 = httpRpcClient;
            }

            public void run() {
                TimerTask $this$scheduleAtFixedRate = this;
                boolean bl = false;
                if (HttpRpcClient.access$healthCheck(this.this$0)) {
                    HttpRpcClient.access$Companion();
                    Logger $this$debug$iv = HttpRpcClient.access$getLog$cp();
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        Logger logger = $this$debug$iv;
                        boolean bl2 = false;
                        String string = "Connection stable.";
                        logger.debug(string);
                    }
                } else {
                    HttpRpcClient.access$Companion();
                    HttpRpcClient.access$getLog$cp().warn("Did not get health check response.");
                }
            }
        };
        timer2.scheduleAtFixedRate(timerTask, l, l2);
        timer2 = timer;
        boolean bl3 = false;
        boolean bl4 = false;
        Timer it = timer2;
        boolean bl5 = false;
        Logger $this$trace$iv2 = log;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            timerTask = $this$trace$iv2;
            boolean bl6 = false;
            String string = "Schedule periodic health check completed.";
            timerTask.trace(string);
        }
        return timer2;
    }

    private final boolean healthCheck() {
        boolean bl;
        try {
            I i = this.ops;
            if (i == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ops");
            }
            Integer n = this.serverProtocolVersion;
            if (n == null || i.getProtocolVersion() != n.intValue()) {
                StringBuilder stringBuilder = new StringBuilder().append("Protocol version previously retrieved (");
                I i2 = this.ops;
                if (i2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"ops");
                }
                log.warn(stringBuilder.append(i2.getProtocolVersion()).append(") does not match").append(" the initial protocol version (").append(this.serverProtocolVersion).append(')').toString());
            }
            this.connectionEventDistributor.onConnect$http_rpc_client();
            bl = true;
        }
        catch (Throwable throwable) {
            log.error("Error when performing health check call", throwable);
            this.connectionEventDistributor.onDisconnect$http_rpc_client(throwable);
            bl = false;
        }
        return bl;
    }

    public HttpRpcClient(@NotNull String baseAddress, @NotNull Class<I> rpcOpsClass, @NotNull HttpRpcClientConfig clientConfig, long healthCheckInterval, @NotNull Function2<? super Class<I>, ? super HttpRpcClientProxyHandler<I>, ? extends I> proxyGenerator) {
        Intrinsics.checkNotNullParameter((Object)baseAddress, (String)"baseAddress");
        Intrinsics.checkNotNullParameter(rpcOpsClass, (String)"rpcOpsClass");
        Intrinsics.checkNotNullParameter((Object)clientConfig, (String)"clientConfig");
        Intrinsics.checkNotNullParameter(proxyGenerator, (String)"proxyGenerator");
        this.baseAddress = baseAddress;
        this.rpcOpsClass = rpcOpsClass;
        this.clientConfig = clientConfig;
        this.healthCheckInterval = healthCheckInterval;
        this.proxyGenerator = proxyGenerator;
        this.listeners = new CopyOnWriteArraySet();
        this.connectionEventDistributor = new HttpRpcConnectionListenerDistributor((Iterable)this.listeners, this.clientConfig.getAuthenticationConfig().getCredentialsProvider());
    }

    public HttpRpcClient(@NotNull String baseAddress, @NotNull Class<I> rpcOpsClass, @NotNull HttpRpcClientConfig clientConfig) {
        Intrinsics.checkNotNullParameter((Object)baseAddress, (String)"baseAddress");
        Intrinsics.checkNotNullParameter(rpcOpsClass, (String)"rpcOpsClass");
        Intrinsics.checkNotNullParameter((Object)clientConfig, (String)"clientConfig");
        this(baseAddress, rpcOpsClass, clientConfig, 10000L, (Function2)new Function2<Class<I>, HttpRpcClientProxyHandler<I>, I>(Companion){

            @NotNull
            public final I invoke(@NotNull Class<I> p1, @NotNull HttpRpcClientProxyHandler<I> p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                return ((Companion)this.receiver).defaultProxyGenerator(p1, p2);
            }
        });
    }

    public HttpRpcClient(@NotNull String baseAddress, @NotNull Class<I> rpcOpsClass, @NotNull HttpRpcClientConfig clientConfig, long healthCheckInterval) {
        Intrinsics.checkNotNullParameter((Object)baseAddress, (String)"baseAddress");
        Intrinsics.checkNotNullParameter(rpcOpsClass, (String)"rpcOpsClass");
        Intrinsics.checkNotNullParameter((Object)clientConfig, (String)"clientConfig");
        this(baseAddress, rpcOpsClass, clientConfig, healthCheckInterval, (Function2)new Function2<Class<I>, HttpRpcClientProxyHandler<I>, I>(Companion){

            @NotNull
            public final I invoke(@NotNull Class<I> p1, @NotNull HttpRpcClientProxyHandler<I> p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                return ((Companion)this.receiver).defaultProxyGenerator(p1, p2);
            }
        });
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    public static final /* synthetic */ String access$getBaseAddress$p(HttpRpcClient $this) {
        return $this.baseAddress;
    }

    public static final /* synthetic */ HttpRpcClientConfig access$getClientConfig$p(HttpRpcClient $this) {
        return $this.clientConfig;
    }

    public static final /* synthetic */ Class access$getRpcOpsClass$p(HttpRpcClient $this) {
        return $this.rpcOpsClass;
    }

    public static final /* synthetic */ Function2 access$getProxyGenerator$p(HttpRpcClient $this) {
        return $this.proxyGenerator;
    }

    public static final /* synthetic */ Integer access$getServerProtocolVersion$p(HttpRpcClient $this) {
        return $this.serverProtocolVersion;
    }

    public static final /* synthetic */ void access$setServerProtocolVersion$p(HttpRpcClient $this, Integer n) {
        $this.serverProtocolVersion = n;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ HttpRpcConnectionListenerDistributor access$getConnectionEventDistributor$p(HttpRpcClient $this) {
        return $this.connectionEventDistributor;
    }

    public static final /* synthetic */ Timer access$getHealthCheckTimer$p(HttpRpcClient $this) {
        Timer timer = $this.healthCheckTimer;
        if (timer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"healthCheckTimer");
        }
        return timer;
    }

    public static final /* synthetic */ void access$setHealthCheckTimer$p(HttpRpcClient $this, Timer timer) {
        $this.healthCheckTimer = timer;
    }

    public static final /* synthetic */ Timer access$schedulePeriodicHealthCheck(HttpRpcClient $this) {
        return $this.schedulePeriodicHealthCheck();
    }

    public static final /* synthetic */ boolean access$healthCheck(HttpRpcClient $this) {
        return $this.healthCheck();
    }

    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0007\u001a\u0002H\b\"\b\b\u0001\u0010\b*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\b0\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ1\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0001\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J-\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0001\u0010\u0010*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/corda/v5/httprpc/client/HttpRpcClient$Companion;", "", "()V", "defaultHealthCheckInterval", "", "log", "Lorg/slf4j/Logger;", "defaultProxyGenerator", "I", "Lnet/corda/v5/application/messaging/RPCOps;", "rpcOpsClass", "Ljava/lang/Class;", "proxyHandler", "Lnet/corda/v5/httprpc/client/internal/HttpRpcClientProxyHandler;", "(Ljava/lang/Class;Lnet/corda/v5/httprpc/client/internal/HttpRpcClientProxyHandler;)Lnet/corda/v5/application/messaging/RPCOps;", "logElapsedTime", "T", "label", "", "logger", "body", "Lkotlin/Function0;", "(Ljava/lang/String;Lorg/slf4j/Logger;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(Lorg/slf4j/Logger;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "http-rpc-client"})
    private static final class Companion {
        private final <I extends RPCOps> I defaultProxyGenerator(Class<I> rpcOpsClass, HttpRpcClientProxyHandler<I> proxyHandler) {
            return (I)((RPCOps)KotlinUtilsKt.uncheckedCast((Object)Proxy.newProxyInstance(rpcOpsClass.getClassLoader(), new Class[]{rpcOpsClass}, (InvocationHandler)proxyHandler)));
        }

        private final <T> T logElapsedTime(Logger $this$logElapsedTime, String label, Function0<? extends T> body) {
            return this.logElapsedTime(label, $this$logElapsedTime, body);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> T logElapsedTime(String label, Logger logger, Function0<? extends T> body) {
            String msg;
            Object object;
            long now = System.nanoTime();
            boolean failed = false;
            try {
                object = body.invoke();
                long elapsed = Duration.ofNanos(System.nanoTime() - now).toMillis();
                msg = "" + label + " took " + elapsed + " msec";
            }
            catch (Throwable th) {
                try {
                    failed = true;
                    throw th;
                }
                catch (Throwable throwable) {
                    long elapsed = Duration.ofNanos(System.nanoTime() - now).toMillis();
                    String msg2 = (failed ? "Failed " : "") + label + " took " + elapsed + " msec";
                    logger.info(msg2);
                    throw throwable;
                }
            }
            logger.info(msg);
            return (T)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

